/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedcore.upgrades.jukebox;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.RecordItem;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.fml.util.ObfuscationReflectionHelper;
import net.minecraftforge.registries.ForgeRegistries;
import net.p3pp3rf1y.sophisticatedcore.api.IDiscHandler;
import net.p3pp3rf1y.sophisticatedcore.upgrades.jukebox.ServerStorageSoundHandler;

public class VanillaDiscHandler
implements IDiscHandler<RecordItem> {
    private static List<Item> musicDiscs = null;
    private static Supplier<List<? extends String>> discBlockListGetter = Collections::emptyList;

    @Override
    public Optional<RecordItem> getSongInfo(ItemStack itemStack, Level level) {
        Optional<RecordItem> optional;
        Item item = itemStack.m_41720_();
        if (item instanceof RecordItem) {
            RecordItem recordItem = (RecordItem)item;
            optional = Optional.of(recordItem);
        } else {
            optional = Optional.empty();
        }
        return optional;
    }

    @Override
    public void playDisc(ServerLevel serverLevel, BlockPos position, UUID storageUuid, ItemStack discItemStack, Runnable onFinished) {
        this.getSongInfo(discItemStack, (Level)serverLevel).ifPresent(jukeboxSong -> ServerStorageSoundHandler.startPlayingDisc(serverLevel, position, storageUuid, (Item)jukeboxSong, onFinished));
    }

    @Override
    public void playDisc(ServerLevel serverLevel, Vec3 position, UUID storageUuid, ItemStack discItemStack, int entityId, Runnable onFinished) {
        this.getSongInfo(discItemStack, (Level)serverLevel).ifPresent(jukeboxSong -> ServerStorageSoundHandler.startPlayingDisc(serverLevel, position, storageUuid, entityId, (Item)jukeboxSong, onFinished));
    }

    @Override
    public Optional<Integer> getMusicLengthInTicks(ItemStack itemStack, Level level) {
        return this.getSongInfo(itemStack, level).map(RecordItem::m_43036_);
    }

    @Override
    public boolean supports(ItemStack itemStack) {
        return itemStack.m_41720_() instanceof RecordItem;
    }

    @Override
    public Optional<ItemStack> getRandomDisc(RandomSource randomSource) {
        List<Item> discs = this.getMusicDiscs();
        if (!discs.isEmpty()) {
            Item disc = discs.get(randomSource.m_188503_(discs.size()));
            return Optional.of(new ItemStack((ItemLike)disc, 1));
        }
        return Optional.empty();
    }

    @Override
    public int getMusicDiscSize() {
        return this.getMusicDiscs().size();
    }

    private List<Item> getMusicDiscs() {
        if (musicDiscs == null) {
            Map records = (Map)ObfuscationReflectionHelper.getPrivateValue(RecordItem.class, null, (String)"f_43032_");
            if (records == null) {
                musicDiscs = new ArrayList<Item>();
            } else {
                HashSet blockedDiscs = new HashSet(discBlockListGetter.get());
                musicDiscs = new ArrayList<Item>();
                records.forEach((sound, musicDisc) -> {
                    if (!blockedDiscs.contains(ForgeRegistries.ITEMS.getKey(musicDisc).toString())) {
                        musicDiscs.add((Item)musicDisc);
                    }
                });
            }
        }
        return musicDiscs;
    }

    public static void setDiscBlockListGetter(Supplier<List<? extends String>> getter) {
        discBlockListGetter = getter;
    }
}

