/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedcore.util;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.registries.ForgeRegistries;
import net.p3pp3rf1y.sophisticatedcore.inventory.InventoryHandler;
import net.p3pp3rf1y.sophisticatedcore.inventory.ItemStackKey;
import net.p3pp3rf1y.sophisticatedcore.util.InventoryHelper;

public class InventorySorter {
    public static final Comparator<Map.Entry<ItemStackKey, Integer>> BY_NAME = Comparator.comparing(o -> ((ItemStackKey)o.getKey()).getStack().m_41786_().getString());
    public static final Comparator<Map.Entry<ItemStackKey, Integer>> BY_MOD = Comparator.comparing(o -> {
        ResourceLocation registryName = ForgeRegistries.ITEMS.getKey((Object)((ItemStackKey)o.getKey()).getStack().m_41720_());
        return registryName == null ? null : registryName.m_135827_();
    }).thenComparing(o -> ((ItemStackKey)o.getKey()).getStack().m_41786_().getString());
    public static final Comparator<Map.Entry<ItemStackKey, Integer>> BY_COUNT = (first, second) -> {
        int ret = ((Integer)second.getValue()).compareTo((Integer)first.getValue());
        return ret != 0 ? ret : InventorySorter.getRegistryName((ItemStackKey)first.getKey()).compareTo(InventorySorter.getRegistryName((ItemStackKey)second.getKey()));
    };
    public static final Comparator<Map.Entry<ItemStackKey, Integer>> BY_TAGS = new Comparator<Map.Entry<ItemStackKey, Integer>>(){

        @Override
        public int compare(Map.Entry<ItemStackKey, Integer> first, Map.Entry<ItemStackKey, Integer> second) {
            ItemStack secondStack;
            Item secondItem;
            ItemStack firstStack = first.getKey().getStack();
            Item firstItem = firstStack.m_41720_();
            if (firstItem == (secondItem = (secondStack = second.getKey().getStack()).m_41720_())) {
                return 0;
            }
            int ret = this.compareTags(firstStack.m_204131_().collect(Collectors.toSet()), secondStack.m_204131_().collect(Collectors.toSet()));
            return ret != 0 ? ret : InventorySorter.getRegistryName(first.getKey()).compareTo(InventorySorter.getRegistryName(second.getKey()));
        }

        private int compareTags(Set<TagKey<Item>> firstTags, Set<TagKey<Item>> secondTags) {
            int ret = Integer.compare(secondTags.size(), firstTags.size());
            if (ret != 0) {
                return ret;
            }
            if (firstTags.size() == 1) {
                return firstTags.iterator().next().f_203868_().compareTo(secondTags.iterator().next().f_203868_());
            }
            ArrayList<TagKey<Item>> firstTagsSorted = new ArrayList<TagKey<Item>>(firstTags);
            ArrayList<TagKey<Item>> secondTagsSorted = new ArrayList<TagKey<Item>>(secondTags);
            firstTagsSorted.sort(Comparator.comparing(TagKey::f_203868_));
            secondTagsSorted.sort(Comparator.comparing(TagKey::f_203868_));
            for (int i = 0; i < firstTagsSorted.size(); ++i) {
                ret = firstTagsSorted.get(i).f_203868_().compareTo(secondTagsSorted.get(i).f_203868_());
                if (ret == 0) continue;
                return ret;
            }
            return 0;
        }
    };

    private InventorySorter() {
    }

    private static String getRegistryName(ItemStackKey itemStackKey) {
        return ForgeRegistries.ITEMS.getKey((Object)itemStackKey.getStack().m_41720_()).toString();
    }

    public static void sortHandler(IItemHandlerModifiable handler, Comparator<? super Map.Entry<ItemStackKey, Integer>> comparator, Set<Integer> noSortSlots) {
        Map<ItemStackKey, Integer> compactedStacks = InventoryHelper.getCompactedStacks((IItemHandler)handler, noSortSlots, false);
        ArrayList<Map.Entry<ItemStackKey, Integer>> sortedList = new ArrayList<Map.Entry<ItemStackKey, Integer>>(compactedStacks.entrySet());
        sortedList.sort(comparator);
        int slots = handler.getSlots();
        InventorySorter.sortIntoNoSortSlots(handler, noSortSlots, sortedList);
        InventorySorter.sortIntoOtherSlots(handler, noSortSlots, sortedList, slots);
    }

    private static void sortIntoOtherSlots(IItemHandlerModifiable handler, Set<Integer> noSortSlots, List<Map.Entry<ItemStackKey, Integer>> sortedList, int slots) {
        Iterator<Map.Entry<ItemStackKey, Integer>> ite = sortedList.iterator();
        ItemStackKey current = null;
        int count = 0;
        for (int slot = 0; slot < slots; ++slot) {
            if (noSortSlots.contains(slot)) continue;
            if ((current == null || count <= 0) && ite.hasNext()) {
                Map.Entry<ItemStackKey, Integer> entry = ite.next();
                current = entry.getKey();
                count = entry.getValue();
            }
            if (current != null && count > 0) {
                count -= InventorySorter.placeStack(handler, current, count, slot, false);
                continue;
            }
            InventorySorter.emptySlot(handler, slot);
        }
    }

    private static void sortIntoNoSortSlots(IItemHandlerModifiable handler, Set<Integer> noSortSlots, List<Map.Entry<ItemStackKey, Integer>> sortedList) {
        Iterator<Map.Entry<ItemStackKey, Integer>> it = sortedList.iterator();
        if (!noSortSlots.isEmpty()) {
            block0: while (it.hasNext()) {
                Map.Entry<ItemStackKey, Integer> entry = it.next();
                ItemStackKey current = entry.getKey();
                Integer count = entry.getValue();
                for (int slot : noSortSlots) {
                    ItemStack slotStack = handler.getStackInSlot(slot);
                    if (!ItemHandlerHelper.canItemStacksStack((ItemStack)slotStack, (ItemStack)current.getStack())) continue;
                    int placedCount = InventorySorter.placeStack(handler, current, count, slot, true);
                    count = count - placedCount;
                    entry.setValue(count);
                    if (count > 0) continue;
                    it.remove();
                    continue block0;
                }
            }
        }
    }

    private static void emptySlot(IItemHandlerModifiable handler, int slot) {
        if (!handler.getStackInSlot(slot).m_41619_()) {
            if (handler instanceof InventoryHandler) {
                InventoryHandler inventoryHandler = (InventoryHandler)handler;
                inventoryHandler.setSlotStack(slot, ItemStack.f_41583_);
            } else {
                handler.setStackInSlot(slot, ItemStack.f_41583_);
            }
        }
    }

    private static int placeStack(IItemHandlerModifiable handler, ItemStackKey current, int count, int slot, boolean countWithCurrentStack) {
        if (handler instanceof InventoryHandler) {
            InventoryHandler inventoryHandler = (InventoryHandler)handler;
            return InventorySorter.placeStack(current, count, slot, countWithCurrentStack, (s, stack) -> inventoryHandler.getBaseStackLimit(stack), inventoryHandler::getSlotStack, inventoryHandler::setSlotStack);
        }
        return InventorySorter.placeStack(current, count, slot, countWithCurrentStack, (s, stack) -> handler.getSlotLimit(s), arg_0 -> ((IItemHandlerModifiable)handler).getStackInSlot(arg_0), (arg_0, arg_1) -> ((IItemHandlerModifiable)handler).setStackInSlot(arg_0, arg_1));
    }

    private static int placeStack(ItemStackKey current, int count, int slot, boolean countWithCurrentStack, IStackLimitGetter stackLimitGetter, ISlotStackGetter slotStackGetter, ISlotStackSetter slotStackSetter) {
        ItemStack copy = current.getStack().m_41777_();
        int slotLimit = stackLimitGetter.getStackLimit(slot, copy);
        int existingCount = slotStackGetter.getSlotStack(slot).m_41613_();
        if (countWithCurrentStack) {
            count += existingCount;
        }
        int countPlaced = Math.min(count, slotLimit);
        copy.m_41764_(countPlaced);
        if (!ItemStack.m_41728_((ItemStack)slotStackGetter.getSlotStack(slot), (ItemStack)copy)) {
            slotStackSetter.setSlotStack(slot, copy);
        }
        return countWithCurrentStack ? countPlaced - existingCount : countPlaced;
    }

    private static interface IStackLimitGetter {
        public int getStackLimit(int var1, ItemStack var2);
    }

    private static interface ISlotStackGetter {
        public ItemStack getSlotStack(int var1);
    }

    private static interface ISlotStackSetter {
        public void setSlotStack(int var1, ItemStack var2);
    }
}

