/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.mcdragonlib.client;

import de.mrjulsen.mcdragonlib.client.gui.widgets.base.DLWindow;
import de.mrjulsen.mcdragonlib.client.gui.widgets.base.DLWindowManager;
import de.mrjulsen.mcdragonlib.client.gui.widgets.base.WindowBuilder;
import de.mrjulsen.mcdragonlib.client.util.DLGuiGraphics;
import de.mrjulsen.mcdragonlib.client.util.GuiUtils;
import dev.architectury.event.EventResult;
import dev.architectury.event.events.client.ClientGuiEvent;
import dev.architectury.event.events.client.ClientPlayerEvent;
import dev.architectury.event.events.client.ClientScreenInputEvent;
import dev.architectury.event.events.client.ClientTickEvent;
import java.util.Optional;
import net.minecraft.client.Minecraft;

public final class DLOverlayManager {
    private static DLWindowManager root;

    private DLOverlayManager() {
    }

    public static final boolean initialized() {
        return root != null;
    }

    public static void init() {
        ClientTickEvent.CLIENT_POST.register(mc -> {
            if (!DLOverlayManager.initialized()) {
                return;
            }
            root.tick();
        });
        ClientGuiEvent.INIT_POST.register((guiGraphics, screen) -> {
            if (!DLOverlayManager.initialized()) {
                return;
            }
            root.updateLayout((int)GuiUtils.getScreenWidth(), (int)GuiUtils.getScreenHeight());
        });
        ClientPlayerEvent.CLIENT_PLAYER_JOIN.register(mc -> {
            if (!DLOverlayManager.initialized()) {
                return;
            }
            root.close();
        });
        ClientGuiEvent.RENDER_HUD.register((guiGraphics, partialTick) -> {
            if (!DLOverlayManager.initialized()) {
                return;
            }
            DLGuiGraphics graphics = new DLGuiGraphics(guiGraphics, guiGraphics.m_280168_(), Minecraft.m_91087_().f_91062_, partialTick);
            root.render(graphics, (int)GuiUtils.mouseXOnScreen(), (int)GuiUtils.mouseYOnScreen());
        });
        ClientScreenInputEvent.CHAR_TYPED_POST.register((mc, screen, codePoint, modifiers) -> {
            if (!DLOverlayManager.initialized()) {
                return EventResult.pass();
            }
            boolean result = root.charTyped(codePoint, modifiers);
            return result ? EventResult.interruptTrue() : EventResult.pass();
        });
        ClientScreenInputEvent.KEY_PRESSED_POST.register((mc, screen, keyCode, scanCode, modifiers) -> {
            if (!DLOverlayManager.initialized()) {
                return EventResult.pass();
            }
            boolean result = root.keyPressed(keyCode, scanCode, modifiers);
            return result ? EventResult.interruptTrue() : EventResult.pass();
        });
        ClientScreenInputEvent.KEY_RELEASED_POST.register((mc, screen, keyCode, scanCode, modifiers) -> {
            if (!DLOverlayManager.initialized()) {
                return EventResult.pass();
            }
            boolean result = root.keyReleased(keyCode, scanCode, modifiers);
            return result ? EventResult.interruptTrue() : EventResult.pass();
        });
        ClientScreenInputEvent.MOUSE_CLICKED_POST.register((mc, screen, mouseX, mouseY, button) -> {
            if (!DLOverlayManager.initialized()) {
                return EventResult.pass();
            }
            boolean result = root.mouseClicked(mouseX, mouseY, button);
            return result ? EventResult.interruptTrue() : EventResult.pass();
        });
        ClientScreenInputEvent.MOUSE_DRAGGED_POST.register((mc, screen, mouseX, mouseY, button, dragX, dragY) -> {
            if (!DLOverlayManager.initialized()) {
                return EventResult.pass();
            }
            boolean result = root.mouseDragged(mouseX, mouseY, button, dragX, dragY);
            return result ? EventResult.interruptTrue() : EventResult.pass();
        });
        ClientScreenInputEvent.MOUSE_RELEASED_PRE.register((mc, screen, mouseX, mouseY, button) -> {
            if (!DLOverlayManager.initialized()) {
                return EventResult.pass();
            }
            boolean result = root.mouseReleased(mouseX, mouseY, button);
            return result ? EventResult.interruptTrue() : EventResult.pass();
        });
        ClientPlayerEvent.CLIENT_PLAYER_QUIT.register(mc -> {
            if (!DLOverlayManager.initialized()) {
                return;
            }
            root.close();
        });
    }

    public static void mouseMoved(double mouseX, double mouseY) {
        if (!DLOverlayManager.initialized()) {
            return;
        }
        root.mouseMoved(mouseX, mouseY);
    }

    public static boolean mouseScrolled(double mouseX, double mouseY, double scrollX, double scrollY) {
        if (!DLOverlayManager.initialized()) {
            return false;
        }
        return root.mouseScrolled(mouseX, mouseY, scrollX, scrollY);
    }

    public static void resizeDisplay() {
        if (!DLOverlayManager.initialized()) {
            return;
        }
        root.updateLayout((int)GuiUtils.getScreenWidth(), (int)GuiUtils.getScreenHeight());
    }

    public static <T extends DLWindow> void addOverlay(WindowBuilder<T> builder) {
        if (Minecraft.m_91087_().f_91073_ == null || Minecraft.m_91087_().f_91074_ == null) {
            throw new IllegalStateException("Player must be in game to use overlays.");
        }
        if (!DLOverlayManager.initialized()) {
            root = new DLWindowManager(null, builder, GuiUtils.getScreenWidth(), GuiUtils.getScreenHeight(), mgr -> {
                root = null;
            });
        } else {
            root.createWindow(builder);
        }
    }

    public static Optional<DLWindowManager> getWindowManager() {
        return Optional.ofNullable(root);
    }
}

