/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.mcdragonlib.client.atlas;

import com.google.common.collect.ImmutableSet;
import de.mrjulsen.mcdragonlib.client.atlas.DLGuiTextureDataSerializer;
import de.mrjulsen.mcdragonlib.client.util.DLGuiGraphics;
import de.mrjulsen.mcdragonlib.client.util.GuiUtils;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.resources.ResourceLocation;

public class DLTextureSheetData {
    public static final AbstractSprite EMPTY_SPRITE = new StretchedSprite(new int[]{0, 0}, new int[]{0, 0});
    public static final DLTextureSheetData EMPTY = new DLTextureSheetData(Map.of("", EMPTY_SPRITE), new int[]{0, 0});
    public static final DLGuiTextureDataSerializer SERIALIZER = new DLGuiTextureDataSerializer();
    private final Map<String, AbstractSprite> sprites;
    private final int[] textureSize;
    private ResourceLocation location;

    public DLTextureSheetData(Map<String, AbstractSprite> sprites, int[] textureSize) {
        this.sprites = sprites;
        this.textureSize = textureSize;
        sprites.values().forEach(x -> x.setMetadata(this));
    }

    public Set<String> availableSprites() {
        return ImmutableSet.copyOf(this.sprites.keySet());
    }

    public AbstractSprite getSprite(String variant) {
        if (this.sprites.containsKey(variant)) {
            return this.sprites.get(variant);
        }
        if (this.sprites.containsKey("")) {
            return this.sprites.get("");
        }
        return EMPTY_SPRITE;
    }

    public int width() {
        return this.textureSize[0];
    }

    public int height() {
        return this.textureSize[1];
    }

    public void setTextureLocation(ResourceLocation location) {
        this.location = location;
    }

    public ResourceLocation location() {
        return this.location;
    }

    static {
        EMPTY.setTextureLocation(TextureManager.f_118466_);
    }

    public static abstract class AbstractSprite {
        private DLTextureSheetData data = EMPTY;

        void setMetadata(DLTextureSheetData data) {
            Objects.requireNonNull(data);
            this.data = data;
        }

        public DLTextureSheetData metadata() {
            return this.data;
        }

        public abstract void render(DLGuiGraphics var1, int var2, int var3, int var4, int var5);
    }

    public static class StretchedSprite
    extends AbstractSprite {
        private final int[] uv;
        private final int[] size;

        public StretchedSprite(int[] uv, int[] size) {
            this.uv = uv;
            this.size = size;
        }

        public int u() {
            return this.uv[0];
        }

        public int v() {
            return this.uv[1];
        }

        public int width() {
            return this.size[0];
        }

        public int height() {
            return this.size[1];
        }

        @Override
        public void render(DLGuiGraphics graphics, int x, int y, int w, int h) {
            graphics.graphics().m_280411_(this.metadata().location(), x, y, w, h, (float)this.u(), (float)this.v(), this.width(), this.height(), this.metadata().width(), this.metadata().height());
        }
    }

    public static class NineSlicedSprite
    extends AbstractSprite {
        private final int[] uv;
        private final int[] size;
        private final int[] borderSize;
        private final boolean tiledContent;
        private final boolean tiledBorder;

        public NineSlicedSprite(int[] uv, int[] size, int[] borderSize, boolean tiledBorder, boolean tiledContent) {
            this.uv = uv;
            this.size = size;
            this.borderSize = borderSize;
            this.tiledContent = tiledContent;
            this.tiledBorder = tiledBorder;
        }

        public int u() {
            return this.uv[0];
        }

        public int v() {
            return this.uv[1];
        }

        public int width() {
            return this.size[0];
        }

        public int height() {
            return this.size[1];
        }

        public int leftBorder() {
            return this.borderSize[0];
        }

        public int topBorder() {
            return this.borderSize[1];
        }

        public int rightBorder() {
            return this.borderSize[2];
        }

        public int bottomBorder() {
            return this.borderSize[3];
        }

        public boolean tiledContent() {
            return this.tiledContent;
        }

        public boolean tiledBorder() {
            return this.tiledBorder;
        }

        @Override
        public void render(DLGuiGraphics graphics, int x, int y, int w, int h) {
            GuiUtils.drawTexture(this.metadata().location(), graphics, x, y, this.leftBorder(), this.topBorder(), this.u(), this.v(), this.leftBorder(), this.topBorder(), this.tiledBorder() ? GuiUtils.TextureFillMode.TILE : GuiUtils.TextureFillMode.STRETCH, this.metadata().textureSize[0], this.metadata().textureSize[1]);
            GuiUtils.drawTexture(this.metadata().location(), graphics, x + w - this.rightBorder(), y, this.rightBorder(), this.topBorder(), this.u() + this.width() - this.rightBorder(), this.v(), this.rightBorder(), this.topBorder(), this.tiledBorder() ? GuiUtils.TextureFillMode.TILE : GuiUtils.TextureFillMode.STRETCH, this.metadata().textureSize[0], this.metadata().textureSize[1]);
            GuiUtils.drawTexture(this.metadata().location(), graphics, x, y + h - this.bottomBorder(), this.leftBorder(), this.bottomBorder(), this.u(), this.v() + this.height() - this.bottomBorder(), this.leftBorder(), this.bottomBorder(), this.tiledBorder() ? GuiUtils.TextureFillMode.TILE : GuiUtils.TextureFillMode.STRETCH, this.metadata().textureSize[0], this.metadata().textureSize[1]);
            GuiUtils.drawTexture(this.metadata().location(), graphics, x + w - this.rightBorder(), y + h - this.bottomBorder(), this.rightBorder(), this.bottomBorder(), this.u() + this.width() - this.rightBorder(), this.v() + this.height() - this.bottomBorder(), this.rightBorder(), this.bottomBorder(), this.tiledBorder() ? GuiUtils.TextureFillMode.TILE : GuiUtils.TextureFillMode.STRETCH, this.metadata().textureSize[0], this.metadata().textureSize[1]);
            GuiUtils.drawTexture(this.metadata().location(), graphics, x + this.leftBorder(), y, w - this.leftBorder() - this.rightBorder(), this.topBorder(), this.u() + this.leftBorder(), this.v(), this.width() - this.leftBorder() - this.rightBorder(), this.topBorder(), this.tiledBorder() ? GuiUtils.TextureFillMode.TILE : GuiUtils.TextureFillMode.STRETCH, this.metadata().textureSize[0], this.metadata().textureSize[1]);
            GuiUtils.drawTexture(this.metadata().location(), graphics, x + this.leftBorder(), y + h - this.bottomBorder(), w - this.leftBorder() - this.rightBorder(), this.bottomBorder(), this.u() + this.leftBorder(), this.v() + this.height() - this.bottomBorder(), this.width() - this.leftBorder() - this.rightBorder(), this.bottomBorder(), this.tiledBorder() ? GuiUtils.TextureFillMode.TILE : GuiUtils.TextureFillMode.STRETCH, this.metadata().textureSize[0], this.metadata().textureSize[1]);
            GuiUtils.drawTexture(this.metadata().location(), graphics, x, y + this.topBorder(), this.leftBorder(), h - this.topBorder() - this.bottomBorder(), this.u(), this.v() + this.topBorder(), this.leftBorder(), this.height() - this.topBorder() - this.bottomBorder(), this.tiledBorder() ? GuiUtils.TextureFillMode.TILE : GuiUtils.TextureFillMode.STRETCH, this.metadata().textureSize[0], this.metadata().textureSize[1]);
            GuiUtils.drawTexture(this.metadata().location(), graphics, x + w - this.rightBorder(), y + this.topBorder(), this.rightBorder(), h - this.topBorder() - this.bottomBorder(), this.u() + this.width() - this.rightBorder(), this.v() + this.topBorder(), this.rightBorder(), this.height() - this.topBorder() - this.bottomBorder(), this.tiledBorder() ? GuiUtils.TextureFillMode.TILE : GuiUtils.TextureFillMode.STRETCH, this.metadata().textureSize[0], this.metadata().textureSize[1]);
            GuiUtils.drawTexture(this.metadata().location(), graphics, x + this.rightBorder(), y + this.rightBorder(), w - this.rightBorder() - this.leftBorder(), h - this.topBorder() - this.bottomBorder(), this.u() + this.rightBorder(), this.v() + this.topBorder(), this.width() - this.rightBorder() - this.leftBorder(), this.height() - this.topBorder() - this.bottomBorder(), this.tiledContent() ? GuiUtils.TextureFillMode.TILE : GuiUtils.TextureFillMode.STRETCH, this.metadata().textureSize[0], this.metadata().textureSize[1]);
        }
    }

    public static class TiledSprite
    extends AbstractSprite {
        private final int[] uv;
        private final int[] size;

        public TiledSprite(int[] uv, int[] size) {
            this.uv = uv;
            this.size = size;
        }

        public int u() {
            return this.uv[0];
        }

        public int v() {
            return this.uv[1];
        }

        public int width() {
            return this.size[0];
        }

        public int height() {
            return this.size[1];
        }

        @Override
        public void render(DLGuiGraphics graphics, int x, int y, int w, int h) {
            GuiUtils.drawTexture(this.metadata().location(), graphics, x, y, w, h, this.u(), this.v(), this.width(), this.height(), GuiUtils.TextureFillMode.TILE, this.metadata().textureSize[0], this.metadata().textureSize[1]);
        }
    }
}

