/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.mcdragonlib.client.ber;

import com.mojang.blaze3d.font.GlyphInfo;
import de.mrjulsen.mcdragonlib.client.gui.widgets.richtext.PaddingF;
import de.mrjulsen.mcdragonlib.client.util.DLGraphics;
import de.mrjulsen.mcdragonlib.client.util.FontUtils;
import de.mrjulsen.mcdragonlib.client.util.RenderUtils;
import de.mrjulsen.mcdragonlib.data.ETextAlignment;
import de.mrjulsen.mcdragonlib.mixin.BakedGlyphAccessor;
import de.mrjulsen.mcdragonlib.util.DLColor;
import de.mrjulsen.mcdragonlib.util.Pair;
import de.mrjulsen.mcdragonlib.util.TextUtils;
import de.mrjulsen.mcdragonlib.util.math.Point;
import de.mrjulsen.mcdragonlib.util.math.Rectangle;
import de.mrjulsen.mcdragonlib.util.math.Size;
import de.mrjulsen.mcdragonlib.util.properties.BooleanProperty;
import de.mrjulsen.mcdragonlib.util.properties.ColorProperty;
import de.mrjulsen.mcdragonlib.util.properties.NumberProperty;
import de.mrjulsen.mcdragonlib.util.properties.Property;
import de.mrjulsen.mcdragonlib.util.properties.VirtualProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.client.gui.Font;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.util.FormattedCharSink;
import net.minecraft.util.Mth;
import net.minecraft.util.StringDecomposer;
import org.apache.commons.lang3.mutable.MutableFloat;
import org.joml.Vector3f;

public class BERLabel {
    protected static final Map<Integer, CharData> charDataCache = new ConcurrentHashMap<Integer, CharData>();
    public final Property<Rectangle> clippingArea = new Property<Rectangle>(Rectangle.withSize(0.0, 0.0, 32767.0, 32767.0));
    public final NumberProperty<Float> x = new NumberProperty<Float>(Float.valueOf(0.0f));
    public final NumberProperty<Float> y = new NumberProperty<Float>(Float.valueOf(0.0f));
    public final VirtualProperty<Point> position = new VirtualProperty<Point>(Point.of(0.0, 0.0), () -> Point.of(((Float)this.x.get()).floatValue(), ((Float)this.y.get()).floatValue()), p -> {
        this.x.set(Float.valueOf((float)p.x()));
        this.y.set(Float.valueOf((float)p.y()));
    });
    public final Property<ETextAlignment> horizontalAlign = new Property<ETextAlignment>(ETextAlignment.LEFT);
    public final Property<Component> text = new Property<MutableComponent>(TextUtils.empty());
    public final ColorProperty color = new ColorProperty(DLColor.WHITE, DLColor.WHITE);
    public final ColorProperty backgroundColor = new ColorProperty(DLColor.TRANSPARENT, DLColor.TRANSPARENT);
    public final Property<PaddingF> backgroundPadding = new Property<PaddingF>(new PaddingF(1.0f, 1.0f, 1.0f, 1.0f));
    public final BooleanProperty fullBackground = new BooleanProperty(false);
    public final BooleanProperty glowing = new BooleanProperty(false);
    public final NumberProperty<Float> preferredWidth = new NumberProperty<Float>(Float.valueOf(16.0f), Float.valueOf(0.0f), Float.valueOf(2.1474836E9f));
    public final NumberProperty<Float> preferredHeight = new NumberProperty<Float>(Float.valueOf(16.0f), Float.valueOf(0.0f), Float.valueOf(2.1474836E9f));
    public final VirtualProperty<Size> preferredSize = new VirtualProperty<Size>(Size.of(0.0, 0.0), () -> Size.of(((Float)this.preferredWidth.get()).floatValue(), ((Float)this.preferredHeight.get()).floatValue()), p -> {
        this.preferredWidth.set(Float.valueOf((float)p.w()));
        this.preferredHeight.set(Float.valueOf((float)p.h()));
    });
    public final VirtualProperty<Rectangle> layoutArea = new VirtualProperty<Rectangle>(Rectangle.withSize(0.0, 0.0, 2.147483647E9, 2.147483647E9), () -> Rectangle.withSize(((Float)this.x.get()).floatValue(), ((Float)this.y.get()).floatValue(), ((Float)this.preferredWidth.get()).floatValue(), ((Float)this.preferredHeight.get()).floatValue()), r -> {
        this.x.set(Float.valueOf((float)r.x()));
        this.y.set(Float.valueOf((float)r.y()));
        this.preferredWidth.set(Float.valueOf((float)r.width()));
        this.preferredHeight.set(Float.valueOf((float)r.height()));
    });
    public final NumberProperty<Float> horizontalMinScale = new NumberProperty<Float>(Float.valueOf(1.0f), Float.valueOf(0.0f), Float.valueOf(2.1474836E9f));
    public final NumberProperty<Float> horizontalMaxScale = new NumberProperty<Float>(Float.valueOf(1.0f), Float.valueOf(0.0f), Float.valueOf(2.1474836E9f));
    public final VirtualProperty<Pair<Float, Float>> horizontalScale = new VirtualProperty<Pair>(Pair.of(Float.valueOf(0.0f), Float.valueOf(0.0f)), () -> Pair.of((Float)this.horizontalMinScale.get(), (Float)this.horizontalMaxScale.get()), p -> {
        this.horizontalMinScale.set(Float.valueOf(((Float)p.getFirst()).floatValue()));
        this.horizontalMaxScale.set(Float.valueOf(((Float)p.getSecond()).floatValue()));
    });
    public final NumberProperty<Float> verticalMinScale = new NumberProperty<Float>(Float.valueOf(1.0f), Float.valueOf(0.0f), Float.valueOf(2.1474836E9f));
    public final NumberProperty<Float> verticalMaxScale = new NumberProperty<Float>(Float.valueOf(1.0f), Float.valueOf(0.0f), Float.valueOf(2.1474836E9f));
    public final VirtualProperty<Pair<Float, Float>> verticalScale = new VirtualProperty<Pair>(Pair.of(Float.valueOf(0.0f), Float.valueOf(0.0f)), () -> Pair.of((Float)this.verticalMinScale.get(), (Float)this.verticalMaxScale.get()), p -> {
        this.verticalMinScale.set(Float.valueOf(((Float)p.getFirst()).floatValue()));
        this.verticalMaxScale.set(Float.valueOf(((Float)p.getSecond()).floatValue()));
    });
    public final NumberProperty<Float> horizontalScrollingSpeed = new NumberProperty<Float>(Float.valueOf(4.0f));
    public final NumberProperty<Float> verticalScrollingSpeed = new NumberProperty<Float>(Float.valueOf(4.0f));
    public final Property<EScrollMode> horizontalScrollMode = new Property<EScrollMode>(EScrollMode.NEVER);
    public final Property<EScrollMode> verticalScrollMode = new Property<EScrollMode>(EScrollMode.NEVER);
    private final FontUtils fontUtils = new FontUtils(Style.f_131100_);
    private long lastRenderTime = 0L;
    private float horizontalScrollOffset = 0.0f;
    private float verticalScrollOffset = 0.0f;
    private List<StyledChar> cachedGlyphs = null;
    private float cachedUnscaledTextWidth = 0.0f;
    private Component lastRenderedText = null;
    private float cachedFinalHScale = 1.0f;
    private float cachedFinalVScale = 1.0f;

    public BERLabel() {
        charDataCache.clear();
        this.text.withAfterPropertyChangedCallback((oldVal, newVal) -> this.invalidateCache());
    }

    private void invalidateCache() {
        this.cachedGlyphs = null;
        this.cachedUnscaledTextWidth = 0.0f;
        this.lastRenderedText = null;
    }

    private CharData getCharData(int codePoint, Style style) {
        int key = codePoint;
        if (style.m_131154_()) {
            key |= 0x1000000;
        }
        return charDataCache.computeIfAbsent(key, c -> {
            boolean isBold = (c & 0x1000000) != 0;
            GlyphInfo info = this.fontUtils.fontSet.m_243128_(codePoint, isBold);
            BakedGlyphAccessor glyph = this.fontUtils.getGlyphAccessor(codePoint);
            float glyphUVWidth = glyph.dragonlib$getU1() - glyph.dragonlib$getU0();
            float glyphUVHeight = glyph.dragonlib$getV1() - glyph.dragonlib$getV0();
            return new CharData(codePoint, String.valueOf(Character.toChars(codePoint)), isBold, info, glyph, glyphUVWidth, glyphUVHeight);
        });
    }

    private void updateGlyphCache(Component component) {
        if (component == null || component.equals((Object)this.lastRenderedText)) {
            return;
        }
        ArrayList<StyledChar> glyphs = new ArrayList<StyledChar>();
        MutableFloat widthSum = new MutableFloat();
        StringDecomposer.m_14328_((FormattedText)component, (Style)Style.f_131099_, (charIndex, styl, codePoint) -> {
            CharData data = this.getCharData(codePoint, styl);
            float adv = data.glyphInfo().m_83827_(styl.m_131154_());
            glyphs.add(new StyledChar(data, styl, adv));
            widthSum.add(adv);
            return true;
        });
        this.cachedGlyphs = glyphs;
        this.cachedUnscaledTextWidth = widthSum.getValue().floatValue();
        this.lastRenderedText = component;
    }

    private void calculateFinalScales() {
        boolean vScrollActive;
        float idealScale;
        boolean hScrollActive;
        float charQuadSize = 8.0f;
        float targetW = ((Float)this.preferredWidth.get()).floatValue();
        float targetH = ((Float)this.preferredHeight.get()).floatValue();
        float minHScale = Math.max(((Float)this.horizontalMinScale.get()).floatValue(), 1.0E-4f);
        float maxHScale = ((Float)this.horizontalMaxScale.get()).floatValue() <= 0.0f ? Float.MAX_VALUE : ((Float)this.horizontalMaxScale.get()).floatValue();
        float minVScale = Math.max(((Float)this.verticalMinScale.get()).floatValue(), 1.0E-4f);
        float maxVScale = ((Float)this.verticalMaxScale.get()).floatValue() <= 0.0f ? Float.MAX_VALUE : ((Float)this.verticalMaxScale.get()).floatValue();
        float baseHScale = Mth.m_14036_((float)1.0f, (float)minHScale, (float)maxHScale);
        float baseVScale = Mth.m_14036_((float)1.0f, (float)minVScale, (float)maxVScale);
        float textHeightAtBaseScale = 8.0f * baseVScale;
        boolean vScrollNeeded = targetH > 0.0f && textHeightAtBaseScale > targetH;
        EScrollMode hMode = (EScrollMode)((Object)this.horizontalScrollMode.get());
        if (hMode == EScrollMode.ALWAYS) {
            hScrollActive = ((Float)this.horizontalScrollingSpeed.get()).floatValue() != 0.0f;
        } else {
            float f = idealScale = targetW > 0.0f && this.cachedUnscaledTextWidth > 0.0f ? targetW / this.cachedUnscaledTextWidth : 1.0f;
            hScrollActive = hMode == EScrollMode.WHEN_NEEDED && idealScale < minHScale ? ((Float)this.horizontalScrollingSpeed.get()).floatValue() != 0.0f : false;
        }
        if (hScrollActive) {
            this.cachedFinalHScale = baseHScale;
        } else {
            idealScale = targetW > 0.0f && this.cachedUnscaledTextWidth > 0.0f ? targetW / this.cachedUnscaledTextWidth : 1.0f;
            this.cachedFinalHScale = hMode == EScrollMode.FLEX_FIT && idealScale < minHScale ? minHScale : Mth.m_14036_((float)idealScale, (float)minHScale, (float)maxHScale);
        }
        EScrollMode vMode = (EScrollMode)((Object)this.verticalScrollMode.get());
        boolean bl = vScrollActive = ((Float)this.verticalScrollingSpeed.get()).floatValue() != 0.0f && (vMode == EScrollMode.ALWAYS || vMode == EScrollMode.WHEN_NEEDED && vScrollNeeded);
        if (vScrollActive) {
            this.cachedFinalVScale = baseVScale;
        } else {
            float idealScale2 = targetH > 0.0f ? targetH / 8.0f : 1.0f;
            this.cachedFinalVScale = Mth.m_14036_((float)idealScale2, (float)minVScale, (float)maxVScale);
        }
    }

    public void render(DLGraphics graphics) {
        this.render(graphics, (Boolean)this.glowing.get() != false ? 0xF000F0 : graphics.packedLight());
    }

    public void render(DLGraphics graphics, int light) {
        DLColor bgColor;
        float finalY;
        boolean vScrollActive;
        boolean hScrollActive;
        Component component = (Component)this.text.get();
        if (component == null || component.getString().isEmpty()) {
            return;
        }
        long currentTime = System.currentTimeMillis();
        float deltaTime = this.lastRenderTime == 0L ? 0.0f : (float)(currentTime - this.lastRenderTime) / 1000.0f;
        this.lastRenderTime = currentTime;
        float charQuadSize = 8.0f;
        this.updateGlyphCache(component);
        this.calculateFinalScales();
        float targetW = ((Float)this.preferredWidth.get()).floatValue();
        float targetH = ((Float)this.preferredHeight.get()).floatValue();
        float textX = ((Float)this.x.get()).floatValue();
        float textY = ((Float)this.y.get()).floatValue();
        float minHScale = Math.max(((Float)this.horizontalMinScale.get()).floatValue(), 1.0E-4f);
        float minVScale = Math.max(((Float)this.verticalMinScale.get()).floatValue(), 1.0E-4f);
        float baseVScale = Mth.m_14036_((float)1.0f, (float)minVScale, (float)(((Float)this.verticalMaxScale.get()).floatValue() <= 0.0f ? Float.MAX_VALUE : ((Float)this.verticalMaxScale.get()).floatValue()));
        float textHeightAtBaseScale = 8.0f * baseVScale;
        boolean vScrollNeeded = targetH > 0.0f && textHeightAtBaseScale > targetH;
        Rectangle initialBounds = (Rectangle)this.clippingArea.get();
        float finalClipLeft = (float)Math.max(initialBounds.left(), (double)textX);
        float finalClipRight = (float)(targetW > 0.0f ? Math.min(initialBounds.right(), (double)(textX + targetW)) : initialBounds.right());
        float finalClipTop = (float)Math.max(initialBounds.top(), (double)textY);
        float finalClipBottom = (float)(targetH > 0.0f ? Math.min(initialBounds.bottom(), (double)(textY + targetH)) : initialBounds.bottom());
        EScrollMode hMode = (EScrollMode)((Object)this.horizontalScrollMode.get());
        float finalHScale = this.cachedFinalHScale;
        if (hMode == EScrollMode.ALWAYS) {
            hScrollActive = ((Float)this.horizontalScrollingSpeed.get()).floatValue() != 0.0f;
        } else {
            float idealScale = targetW > 0.0f && this.cachedUnscaledTextWidth > 0.0f ? targetW / this.cachedUnscaledTextWidth : 1.0f;
            boolean bl = hScrollActive = hMode == EScrollMode.WHEN_NEEDED && idealScale < minHScale && ((Float)this.horizontalScrollingSpeed.get()).floatValue() != 0.0f;
        }
        if (hScrollActive) {
            finalClipLeft = (float)Math.max(initialBounds.left(), (double)textX);
            finalClipRight = (float)(targetW > 0.0f ? Math.min(initialBounds.right(), (double)(textX + targetW)) : initialBounds.right());
            float totalScrollRange = Math.max(0.0f, finalClipRight - finalClipLeft) + this.cachedUnscaledTextWidth * finalHScale;
            this.horizontalScrollOffset += ((Float)this.horizontalScrollingSpeed.get()).floatValue() * deltaTime;
            this.horizontalScrollOffset %= totalScrollRange;
        } else {
            if (hMode == EScrollMode.FLEX_FIT && targetW > 0.0f && this.cachedUnscaledTextWidth > 0.0f && targetW / this.cachedUnscaledTextWidth < minHScale) {
                finalClipRight = (float)initialBounds.right();
            }
            this.horizontalScrollOffset = 0.0f;
        }
        EScrollMode vMode = (EScrollMode)((Object)this.verticalScrollMode.get());
        float finalVScale = this.cachedFinalVScale;
        boolean bl = vScrollActive = ((Float)this.verticalScrollingSpeed.get()).floatValue() != 0.0f && (vMode == EScrollMode.ALWAYS || vMode == EScrollMode.WHEN_NEEDED && vScrollNeeded);
        if (vScrollActive) {
            finalClipTop = (float)Math.max(initialBounds.top(), (double)textY);
            finalClipBottom = (float)(targetH > 0.0f ? Math.min(initialBounds.bottom(), (double)(textY + targetH)) : initialBounds.bottom());
            float totalScrollRange = Math.max(0.0f, finalClipBottom - finalClipTop) + 8.0f * finalVScale;
            this.verticalScrollOffset += ((Float)this.verticalScrollingSpeed.get()).floatValue() * deltaTime;
            this.verticalScrollOffset %= totalScrollRange;
        } else {
            this.verticalScrollOffset = 0.0f;
        }
        Rectangle finalClipBounds = Rectangle.withSize(finalClipLeft, finalClipTop, Math.max(0.0f, finalClipRight - finalClipLeft), Math.max(0.0f, finalClipBottom - finalClipTop));
        if (targetW <= 0.0f || targetH <= 0.0f || finalClipBounds.width() <= 0.0 || finalClipBounds.height() <= 0.0) {
            return;
        }
        float totalScaledWidth = this.cachedUnscaledTextWidth * finalHScale;
        float totalScaledHeight = 8.0f * finalVScale;
        float finalX = hScrollActive ? (float)finalClipBounds.right() - this.horizontalScrollOffset : textX;
        float f = finalY = vScrollActive ? (float)finalClipBounds.bottom() - this.verticalScrollOffset : textY;
        if (!hScrollActive) {
            ETextAlignment alignment = (ETextAlignment)this.horizontalAlign.get();
            if (targetW > 0.0f) {
                if (alignment == ETextAlignment.CENTER) {
                    finalX = textX + (targetW - totalScaledWidth) / 2.0f;
                } else if (alignment == ETextAlignment.RIGHT) {
                    finalX = textX + targetW - totalScaledWidth;
                }
            } else if (alignment == ETextAlignment.CENTER) {
                finalX -= totalScaledWidth / 2.0f;
            } else if (alignment == ETextAlignment.RIGHT) {
                finalX -= totalScaledWidth;
            }
        }
        if ((bgColor = this.backgroundColor.get()) != null && bgColor.getAlphaF() > 0.0f) {
            float bgH;
            float bgW;
            float bgY;
            float bgX;
            PaddingF padding = (PaddingF)this.backgroundPadding.get();
            if (((Boolean)this.fullBackground.get()).booleanValue()) {
                bgX = textX;
                bgY = textY;
                bgW = targetW;
                if (bgW <= 0.0f || hMode == EScrollMode.FLEX_FIT && totalScaledWidth > bgW) {
                    bgW = totalScaledWidth;
                }
                if ((bgH = targetH) <= 0.0f || vMode == EScrollMode.FLEX_FIT && totalScaledHeight > bgH) {
                    bgH = totalScaledHeight;
                }
            } else {
                bgX = finalX;
                bgY = finalY;
                bgW = totalScaledWidth;
                bgH = totalScaledHeight;
            }
            float drawX = bgX - padding.left();
            float drawY = bgY - padding.top();
            float drawW = bgW + padding.left() + padding.right();
            float drawH = bgH + padding.top() + padding.bottom();
            float visibleX = Math.max(drawX, (float)Math.max(finalClipBounds.left() - (double)padding.left(), initialBounds.left()));
            float visibleY = Math.max(drawY, (float)Math.max(finalClipBounds.top() - (double)padding.top(), initialBounds.top()));
            float visibleRight = Math.min(drawX + drawW, (float)Math.min(finalClipBounds.right() + (double)padding.right(), initialBounds.right()));
            float visibleBottom = Math.min(drawY + drawH, (float)Math.min(finalClipBounds.bottom() + (double)padding.bottom(), initialBounds.bottom()));
            float visibleW = visibleRight - visibleX;
            float visibleH = visibleBottom - visibleY;
            if (visibleW > 0.0f && visibleH > 0.0f) {
                RenderUtils.fillColor(graphics, new Vector3f(visibleX, visibleY, 0.0f), visibleW, visibleH, bgColor, Direction.NORTH, light, false);
            }
        }
        graphics.poseStack().m_85836_();
        graphics.poseStack().m_85837_((double)finalX, (double)finalY, 0.001);
        float currentUnscaledX = 0.0f;
        for (StyledChar styledChar : this.cachedGlyphs) {
            CharData charData = styledChar.charData();
            Style style = styledChar.style();
            float glyphAdvance = styledChar.unscaledAdvance();
            float quadWidth = 8.0f * finalHScale;
            float quadHeight = 8.0f * finalVScale;
            float quadWorldX = finalX + currentUnscaledX * finalHScale;
            float quadWorldY = finalY;
            if ((double)(quadWorldX + quadWidth) < finalClipBounds.left() || (double)quadWorldX > finalClipBounds.right() || (double)(quadWorldY + quadHeight) < finalClipBounds.top() || (double)quadWorldY > finalClipBounds.bottom()) {
                currentUnscaledX += glyphAdvance;
                continue;
            }
            float u0Offset = 0.0f;
            float u1Offset = 0.0f;
            float v0Offset = 0.0f;
            float v1Offset = 0.0f;
            float clipXLeft = 0.0f;
            float clipXRight = 0.0f;
            float clipYTop = 0.0f;
            float clipYBottom = 0.0f;
            float glyphUWidth = charData.glyphUWidth();
            float glyphVHeight = charData.glyphVHeight();
            if ((double)quadWorldX < finalClipBounds.left()) {
                clipXLeft = (float)(finalClipBounds.left() - (double)quadWorldX) / quadWidth;
                u0Offset = glyphUWidth * clipXLeft;
            }
            if ((double)(quadWorldX + quadWidth) > finalClipBounds.right()) {
                clipXRight = (float)((double)(quadWorldX + quadWidth) - finalClipBounds.right()) / quadWidth;
                u1Offset = glyphUWidth * clipXRight;
            }
            if ((double)quadWorldY < finalClipBounds.top()) {
                clipYTop = (float)(finalClipBounds.top() - (double)quadWorldY) / quadHeight;
                v0Offset = glyphVHeight * clipYTop;
            }
            if ((double)(quadWorldY + quadHeight) > finalClipBounds.bottom()) {
                clipYBottom = (float)((double)(quadWorldY + quadHeight) - finalClipBounds.bottom()) / quadHeight;
                v1Offset = glyphVHeight * clipYBottom;
            }
            this.fontUtils.pushUV(charData.charCode());
            BakedGlyphAccessor glyph = charData.glyph();
            glyph.dragonlib$setU0(glyph.dragonlib$getU0() + u0Offset);
            glyph.dragonlib$setU1(glyph.dragonlib$getU1() - u1Offset);
            glyph.dragonlib$setV0(glyph.dragonlib$getV0() + v0Offset);
            glyph.dragonlib$setV1(glyph.dragonlib$getV1() - v1Offset);
            graphics.poseStack().m_85836_();
            graphics.poseStack().m_85841_(finalHScale, finalVScale, 1.0f);
            graphics.poseStack().m_252880_(currentUnscaledX, 0.0f, 0.0f);
            graphics.poseStack().m_252880_(8.0f * clipXLeft, 8.0f * clipYTop, 0.0f);
            graphics.poseStack().m_85841_(1.0f - clipXLeft - clipXRight, 1.0f - clipYTop - clipYBottom, 1.0f);
            int finalColor = this.color.get().getAsARGB();
            if (style.m_131135_() != null) {
                finalColor = style.m_131135_().m_131265_() | 0xFF000000;
            }
            Font font = this.fontUtils.font;
            Objects.requireNonNull(font);
            Font.StringRenderOutput sro = new Font.StringRenderOutput(font, graphics.multiBufferSource(), 0.0f, 0.0f, finalColor, style.m_131176_(), graphics.poseStack().m_85850_().m_252922_(), Font.DisplayMode.NORMAL, light);
            StringDecomposer.m_14346_((String)charData.charString(), (Style)style, (FormattedCharSink)sro);
            graphics.poseStack().m_85849_();
            this.fontUtils.popUV(charData.charCode());
            currentUnscaledX += glyphAdvance;
        }
        graphics.poseStack().m_85849_();
    }

    public float getRenderedWidth() {
        if (this.cachedGlyphs == null) {
            this.updateGlyphCache((Component)this.text.get());
        }
        this.calculateFinalScales();
        return this.cachedUnscaledTextWidth * this.cachedFinalHScale;
    }

    public float getRenderedHeight() {
        if (this.cachedGlyphs == null) {
            this.updateGlyphCache((Component)this.text.get());
        }
        this.calculateFinalScales();
        return 8.0f * this.cachedFinalVScale;
    }

    public static enum EScrollMode {
        NEVER,
        WHEN_NEEDED,
        ALWAYS,
        FLEX_FIT;

    }

    protected record CharData(int charCode, String charString, boolean isBold, GlyphInfo glyphInfo, BakedGlyphAccessor glyph, float glyphUWidth, float glyphVHeight) {
    }

    protected record StyledChar(CharData charData, Style style, float unscaledAdvance) {
    }
}

