/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.mcdragonlib.client.gui.container;

import de.mrjulsen.mcdragonlib.DragonLib;
import de.mrjulsen.mcdragonlib.client.gui.container.DLPlayerInventoryComponent;
import de.mrjulsen.mcdragonlib.client.gui.events.DLGuiStandardEvents;
import de.mrjulsen.mcdragonlib.client.gui.widgets.base.DLMenuWindow;
import de.mrjulsen.mcdragonlib.client.gui.widgets.base.DLWindow;
import de.mrjulsen.mcdragonlib.client.gui.widgets.base.DLWindowManager;
import de.mrjulsen.mcdragonlib.client.gui.widgets.components.DLButton;
import de.mrjulsen.mcdragonlib.client.gui.widgets.render.FlatButtonRenderer;
import de.mrjulsen.mcdragonlib.client.gui.widgets.util.EAlign;
import de.mrjulsen.mcdragonlib.client.render.DefaultGuiTextures;
import de.mrjulsen.mcdragonlib.client.util.DLGuiGraphics;
import de.mrjulsen.mcdragonlib.client.util.GuiUtils;
import de.mrjulsen.mcdragonlib.data.ETextAlignment;
import de.mrjulsen.mcdragonlib.menu.PlayerInventoryContainerMenu;
import de.mrjulsen.mcdragonlib.util.TextUtils;
import de.mrjulsen.mcdragonlib.util.math.Rectangle;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;

public class DLPlayerInventoryWindow
extends DLMenuWindow<PlayerInventoryContainerMenu> {
    private static final int HEADER_SIZE = 22;
    private static final int BUTTON_BORDER_DISTANCE = 5;
    private static final int BORDER = 6;

    public DLPlayerInventoryWindow(DLWindowManager manager) {
        super(PlayerInventoryContainerMenu.class, manager);
        this.movable.set(true);
        this.windowSpawnPosition.set(DLWindow.WindowPosition.CENTER);
        DLPlayerInventoryComponent<PlayerInventoryContainerMenu> inventory = new DLPlayerInventoryComponent<PlayerInventoryContainerMenu>(6, 22, (PlayerInventoryContainerMenu)this.menu);
        this.addComponent(inventory);
        this.setSize(inventory.width() + 12, inventory.height() + 22 + 6);
        DLButton closeBtn = new DLButton(this.width() - 5 - 16, 5, 16, 16);
        closeBtn.text.set((Component)TextUtils.text("\u00d7"));
        closeBtn.textColor.set(DragonLib.VANILLA_UI_FONT_COLOR);
        closeBtn.drawFontShadow.set(false);
        closeBtn.anchor.set2(new EAlign[]{EAlign.RIGHT, EAlign.TOP});
        closeBtn.componentRenderer.set(FlatButtonRenderer.INSTANCE);
        closeBtn.addEventListener(DLGuiStandardEvents.ClickEvent.class, (s, e) -> {
            this.getWindowManager().closeWindow(this);
            return false;
        });
        this.addComponent(closeBtn);
    }

    @Override
    public void renderMainLayer(DLGuiGraphics graphics, double mouseX, double mouseY, Rectangle renderBounds) {
        DefaultGuiTextures.DRAGONLIB_UI.getSprite("window_rounded").render(graphics, 0, 0, this.width(), this.height());
        Font font = Minecraft.m_91087_().f_91062_;
        Objects.requireNonNull(Minecraft.m_91087_().f_91062_);
        GuiUtils.drawString(graphics, font, 6, 12 - 9 / 2, (FormattedText)TextUtils.text("Inventory"), DragonLib.VANILLA_UI_FONT_COLOR, ETextAlignment.LEFT, false);
    }
}

