/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.mcdragonlib.client.gui.container;

import com.mojang.blaze3d.platform.InputConstants;
import de.mrjulsen.mcdragonlib.client.gui.events.DLGuiStandardEvents;
import de.mrjulsen.mcdragonlib.client.gui.widgets.base.DLGuiComponent;
import de.mrjulsen.mcdragonlib.client.gui.widgets.base.DLWindowManager;
import de.mrjulsen.mcdragonlib.client.gui.widgets.base.manager.InventoryManager;
import de.mrjulsen.mcdragonlib.client.gui.widgets.render.ILayeredStateRenderer;
import de.mrjulsen.mcdragonlib.client.gui.widgets.render.VanillaSlotRenderer;
import de.mrjulsen.mcdragonlib.client.util.DLGuiGraphics;
import de.mrjulsen.mcdragonlib.client.util.DLSprite;
import de.mrjulsen.mcdragonlib.client.util.GuiUtils;
import de.mrjulsen.mcdragonlib.util.DLColor;
import de.mrjulsen.mcdragonlib.util.math.Rectangle;
import de.mrjulsen.mcdragonlib.util.properties.Property;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;

public class DLSlot
extends DLGuiComponent {
    public final Property<DLSprite> icon = new Property<DLSprite>(DLSprite.empty());
    public final Property<ILayeredStateRenderer<SlotState>> componentRenderer = new Property<VanillaSlotRenderer>(VanillaSlotRenderer.VANILLA_SLOT);
    public final AbstractContainerMenu menu;
    private final Slot slot;
    private final int slotIndex;

    public DLSlot(int x, int y, int w, int h, Slot sl, AbstractContainerMenu menu) {
        super(x, y, w, h);
        this.menu = menu;
        this.slot = sl;
        this.slotIndex = sl.f_40219_;
        this.addEventListener(DLGuiStandardEvents.MouseDownEvent.class, (s, e) -> {
            this.handleMouseDownEvent((DLGuiStandardEvents.MouseDownEvent)e);
            return false;
        });
        this.addEventListener(DLGuiStandardEvents.MouseReleaseEvent.class, (sender, e) -> {
            this.handleMouseReleaseEvent((DLGuiStandardEvents.MouseReleaseEvent)e);
            return false;
        });
        this.addEventListener(DLGuiStandardEvents.DraggingOverEvent.class, (sender, e) -> {
            this.handleMouseDraggedEvent((DLGuiStandardEvents.DraggingOverEvent)e);
            return false;
        });
    }

    protected void handleMouseDownEvent(DLGuiStandardEvents.MouseDownEvent e) {
        InventoryManager manager = this.getWindowManager().addManager(InventoryManager::new);
        boolean pickItem = Minecraft.m_91087_().f_91066_.f_92097_.m_90830_(e.button()) && Minecraft.m_91087_().f_91072_.m_105290_();
        Slot slot = this.menu.m_38853_(this.slotIndex);
        int slotIndex = slot.f_40219_;
        long clickTime = Util.m_137550_();
        manager.setDoubleClick(manager.getLastClickedSlot() != null && manager.getLastClickedSlot().slot == slot && clickTime - manager.getLastClickTime() < 250L && manager.getLastClickButton() == e.button());
        manager.setSkipNextRelease(false);
        if (((Boolean)Minecraft.m_91087_().f_91066_.m_231828_().m_231551_()).booleanValue()) {
            if (slot != null && slot.m_6657_()) {
                manager.setSelectedSlot(this);
                manager.setDraggingItem(ItemStack.f_41583_);
                manager.setIsSplittingStack(e.button() == 1);
            } else {
                manager.setSelectedSlot(null);
            }
        } else if (!manager.isQuickCrafting()) {
            if (manager.getHoldingItem().m_41619_()) {
                if (pickItem) {
                    this.slotClicked(slotIndex, e.button(), ClickType.CLONE);
                } else {
                    boolean qickMoving = slotIndex != -999 && (InputConstants.m_84830_((long)Minecraft.m_91087_().m_91268_().m_85439_(), (int)340) || InputConstants.m_84830_((long)Minecraft.m_91087_().m_91268_().m_85439_(), (int)344));
                    ClickType clickType = ClickType.PICKUP;
                    if (qickMoving) {
                        manager.setLastQuickMoved(slot != null && slot.m_6657_() ? slot.m_7993_().m_41777_() : ItemStack.f_41583_);
                        clickType = ClickType.QUICK_MOVE;
                    } else if (slotIndex == -999) {
                        clickType = ClickType.THROW;
                    }
                    this.slotClicked(slotIndex, e.button(), clickType);
                }
                manager.setSkipNextRelease(true);
            } else {
                int n = e.button();
                manager.setQuickCrafting(true, n, switch (e.button()) {
                    case 0 -> 0;
                    case 1 -> 1;
                    case 2 -> 2;
                    default -> -1;
                });
            }
        }
        manager.setLastClickedSlot(this);
        manager.setLastClickTime(clickTime);
        manager.setLastClickedButton(e.button());
    }

    protected void handleMouseReleaseEvent(DLGuiStandardEvents.MouseReleaseEvent e) {
        Slot targetSlot;
        int targetSlotIndex;
        InventoryManager manager = this.getWindowManager().addManager(InventoryManager::new);
        DLSlot targetDLSlot = null;
        for (DLGuiComponent c : this.getWindowManager().getDraggedOverComponents()) {
            if (!(c instanceof DLSlot)) continue;
            DLSlot s = (DLSlot)c;
            targetDLSlot = s;
            break;
        }
        if (targetDLSlot == null) {
            targetDLSlot = this;
        }
        int n = targetSlotIndex = (targetSlot = targetDLSlot.slot) != null ? targetSlot.f_40219_ : -1;
        if (manager.isDoubleClick() && targetSlot != null && e.button() == 0 && this.menu.m_5882_(ItemStack.f_41583_, targetSlot)) {
            if (DLWindowManager.hasShiftDown()) {
                if (!manager.getQuickMovedItem().m_41619_()) {
                    for (Slot s : this.menu.f_38839_) {
                        if (s == null || !s.m_8010_((Player)Minecraft.m_91087_().f_91074_) || !s.m_6657_() || s.f_40218_ != targetSlot.f_40218_ || !AbstractContainerMenu.m_38899_((Slot)s, (ItemStack)manager.getQuickMovedItem(), (boolean)true)) continue;
                        this.slotClicked(s.f_40219_, e.button(), ClickType.QUICK_MOVE);
                    }
                }
            } else {
                this.slotClicked(targetSlotIndex, e.button(), ClickType.PICKUP_ALL);
            }
            manager.setSkipNextRelease(true);
        } else {
            if (manager.isQuickCrafting() && manager.getQuickCraftingButton() != e.button()) {
                manager.setQuickCrafting(false);
                manager.setSkipNextRelease(true);
                return;
            }
            if (manager.shouldSkipNextRelease()) {
                manager.setSkipNextRelease(false);
                return;
            }
            if (manager.getSelectedSlot() != null && ((Boolean)Minecraft.m_91087_().f_91066_.m_231828_().m_231551_()).booleanValue()) {
                if (e.button() == 0 || e.button() == 1) {
                    if (manager.getDraggingItem().m_41619_() && targetSlot != manager.getSelectedSlot().slot) {
                        manager.setDraggingItem(manager.getSelectedSlot().slot.m_7993_());
                    }
                    boolean canQuickReplace = AbstractContainerMenu.m_38899_((Slot)targetSlot, (ItemStack)manager.getDraggingItem(), (boolean)false);
                    if (targetSlotIndex != -1 && !manager.getDraggingItem().m_41619_() && canQuickReplace) {
                        this.slotClicked(manager.getSelectedSlot().slot.f_40219_, e.button(), ClickType.PICKUP);
                        this.slotClicked(targetSlotIndex, 0, ClickType.PICKUP);
                        if (this.menu.m_142621_().m_41619_()) {
                            manager.setSnapbackItem(ItemStack.f_41583_);
                        } else {
                            this.slotClicked(manager.getSelectedSlot().slot.f_40219_, e.button(), ClickType.PICKUP);
                            manager.setSnapbackStartX(Mth.m_14107_((double)(e.mouseX() + this.getXOnScreen())));
                            manager.setSnapbackStartY(Mth.m_14107_((double)(e.mouseY() + this.getYOnScreen())));
                            manager.setSnapbackEnd(manager.getSelectedSlot());
                            manager.setSnapbackItem(manager.getDraggingItem());
                            manager.setSnapbackTime(Util.m_137550_());
                        }
                    } else if (!manager.getDraggingItem().m_41619_()) {
                        manager.setSnapbackStartX(Mth.m_14107_((double)(e.mouseX() + this.getXOnScreen())));
                        manager.setSnapbackStartY(Mth.m_14107_((double)(e.mouseY() + this.getYOnScreen())));
                        manager.setSnapbackEnd(manager.getSelectedSlot());
                        manager.setSnapbackItem(manager.getDraggingItem());
                        manager.setSnapbackTime(Util.m_137550_());
                    }
                    this.clearDraggingState(manager);
                }
            } else if (manager.isQuickCrafting() && !manager.getQuickCraftingSlots().isEmpty()) {
                this.slotClicked(-999, AbstractContainerMenu.m_38930_((int)0, (int)manager.getQuickCraftingType()), ClickType.QUICK_CRAFT);
                for (Slot s : manager.getQuickCraftingSlots()) {
                    this.slotClicked(s.f_40219_, AbstractContainerMenu.m_38930_((int)1, (int)manager.getQuickCraftingType()), ClickType.QUICK_CRAFT);
                }
                this.slotClicked(-999, AbstractContainerMenu.m_38930_((int)2, (int)manager.getQuickCraftingType()), ClickType.QUICK_CRAFT);
            } else if (!this.menu.m_142621_().m_41619_()) {
                if (Minecraft.m_91087_().f_91066_.f_92097_.m_90830_(e.button())) {
                    this.slotClicked(targetSlotIndex, e.button(), ClickType.CLONE);
                } else {
                    boolean canQuickReplace;
                    boolean bl = canQuickReplace = targetSlotIndex != -999 && (InputConstants.m_84830_((long)Minecraft.m_91087_().m_91268_().m_85439_(), (int)340) || InputConstants.m_84830_((long)Minecraft.m_91087_().m_91268_().m_85439_(), (int)344));
                    if (canQuickReplace) {
                        manager.setLastQuickMoved(targetSlot != null && targetSlot.m_6657_() ? targetSlot.m_7993_().m_41777_() : ItemStack.f_41583_);
                    }
                    this.slotClicked(targetSlotIndex, e.button(), canQuickReplace ? ClickType.QUICK_MOVE : ClickType.PICKUP);
                }
            }
        }
        if (this.menu.m_142621_().m_41619_()) {
            manager.setLastClickTime(0L);
        }
        manager.setQuickCrafting(false);
    }

    protected void handleMouseDraggedEvent(DLGuiStandardEvents.DraggingOverEvent e) {
        DLSlot slot = null;
        if (e.other() != null) {
            for (DLGuiComponent c : e.other()) {
                DLSlot s;
                if (!(c instanceof DLSlot)) continue;
                slot = s = (DLSlot)c;
                break;
            }
        }
        InventoryManager manager = this.getWindowManager().addManager(InventoryManager::new);
        ItemStack itemStack = this.menu.m_142621_();
        if (manager.getSelectedSlot() != null && ((Boolean)Minecraft.m_91087_().f_91066_.m_231828_().m_231551_()).booleanValue()) {
            if (e.button() == 0 || e.button() == 1) {
                if (manager.getDraggingItem().m_41619_()) {
                    boolean stillOverOriginalSlot;
                    boolean bl = stillOverOriginalSlot = slot != null && slot == manager.getSelectedSlot();
                    if (!stillOverOriginalSlot && !manager.getSelectedSlot().slot.m_7993_().m_41619_()) {
                        manager.setDraggingItem(manager.getSelectedSlot().slot.m_7993_().m_41777_());
                    }
                } else if (manager.getDraggingItem().m_41613_() > 1 && slot != null && AbstractContainerMenu.m_38899_((Slot)slot.slot, (ItemStack)manager.getDraggingItem(), (boolean)false)) {
                    long l = Util.m_137550_();
                    if (manager.getQuickdropSlot() == slot.slot) {
                        if (l - manager.getQuickdropTime() > 500L) {
                            this.slotClicked(manager.getSelectedSlot().slot.f_40219_, 0, ClickType.PICKUP);
                            this.slotClicked(slot.slotIndex, 1, ClickType.PICKUP);
                            this.slotClicked(manager.getSelectedSlot().slot.f_40219_, 0, ClickType.PICKUP);
                            manager.setQuickdropTime(l + 750L);
                            manager.getDraggingItem().m_41774_(1);
                        }
                    } else {
                        manager.setQuickdropSlot(slot.slot);
                        manager.setQuickdropTime(l);
                    }
                }
            }
        } else if (manager.isQuickCrafting() && slot != null && !itemStack.m_41619_() && (itemStack.m_41613_() > manager.getQuickCraftingSlots().size() || manager.getQuickCraftingType() == 2) && AbstractContainerMenu.m_38899_((Slot)slot.slot, (ItemStack)itemStack, (boolean)true) && slot.slot.m_5857_(itemStack) && this.menu.m_5622_(slot.slot)) {
            manager.getQuickCraftingSlots().add(this.slot);
            manager.getQuickCraftingSlots().add(slot.slot);
            this.recalculateQuickCraftRemaining(manager);
        }
    }

    private void recalculateQuickCraftRemaining(InventoryManager manager) {
        ItemStack itemStack = this.menu.m_142621_();
        if (!itemStack.m_41619_() && manager.isQuickCrafting()) {
            if (manager.getQuickCraftingType() == 2) {
                manager.setQuickCraftingRemainder(itemStack.m_41741_());
            } else {
                int remainder = itemStack.m_41613_();
                for (Slot slot : manager.getQuickCraftingSlots()) {
                    ItemStack slotStack = slot.m_7993_();
                    int count = slotStack.m_41619_() ? 0 : slotStack.m_41613_();
                    int maxCount = Math.min(itemStack.m_41741_(), slot.m_5866_(itemStack));
                    int usedCount = Math.min(AbstractContainerMenu.m_278794_(manager.getQuickCraftingSlots(), (int)manager.getQuickCraftingType(), (ItemStack)itemStack) + count, maxCount);
                    remainder -= usedCount - count;
                }
                manager.setQuickCraftingRemainder(remainder);
            }
        }
    }

    protected void slotClicked(int slotId, int mouseButton, ClickType type) {
        Minecraft.m_91087_().f_91072_.m_171799_(this.menu.f_38840_, slotId, mouseButton, type, (Player)Minecraft.m_91087_().f_91074_);
    }

    public void clearDraggingState(InventoryManager manager) {
        manager.setDraggingItem(ItemStack.f_41583_);
        manager.setSelectedSlot(null);
    }

    @Override
    public void renderMainLayer(DLGuiGraphics graphics, double mouseX, double mouseY, Rectangle renderBounds) {
        InventoryManager manager = this.getWindowManager().addManager(InventoryManager::new);
        ItemStack itemStack = this.slot.m_7993_();
        ItemStack carriedStack = manager.getHoldingItem();
        String string = null;
        boolean renderHighlight = false;
        boolean renderEmptyIcon = false;
        if (manager.getSelectedSlot() != null && this.slot == manager.getSelectedSlot().slot && !manager.getDraggingItem().m_41619_() && manager.isSplittingStack() && !itemStack.m_41619_()) {
            itemStack = itemStack.m_255036_(itemStack.m_41613_() / 2);
        } else if (manager.isQuickCrafting() && manager.getQuickCraftingSlots().contains(this.slot) && !carriedStack.m_41619_()) {
            if (manager.getQuickCraftingSlots().size() == 1) {
                return;
            }
            if (AbstractContainerMenu.m_38899_((Slot)this.slot, (ItemStack)carriedStack, (boolean)true) && this.menu.m_5622_(this.slot)) {
                renderHighlight = true;
                int maxStackSize = Math.min(carriedStack.m_41741_(), this.slot.m_5866_(carriedStack));
                int stackSize = this.slot.m_7993_().m_41619_() ? 0 : this.slot.m_7993_().m_41613_();
                int count = AbstractContainerMenu.m_278794_(manager.getQuickCraftingSlots(), (int)manager.getQuickCraftingType(), (ItemStack)carriedStack) + stackSize;
                if (count > maxStackSize) {
                    count = maxStackSize;
                    String maxStackSizeTxt = ChatFormatting.YELLOW.toString();
                    string = maxStackSizeTxt + maxStackSize;
                }
                itemStack = carriedStack.m_255036_(count);
            } else {
                manager.getQuickCraftingSlots().remove(this.slot);
                this.recalculateQuickCraftRemaining(manager);
            }
        }
        if (!((Boolean)this.enabled.get()).booleanValue() && this.isMouseOver(mouseX, mouseY)) {
            ((ILayeredStateRenderer)this.componentRenderer.get()).renderSprite(graphics, 0, 0, this.width(), this.height(), this, SlotState.DISABLED_SELECTED);
        } else if (!((Boolean)this.enabled.get()).booleanValue()) {
            ((ILayeredStateRenderer)this.componentRenderer.get()).renderSprite(graphics, 0, 0, this.width(), this.height(), this, SlotState.DISABLED);
        } else if (this.isSelected()) {
            ((ILayeredStateRenderer)this.componentRenderer.get()).renderSprite(graphics, 0, 0, this.width(), this.height(), this, SlotState.SELECTED);
        } else {
            ((ILayeredStateRenderer)this.componentRenderer.get()).renderSprite(graphics, 0, 0, this.width(), this.height(), this, SlotState.NORMAL);
        }
        if (itemStack.m_41619_() && this.slot.m_6659_()) {
            DLSprite sprite = (DLSprite)this.icon.get();
            sprite.render(graphics, this.width() / 2 - sprite.getWidth() / 2, this.height() / 2 - sprite.getHeight() / 2);
        }
        if (!renderEmptyIcon) {
            if (renderHighlight) {
                GuiUtils.fill(graphics, 1, 1, 16, 16, DLColor.fromInt(-2130706433));
            }
            GuiUtils.renderItem(graphics, itemStack, 1, 1, 1.0f, true);
            GuiUtils.renderItemDecoration(graphics, itemStack, 1, 1, 1.0f, string);
        }
        if (!((Boolean)this.enabled.get()).booleanValue() && this.isMouseOver(mouseX, mouseY)) {
            ((ILayeredStateRenderer)this.componentRenderer.get()).renderSpritePost(graphics, 0, 0, this.width(), this.height(), this, SlotState.DISABLED_SELECTED);
        } else if (!((Boolean)this.enabled.get()).booleanValue()) {
            ((ILayeredStateRenderer)this.componentRenderer.get()).renderSpritePost(graphics, 0, 0, this.width(), this.height(), this, SlotState.DISABLED);
        } else if (this.isSelected()) {
            ((ILayeredStateRenderer)this.componentRenderer.get()).renderSpritePost(graphics, 0, 0, this.width(), this.height(), this, SlotState.SELECTED);
        } else {
            ((ILayeredStateRenderer)this.componentRenderer.get()).renderSpritePost(graphics, 0, 0, this.width(), this.height(), this, SlotState.NORMAL);
        }
    }

    @Override
    public void renderFrontLayer(DLGuiGraphics graphics, double mouseX, double mouseY, Rectangle renderBounds) {
        ItemStack itemstack;
        InventoryManager manager;
        if (this.isSelected() && ((manager = this.getWindowManager().addManager(InventoryManager::new)) == null || !manager.isHoldingItem() && manager.getDraggingItem().m_41619_()) && !(itemstack = this.menu.m_38853_(this.slotIndex).m_7993_()).m_41619_()) {
            Minecraft mc = Minecraft.m_91087_();
            graphics.graphics().m_280677_(mc.f_91062_, DLSlot.getTooltipFromItem(itemstack), itemstack.m_150921_(), (int)mouseX, (int)mouseY);
        }
    }

    public static List<Component> getTooltipFromItem(ItemStack item) {
        return item.m_41651_((Player)Minecraft.m_91087_().f_91074_, (TooltipFlag)(Minecraft.m_91087_().f_91066_.f_92125_ ? TooltipFlag.Default.f_256730_ : TooltipFlag.Default.f_256752_));
    }

    public Slot getSlot() {
        return this.slot;
    }

    public static enum SlotState {
        NORMAL,
        DISABLED,
        SELECTED,
        DISABLED_SELECTED;

    }
}

