/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.mcdragonlib.client.gui.widgets.base;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import de.mrjulsen.mcdragonlib.annotations.SupportsEvents;
import de.mrjulsen.mcdragonlib.client.gui.container.IMenuGuiComponent;
import de.mrjulsen.mcdragonlib.client.gui.events.DLGuiStandardEvents;
import de.mrjulsen.mcdragonlib.client.gui.widgets.base.DLMenuWindow;
import de.mrjulsen.mcdragonlib.client.gui.widgets.base.DLWindow;
import de.mrjulsen.mcdragonlib.client.gui.widgets.base.DLWindowManager;
import de.mrjulsen.mcdragonlib.client.gui.widgets.components.DLTooltip;
import de.mrjulsen.mcdragonlib.client.gui.widgets.layout.ILayoutManager;
import de.mrjulsen.mcdragonlib.client.gui.widgets.layout.LayoutResult;
import de.mrjulsen.mcdragonlib.client.gui.widgets.layout.NoLayout;
import de.mrjulsen.mcdragonlib.client.gui.widgets.util.Align;
import de.mrjulsen.mcdragonlib.client.gui.widgets.util.CursorType;
import de.mrjulsen.mcdragonlib.client.gui.widgets.util.EAlign;
import de.mrjulsen.mcdragonlib.client.gui.widgets.util.HitResult;
import de.mrjulsen.mcdragonlib.client.gui.widgets.util.RenderLayer;
import de.mrjulsen.mcdragonlib.client.util.DLGuiGraphics;
import de.mrjulsen.mcdragonlib.client.util.GuiUtils;
import de.mrjulsen.mcdragonlib.events.EventListenerWrapper;
import de.mrjulsen.mcdragonlib.events.IEvent;
import de.mrjulsen.mcdragonlib.events.IEventDispatcher;
import de.mrjulsen.mcdragonlib.util.Cache;
import de.mrjulsen.mcdragonlib.util.math.MathUtils;
import de.mrjulsen.mcdragonlib.util.math.Point;
import de.mrjulsen.mcdragonlib.util.math.Rectangle;
import de.mrjulsen.mcdragonlib.util.math.Size;
import de.mrjulsen.mcdragonlib.util.properties.BitflagProperty;
import de.mrjulsen.mcdragonlib.util.properties.BooleanProperty;
import de.mrjulsen.mcdragonlib.util.properties.NumberProperty;
import de.mrjulsen.mcdragonlib.util.properties.Property;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.PriorityQueue;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderType;
import org.apache.commons.lang3.mutable.MutableBoolean;

@SupportsEvents(value={DLGuiStandardEvents.RenderPreEvent.class, DLGuiStandardEvents.RenderEvent.class, DLGuiStandardEvents.RenderPostEvent.class, DLGuiStandardEvents.RenderOnScreenEvent.class, DLGuiStandardEvents.ClickEvent.class, DLGuiStandardEvents.RightClickEvent.class, DLGuiStandardEvents.MultiClickEvent.class, DLGuiStandardEvents.MousePressedEvent.class, DLGuiStandardEvents.FocusChangedEvent.class, DLGuiStandardEvents.MouseDownEvent.class, DLGuiStandardEvents.MouseHoldDownEvent.class, DLGuiStandardEvents.MouseReleaseEvent.class, DLGuiStandardEvents.MouseEnterEvent.class, DLGuiStandardEvents.MouseLeaveEvent.class, DLGuiStandardEvents.MouseMoveEvent.class, DLGuiStandardEvents.ScrollEvent.class, DLGuiStandardEvents.ComponentAddedEvent.class, DLGuiStandardEvents.ComponentRemovedEvent.class, DLGuiStandardEvents.TickEvent.class, DLGuiStandardEvents.DragBeginEvent.class, DLGuiStandardEvents.DragEvent.class, DLGuiStandardEvents.DragEndEvent.class, DLGuiStandardEvents.KeyPressEvent.class, DLGuiStandardEvents.KeyReleaseEvent.class, DLGuiStandardEvents.CharTypeEvent.class, DLGuiStandardEvents.ResizeBeginEvent.class, DLGuiStandardEvents.ResizeEvent.class, DLGuiStandardEvents.ResizeEndEvent.class, DLGuiStandardEvents.ComponentPosAndSizeChanged.class, DLGuiStandardEvents.DragComponentBeginEvent.class, DLGuiStandardEvents.DragComponentEvent.class, DLGuiStandardEvents.DragComponentEndEvent.class, DLGuiStandardEvents.DragComponentOverBeginEvent.class, DLGuiStandardEvents.DragComponentOverEndEvent.class, DLGuiStandardEvents.DragComponentOverEvent.class, DLGuiStandardEvents.DraggingOverEvent.class, DLGuiStandardEvents.VisibilityChangedEvent.class, DLGuiStandardEvents.EnabledChangedEvent.class, DLGuiStandardEvents.ResizableChangedEvent.class, DLGuiStandardEvents.MovableChangedEvent.class, DLGuiStandardEvents.ParentChangedEvent.class, DLGuiStandardEvents.ComponentsClearEvent.class, DLGuiStandardEvents.ScreenLayoutUpdatedEvent.class, DLGuiStandardEvents.ComponentLayoutUpdatedEvent.class, DLGuiStandardEvents.DropComponentEvent.class, DLGuiStandardEvents.DragAndDropFilesEvent.class, DLGuiStandardEvents.WindowManagerChangeEvent.class, DLGuiStandardEvents.CloseEvent.class})
public abstract class DLGuiComponent
implements IEventDispatcher<DLGuiComponent>,
AutoCloseable {
    private final Map<Class<? extends IEvent>, PriorityQueue<EventListenerWrapper<?>>> eventListeners = new HashMap();
    public static final int MOUSE_DRAG_THRESHOLD = 5;
    public static final byte DOUBLE_CLICK_COUNT = 2;
    public static final int MULTI_CLICK_SPEED_MS = 500;
    public static final int MOUSE_DOWN_INITIAL_DELAY = 10;
    private final ConcurrentLinkedDeque<DLGuiComponent> components = new ConcurrentLinkedDeque();
    private DLWindowManager windowManager = null;
    private DLGuiComponent parent;
    private double x;
    private double y;
    private double width;
    private double height;
    protected double scrollOffsetX;
    protected double scrollOffsetY;
    private boolean mouseSelected;
    private boolean mouseDown;
    private boolean focused;
    private boolean dragging;
    private boolean mouseInMoveArea = false;
    private Align resizeArea = Align.CENTER;
    protected Rectangle newBounds = Rectangle.EMPTY;
    private byte multiClickCount;
    private long multiClickLastMs = Long.MIN_VALUE;
    private int ticksHoldingDown;
    private double mouseDownX;
    private double mouseDownY;
    private int mouseDownButton;
    public final BooleanProperty enabled = (BooleanProperty)new BooleanProperty(true).withAfterPropertyChangedCallback(this::onEnabledChanged);
    public final BooleanProperty visible = (BooleanProperty)new BooleanProperty(true).withAfterPropertyChangedCallback(this::onVisibilityChanged);
    public final BooleanProperty resizable = (BooleanProperty)new BooleanProperty(false).withAfterPropertyChangedCallback((o, v) -> this.invokeEvent(this, new DLGuiStandardEvents.ResizableChangedEvent((boolean)v), true));
    public final BooleanProperty movable = (BooleanProperty)new BooleanProperty(false).withAfterPropertyChangedCallback((o, v) -> this.invokeEvent(this, new DLGuiStandardEvents.MovableChangedEvent((boolean)v), true));
    public final NumberProperty<Byte> multiClickable = new NumberProperty<Byte>(Byte.valueOf((byte)1), (byte)1, (byte)127);
    public final Property<CursorType> cursor = new Property<Object>(null);
    public final Property<Predicate<ConsumptionType>> inputConsumptionPolicy = new Property<Predicate<ConsumptionType>>(context -> context != ConsumptionType.SCROLL);
    public final BitflagProperty<EAlign> anchor = new BitflagProperty(EAlign.class, (Enum[])new EAlign[]{EAlign.LEFT, EAlign.TOP});
    public final Property<Size> minSize = new Property<Size>(Size.of(5.0, 5.0));
    public final Property<Size> maxSize = new Property<Size>(Size.INFINITY);
    public final NumberProperty<Double> scale = new NumberProperty<Double>(Double.valueOf(1.0), 0.01, 10.0);
    public final Property<DLTooltip> tooltip = new Property<DLTooltip>(DLTooltip.EMPTY);
    public final Property<ILayoutManager> layout = (Property)new Property<NoLayout>(NoLayout.INSTANCE).withAfterPropertyChangedCallback((o, v) -> v.arrangeComponents(this));
    public final Property<Object> layoutContraint = new Property<Object>(null);
    public final Property<Object> customData = new Property<Object>(null);
    public final BooleanProperty scrollToFocus = new BooleanProperty(true);
    protected final Cache<Double> globalX = new Cache<Double>(() -> this.getParent().map(p -> p.getXOnScreen()).orElse(0.0) + this.dX() * this.getParent().map(p -> (Double)p.scale.get()).orElse(1.0));
    protected final Cache<Double> globalY = new Cache<Double>(() -> this.getParent().map(p -> p.getYOnScreen()).orElse(0.0) + this.dY() * this.getParent().map(p -> (Double)p.scale.get()).orElse(1.0));
    private boolean layoutLoopFix = false;
    private boolean applyingLayout = false;
    private int dragOffsetX;
    private int dragOffsetY;
    private int dragOriginalWidth;
    private int dragOriginalHeight;
    private boolean isComponentDraggedOver = false;

    @Override
    public Map<Class<? extends IEvent>, PriorityQueue<EventListenerWrapper<?>>> getEventListeners() {
        return this.eventListeners;
    }

    public static final int getResizeBorderSize() {
        return (int)(10.0 / Minecraft.m_91087_().m_91268_().m_85449_());
    }

    public static final int getResizeCornerSize() {
        return DLGuiComponent.getResizeBorderSize() * 8;
    }

    public DLGuiComponent(int x, int y, int w, int h) {
        this.x = x;
        this.y = y;
        this.width = w;
        this.height = h;
        this.addEventListener(DLGuiStandardEvents.RenderEvent.class, (src, e) -> {
            if (src.width() <= 0 || src.height() <= 0) {
                return true;
            }
            switch (e.layer()) {
                case BACK: {
                    this.renderBackLayer(e.graphics(), e.mouseX(), e.mouseY(), e.renderBounds());
                    break;
                }
                case MAIN: {
                    this.renderMainLayer(e.graphics(), e.mouseX(), e.mouseY(), e.renderBounds());
                    break;
                }
                case FRONT: {
                    this.renderFrontLayer(e.graphics(), e.mouseX(), e.mouseY(), e.renderBounds());
                    break;
                }
                case OVERLAY: {
                    this.renderSpecialOverlay(e.graphics(), e.mouseX(), e.mouseY(), e.renderBounds());
                    break;
                }
            }
            return false;
        });
        this.addEventListener(DLGuiStandardEvents.RenderOnScreenEvent.class, (src, e) -> {
            if (this.isSelected() && this.tooltip.get() != DLTooltip.EMPTY) {
                ((DLTooltip)this.tooltip.get()).render(e.graphics(), (int)e.mouseX(), (int)e.mouseY());
            }
            this.renderOnScreen(e.graphics(), e.mouseX(), e.mouseY());
            return false;
        });
        this.addEventListener(DLGuiStandardEvents.ComponentPosAndSizeChanged.class, (s, e) -> {
            if (this.layoutLoopFix) {
                return false;
            }
            this.layoutLoopFix = true;
            this.getParent().ifPresent(p -> p.applyLayout());
            this.applyLayout();
            this.layoutLoopFix = false;
            return false;
        });
        this.addEventListener(DLGuiStandardEvents.ParentChangedEvent.class, (s, e) -> {
            this.applyLayout();
            return false;
        });
        this.addEventListener(DLGuiStandardEvents.ComponentAddedEvent.class, (s, e) -> {
            this.applyLayout();
            return false;
        });
        this.addEventListener(DLGuiStandardEvents.ComponentRemovedEvent.class, (s, e) -> {
            this.applyLayout();
            return false;
        });
        this.addEventListener(DLGuiStandardEvents.ScreenLayoutUpdatedEvent.class, (s, e) -> {
            this.applyLayout();
            return false;
        });
        this.addEventListener(DLGuiStandardEvents.ComponentsClearEvent.class, (s, e) -> {
            this.applyLayout();
            return false;
        });
    }

    protected final void applyLayout() {
        if (this.applyingLayout) {
            return;
        }
        this.applyingLayout = true;
        LayoutResult result = ((ILayoutManager)this.layout.get()).arrangeComponents(this);
        this.invokeEvent(this, new DLGuiStandardEvents.ComponentLayoutUpdatedEvent(result));
        this.applyingLayout = false;
    }

    protected void updateScreenLayout() {
    }

    @Override
    public void close() throws Exception {
        this.invokeEvent(this, new DLGuiStandardEvents.CloseEvent(), true);
        for (DLGuiComponent child : this.getComponents()) {
            child.close();
        }
    }

    public boolean isDragged() {
        return this.dragging;
    }

    public boolean isSelected() {
        return this.mouseSelected;
    }

    public boolean isFocused() {
        return this.focused;
    }

    public boolean isMouseDown() {
        return this.mouseDown;
    }

    public boolean isComponentDraggedOver() {
        return this.isComponentDraggedOver;
    }

    public int height() {
        return (int)this.height;
    }

    public int width() {
        return (int)this.width;
    }

    public int x() {
        return (int)this.x;
    }

    public int y() {
        return (int)this.y;
    }

    public double dHeight() {
        return this.height;
    }

    public double dWidth() {
        return this.width;
    }

    public double dX() {
        return this.x;
    }

    public double dY() {
        return this.y;
    }

    public double getXOnScreen() {
        return this.globalX.get();
    }

    public double getYOnScreen() {
        return this.globalY.get();
    }

    public Point toScreenCoordinates() {
        Point local = Point.of(this.dX() - this.getScrollOffsetX(), this.dY() - this.getScrollOffsetY());
        return this.getParent().map(parent -> parent.toScreenCoordinates().add(local)).orElse(local);
    }

    public double getGlobalScale() {
        return this.getParent().map(x -> x.getGlobalScale()).orElse(1.0) * (Double)this.scale.get();
    }

    protected void invalidateGlobalCoordinates(boolean x, boolean y) {
        if (x) {
            this.globalX.clear();
        }
        if (y) {
            this.globalY.clear();
        }
        this.forEachComponentMatching(t -> true, c -> c.invalidateGlobalCoordinates(x, y));
    }

    public void setX(double x) {
        double oldX = x;
        this.x = x;
        this.invalidateGlobalCoordinates(true, false);
        this.invokeEvent(this, new DLGuiStandardEvents.ComponentPosAndSizeChanged((int)oldX, (int)x, (int)this.y, (int)this.y, (int)this.width, (int)this.width, (int)this.height, (int)this.height));
    }

    public void setY(double y) {
        double oldY = this.x;
        this.y = y;
        this.invalidateGlobalCoordinates(false, true);
        this.invokeEvent(this, new DLGuiStandardEvents.ComponentPosAndSizeChanged((int)this.x, (int)this.x, (int)oldY, (int)y, (int)this.width, (int)this.width, (int)this.height, (int)this.height));
    }

    public void setLeft(double x) {
        double diff = this.dX() - x;
        this.setX(x);
        this.setWidth(this.dWidth() + diff);
    }

    public void setTop(double y) {
        double diff = y - this.dY();
        this.setY(y);
        this.setHeight(this.dHeight() + diff);
    }

    public void setWidth(double width) {
        double oldWidth = this.dWidth();
        this.width = width;
        double diff = width - oldWidth;
        for (DLGuiComponent child : this.getComponents()) {
            double k = child.dWidth() / 2.0;
            if (child.anchor.has(EAlign.RIGHT)) {
                if (child.anchor.has(EAlign.LEFT)) {
                    child.setWidth(child.dWidth() + diff);
                } else {
                    child.setX(this.dWidth() - child.dWidth());
                }
            }
            if (!child.anchor.hasNone(new EAlign[]{EAlign.LEFT, EAlign.RIGHT}) || !(oldWidth > 0.0) || this.width() <= 0) continue;
            double p = Math.max(1.0 / oldWidth * (child.dX() + k), 0.0);
            child.setX(p * this.dWidth() - k);
        }
        this.invokeEvent(this, new DLGuiStandardEvents.ComponentPosAndSizeChanged((int)this.x, (int)this.x, (int)this.y, (int)this.y, (int)oldWidth, (int)width, (int)this.height, (int)this.height));
    }

    public void setHeight(double height) {
        double oldHeight = this.dHeight();
        this.height = height;
        double diff = height - oldHeight;
        for (DLGuiComponent child : this.getComponents()) {
            double k = child.dHeight() / 2.0;
            if (child.anchor.has(EAlign.BOTTOM)) {
                if (child.anchor.has(EAlign.TOP)) {
                    child.setHeight(child.dHeight() + diff);
                } else {
                    child.setY(this.dHeight() - child.dHeight());
                }
            }
            if (!child.anchor.hasNone(new EAlign[]{EAlign.TOP, EAlign.BOTTOM}) || !(oldHeight > 0.0) || this.height() <= 0) continue;
            double p = Math.max(1.0 / oldHeight * (child.dY() + k), 0.0);
            child.setY(p * this.dHeight() - k);
        }
        this.invokeEvent(this, new DLGuiStandardEvents.ComponentPosAndSizeChanged((int)this.x, (int)this.x, (int)this.y, (int)this.y, (int)this.width, (int)this.width, (int)oldHeight, (int)height));
    }

    public void setPosition(double x, double y) {
        this.setX(x);
        this.setY(y);
    }

    public void setSize(double width, double height) {
        this.setWidth(width);
        this.setHeight(height);
    }

    public boolean bringToFront(DLGuiComponent component) {
        if (this.components.contains(component)) {
            this.components.remove(component);
            this.components.addLast(component);
            return true;
        }
        return false;
    }

    public boolean sendToBack(DLGuiComponent component) {
        if (this.components.contains(component)) {
            this.components.remove(component);
            this.components.addFirst(component);
            return true;
        }
        return false;
    }

    public void setScrollOffsetX(double scrollOffsetX) {
        this.scrollOffsetX = MathUtils.clamp(scrollOffsetX, 0.0, 2.147483647E9);
    }

    public void setScrollOffsetY(double scrollOffsetY) {
        this.scrollOffsetY = MathUtils.clamp(scrollOffsetY, 0.0, 2.147483647E9);
    }

    public double getScrollOffsetX() {
        return this.scrollOffsetX;
    }

    public double getScrollOffsetY() {
        return this.scrollOffsetY;
    }

    public void scrollIntoView(DLGuiComponent child) {
        if (!this.components.contains(child)) {
            return;
        }
        if ((double)(child.x() + child.width()) > this.getScrollOffsetX() + (double)this.width()) {
            this.setScrollOffsetX(child.x() + child.width() - this.width());
        } else if ((double)child.x() < this.getScrollOffsetX()) {
            this.setScrollOffsetX(child.x());
        }
        if ((double)(child.y() + child.height()) > this.getScrollOffsetY() + (double)this.height()) {
            this.setScrollOffsetY(child.y() + child.height() - this.height());
        } else if ((double)child.y() < this.getScrollOffsetY()) {
            this.setScrollOffsetY(child.y());
        }
    }

    public Rectangle getChildInteractionBounds() {
        return Rectangle.withSize(0.0, 0.0, Math.max(this.width(), 0), Math.max(this.height(), 0));
    }

    public Rectangle getInteractionBounds() {
        return Rectangle.withSize(0.0, 0.0, Math.max(this.width(), 0), Math.max(this.height(), 0));
    }

    public Rectangle getRenderBounds() {
        return Rectangle.withSize(0.0, 0.0, Math.max(this.width(), 0), Math.max(this.height(), 0));
    }

    public Rectangle getChildRenderBounds() {
        return Rectangle.withSize(0.0, 0.0, Math.max(this.width(), 0), Math.max(this.height(), 0));
    }

    public Rectangle getPositionBox() {
        return Rectangle.withSize(this.x(), this.y(), Math.max(this.width(), 0), Math.max(this.height(), 0));
    }

    public Rectangle getSurroundingCollisionBox() {
        return Rectangle.surroundingBase(this.getInteractionBounds(), (Rectangle[])this.getComponents().stream().map(DLGuiComponent::getSurroundingCollisionBox).toArray(Rectangle[]::new));
    }

    public double getLocalMouseX() {
        if (this.getWindowManager() == null) {
            return 0.0;
        }
        return this.getWindowManager().mouseXOnScreen() - this.getXOnScreen();
    }

    public double getLocalMouseY() {
        if (this.getWindowManager() == null) {
            return 0.0;
        }
        return this.getWindowManager().mouseYOnScreen() - this.getYOnScreen();
    }

    private void onEnabledChanged(boolean oldState, boolean newState) {
        this.invokeEvent(this, new DLGuiStandardEvents.EnabledChangedEvent(newState), false);
    }

    private void onVisibilityChanged(boolean oldState, boolean newState) {
        this.invokeEvent(this, new DLGuiStandardEvents.VisibilityChangedEvent(newState), false);
    }

    public <T extends DLGuiComponent> T addComponent(T component) {
        Objects.requireNonNull(component);
        if (component instanceof DLWindow) {
            throw new IllegalArgumentException("Cannot add windows as components.");
        }
        if (component instanceof IMenuGuiComponent) {
            if (!this.windowManager.supportsMenus()) {
                throw new IllegalArgumentException("The window manager doesn't support menus.");
            }
            if (this.getNextParentMatching(c -> c instanceof DLMenuWindow).isEmpty()) {
                throw new IllegalArgumentException("Cannot add menu components to non-menu windows.");
            }
        }
        this.components.add(component);
        component.setParent((DLGuiComponent)this);
        component.setWindowManager(this.windowManager);
        component.invalidateGlobalCoordinates(true, true);
        this.invokeEvent(this, new DLGuiStandardEvents.ComponentAddedEvent(component), true);
        return (T)component;
    }

    public <T extends DLGuiComponent> boolean removeComponent(T component) {
        Objects.requireNonNull(component);
        boolean b = this.components.remove(component);
        if (b) {
            ((DLGuiComponent)component).setParent(null);
            ((DLGuiComponent)component).setWindowManager(null);
            ((DLGuiComponent)component).invalidateGlobalCoordinates(true, true);
            this.invokeEvent(this, new DLGuiStandardEvents.ComponentRemovedEvent((DLGuiComponent)component), true);
        }
        return b;
    }

    public boolean isMouseOver(double mouseX, double mouseY) {
        return this.getInteractionBounds().collision(mouseX, mouseY);
    }

    public CursorType getCursor() {
        return this.resizeArea == Align.CENTER ? (this.mouseInMoveArea ? CursorType.ALLRESIZE : (CursorType)((Object)this.cursor.get())) : this.resizeArea.getCursor();
    }

    public int componentsCount() {
        return this.components.size();
    }

    public boolean hasComponents() {
        return !this.components.isEmpty();
    }

    public Optional<DLGuiComponent> getParent() {
        return Optional.ofNullable(this.parent);
    }

    public Optional<DLGuiComponent> getNextParentMatching(Predicate<DLGuiComponent> condition) {
        if (!this.getParent().isPresent()) {
            return Optional.empty();
        }
        DLGuiComponent parent = this.getParent().get();
        if (condition.test(parent)) {
            return Optional.of(parent);
        }
        return parent.getNextParentMatching(condition);
    }

    public void forEachComponentMatching(Predicate<DLGuiComponent> test, Consumer<DLGuiComponent> action) {
        for (DLGuiComponent component : this.getComponents()) {
            if (!test.test(component)) continue;
            action.accept(component);
        }
    }

    public <T extends DLGuiComponent> void forEachComponentMatching(Class<T> type, Predicate<T> test, Consumer<T> action) {
        for (DLGuiComponent component : this.getComponents()) {
            DLGuiComponent t;
            if (!component.getClass().equals(type) || !test.test(t = component)) continue;
            action.accept(t);
        }
    }

    public DLWindowManager getWindowManager() {
        return this.windowManager;
    }

    public void setWindowManager(DLWindowManager windowManager) {
        DLWindowManager oldManager = this.windowManager;
        this.windowManager = windowManager;
        this.invokeEvent(this, new DLGuiStandardEvents.WindowManagerChangeEvent(oldManager, windowManager), true);
        for (DLGuiComponent child : this.getComponents()) {
            child.setWindowManager(windowManager);
        }
    }

    <T extends DLGuiComponent> void setParent(T parent) {
        Optional<DLGuiComponent> oldParent = this.getParent();
        this.parent = parent;
        this.invokeEvent(this, new DLGuiStandardEvents.ParentChangedEvent(oldParent, Optional.ofNullable(parent)), true);
    }

    public List<DLGuiComponent> getComponents() {
        return ImmutableList.copyOf(this.components);
    }

    public List<DLGuiComponent> getComponentsMatching(Predicate<DLGuiComponent> predicate) {
        return this.components.stream().filter(predicate::test).toList();
    }

    public <T extends DLGuiComponent> List<T> getComponentsOfType(Class<T> type, boolean includeSubtypes) {
        ArrayList<DLGuiComponent> result = new ArrayList<DLGuiComponent>(this.componentsCount());
        for (DLGuiComponent obj : this.getComponents()) {
            if (includeSubtypes) {
                if (!type.isInstance(obj)) continue;
                result.add((DLGuiComponent)type.cast(obj));
                continue;
            }
            if (!obj.getClass().equals(type)) continue;
            result.add((DLGuiComponent)type.cast(obj));
        }
        return result;
    }

    public void clearComponents() {
        this.clearComponents(c -> true);
    }

    public void clearComponents(Predicate<DLGuiComponent> predicate) {
        MutableBoolean bool = new MutableBoolean();
        this.invokeEvent(this, new DLGuiStandardEvents.ComponentsClearEvent(IEvent.Phase.PRE, bool), true);
        if (bool.isTrue()) {
            return;
        }
        Iterator<DLGuiComponent> iterator = this.components.iterator();
        while (iterator.hasNext()) {
            DLGuiComponent component = iterator.next();
            if (!predicate.test(component)) continue;
            iterator.remove();
        }
        this.invokeEvent(this, new DLGuiStandardEvents.ComponentsClearEvent(IEvent.Phase.POST, bool), true);
    }

    public boolean setSelected(boolean b, double mouseX, double mouseY) {
        boolean hasChanged;
        boolean bl = hasChanged = this.mouseSelected != b;
        if (hasChanged) {
            if (b) {
                CursorType.set(this.getCursor());
                this.invokeEvent(this, new DLGuiStandardEvents.MouseEnterEvent(mouseX, mouseY), true);
            } else {
                CursorType.set(null);
                this.invokeEvent(this, new DLGuiStandardEvents.MouseLeaveEvent(mouseX, mouseY), true);
            }
            this.mouseSelected = b;
        } else if (b) {
            CursorType.set(this.getCursor());
            this.invokeEvent(this, new DLGuiStandardEvents.MouseMoveEvent(mouseX, mouseY), true);
        }
        if (b) {
            this.updateResizeArea(mouseX, mouseY);
            this.updateMoveArea(mouseX, mouseY);
        }
        return hasChanged;
    }

    public void updateMoveArea(double mouseX, double mouseY) {
        if (!((Boolean)this.movable.get()).booleanValue() || this.getResizeArea() != Align.CENTER) {
            this.setInMoveArea(false);
            return;
        }
        int dX = (int)mouseX;
        int dY = (int)mouseY;
        this.setInMoveArea(dX <= DLGuiComponent.getResizeBorderSize() || dX >= this.width() - DLGuiComponent.getResizeBorderSize() || dY <= DLGuiComponent.getResizeBorderSize() || dY >= this.height() - DLGuiComponent.getResizeBorderSize());
    }

    public void updateResizeArea(double mouseX, double mouseY) {
        boolean yCondition;
        if (!((Boolean)this.resizable.get()).booleanValue()) {
            this.setResizeArea(Align.CENTER);
            return;
        }
        int dX = (int)mouseX;
        int dY = (int)mouseY;
        int cornerWidthX = Math.min(DLGuiComponent.getResizeCornerSize(), this.width() / 2);
        int cornerHeightY = Math.min(DLGuiComponent.getResizeCornerSize(), this.height() / 2);
        if (dX > DLGuiComponent.getResizeBorderSize() && dX < this.width() - DLGuiComponent.getResizeBorderSize() && dY > DLGuiComponent.getResizeBorderSize() && dY < this.height() - DLGuiComponent.getResizeBorderSize()) {
            this.setResizeArea(Align.CENTER);
            return;
        }
        if (dY < cornerHeightY) {
            boolean xCondition;
            boolean bl = xCondition = (Boolean)this.movable.get() == false || this.width() >= DLGuiComponent.getResizeCornerSize() * 3 + 2 && dX > this.width() / 2 - DLGuiComponent.getResizeCornerSize() / 2 && dX < this.width() / 2 + DLGuiComponent.getResizeCornerSize() / 2;
            if (dX < cornerWidthX) {
                this.setResizeArea(Align.TOP_LEFT);
            } else if (dX > this.width() - cornerWidthX) {
                this.setResizeArea(Align.TOP_RIGHT);
            } else if (xCondition) {
                this.setResizeArea(Align.TOP);
            } else {
                this.setResizeArea(Align.CENTER);
            }
            return;
        }
        if (dY > this.height() - cornerHeightY) {
            boolean xCondition;
            boolean bl = xCondition = (Boolean)this.movable.get() == false || this.width() >= DLGuiComponent.getResizeCornerSize() * 3 + 2 && dX > this.width() / 2 - DLGuiComponent.getResizeCornerSize() / 2 && dX < this.width() / 2 + DLGuiComponent.getResizeCornerSize() / 2;
            if (dX < cornerWidthX) {
                this.setResizeArea(Align.BOTTOM_LEFT);
            } else if (dX > this.width() - cornerWidthX) {
                this.setResizeArea(Align.BOTTOM_RIGHT);
            } else if (xCondition) {
                this.setResizeArea(Align.BOTTOM);
            } else {
                this.setResizeArea(Align.CENTER);
            }
            return;
        }
        boolean bl = yCondition = (Boolean)this.movable.get() == false || this.height() >= DLGuiComponent.getResizeCornerSize() * 3 + 2 && dY > this.height() / 2 - DLGuiComponent.getResizeCornerSize() / 2 && dY < this.height() / 2 + DLGuiComponent.getResizeCornerSize() / 2;
        if (dX < cornerWidthX && yCondition) {
            this.setResizeArea(Align.LEFT);
        } else if (dX > this.width() - cornerWidthX && yCondition) {
            this.setResizeArea(Align.RIGHT);
        } else {
            this.setResizeArea(Align.CENTER);
        }
    }

    public boolean setFocus(boolean b) {
        boolean hasChanged = this.focused != b;
        this.focused = b;
        if (hasChanged) {
            this.invokeEvent(this, new DLGuiStandardEvents.FocusChangedEvent(b), true);
        }
        return hasChanged;
    }

    public boolean setMouseDown(boolean b, double mouseX, double mouseY, int button) {
        boolean hasChanged;
        this.mouseDownX = mouseX;
        this.mouseDownY = mouseY;
        this.mouseDownButton = button;
        boolean bl = hasChanged = this.mouseDown != b;
        if (hasChanged) {
            if (b) {
                this.invokeEvent(this, new DLGuiStandardEvents.MouseDownEvent(mouseX, mouseY, button), true);
            } else {
                this.invokeEvent(this, new DLGuiStandardEvents.MouseReleaseEvent(mouseX, mouseY, button), true);
                this.ticksHoldingDown = 0;
            }
            this.mouseDown = b;
        }
        return hasChanged;
    }

    public boolean setDragging(boolean b, double mouseX, double mouseY, int button, double mouseOriginX, double mouseOriginY, double dragX, double dragY, boolean dragThresholdTriggered, List<DLGuiComponent> dragOverComponents) {
        boolean hasChanged = this.dragging != b;
        this.dragging = b;
        if (hasChanged && b) {
            this.dragOffsetX = (int)(mouseX * this.getGlobalScale() - (double)this.x());
            this.dragOffsetY = (int)(mouseY * this.getGlobalScale() - (double)this.y());
            this.dragOriginalWidth = this.width();
            this.dragOriginalHeight = this.height();
        }
        if (this.getResizeArea() != Align.CENTER) {
            int newX1 = this.x();
            int newY1 = this.y();
            int newX2 = this.x() + this.width();
            int newY2 = this.y() + this.height();
            switch (this.getResizeArea()) {
                case TOP_LEFT: {
                    newX1 = MathUtils.clamp((int)(mouseX - (double)this.dragOffsetX), (int)((double)newX2 - ((Size)this.maxSize.get()).w()), (int)((double)newX2 - ((Size)this.minSize.get()).w()));
                    newY1 = MathUtils.clamp((int)(mouseY - (double)this.dragOffsetY), (int)((double)newY2 - ((Size)this.maxSize.get()).h()), (int)((double)newY2 - ((Size)this.minSize.get()).h()));
                    break;
                }
                case TOP: {
                    newY1 = MathUtils.clamp((int)(mouseY - (double)this.dragOffsetY), (int)((double)newY2 - ((Size)this.maxSize.get()).h()), (int)((double)newY2 - ((Size)this.minSize.get()).h()));
                    break;
                }
                case LEFT: {
                    newX1 = MathUtils.clamp((int)(mouseX - (double)this.dragOffsetX), (int)((double)newX2 - ((Size)this.maxSize.get()).w()), (int)((double)newX2 - ((Size)this.minSize.get()).w()));
                    break;
                }
                case BOTTOM_RIGHT: {
                    newX2 = MathUtils.clamp((int)(mouseX + (double)(this.dragOriginalWidth - this.dragOffsetX)), (int)((double)newX1 + ((Size)this.minSize.get()).w()), (int)((double)newX1 + ((Size)this.maxSize.get()).w()));
                    newY2 = MathUtils.clamp((int)(mouseY + (double)(this.dragOriginalHeight - this.dragOffsetY)), (int)((double)newY1 + ((Size)this.minSize.get()).h()), (int)((double)newY1 + ((Size)this.maxSize.get()).h()));
                    break;
                }
                case RIGHT: {
                    newX2 = MathUtils.clamp((int)(mouseX + (double)(this.dragOriginalWidth - this.dragOffsetX)), (int)((double)newX1 + ((Size)this.minSize.get()).w()), (int)((double)newX1 + ((Size)this.maxSize.get()).w()));
                    break;
                }
                case BOTTOM: {
                    newY2 = MathUtils.clamp((int)(mouseY + (double)(this.dragOriginalHeight - this.dragOffsetY)), (int)((double)newY1 + ((Size)this.minSize.get()).h()), (int)((double)newY1 + ((Size)this.maxSize.get()).h()));
                    break;
                }
                case BOTTOM_LEFT: {
                    newX1 = MathUtils.clamp((int)(mouseX - (double)this.dragOffsetX), (int)((double)newX2 - ((Size)this.maxSize.get()).w()), (int)((double)newX2 - ((Size)this.minSize.get()).w()));
                    newY2 = MathUtils.clamp((int)(mouseY + (double)(this.dragOriginalHeight - this.dragOffsetY)), (int)((double)newY1 + ((Size)this.minSize.get()).h()), (int)((double)newY1 + ((Size)this.maxSize.get()).h()));
                    break;
                }
                case TOP_RIGHT: {
                    newX2 = MathUtils.clamp((int)(mouseX + (double)(this.dragOriginalWidth - this.dragOffsetX)), (int)((double)newX1 + ((Size)this.minSize.get()).w()), (int)((double)newX1 + ((Size)this.maxSize.get()).w()));
                    newY1 = MathUtils.clamp((int)(mouseY - (double)this.dragOffsetY), (int)((double)newY2 - ((Size)this.maxSize.get()).h()), (int)((double)newY2 - ((Size)this.minSize.get()).h()));
                    break;
                }
            }
            if (hasChanged) {
                if (b) {
                    this.invokeEvent(this, new DLGuiStandardEvents.ResizeBeginEvent(mouseX, mouseY), true);
                } else {
                    this.newBounds = Rectangle.withPoints(newX1, newY1, newX2, newY2);
                    MutableBoolean cancel = new MutableBoolean(false);
                    this.invokeEvent(this, new DLGuiStandardEvents.ResizeEndEvent(mouseX, mouseY, newX1, newY1, newX2 - newX1, newY2 - newY1, cancel), true);
                    if (cancel.isFalse()) {
                        this.setPosition(newX1, newY1);
                        this.setSize(newX2 - newX1, newY2 - newY1);
                    }
                }
            } else if (b) {
                this.newBounds = Rectangle.withPoints(newX1, newY1, newX2, newY2);
                this.invokeEvent(this, new DLGuiStandardEvents.ResizeEvent(mouseX, mouseY, newX1, newY1, newX2 - newX1, newY2 - newY1), true);
            }
            return true;
        }
        if (dragThresholdTriggered && this.isInMoveArea()) {
            if (hasChanged) {
                if (b) {
                    this.invokeEvent(this, new DLGuiStandardEvents.DragComponentBeginEvent(mouseX, mouseY, button, dragOverComponents), true);
                } else {
                    this.newBounds = Rectangle.withSize((int)(mouseX - (double)this.dragOffsetX), (int)(mouseY - (double)this.dragOffsetY), this.width(), this.height());
                    MutableBoolean cancel = new MutableBoolean(false);
                    this.invokeEvent(this, new DLGuiStandardEvents.DragComponentEndEvent(mouseX, mouseY, button, (int)(mouseX - (double)this.dragOffsetX), (int)(mouseY - (double)this.dragOffsetY), dragOverComponents, cancel), true);
                    if (cancel.isFalse()) {
                        this.setPosition(mouseX * this.getGlobalScale() - (double)this.dragOffsetX, mouseY * this.getGlobalScale() - (double)this.dragOffsetY);
                    }
                }
            } else if (b) {
                this.newBounds = Rectangle.withSize((int)(mouseX - (double)this.dragOffsetX), (int)(mouseY - (double)this.dragOffsetY), this.width(), this.height());
                this.invokeEvent(this, new DLGuiStandardEvents.DragComponentEvent(mouseX, mouseY, button, (int)(mouseX - (double)this.dragOffsetX), (int)(mouseY - (double)this.dragOffsetY), dragX, dragY, dragOverComponents), true);
            }
            for (DLGuiComponent c : dragOverComponents) {
                if (b) continue;
                c.invokeEvent(c, new DLGuiStandardEvents.DropComponentEvent(this, mouseX, mouseY), true);
            }
            return true;
        }
        if (hasChanged) {
            if (b) {
                this.invokeEvent(this, new DLGuiStandardEvents.DragBeginEvent(mouseX, mouseY, button), true);
            } else {
                this.invokeEvent(this, new DLGuiStandardEvents.DragEndEvent(mouseX, mouseY, button, mouseOriginX, mouseOriginY, this.mouseDownX, this.mouseDownY), true);
            }
        } else if (b) {
            this.invokeEvent(this, new DLGuiStandardEvents.DragEvent(mouseX, mouseY, button, mouseOriginX, mouseOriginY, this.mouseDownX, this.mouseDownY, dragX, dragY), true);
        }
        return false;
    }

    public boolean setDragComponentOver(boolean b, List<DLGuiComponent> other, double mouseX, double mouseY, int button) {
        boolean hasChanged;
        boolean bl = hasChanged = this.isComponentDraggedOver != b;
        if (hasChanged) {
            if (b) {
                this.invokeEvent(this, new DLGuiStandardEvents.DragComponentOverBeginEvent(other, mouseX, mouseY, button), true);
            } else {
                this.invokeEvent(this, new DLGuiStandardEvents.DragComponentOverEndEvent(other, mouseX, mouseY, button), true);
            }
            this.isComponentDraggedOver = b;
        } else if (b) {
            this.invokeEvent(this, new DLGuiStandardEvents.DragComponentOverEvent(other, mouseX, mouseY, button), true);
        }
        return hasChanged;
    }

    public void setResizeArea(Align align) {
        boolean b = this.resizeArea != align;
        this.resizeArea = align;
        if (b) {
            CursorType.set(this.getCursor());
        }
    }

    public void setInMoveArea(boolean inside) {
        boolean b = this.mouseInMoveArea != inside;
        this.mouseInMoveArea = inside;
        if (b) {
            CursorType.set(this.getCursor());
        }
    }

    public Align getResizeArea() {
        return this.resizeArea;
    }

    public boolean isInMoveArea() {
        return this.mouseInMoveArea;
    }

    public void mouseClickDispatcher(double mouseX, double mouseY, int button) {
        if (this.dragging && (this.getResizeArea() != Align.CENTER || this.isInMoveArea())) {
            return;
        }
        if (this.multiClickLastMs < System.currentTimeMillis() - 500L) {
            this.multiClickCount = 0;
        }
        if (this.multiClickCount == 0) {
            this.invokeEvent(this, new DLGuiStandardEvents.MousePressedEvent(mouseX, mouseY, button), false);
            switch (button) {
                case 0: {
                    this.invokeEvent(this, new DLGuiStandardEvents.ClickEvent(mouseX, mouseY), false);
                    break;
                }
                case 1: {
                    this.invokeEvent(this, new DLGuiStandardEvents.RightClickEvent(mouseX, mouseY), false);
                }
            }
        } else {
            this.invokeEvent(this, new DLGuiStandardEvents.MultiClickEvent(mouseX, mouseY, button, (byte)(this.multiClickCount + 1)), false);
        }
        this.multiClickCount = (byte)(this.multiClickCount + 1);
        this.multiClickCount = (byte)(this.multiClickCount % Math.min(((Byte)this.multiClickable.get()).byteValue(), 126));
        this.multiClickLastMs = System.currentTimeMillis();
    }

    public HitResult iterateComponents(double mouseX, double mouseY, double xOffset, double yOffset, Rectangle bounds, Flags flags, ConsumptionType type, double parentScale) {
        boolean valid;
        HitResult result = new HitResult();
        if (flags.ignoredComponents().contains((Object)this)) {
            return result;
        }
        double currentScale = (Double)this.scale.get() * parentScale;
        boolean ignored = flags.ignored() || (Boolean)this.visible.get() == false;
        boolean focusFound = flags.focusFound();
        boolean eventConsumed = flags.eventConsumed();
        boolean enabled = flags.enabled() && (Boolean)this.enabled.get() != false;
        double localMouseX = (mouseX - xOffset) / parentScale;
        double localMouseY = (mouseY - yOffset) / parentScale;
        double scrollOffsetX = this.getScrollOffsetX() * currentScale;
        double scrollOffsetY = this.getScrollOffsetY() * currentScale;
        double scrolledMouseX = mouseX + scrollOffsetX;
        double scrolledMouseY = mouseY + scrollOffsetY;
        double scaledLocalMouseX = localMouseX / (Double)this.scale.get();
        double scaledLocalMouseY = localMouseY / (Double)this.scale.get();
        Rectangle newBounds = Rectangle.intersection(bounds, Rectangle.offset(this.getChildInteractionBounds(), xOffset, yOffset));
        Rectangle childBounds = Rectangle.offset(newBounds, scrollOffsetX, scrollOffsetY);
        List<DLGuiComponent> childs = this.getComponents();
        ListIterator<DLGuiComponent> children = childs.listIterator(childs.size());
        while (children.hasPrevious()) {
            DLGuiComponent component = children.previous();
            if (flags.ignoredComponents().contains((Object)component)) continue;
            HitResult hit = component.iterateComponents(scrolledMouseX, scrolledMouseY, xOffset + (double)component.x() * currentScale, yOffset + (double)component.y() * currentScale, childBounds, new Flags(eventConsumed, focusFound, ignored, enabled, flags.ignoredComponents(), flags.nonConsumable()), type, currentScale);
            result.addAll(hit.components());
            if (!childBounds.collision(scrolledMouseX, scrolledMouseY)) continue;
            eventConsumed |= hit.consumed();
            focusFound |= result.isPresent();
        }
        boolean bl = valid = this.isMouseOver(scaledLocalMouseX, scaledLocalMouseY) && newBounds.collision(mouseX, mouseY) && !ignored && !eventConsumed;
        if (valid) {
            result.add(enabled ? (focusFound ? HitResult.ComponentSelectionState.HIT : HitResult.ComponentSelectionState.FOCUSED) : HitResult.ComponentSelectionState.UNSELECTED, new HitResult.ComponentHitContext(this, scaledLocalMouseX, scaledLocalMouseY, (int)xOffset, (int)yOffset, enabled));
            result.consume(!flags.nonConsumable().contains((Object)this) && ((Predicate)this.inputConsumptionPolicy.get()).test(type));
        } else {
            result.add(HitResult.ComponentSelectionState.UNSELECTED, new HitResult.ComponentHitContext(this, scaledLocalMouseX, scaledLocalMouseY, (int)xOffset, (int)yOffset, enabled));
            result.consume(!flags.nonConsumable().contains((Object)this) && eventConsumed);
        }
        return result;
    }

    public final void renderEvent(DLGuiGraphics graphics, double mouseX, double mouseY, RenderLayer layer, double xOffset, double yOffset, double scrollOffsetX, double scrollOffsetY, Rectangle scissorBounds, double globalScale) {
        double currentScale = (Double)this.scale.get();
        globalScale *= currentScale;
        graphics.poseStack().m_85841_((float)currentScale, (float)currentScale, (float)currentScale);
        graphics.poseStack().m_85836_();
        this.invokeEvent(this, new DLGuiStandardEvents.RenderPreEvent(graphics, mouseX, mouseY, layer, scissorBounds), true);
        boolean useScissor = !layer.isSpecial() && layer != RenderLayer.FRONT && layer != RenderLayer.SCREEN_SPACE;
        int maxWidth = Minecraft.m_91087_().m_91268_().m_85445_();
        int maxHeight = Minecraft.m_91087_().m_91268_().m_85446_();
        if (useScissor) {
            int x1 = (int)Math.floor(Math.max(scissorBounds.x(), (double)(-maxWidth)));
            int y1 = (int)Math.floor(Math.max(scissorBounds.y(), (double)(-maxHeight)));
            int w = (int)Math.ceil(scissorBounds.width());
            int h = (int)Math.ceil(scissorBounds.height());
            GuiUtils.enableScissor(graphics, x1, y1, w, h);
        }
        this.invokeEvent(this, new DLGuiStandardEvents.RenderEvent(graphics, mouseX += this.getScrollOffsetX(), mouseY += this.getScrollOffsetY(), layer, scissorBounds), true);
        if (layer.isSpecial()) {
            if (useScissor) {
                GuiUtils.disableScissor(graphics);
            }
            graphics.poseStack().m_85849_();
            return;
        }
        Rectangle childRenderBounds = this.getChildRenderBounds();
        Rectangle childClipBounds = Rectangle.intersection(scissorBounds, Rectangle.offset(childRenderBounds, xOffset, yOffset));
        for (DLGuiComponent child : this.getComponents()) {
            Rectangle intersection;
            if (!((Boolean)child.visible.get()).booleanValue()) continue;
            double localChildX = (double)child.x() - this.getScrollOffsetX();
            double localChildY = (double)child.y() - this.getScrollOffsetY();
            Rectangle renderBounds = child.getRenderBounds();
            double childScreenX = xOffset + (localChildX + renderBounds.x()) * globalScale;
            double childScreenY = yOffset + (localChildY + renderBounds.y()) * globalScale;
            double childScreenW = renderBounds.width() * globalScale;
            double childScreenH = renderBounds.height() * globalScale;
            if (childScreenX + childScreenW <= childClipBounds.x() || childScreenY + childScreenH <= childClipBounds.y() || childScreenX >= childClipBounds.x() + childClipBounds.width() || childScreenY >= childClipBounds.y() + childClipBounds.height() || (intersection = Rectangle.intersection(childClipBounds, Rectangle.withSize((renderBounds.x() + localChildX) * globalScale + xOffset, (renderBounds.y() + localChildY) * globalScale + yOffset, renderBounds.width() * globalScale, renderBounds.height() * globalScale))).width() <= 0.0 || intersection.height() <= 0.0) continue;
            graphics.poseStack().m_85836_();
            graphics.poseStack().m_85837_(localChildX, localChildY, 0.0);
            child.renderEvent(graphics, mouseX - localChildX * globalScale, mouseY - localChildY * globalScale, layer, xOffset + localChildX * globalScale, yOffset + localChildY * globalScale, scrollOffsetX + this.getScrollOffsetX(), scrollOffsetY + this.getScrollOffsetY(), intersection, globalScale);
            graphics.poseStack().m_85849_();
        }
        if (useScissor) {
            GuiUtils.disableScissor(graphics);
        }
        this.invokeEvent(this, new DLGuiStandardEvents.RenderPostEvent(graphics, mouseX, mouseY, layer, scissorBounds), true);
        graphics.poseStack().m_85849_();
    }

    public final void renderOnScreenEvent(DLGuiGraphics graphics, double mouseX, double mouseY) {
        this.invokeEvent(this, new DLGuiStandardEvents.RenderOnScreenEvent(graphics, mouseX, mouseY), true);
        for (DLGuiComponent child : this.getComponents()) {
            if (!((Boolean)child.visible.get()).booleanValue()) continue;
            graphics.poseStack().m_85836_();
            child.renderOnScreenEvent(graphics, mouseX, mouseY);
            graphics.poseStack().m_85849_();
        }
    }

    public final void updateLayoutEvent(int screenWidth, int screenHeight) {
        this.invokeEvent(this, new DLGuiStandardEvents.ScreenLayoutUpdatedEvent(IEvent.Phase.PRE), true);
        this.invalidateGlobalCoordinates(true, true);
        this.updateScreenLayout();
        this.invokeEvent(this, new DLGuiStandardEvents.ScreenLayoutUpdatedEvent(IEvent.Phase.POST), true);
        for (DLGuiComponent child : this.getComponents()) {
            child.updateLayoutEvent(screenWidth, screenHeight);
        }
    }

    public void tick() {
        if (this.isMouseDown()) {
            if (this.ticksHoldingDown <= 0 || this.ticksHoldingDown > 10) {
                this.invokeEvent(this, new DLGuiStandardEvents.MouseHoldDownEvent(this.mouseDownX, this.mouseDownY, this.mouseDownButton, this.ticksHoldingDown), true);
            }
            ++this.ticksHoldingDown;
        }
        this.getComponents().forEach(DLGuiComponent::tick);
        this.invokeEvent(this, new DLGuiStandardEvents.TickEvent(), true);
    }

    public void renderBackLayer(DLGuiGraphics graphics, double mouseX, double mouseY, Rectangle renderBounds) {
    }

    public void renderMainLayer(DLGuiGraphics graphics, double mouseX, double mouseY, Rectangle renderBounds) {
    }

    public void renderFrontLayer(DLGuiGraphics graphics, double mouseX, double mouseY, Rectangle renderBounds) {
    }

    public void renderOnScreen(DLGuiGraphics graphics, double mouseX, double mouseY) {
    }

    public void renderSpecialOverlay(DLGuiGraphics graphics, double mouseX, double mouseY, Rectangle renderBounds) {
        DLGuiComponent.renderBoundingBox(graphics, (int)(this.newBounds.x() - (double)this.x()), (int)(this.newBounds.y() - (double)this.y()), (int)this.newBounds.width(), (int)this.newBounds.height());
    }

    public static void renderBoundingBox(DLGuiGraphics graphics, int x, int y, int w, int h) {
        graphics.graphics().m_285944_(RenderType.m_285783_(), x + 0, y + 0, x + w, y + 1, -16776961);
        graphics.graphics().m_285944_(RenderType.m_285783_(), x + 0, y + h - 1, x + w, y + h, -16776961);
        graphics.graphics().m_285944_(RenderType.m_285783_(), x + 0, y + 1, x + 1, y + h - 1, -16776961);
        graphics.graphics().m_285944_(RenderType.m_285783_(), x + w - 1, y + 1, x + w, y + h - 1, -16776961);
    }

    public record Flags(boolean eventConsumed, boolean focusFound, boolean ignored, boolean enabled, ImmutableSet<DLGuiComponent> ignoredComponents, ImmutableSet<DLGuiComponent> nonConsumable) {
        public static final Flags EMPTY = new Flags(false, false, false, true, (ImmutableSet<DLGuiComponent>)ImmutableSet.of(), (ImmutableSet<DLGuiComponent>)ImmutableSet.of());
    }

    public static enum ConsumptionType {
        CLICK,
        MOUSE_MOVE,
        DRAG,
        SCROLL,
        DRAG_AND_DROP;

    }
}

