/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.mcdragonlib.client.gui.widgets.base;

import de.mrjulsen.mcdragonlib.annotations.SupportsEvents;
import de.mrjulsen.mcdragonlib.client.gui.widgets.base.DLGuiComponent;
import de.mrjulsen.mcdragonlib.client.gui.widgets.base.DLScreen;
import de.mrjulsen.mcdragonlib.client.gui.widgets.base.DLWindowManager;
import de.mrjulsen.mcdragonlib.client.gui.widgets.base.ModalId;
import de.mrjulsen.mcdragonlib.client.gui.widgets.base.WindowBuilder;
import de.mrjulsen.mcdragonlib.client.gui.widgets.util.EAlign;
import de.mrjulsen.mcdragonlib.events.IEvent;
import de.mrjulsen.mcdragonlib.util.properties.BooleanProperty;
import de.mrjulsen.mcdragonlib.util.properties.Property;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;

@SupportsEvents(value={WindowCreatedEvent.class, WindowFocusEvent.class})
public abstract class DLWindow
extends DLGuiComponent {
    private WindowSettings windowedSettings = null;
    private boolean resizeBypass = false;
    public final Property<WindowPosition> windowSpawnPosition = new Property<WindowPosition>(WindowPosition.CUSTOM);
    public final BooleanProperty fullscreen = (BooleanProperty)new BooleanProperty(false).withAfterPropertyChangedCallback((o, n) -> {
        if (n.booleanValue()) {
            this.resizeBypass = true;
            this.windowedSettings = new WindowSettings(this.x(), this.y(), this.width(), this.height(), (EAlign[])this.anchor.get());
            this.setPosition(0.0, 0.0);
            this.setSize(this.getWindowManager().getScreenWidth(), this.getWindowManager().getScreenHeight());
            this.anchor.set(EAlign.values());
            this.resizeBypass = false;
        } else if (!n.booleanValue() && this.windowedSettings != null) {
            this.setPosition(this.windowedSettings.x(), this.windowedSettings.y());
            this.setSize(this.windowedSettings.w(), this.windowedSettings.h());
            this.anchor.set(this.windowedSettings.anchor());
        }
    });
    public final BooleanProperty topLevel = new BooleanProperty(false);
    public final BooleanProperty focusOnSpawn = new BooleanProperty(true);
    public final BooleanProperty pauseGame = new BooleanProperty(false);
    private ModalId modal;

    public DLWindow(DLWindowManager manager) {
        super(0, 0, 150, 150);
        this.setWindowManager(manager);
        this.anchor.set2(new EAlign[0]);
        this.addEventListener(WindowCreatedEvent.class, (s, e) -> {
            switch (((WindowPosition)((Object)((Object)this.windowSpawnPosition.get()))).ordinal()) {
                case 1: {
                    this.setPosition(e.windowManager().getScreenWidth() / 2.0 - (double)(this.width() / 2), e.windowManager().getScreenHeight() / 2.0 - (double)(this.height() / 2));
                    break;
                }
                case 2: {
                    this.getParent().ifPresent(p -> {
                        if (p instanceof DLWindow) {
                            DLWindow win = (DLWindow)p;
                            this.setPosition(win.x() + win.width() / 2 - this.width() / 2, win.y() + win.height() / 2 - this.height() / 2);
                        }
                    });
                    break;
                }
                case 3: {
                    this.getParent().map(p -> {
                        if (p instanceof DLWindow) {
                            DLWindow win = (DLWindow)p;
                            this.setPosition(win.x(), win.y());
                        }
                        return null;
                    }).orElseGet(() -> {
                        this.setPosition(e.windowManager().getScreenWidth() / 2.0 - (double)(this.width() / 2), e.windowManager().getScreenHeight() / 2.0 - (double)(this.height() / 2));
                        return null;
                    });
                    break;
                }
            }
            return false;
        });
    }

    public void setParent(DLWindow parent) {
        super.setParent(parent);
    }

    final void assignToModal(ModalId id) {
        if (id != null && this.modal != null) {
            throw new IllegalStateException("Each window instance can only be shown once.");
        }
        this.modal = id;
    }

    public Optional<ModalId> getAssignedModal() {
        return Optional.ofNullable(this.modal);
    }

    @Override
    public void setWidth(double width) {
        if (((Boolean)this.fullscreen.get()).booleanValue() && !this.resizeBypass && !this.getWindowManager().isUpdatingLayout()) {
            return;
        }
        super.setWidth(width);
    }

    @Override
    public void setHeight(double height) {
        if (((Boolean)this.fullscreen.get()).booleanValue() && !this.resizeBypass && !this.getWindowManager().isUpdatingLayout()) {
            return;
        }
        super.setHeight(height);
    }

    @Override
    public void setX(double x) {
        if (((Boolean)this.fullscreen.get()).booleanValue() && !this.resizeBypass && !this.getWindowManager().isUpdatingLayout()) {
            return;
        }
        super.setX(x);
    }

    @Override
    public void setY(double y) {
        if (((Boolean)this.fullscreen.get()).booleanValue() && !this.resizeBypass && !this.getWindowManager().isUpdatingLayout()) {
            return;
        }
        super.setY(y);
    }

    public static <T extends DLWindow> T openWindow(WindowBuilder<T> builder) {
        AtomicReference<Object> window = new AtomicReference<Object>(null);
        DLScreen<Object> wrapper = new DLScreen<Object>(null, mgr -> {
            Object win = builder.build(mgr);
            window.set(win);
            return win;
        });
        Minecraft.m_91087_().m_91152_(wrapper);
        return (T)((DLWindow)window.get());
    }

    public static void closeWindow() {
        Screen screen = Minecraft.m_91087_().f_91080_;
        if (screen instanceof DLScreen) {
            DLScreen wrapper = (DLScreen)screen;
            wrapper.getWindowManager().close();
        } else {
            Minecraft.m_91087_().m_91152_(null);
        }
    }

    private record WindowSettings(double x, double y, double w, double h, EAlign[] anchor) {
    }

    public static enum WindowPosition {
        CUSTOM,
        CENTER,
        PARENT,
        PARENT_CENTER;

    }

    public record WindowCreatedEvent(DLWindowManager windowManager, ModalId id, int screenWidth, int screenHeight) implements IEvent
    {
    }

    public record WindowFocusEvent(DLWindowManager windowManager, boolean focus) implements IEvent
    {
    }
}

