/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.mcdragonlib.client.gui.widgets.base;

import de.mrjulsen.mcdragonlib.client.gui.widgets.base.DLWindow;
import de.mrjulsen.mcdragonlib.client.gui.widgets.base.ModalId;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.ConcurrentLinkedDeque;

public class ModalWindowStack
extends ConcurrentLinkedDeque<DLWindow> {
    private final ModalId id;

    public ModalWindowStack(UUID id) {
        Objects.requireNonNull(id);
        this.id = new ModalId(id);
    }

    @Override
    public boolean add(DLWindow win) {
        win.assignToModal(this.id);
        boolean b = super.add(win);
        return b;
    }

    @Override
    public DLWindow remove() {
        DLWindow win = (DLWindow)super.remove();
        win.assignToModal(null);
        return win;
    }

    @Override
    public void clear() {
        for (DLWindow win : this) {
            win.assignToModal(null);
        }
        super.clear();
    }

    public ModalId id() {
        return this.id;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof ModalWindowStack) {
            ModalWindowStack o = (ModalWindowStack)obj;
            return this.id.equals(o.id);
        }
        if (obj instanceof ModalId) {
            ModalId o = (ModalId)obj;
            return this.id.equals(o);
        }
        if (obj instanceof UUID) {
            UUID o = (UUID)obj;
            return this.id.equals(o);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.id.hashCode();
    }
}

