/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.mcdragonlib.client.gui.widgets.components;

import de.mrjulsen.mcdragonlib.annotations.SupportsEvents;
import de.mrjulsen.mcdragonlib.client.gui.events.DLGuiStandardEvents;
import de.mrjulsen.mcdragonlib.client.gui.widgets.base.DLGuiComponent;
import de.mrjulsen.mcdragonlib.client.gui.widgets.components.DLPanel;
import de.mrjulsen.mcdragonlib.client.gui.widgets.layout.FlowLayout;
import de.mrjulsen.mcdragonlib.client.gui.widgets.layout.LayoutResult;
import de.mrjulsen.mcdragonlib.client.gui.widgets.util.EAlign;
import de.mrjulsen.mcdragonlib.events.IEvent;
import de.mrjulsen.mcdragonlib.util.properties.BooleanProperty;
import de.mrjulsen.mcdragonlib.util.properties.ListProperty;
import de.mrjulsen.mcdragonlib.util.properties.Property;
import java.util.Iterator;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;

@SupportsEvents(value={ListLayoutChangedEvent.class, FilterChangedEvent.class})
public abstract class DLAbstractCollectionComponent<T, I extends DLCollectionItem<T, ?>>
extends DLGuiComponent {
    public final ListProperty<T> items = (ListProperty)new ListProperty<List>().withAfterPropertyChangedCallback((o, val) -> this.createComponents());
    public final Property<Function<T, I>> itemBuilder = (Property)new Property<Function<Object, DLCollectionItem>>(this::defaultItemBuilder).withAfterPropertyChangedCallback((a, b) -> this.createComponents());
    public final BooleanProperty itemResizeAllowed = new BooleanProperty(false);
    public final Property<Predicate<T>> filter = (Property)new Property<Predicate<Object>>(item -> true).withAfterPropertyChangedCallback((a, b) -> {
        this.createComponents();
        this.invokeEvent(this, new FilterChangedEvent());
    });
    protected final DLPanel contentPanel = new DLPanel(0, 0, this.width(), this.height());

    public DLAbstractCollectionComponent(int x, int y, int w, int h) {
        super(x, y, w, h);
        this.contentPanel.inputConsumptionPolicy.set(type -> type != DLGuiComponent.ConsumptionType.SCROLL);
        this.contentPanel.anchor.set(EAlign.values());
        FlowLayout layout = new FlowLayout();
        layout.wrap.set(false);
        layout.fillCrossAxis.set(true);
        layout.flowDirection.set(FlowLayout.Direction.VERTICAL);
        this.contentPanel.layout.set(layout);
        this.contentPanel.addEventListener(DLGuiStandardEvents.ComponentLayoutUpdatedEvent.class, (s, e) -> {
            this.invokeEvent(this.contentPanel, new ListLayoutChangedEvent(e.layoutResult()));
            return false;
        });
        this.addComponent(this.contentPanel);
    }

    protected void createComponents() {
        this.contentPanel.clearComponents();
        Iterator iterator = this.items.get().iterator();
        while (iterator.hasNext()) {
            Object item = iterator.next();
            if (!((Predicate)this.filter.get()).test(item)) continue;
            DLCollectionItem listItem = (DLCollectionItem)((Function)this.itemBuilder.get()).apply(item);
            this.contentPanel.addComponent(listItem);
        }
    }

    protected abstract I defaultItemBuilder(T var1);

    public static abstract class DLCollectionItem<T, L extends DLAbstractCollectionComponent<T, ?>>
    extends DLGuiComponent {
        protected final L collectionComponentRef;
        protected final T item;

        protected DLCollectionItem(L collectionComponentRef, T item, int w, int h) {
            super(0, 0, w, h);
            this.inputConsumptionPolicy.set(type -> type != DLGuiComponent.ConsumptionType.SCROLL);
            this.collectionComponentRef = collectionComponentRef;
            this.item = item;
        }

        public T getItem() {
            return this.item;
        }
    }

    public record ListLayoutChangedEvent(LayoutResult layoutResult) implements IEvent
    {
    }

    public record FilterChangedEvent() implements IEvent
    {
    }
}

