/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.mcdragonlib.client.gui.widgets.components;

import de.mrjulsen.mcdragonlib.client.gui.events.DLGuiStandardEvents;
import de.mrjulsen.mcdragonlib.client.gui.widgets.base.DLGuiComponent;
import de.mrjulsen.mcdragonlib.client.gui.widgets.components.DLAbstractCollectionComponent;
import de.mrjulsen.mcdragonlib.client.gui.widgets.components.DLPanel;
import de.mrjulsen.mcdragonlib.client.gui.widgets.util.EAlign;
import de.mrjulsen.mcdragonlib.util.properties.ListProperty;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.network.chat.Component;

public abstract class DLAbstractDataView<T, I extends DLDataViewItem<T, ?>>
extends DLAbstractCollectionComponent<T, I> {
    public final ListProperty<DataSlot> dataSlots = (ListProperty)new ListProperty<List>().withAfterPropertyChangedCallback((o, val) -> this.createComponents());

    public DLAbstractDataView(int x, int y, int w, int h) {
        super(x, y, w, h);
    }

    public static abstract class DLDataViewItem<T, L extends DLAbstractDataView<T, ?>>
    extends DLAbstractCollectionComponent.DLCollectionItem<T, L> {
        protected final DLPanel contentPanel;
        public final ListProperty<DataSlotComponent> subComponents = new ListProperty();

        protected DLDataViewItem(L collectionComponentRef, T item) {
            super(collectionComponentRef, item, 1, 1);
            this.contentPanel = new DLPanel(0, 0, this.width(), this.height());
            this.contentPanel.inputConsumptionPolicy.set(type -> type != DLGuiComponent.ConsumptionType.SCROLL);
            this.contentPanel.anchor.set(EAlign.values());
            this.addComponent(this.contentPanel);
            this.addEventListener(DLGuiStandardEvents.ComponentPosAndSizeChanged.class, (s, e) -> {
                if (e.widthChanged()) {
                    this.refresh();
                }
                return false;
            });
        }

        protected void refresh() {
            this.contentPanel.clearComponents();
            Map<String, DLGuiComponent> content = this.subComponents.stream().collect(Collectors.toMap(x -> x.name(), x -> x.component()));
            int totalWidth = ((DLAbstractDataView)this.collectionComponentRef).width();
            int fixedWidthSum = ((DLAbstractDataView)this.collectionComponentRef).dataSlots.stream().filter(s -> s.mode() == SizeMode.FIXED).mapToInt(s -> (int)s.size()).sum();
            int remainingWidth = Math.max(totalWidth - fixedWidthSum, 0);
            double percentTotal = ((DLAbstractDataView)this.collectionComponentRef).dataSlots.stream().filter(s -> s.mode == SizeMode.PERCENTAGE).mapToDouble(s -> s.size()).sum();
            HashMap<String, Integer> widths = new HashMap<String, Integer>();
            for (DataSlot s2 : ((DLAbstractDataView)this.collectionComponentRef).dataSlots) {
                if (s2.mode() == SizeMode.FIXED) {
                    widths.put(s2.name(), (int)s2.size());
                    continue;
                }
                double part = percentTotal == 0.0 ? 0.0 : s2.size() / percentTotal;
                widths.put(s2.name(), (int)Math.round((double)remainingWidth * part));
            }
            int x2 = 0;
            int maxH = 0;
            for (DataSlot s3 : ((DLAbstractDataView)this.collectionComponentRef).dataSlots) {
                int w = (Integer)widths.get(s3.name());
                DLGuiComponent c = content.get(s3.name());
                if (c != null) {
                    int h = c.height();
                    c.setPosition(x2, 0.0);
                    c.setSize(w, h);
                    maxH = Math.max(maxH, h);
                    this.contentPanel.addComponent(c);
                }
                x2 += w;
            }
            this.setHeight(maxH);
        }
    }

    public static enum SizeMode {
        FIXED,
        PERCENTAGE;

    }

    public record DataSlotComponent(String name, DLGuiComponent component) {
    }

    public record DataSlot(String name, Component displayName, double size, SizeMode mode) {
    }
}

