/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.mcdragonlib.client.gui.widgets.components;

import com.mojang.blaze3d.vertex.PoseStack;
import de.mrjulsen.mcdragonlib.client.gui.widgets.base.DLGuiComponent;
import de.mrjulsen.mcdragonlib.client.util.DLGuiGraphics;
import de.mrjulsen.mcdragonlib.util.DLUtils;
import de.mrjulsen.mcdragonlib.util.math.Rectangle;
import net.minecraft.client.Minecraft;

public class DLAnimator
extends DLGuiComponent {
    private int maxTicks;
    private int currentTicks;
    private float currentTicksSmooth;
    private boolean running;
    private IAnimatorRenderCallback onAnimateRender;
    private IAnimatorTickCallback onAnimateTick;
    private Runnable onCompleted;

    public DLAnimator() {
        super(0, 0, 1, 1);
    }

    @Override
    public void setWidth(double width) {
    }

    @Override
    public void setHeight(double height) {
    }

    @Override
    public void setX(double x) {
    }

    @Override
    public void setY(double y) {
    }

    public boolean isRunning() {
        return this.running;
    }

    public int getTotalTicks() {
        return this.maxTicks;
    }

    public int getCurrentTicks() {
        return this.currentTicks;
    }

    public float getCurrentTicksSmooth() {
        return this.currentTicksSmooth;
    }

    public float getPercentage() {
        return 1.0f / (float)this.maxTicks * this.currentTicksSmooth;
    }

    @Override
    public Rectangle getRenderBounds() {
        return Rectangle.INFINITE;
    }

    @Override
    public void renderMainLayer(DLGuiGraphics graphics, double mouseX, double mouseY, Rectangle renderBounds) {
        if (this.running) {
            float frameTime = Minecraft.m_91087_().m_91297_();
            this.currentTicksSmooth += frameTime;
            DLUtils.doIfNotNull(this.onAnimateRender, x -> x.execute(graphics.poseStack(), this.getCurrentTicks(), this.getTotalTicks(), this.getPercentage()));
            if (this.currentTicks >= this.maxTicks) {
                this.stop();
                DLUtils.doIfNotNull(this.onCompleted, x -> x.run());
            }
        }
    }

    @Override
    public void tick() {
        if (this.running) {
            DLUtils.doIfNotNull(this.onAnimateTick, x -> x.execute(this.getCurrentTicks(), this.getTotalTicks(), this.getPercentage()));
            ++this.currentTicks;
            this.currentTicksSmooth = this.currentTicks;
            if (this.currentTicks >= this.maxTicks) {
                this.currentTicksSmooth = this.maxTicks;
                this.stop();
                DLUtils.doIfNotNull(this.onCompleted, x -> x.run());
            }
        }
    }

    public void start(int ticks, IAnimatorRenderCallback renderCallback, IAnimatorTickCallback tickCallback, Runnable onCompleted) {
        this.currentTicks = 0;
        this.currentTicksSmooth = 0.0f;
        this.maxTicks = ticks;
        this.onAnimateRender = renderCallback;
        this.onAnimateTick = tickCallback;
        this.onCompleted = onCompleted;
        this.running = true;
    }

    public void stop() {
        this.running = false;
        this.currentTicks = 1;
        this.currentTicksSmooth = 1.0f;
        this.maxTicks = 1;
    }

    @FunctionalInterface
    public static interface IAnimatorRenderCallback {
        public void execute(PoseStack var1, int var2, int var3, double var4);
    }

    @FunctionalInterface
    public static interface IAnimatorTickCallback {
        public void execute(int var1, int var2, double var3);
    }
}

