/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.mcdragonlib.client.gui.widgets.components;

import de.mrjulsen.mcdragonlib.DragonLib;
import de.mrjulsen.mcdragonlib.client.gui.events.DLGuiStandardEvents;
import de.mrjulsen.mcdragonlib.client.gui.widgets.base.DLGuiComponent;
import de.mrjulsen.mcdragonlib.client.gui.widgets.base.DLWindow;
import de.mrjulsen.mcdragonlib.client.gui.widgets.base.DLWindowManager;
import de.mrjulsen.mcdragonlib.client.gui.widgets.base.ModalId;
import de.mrjulsen.mcdragonlib.client.gui.widgets.base.WindowBuilder;
import de.mrjulsen.mcdragonlib.client.gui.widgets.components.DLAbstractCollectionComponent;
import de.mrjulsen.mcdragonlib.client.gui.widgets.layout.FlowLayout;
import de.mrjulsen.mcdragonlib.client.gui.widgets.richtext.Padding;
import de.mrjulsen.mcdragonlib.client.gui.widgets.util.EAlign;
import de.mrjulsen.mcdragonlib.client.util.DLGuiGraphics;
import de.mrjulsen.mcdragonlib.client.util.DLSprite;
import de.mrjulsen.mcdragonlib.client.util.GuiUtils;
import de.mrjulsen.mcdragonlib.data.ETextAlignment;
import de.mrjulsen.mcdragonlib.util.DLColor;
import de.mrjulsen.mcdragonlib.util.DLUtils;
import de.mrjulsen.mcdragonlib.util.TextUtils;
import de.mrjulsen.mcdragonlib.util.math.MathUtils;
import de.mrjulsen.mcdragonlib.util.math.Rectangle;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;

public class DLContextMenu
extends DLAbstractCollectionComponent<ItemEntry, DLContextMenuItem> {
    protected static final int BORDER_SIZE = 1;
    protected static final int ITEM_TOP_MARGIN = 2;
    protected static final int ITEM_BOTTOM_MARGIN = 2;
    protected final DLContextMenu rootMenu;
    protected final DLContextMenu parentMenu;
    protected ModalId windowId;
    protected DLGuiComponent hoveredItem;
    protected DLContextMenu subMenu;
    protected DLWindow window;
    private int posX;
    private int posY;
    public final MenuBuilder menuBuilder;

    public DLContextMenu(MenuBuilder builder) {
        this(builder, null, null);
    }

    protected DLContextMenu(MenuBuilder builder, DLContextMenu rootMenu, DLContextMenu parentMenu) {
        super(0, 0, 80, 100);
        this.menuBuilder = builder;
        this.rootMenu = rootMenu;
        this.parentMenu = parentMenu;
        this.contentPanel.setPosition(1.0, 1.0);
        this.contentPanel.setSize(this.width() - 2, this.height() - 2);
        Object t = this.contentPanel.layout.get();
        if (t instanceof FlowLayout) {
            FlowLayout flow = (FlowLayout)t;
            flow.padding.set(new Padding(2, 0, 2, 0));
        }
        this.addEventListener(DLAbstractCollectionComponent.ListLayoutChangedEvent.class, (s, e) -> {
            this.setHeight(e.layoutResult().contentHeight() + 2);
            return false;
        });
    }

    public void open(DLWindowManager windowManager) {
        this.open(windowManager, (int)windowManager.mouseXOnScreen(), (int)windowManager.mouseYOnScreen());
    }

    public void open(DLWindowManager windowManager, int x, int y) {
        this.posX = x;
        this.posY = y;
        this.contentPanel.clearComponents();
        this.createComponents();
        WindowBuilder<DLWindow> builder = root -> {
            DLContextMenuWindow win = new DLContextMenuWindow(root, this);
            win.addComponent(this);
            int pX = x;
            if (this.parentMenu != null && (double)(pX + this.width()) > windowManager.getScreenWidth()) {
                pX = (int)this.parentMenu.getXOnScreen() - this.width();
            }
            win.setPosition(MathUtils.clamp((double)pX, 0.0, windowManager.getScreenWidth() - (double)this.width()), MathUtils.clamp((double)y, 0.0, windowManager.getScreenHeight() - (double)this.height()));
            this.window = win;
            return win;
        };
        this.windowId = this.rootMenu == null ? windowManager.createModal(builder) : windowManager.createWindow(builder);
    }

    @Override
    protected void createComponents() {
        this.contentPanel.clearComponents();
        int w = 5;
        Iterator<ItemEntry> iterator = this.menuBuilder.buildContextMenuContents(this.posX, this.posY).iterator();
        while (iterator.hasNext()) {
            ItemEntry item;
            ItemEntry itm = item = iterator.next();
            DLContextMenuItem listItem = (DLContextMenuItem)((Function)this.itemBuilder.get()).apply(itm);
            listItem.addEventListener(DLGuiStandardEvents.MouseEnterEvent.class, (src, event) -> {
                if (this.hoveredItem == src) {
                    return false;
                }
                if (this.subMenu != null) {
                    this.subMenu.closeSubMenu();
                    this.subMenu = null;
                    this.hoveredItem = null;
                }
                this.hoveredItem = src;
                if (itm.subMenu() != null) {
                    this.subMenu = new DLContextMenu(itm.subMenu(), this.getRootMenu(), this);
                    this.subMenu.open(this.getWindowManager(), (int)(listItem.getXOnScreen() + (double)listItem.width() - 2.0), (int)(listItem.getYOnScreen() - 1.0 - 2.0));
                }
                return false;
            });
            this.contentPanel.addComponent(listItem);
            listItem.setHeight(listItem.requiredHeight());
            w = Math.max(listItem.requiredWidth(), w);
        }
        this.setWidth(w + 2);
    }

    public void closeSubMenu() {
        if (this.subMenu != null) {
            this.subMenu.closeSubMenu();
        }
        if (this.getWindowManager() != null && this.window != null) {
            this.getWindowManager().closeWindow(this.window);
        }
    }

    public void closeMenu() {
        if (this.getWindowManager() != null) {
            this.getWindowManager().closeModal(this.getRootMenu().windowId);
            this.window = null;
            this.windowId = null;
        }
    }

    public DLContextMenu getRootMenu() {
        return this.rootMenu == null ? this : this.rootMenu;
    }

    @Override
    protected DLContextMenuItem defaultItemBuilder(ItemEntry item) {
        return item == ItemEntry.SEPARATOR ? new DLContextMenuSeparator(this) : new DLContextMenuItem(this, item);
    }

    @Override
    public void renderMainLayer(DLGuiGraphics graphics, double mouseX, double mouseY, Rectangle renderBounds) {
        GuiUtils.fill(graphics, 0, 0, this.width(), this.height(), DragonLib.VANILLA_BUTTON_DISABLED_FONT_COLOR);
        GuiUtils.fill(graphics, 1, 1, this.width() - 2, this.height() - 2, DLColor.BLACK);
    }

    @FunctionalInterface
    public static interface MenuBuilder {
        public List<ItemEntry> buildContextMenuContents(int var1, int var2);
    }

    public record ItemEntry(Component text, DLSprite icon, boolean enabled, Runnable action, MenuBuilder subMenu) {
        public static final ItemEntry SEPARATOR = new ItemEntry((Component)TextUtils.empty(), DLSprite.empty(), false, () -> {}, null);
    }

    public static class DLContextMenuItem
    extends DLAbstractCollectionComponent.DLCollectionItem<ItemEntry, DLContextMenu> {
        protected static final int DEFAULT_HEIGHT = 12;
        protected static final int SUB_MENU_ARROW = 10;
        protected static final int ICON_MARGIN = 2;
        protected static final int TEXT_TO_ICON_MARGIN = 4;
        protected static final int RIGHT_MARGIN = 2;
        protected DLColor color = DLColor.TRANSPARENT;

        protected DLContextMenuItem(DLContextMenu collectionComponentRef, ItemEntry item) {
            super(collectionComponentRef, item, 1, 0);
            this.enabled.set(item.enabled());
            this.addEventListener(DLGuiStandardEvents.ClickEvent.class, (src, event) -> {
                collectionComponentRef.closeMenu();
                DLUtils.doIfNotNull(item.action(), Runnable::run);
                return false;
            });
        }

        @Override
        public void renderMainLayer(DLGuiGraphics graphics, double mouseX, double mouseY, Rectangle renderBounds) {
            if (!((ItemEntry)this.item).icon.isEmpty()) {
                ((ItemEntry)this.item).icon.render(graphics, 2, 2);
            }
            if (this.isSelected()) {
                GuiUtils.fill(graphics, 0, 0, this.width(), this.height(), DLColor.fromInt(0x44FFFFFF));
            }
            Font font = Minecraft.m_91087_().f_91062_;
            int n = 2 + ((ItemEntry)this.item).icon().getWidth() + 4;
            int n2 = this.height() / 2;
            Objects.requireNonNull(Minecraft.m_91087_().f_91062_);
            GuiUtils.drawString(graphics, font, n, n2 - 9 / 2, (FormattedText)((ItemEntry)this.item).text(), this.isSelected() ? DragonLib.VANILLA_BUTTON_HIGHLIGHTED_FONT_COLOR : ((Boolean)this.enabled.get() != false ? DragonLib.VANILLA_BUTTON_ACTIVE_FONT_COLOR : DragonLib.VANILLA_BUTTON_DISABLED_FONT_COLOR), ETextAlignment.LEFT, false);
            if (((ItemEntry)this.item).subMenu() != null) {
                Font font2 = Minecraft.m_91087_().f_91062_;
                int n3 = this.width() - 2;
                int n4 = this.height() / 2;
                Objects.requireNonNull(Minecraft.m_91087_().f_91062_);
                GuiUtils.drawString(graphics, font2, n3, n4 - 9 / 2, ">", DragonLib.VANILLA_BUTTON_DISABLED_FONT_COLOR, ETextAlignment.RIGHT, false);
            }
            GuiUtils.fill(graphics, 0, 0, this.width(), this.height(), this.color);
        }

        public int requiredWidth() {
            return 2 + ((ItemEntry)this.item).icon().getWidth() + 4 + Minecraft.m_91087_().f_91062_.m_92852_((FormattedText)((ItemEntry)this.item).text()) + 10 + 2;
        }

        public int requiredHeight() {
            int n = ((ItemEntry)this.item).icon().getHeight() + 2 + 2;
            Objects.requireNonNull(Minecraft.m_91087_().f_91062_);
            return Math.max(12, Math.max(n, 9 + 2));
        }
    }

    public static final class DLContextMenuSeparator
    extends DLContextMenuItem {
        protected DLContextMenuSeparator(DLContextMenu collectionComponentRef) {
            super(collectionComponentRef, ItemEntry.SEPARATOR);
        }

        @Override
        public void renderMainLayer(DLGuiGraphics graphics, double mouseX, double mouseY, Rectangle renderBounds) {
            GuiUtils.fill(graphics, 5, 1, this.width() - 10, 1, DragonLib.VANILLA_BUTTON_DISABLED_FONT_COLOR);
        }

        @Override
        public int requiredHeight() {
            return 3;
        }

        @Override
        public int requiredWidth() {
            return 1;
        }
    }

    public static class DLContextMenuWindow
    extends DLWindow {
        public DLContextMenuWindow(DLWindowManager manager, DLContextMenu menu) {
            super(manager);
            this.setSize(menu.width(), menu.height());
            this.anchor.set(EAlign.values());
            this.addEventListener(DLWindow.WindowFocusEvent.class, (src, e) -> {
                if (this.getWindowManager() != null && this.getAssignedModal().isPresent() && !e.focus()) {
                    for (DLWindow win : this.getWindowManager().getWindows(this.getAssignedModal().get())) {
                        if (!(win instanceof DLContextMenuWindow) || this.getWindowManager() != null && this.getWindowManager().getFocusedWindow() != win) continue;
                        return false;
                    }
                    this.getWindowManager().closeModal(this.getAssignedModal().get());
                }
                return false;
            });
        }

        @Override
        public void renderMainLayer(DLGuiGraphics graphics, double mouseX, double mouseY, Rectangle renderBounds) {
            GuiUtils.fill(graphics, 0, 0, this.width(), this.height(), DLColor.fromInt(0x22FFFFFF));
        }
    }
}

