/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.mcdragonlib.client.gui.widgets.components;

import de.mrjulsen.mcdragonlib.annotations.SupportsEvents;
import de.mrjulsen.mcdragonlib.client.gui.events.DLGuiStandardEvents;
import de.mrjulsen.mcdragonlib.client.gui.widgets.base.DLGuiComponent;
import de.mrjulsen.mcdragonlib.client.gui.widgets.components.DLRichTextEditBox;
import de.mrjulsen.mcdragonlib.client.gui.widgets.richtext.Padding;
import de.mrjulsen.mcdragonlib.client.gui.widgets.richtext.RichTextComponent;
import de.mrjulsen.mcdragonlib.client.gui.widgets.util.EAlign;
import de.mrjulsen.mcdragonlib.client.util.DLGuiGraphics;
import de.mrjulsen.mcdragonlib.client.util.GuiUtils;
import de.mrjulsen.mcdragonlib.data.ETextAlignment;
import de.mrjulsen.mcdragonlib.events.IEvent;
import de.mrjulsen.mcdragonlib.util.DLColor;
import de.mrjulsen.mcdragonlib.util.TextUtils;
import de.mrjulsen.mcdragonlib.util.math.Rectangle;
import de.mrjulsen.mcdragonlib.util.properties.BooleanProperty;
import de.mrjulsen.mcdragonlib.util.properties.ColorProperty;
import de.mrjulsen.mcdragonlib.util.properties.Property;
import java.util.Objects;
import net.minecraft.client.gui.Font;

@SupportsEvents(value={TextColorChangedEvent.class, TextEditedEvent.class, EditModeChangedEvent.class})
public class DLEditableLabel
extends DLGuiComponent {
    public final Property<String> text = new Property<String>("");
    public final ColorProperty textColor = (ColorProperty)new ColorProperty(DLColor.UNDEFINED, DLColor.WHITE).withAfterPropertyChangedCallback((o, a) -> this.invokeEvent(this, new TextColorChangedEvent((DLColor)a), true));
    public final BooleanProperty drawFontShadow = new BooleanProperty(false);
    public final Property<Padding> padding = new Property<Padding>(new Padding(1));
    public final BooleanProperty editable = new BooleanProperty(true);
    protected final DLRichTextEditBox editBox;
    protected boolean isEditing = false;

    public DLEditableLabel(int x, int y, int w, int h) {
        super(x, y, w, h);
        this.editBox = new DLRichTextEditBox(0, 0, w, h);
        this.editBox.anchor.set(EAlign.values());
        this.editBox.visible.set(false);
        this.addComponent(this.editBox);
        this.editBox.addEventListener(DLGuiStandardEvents.FocusChangedEvent.class, (s, e) -> {
            if (this.isEditing && !e.focus()) {
                this.isEditing = false;
                this.editBox.visible.set(false);
                if (((Boolean)this.editable.get()).booleanValue()) {
                    this.text.set(((RichTextComponent)this.editBox.text.get()).getPlainText());
                    this.invokeEvent(this, new EditModeChangedEvent(false));
                    this.invokeEvent(this, new TextEditedEvent((String)this.text.get()));
                }
            }
            return false;
        });
        this.addEventListener(DLGuiStandardEvents.ClickEvent.class, (s, e) -> {
            if (((Boolean)this.editable.get()).booleanValue() && !this.isEditing) {
                this.isEditing = true;
                this.editBox.visible.set(true);
                ((RichTextComponent)this.editBox.text.get()).set((String)this.text.get());
                this.editBox.contentPadding.set(new Padding(0, 3, 0, 3));
                this.getWindowManager().focusComponent(this.editBox);
                this.invokeEvent(this, new EditModeChangedEvent(true));
            }
            return false;
        });
    }

    public boolean isEditing() {
        return this.isEditing;
    }

    @Override
    public void renderMainLayer(DLGuiGraphics graphics, double mouseX, double mouseY, Rectangle renderBounds) {
        if (((Boolean)this.editable.get()).booleanValue() && this.isSelected()) {
            GuiUtils.fill(graphics, 0, 0, this.width(), this.height(), DLColor.fromInt(0x70FFFFFF));
        }
        Font font = graphics.defaultFont();
        int n = ((Padding)this.padding.get()).left();
        int n2 = this.height() / 2;
        Objects.requireNonNull(graphics.defaultFont());
        GuiUtils.drawString(graphics, font, n, n2 - 9 / 2, TextUtils.truncateWithEllipsis(graphics.defaultFont(), (String)this.text.get(), this.width() - ((Padding)this.padding.get()).left() - ((Padding)this.padding.get()).right()), this.textColor.get(), ETextAlignment.LEFT, (boolean)((Boolean)this.drawFontShadow.get()));
    }

    public record EditModeChangedEvent(boolean isEditing) implements IEvent
    {
    }

    public record TextEditedEvent(String text) implements IEvent
    {
    }

    public record TextColorChangedEvent(DLColor color) implements IEvent
    {
    }
}

