/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.mcdragonlib.client.gui.widgets.components;

import com.mojang.blaze3d.systems.RenderSystem;
import de.mrjulsen.mcdragonlib.DragonLib;
import de.mrjulsen.mcdragonlib.client.gui.events.DLGuiStandardEvents;
import de.mrjulsen.mcdragonlib.client.gui.widgets.base.DLGuiComponent;
import de.mrjulsen.mcdragonlib.client.gui.widgets.base.DLWindowManager;
import de.mrjulsen.mcdragonlib.client.gui.widgets.components.DLButton;
import de.mrjulsen.mcdragonlib.client.gui.widgets.components.DLContextMenu;
import de.mrjulsen.mcdragonlib.client.gui.widgets.components.DLCycleButton;
import de.mrjulsen.mcdragonlib.client.gui.widgets.render.DLItemPickerRenderer;
import de.mrjulsen.mcdragonlib.client.gui.widgets.render.IStateRenderer;
import de.mrjulsen.mcdragonlib.client.gui.widgets.render.VanillaSimpleButtonRenderer;
import de.mrjulsen.mcdragonlib.client.gui.widgets.util.ITextFormatter;
import de.mrjulsen.mcdragonlib.client.render.GuiIcons;
import de.mrjulsen.mcdragonlib.client.util.DLGuiGraphics;
import de.mrjulsen.mcdragonlib.client.util.DLSprite;
import de.mrjulsen.mcdragonlib.client.util.GuiUtils;
import de.mrjulsen.mcdragonlib.data.ETextAlignment;
import de.mrjulsen.mcdragonlib.util.TextUtils;
import de.mrjulsen.mcdragonlib.util.math.MathUtils;
import de.mrjulsen.mcdragonlib.util.math.Rectangle;
import de.mrjulsen.mcdragonlib.util.properties.BooleanProperty;
import de.mrjulsen.mcdragonlib.util.properties.NumberProperty;
import de.mrjulsen.mcdragonlib.util.properties.Property;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;

public class DLItemPicker<T>
extends DLCycleButton<T> {
    private static final int BUTTON_WIDTH = 16;
    protected final DLButton addBtn;
    protected final DLButton subBtn;
    public final BooleanProperty showButtons = new BooleanProperty(true);
    public final Property<ITextFormatter<DLItemPicker<T>>> textFormat = new Property<ITextFormatter<DLItemPicker>>(src -> TextUtils.text(((Optional)src.selectedItem.get()).map(x -> x.toString()).orElse(((Component)this.text.get()).getString())).m_130948_(((Component)src.text.get()).m_7383_()));
    public final NumberProperty<Integer> shiftStep = new NumberProperty<Integer>(Integer.valueOf(5), 1, Integer.MAX_VALUE);
    public final BooleanProperty drawFontShadow = new BooleanProperty(true);
    public final Property<IStateRenderer<DLButton.ButtonState>> buttonsComponentRenderer = new Property<VanillaSimpleButtonRenderer>(VanillaSimpleButtonRenderer.VANILLA_BUTTON_GRAY);
    public final Property<IStateRenderer<ItemPickerState>> componentRenderer = new Property<DLItemPickerRenderer>(DLItemPickerRenderer.INSTANCE);

    public DLItemPicker(int x, int y, int w, int h) {
        super(x, y, w, h);
        this.addEventListener(DLGuiStandardEvents.ScrollEvent.class, (src, event) -> {
            this.changeValueOnScroll(-((int)Math.signum(event.deltaY())));
            return false;
        });
        this.addBtn = new DLButton(this.width() - 16, 0, 16, this.height() / 2);
        this.addBtn.icon.set(GuiIcons.ARROW_UP.getAsSprite(16, 16));
        this.addBtn.text.set(TextUtils.EMPTY);
        this.addBtn.componentRenderer.set((IStateRenderer)this.buttonsComponentRenderer.get());
        this.addBtn.addEventListener(DLGuiStandardEvents.MouseHoldDownEvent.class, (src, event) -> {
            this.changeValueOnScroll(1);
            return true;
        });
        this.addBtn.inputConsumptionPolicy.set(type -> type != DLGuiComponent.ConsumptionType.SCROLL);
        this.addComponent(this.addBtn);
        this.subBtn = new DLButton(this.width() - 16, this.height() / 2, 16, this.height() / 2);
        this.subBtn.icon.set(GuiIcons.ARROW_DOWN.getAsSprite(16, 16));
        this.subBtn.text.set(TextUtils.EMPTY);
        this.subBtn.componentRenderer.set((IStateRenderer)this.buttonsComponentRenderer.get());
        this.subBtn.addEventListener(DLGuiStandardEvents.MouseHoldDownEvent.class, (src, event) -> {
            this.changeValueOnScroll(-1);
            return true;
        });
        this.subBtn.inputConsumptionPolicy.set(type -> type != DLGuiComponent.ConsumptionType.SCROLL);
        this.addComponent(this.subBtn);
        this.updateButtons();
        this.showButtons.withAfterPropertyChangedCallback((o, val) -> this.updateButtons());
        this.buttonsComponentRenderer.withAfterPropertyChangedCallback((o, val) -> {
            this.addBtn.componentRenderer.set((IStateRenderer<DLButton.ButtonState>)val);
            this.subBtn.componentRenderer.set((IStateRenderer<DLButton.ButtonState>)val);
        });
        DLContextMenu contextMenu = new DLContextMenu((pX, pY) -> {
            ArrayList<DLContextMenu.ItemEntry> entries = new ArrayList<DLContextMenu.ItemEntry>();
            entries.add(new DLContextMenu.ItemEntry((Component)TextUtils.translate("gui.dragonlib.menu.copy"), DLSprite.empty(), ((Optional)this.selectedItem.get()).isPresent(), () -> Minecraft.m_91087_().f_91068_.m_90911_(((Optional)this.selectedItem.get()).map(i -> i.toString()).orElse("")), null));
            return entries;
        });
        this.addEventListener(DLGuiStandardEvents.RightClickEvent.class, (src, event) -> {
            contextMenu.open(this.getWindowManager(), (int)this.getWindowManager().mouseXOnScreen(), (int)this.getWindowManager().mouseYOnScreen());
            return false;
        });
    }

    public void changeValueOnScroll(int direction) {
        this.selectedIndex.set(MathUtils.clamp((Integer)this.selectedIndex.get() + direction * (DLWindowManager.hasShiftDown() ? (Integer)this.shiftStep.get() : 1), 0, this.items.size() - 1));
    }

    protected void updateButtons() {
        this.addBtn.visible.set((Boolean)this.showButtons.get());
        this.subBtn.visible.set((Boolean)this.showButtons.get());
    }

    @Override
    public boolean defaultButtonClickAction(DLGuiComponent src, DLGuiStandardEvents.ClickEvent event) {
        return false;
    }

    @Override
    public void renderMainLayer(DLGuiGraphics graphics, double mouseX, double mouseY, Rectangle renderBounds) {
        RenderSystem.enableBlend();
        GuiUtils.setTint(this.backgroundTint.get());
        if (!((Boolean)this.enabled.get()).booleanValue()) {
            ((IStateRenderer)this.componentRenderer.get()).renderSprite(graphics, 0, 0, this.width(), this.height(), this, ItemPickerState.DISABLED);
        } else if (this.isFocused()) {
            ((IStateRenderer)this.componentRenderer.get()).renderSprite(graphics, 0, 0, this.width(), this.height(), this, ItemPickerState.FOCUSED);
        } else if (this.isSelected()) {
            ((IStateRenderer)this.componentRenderer.get()).renderSprite(graphics, 0, 0, this.width(), this.height(), this, ItemPickerState.SELECTED);
        } else {
            ((IStateRenderer)this.componentRenderer.get()).renderSprite(graphics, 0, 0, this.width(), this.height(), this, ItemPickerState.NORMAL);
        }
        GuiUtils.setTint(this.textColor.get());
        Font font = Minecraft.m_91087_().f_91062_;
        int n = this.height() / 2;
        Objects.requireNonNull(Minecraft.m_91087_().f_91062_);
        GuiUtils.drawString(graphics, font, 4, n - 9 / 2, (FormattedText)((ITextFormatter)this.textFormat.get()).combine(this), (Boolean)this.enabled.get() != false ? DragonLib.VANILLA_BUTTON_ACTIVE_FONT_COLOR : DragonLib.VANILLA_BUTTON_DISABLED_FONT_COLOR, ETextAlignment.LEFT, (boolean)((Boolean)this.drawFontShadow.get()));
        GuiUtils.resetTint();
    }

    public static enum ItemPickerState {
        NORMAL,
        SELECTED,
        FOCUSED,
        DISABLED;

    }
}

