/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.mcdragonlib.client.gui.widgets.components;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mojang.blaze3d.font.GlyphInfo;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import de.mrjulsen.mcdragonlib.annotations.SupportsEvents;
import de.mrjulsen.mcdragonlib.client.gui.events.DLGuiStandardEvents;
import de.mrjulsen.mcdragonlib.client.gui.widgets.base.DLGuiComponent;
import de.mrjulsen.mcdragonlib.client.gui.widgets.components.DLContextMenu;
import de.mrjulsen.mcdragonlib.client.gui.widgets.richtext.EffectBatch;
import de.mrjulsen.mcdragonlib.client.gui.widgets.richtext.LineMarker;
import de.mrjulsen.mcdragonlib.client.gui.widgets.richtext.Padding;
import de.mrjulsen.mcdragonlib.client.gui.widgets.richtext.RichTextComponent;
import de.mrjulsen.mcdragonlib.client.gui.widgets.richtext.TextSegment;
import de.mrjulsen.mcdragonlib.client.gui.widgets.richtext.action.InteractiveElement;
import de.mrjulsen.mcdragonlib.client.gui.widgets.util.Align;
import de.mrjulsen.mcdragonlib.client.gui.widgets.util.CursorType;
import de.mrjulsen.mcdragonlib.client.gui.widgets.util.TextCursorPosition;
import de.mrjulsen.mcdragonlib.client.util.DLGuiGraphics;
import de.mrjulsen.mcdragonlib.client.util.DLSprite;
import de.mrjulsen.mcdragonlib.client.util.GuiUtils;
import de.mrjulsen.mcdragonlib.data.ETextAlignment;
import de.mrjulsen.mcdragonlib.events.EventListenerId;
import de.mrjulsen.mcdragonlib.events.IEvent;
import de.mrjulsen.mcdragonlib.mixin.FontAccessor;
import de.mrjulsen.mcdragonlib.util.DLColor;
import de.mrjulsen.mcdragonlib.util.Holder;
import de.mrjulsen.mcdragonlib.util.TextUtils;
import de.mrjulsen.mcdragonlib.util.math.MathUtils;
import de.mrjulsen.mcdragonlib.util.math.Rectangle;
import de.mrjulsen.mcdragonlib.util.properties.BooleanProperty;
import de.mrjulsen.mcdragonlib.util.properties.ColorProperty;
import de.mrjulsen.mcdragonlib.util.properties.NumberProperty;
import de.mrjulsen.mcdragonlib.util.properties.Property;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.font.FontSet;
import net.minecraft.client.gui.font.glyphs.BakedGlyph;
import net.minecraft.client.gui.font.glyphs.EmptyGlyph;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import org.joml.Matrix4f;

@SupportsEvents(value={TextChangedEvent.class, TextLineSpacingChangedEvent.class, TextLineWrapChangedEvent.class, TextMaxCharactersChangedEvent.class, TextMultilinedChanged.class, TextFilterRegexChangedEvent.class, TextInteractiveElementClicked.class, TextTextValidationEvent.class})
public class DLRichTextLabel
extends DLGuiComponent
implements DLContextMenu.MenuBuilder {
    public final Property<RichTextComponent> text = (Property)new Property<RichTextComponent>(new RichTextComponent()).withAfterPropertyChangedCallback((o, x) -> {
        this.invokeEvent(this, new TextChangedEvent((RichTextComponent)x));
        this.setupRichTextComponent((RichTextComponent)x);
        this.refresh();
    });
    public final BooleanProperty lineWrap = (BooleanProperty)new BooleanProperty(false).withAfterPropertyChangedCallback((o, x) -> {
        this.invokeEvent(this, new TextLineWrapChangedEvent((boolean)x));
        this.refresh();
    });
    public final BooleanProperty multiline = (BooleanProperty)new BooleanProperty(false).withAfterPropertyChangedCallback((o, x) -> {
        if (!x.booleanValue()) {
            ((RichTextComponent)this.text.get()).replace("\n", "").replace("\r", "");
            this.lineWrap.set(false);
        }
        ((RichTextComponent)this.text.get()).setMultiline((boolean)x);
        this.invokeEvent(this, new TextMultilinedChanged((boolean)x));
        this.refresh();
    });
    public final NumberProperty<Integer> maxCharacters = (NumberProperty)new NumberProperty<Supplier<Integer>>((Supplier<Integer>)1000000, () -> 0, () -> 2000000).withAfterPropertyChangedCallback((o, x) -> {
        ((RichTextComponent)this.text.get()).setMaxCharacters((int)x);
        this.invokeEvent(this, new TextMaxCharactersChangedEvent((int)x));
        this.refresh();
    });
    public final NumberProperty<Integer> lineSpacing = (NumberProperty)new NumberProperty<Integer>(2).withAfterPropertyChangedCallback((o, x) -> {
        this.invokeEvent(this, new TextLineSpacingChangedEvent((int)x));
        this.refresh();
    });
    public final Property<String> filterRegex = (Property)new Property<String>("(?s).*").withModificationCallback((o, n) -> {
        Holder.MutableHolder<String> regex = new Holder.MutableHolder<String>((String)n);
        this.invokeEvent(this, new TextFilterRegexChangedEvent(regex));
        try {
            String rx = (String)regex.get();
            Pattern.compile(rx);
            return rx;
        }
        catch (Exception e) {
            return o;
        }
    }).withAfterPropertyChangedCallback((o, x) -> {
        ((RichTextComponent)this.text.get()).setFilterRegex((String)x);
        this.refresh();
    });
    public final ColorProperty clickAreaColor = new ColorProperty(DLColor.fromInt(1077123583), DLColor.TRANSPARENT);
    public final Property<Padding> contentPadding = new Property<Padding>(new Padding(0, 3, 0, 3));
    private final List<EffectBatch> effects = Lists.newLinkedList();
    protected InteractiveElement hoveredElement = null;
    private int renderCharacterIndex;
    private float renderOffsetX;
    private float renderOffsetY;
    private LineMarker currentMarker;
    private TreeMap<Integer, LineMarker> lineMarkers;
    private TreeMap<Integer, LineMarker> lineMarkersByY;
    private List<LineMarker> linesByIndex;
    private double lastMouseX = -1.0;
    private double lastMouseY = -1.0;
    private float currentLayoutContentX;
    private float currentLayoutContentY;
    private float currentLayoutContentWidth;
    private float currentLayoutContentHeight;
    public final EventListenerId textElementClickEventId;
    public final EventListenerId interactiveTextElementClickEventId;
    public final EventListenerId hoverInteractableElementsEventId;
    public final EventListenerId unhoverInteractableElementsEventId;

    public DLRichTextLabel(int x2, int y, int w, int h) {
        super(x2, y, w, h);
        this.text.set(new RichTextComponent());
        DLContextMenu contextMenu = new DLContextMenu(this::buildContextMenuContents);
        this.textElementClickEventId = this.addEventListener(DLGuiStandardEvents.MouseDownEvent.class, this::onTextElementClicked);
        this.interactiveTextElementClickEventId = this.addEventListener(TextInteractiveElementClicked.class, this::onInteractiveElementClicked);
        this.hoverInteractableElementsEventId = this.addEventListener(DLGuiStandardEvents.MouseMoveEvent.class, (src, e) -> this.onHoverInteractiveElements(e.mouseX(), e.mouseY()));
        this.unhoverInteractableElementsEventId = this.addEventListener(DLGuiStandardEvents.MouseLeaveEvent.class, (src, e) -> this.onUnhover());
        this.addEventListener(DLGuiStandardEvents.RightClickEvent.class, (src, event) -> {
            contextMenu.open(this.getWindowManager(), (int)this.getWindowManager().mouseXOnScreen(), (int)this.getWindowManager().mouseYOnScreen());
            return false;
        });
    }

    @Override
    public List<DLContextMenu.ItemEntry> buildContextMenuContents(int x, int y) {
        ArrayList<DLContextMenu.ItemEntry> entries = new ArrayList<DLContextMenu.ItemEntry>();
        entries.add(new DLContextMenu.ItemEntry((Component)TextUtils.translate("gui.dragonlib.menu.copy"), DLSprite.empty(), true, () -> Minecraft.m_91087_().f_91068_.m_90911_(((RichTextComponent)this.text.get()).getPlainText()), null));
        return entries;
    }

    protected boolean onTextElementClicked(DLGuiComponent src, DLGuiStandardEvents.MouseDownEvent event) {
        if (this.text.get() != null && event.button() == 0 && this.hoveredElement != null && this.hoveredElement.hasActionFromType(InteractiveElement.ClickAction.class)) {
            this.invokeEvent(this, new TextInteractiveElementClicked(this.hoveredElement.getActionFromType(InteractiveElement.ClickAction.class)));
        }
        return false;
    }

    protected boolean onInteractiveElementClicked(DLGuiComponent src, TextInteractiveElementClicked event) {
        switch (event.action().actionName()) {
            case "open_url": {
                Util.m_137581_().m_137646_(event.action().value());
                return false;
            }
            case "copy_to_clipboard": {
                Minecraft.m_91087_().f_91068_.m_90911_(event.action().value());
                return false;
            }
        }
        return false;
    }

    protected void setupRichTextComponent(RichTextComponent rtc) {
        if (rtc != null) {
            rtc.setTextChangedCallback(() -> {
                this.refresh();
                this.invokeEvent(this, new TextChangedEvent(rtc));
            });
            rtc.setTextValidator((current, future, input) -> {
                Holder.MutableHolder<String> ipt = new Holder.MutableHolder<String>(input);
                this.invokeEvent(this, new TextTextValidationEvent(current, future, ipt));
                return (String)ipt.get();
            });
        }
    }

    protected float getLayoutContentX() {
        return ((Padding)this.contentPadding.get()).left();
    }

    protected float getLayoutContentY() {
        return ((Padding)this.contentPadding.get()).top();
    }

    protected float getLayoutContentWidth() {
        return this.width() - ((Padding)this.contentPadding.get()).left() - ((Padding)this.contentPadding.get()).right();
    }

    protected float getLayoutContentHeight() {
        return this.height() - ((Padding)this.contentPadding.get()).top() - ((Padding)this.contentPadding.get()).bottom();
    }

    protected TreeMap<Integer, LineMarker> getLineMarkers() {
        if (this.lineMarkers == null) {
            this.recalcLines();
        }
        return this.lineMarkers;
    }

    protected TreeMap<Integer, LineMarker> getLineMarkersByY() {
        if (this.lineMarkersByY == null) {
            this.recalcLines();
        }
        return this.lineMarkersByY;
    }

    public List<LineMarker> getLinesOrdered() {
        if (this.linesByIndex == null) {
            this.recalcLines();
        }
        return this.linesByIndex;
    }

    public LineMarker getLineAt(int textIndex) throws IndexOutOfBoundsException {
        Map.Entry<Integer, LineMarker> marker = this.getLineMarkers().floorEntry(textIndex);
        if (marker == null) {
            throw new IllegalArgumentException(String.format("There is no line at index %d.", textIndex));
        }
        return marker.getValue();
    }

    public LineMarker getLineByLineIndex(int lineIndex) throws IndexOutOfBoundsException {
        if (lineIndex < 0 || lineIndex >= this.getLinesOrdered().size()) {
            throw new IndexOutOfBoundsException(String.format("Index %d is out of bounds [0, %d]", lineIndex, this.getLinesOrdered().size() - 1));
        }
        if (this.getLinesOrdered().isEmpty()) {
            Objects.requireNonNull(Minecraft.m_91087_().f_91062_);
            return new LineMarker(0, 0, 0.0f, 1.0f, 9.0f, 0.0f, this.text.get() != null ? ((RichTextComponent)this.text.get()).getParagraphAlignment(0) : ETextAlignment.LEFT);
        }
        return this.getLinesOrdered().get(lineIndex);
    }

    public LineMarker getLineByYCoord(float y) {
        Map.Entry<Integer, LineMarker> marker = this.getLineMarkersByY().floorEntry((int)(y - this.getLayoutContentX()));
        if (marker == null) {
            return this.getLinesOrdered().get(0);
        }
        return marker.getValue();
    }

    public int getIndexByPos(float x, float y, boolean pickClosest) {
        float lineVisualStartXInTextBlock;
        if (this.text.get() == null) {
            return 0;
        }
        float textBlockRelativeX = (float)((double)(x - this.getLayoutContentX()) + this.getScrollOffsetX());
        LineMarker targetLine = this.getLineByYCoord(y + (float)((Integer)this.lineSpacing.get()).intValue() / 2.0f);
        if (targetLine == null) {
            if (pickClosest && !this.getLinesOrdered().isEmpty()) {
                targetLine = this.getLinesOrdered().get(0);
            } else {
                if (pickClosest) {
                    return 0;
                }
                return -1;
            }
        }
        if (textBlockRelativeX < (lineVisualStartXInTextBlock = this.calculateAlignedX(targetLine, this.getLayoutContentWidth()))) {
            return pickClosest ? targetLine.startIndex() : -1;
        }
        if (textBlockRelativeX > lineVisualStartXInTextBlock + targetLine.lineWidth() + 2.0f) {
            if (pickClosest) {
                return targetLine.endIndex();
            }
            return -1;
        }
        float adjustedXInLineSpace = textBlockRelativeX - lineVisualStartXInTextBlock;
        return ((RichTextComponent)this.text.get()).indexByWidth(adjustedXInLineSpace, targetLine, pickClosest);
    }

    public TextCursorPosition getPosByIndex(int index) {
        if (this.text.get() == null) {
            Objects.requireNonNull(Minecraft.m_91087_().f_91062_);
            return new TextCursorPosition(0, 0, 0.0f, 0.0f, 9.0f, ETextAlignment.LEFT);
        }
        index = MathUtils.clamp(index, 0, ((RichTextComponent)this.text.get()).length());
        LineMarker marker = this.getLineAt(index);
        float widthAtIdx = ((RichTextComponent)this.text.get()).width(marker.startIndex(), index);
        float lineX = this.calculateAlignedX(marker, this.getLayoutContentWidth());
        float x = lineX + widthAtIdx;
        return new TextCursorPosition(index, index - marker.startIndex(), x, marker.y(), marker.lineHeight(), marker.alignment());
    }

    public void refresh() {
        this.currentLayoutContentX = this.getLayoutContentX();
        this.currentLayoutContentY = this.getLayoutContentY();
        this.currentLayoutContentWidth = this.getLayoutContentWidth();
        this.currentLayoutContentHeight = this.getLayoutContentHeight();
        this.linesByIndex = null;
        this.lineMarkers = null;
        this.lineMarkersByY = null;
        this.hoveredElement = null;
    }

    private void recalcLines() {
        TreeMap calculatedMarkers;
        float widthForSplitting;
        this.lineMarkers = Maps.newTreeMap();
        this.lineMarkersByY = Maps.newTreeMap();
        if (this.text.get() == null) {
            TreeMap calculatedMarkers2 = Maps.newTreeMap();
            Integer n = 0;
            Objects.requireNonNull(Minecraft.m_91087_().f_91062_);
            calculatedMarkers2.put(n, new LineMarker(0, 0, 0.0f, 1.0f, 9.0f, 0.0f, ETextAlignment.LEFT));
            this.lineMarkers.putAll(calculatedMarkers2);
            this.lineMarkersByY.putAll(calculatedMarkers2);
            this.linesByIndex = new ArrayList(calculatedMarkers2.values());
            return;
        }
        float f = widthForSplitting = (Boolean)this.lineWrap.get() != false ? this.getLayoutContentWidth() : 2.1474836E9f;
        if (widthForSplitting <= 0.0f && ((Boolean)this.lineWrap.get()).booleanValue()) {
            widthForSplitting = 1.0f;
        }
        if (((RichTextComponent)this.text.get()).isMultiline()) {
            calculatedMarkers = ((RichTextComponent)this.text.get()).splitLines((int)widthForSplitting);
        } else {
            float textWidth = ((RichTextComponent)this.text.get()).width();
            float maxScale = 1.0f;
            Objects.requireNonNull(Minecraft.m_91087_().f_91062_);
            float maxLineHeight = 9.0f;
            if (((RichTextComponent)this.text.get()).getSegmentsRaw() != null && !((RichTextComponent)this.text.get()).getSegmentsRaw().isEmpty()) {
                maxScale = 0.0f;
                maxLineHeight = 0.0f;
                for (TextSegment segment : ((RichTextComponent)this.text.get()).getSegmentsRaw()) {
                    maxScale = Math.max(maxScale, segment.style().scale());
                    float f2 = segment.style().scale();
                    Objects.requireNonNull(segment.style().font());
                    maxLineHeight = Math.max(maxLineHeight, f2 * 9.0f);
                }
                if (maxLineHeight == 0.0f) {
                    Objects.requireNonNull(Minecraft.m_91087_().f_91062_);
                    maxLineHeight = 9.0f;
                }
                if (maxScale == 0.0f) {
                    maxScale = 1.0f;
                }
            }
            calculatedMarkers = Maps.newTreeMap();
            calculatedMarkers.put(0, new LineMarker(0, ((RichTextComponent)this.text.get()).length(), textWidth, maxScale, maxLineHeight, 0.0f, ((RichTextComponent)this.text.get()).getParagraphAlignment(0)));
        }
        if (calculatedMarkers.isEmpty() && (((RichTextComponent)this.text.get()).length() == 0 || ((RichTextComponent)this.text.get()).getPlainText() != null && ((RichTextComponent)this.text.get()).getPlainText().equals("\n"))) {
            Integer n = 0;
            int n2 = ((RichTextComponent)this.text.get()).length();
            Objects.requireNonNull(Minecraft.m_91087_().f_91062_);
            calculatedMarkers.put(n, new LineMarker(0, n2, 0.0f, 1.0f, 9.0f, 0.0f, ((RichTextComponent)this.text.get()).getParagraphAlignment(0)));
        }
        float currentY = (float)((Integer)this.lineSpacing.get()).intValue() / 2.0f;
        ArrayList<LineMarker> tempList = new ArrayList<LineMarker>();
        for (Map.Entry entry : calculatedMarkers.entrySet()) {
            LineMarker oldMarker = (LineMarker)entry.getValue();
            LineMarker newMarkerWithY = new LineMarker(oldMarker.startIndex(), oldMarker.endIndex(), oldMarker.lineWidth(), oldMarker.scale(), oldMarker.lineHeight(), currentY, oldMarker.alignment());
            tempList.add(newMarkerWithY);
            currentY += oldMarker.lineHeight() + (float)((Integer)this.lineSpacing.get()).intValue();
        }
        for (LineMarker lm : tempList) {
            this.lineMarkers.put(lm.startIndex(), lm);
            this.lineMarkersByY.put((int)lm.y(), lm);
        }
        this.linesByIndex = tempList;
    }

    private void setPose(PoseStack stack, float x, float y, float scale) {
        stack.m_85836_();
        stack.m_252880_(x, y, 0.0f);
        stack.m_85836_();
        stack.m_85841_(scale, scale, 1.0f);
    }

    private void clearPose(PoseStack stack) {
        stack.m_85849_();
        stack.m_85849_();
    }

    protected float calculateAlignedX(LineMarker marker, float layoutWidth) {
        if (marker == null || layoutWidth <= 0.0f) {
            return 0.0f;
        }
        float lineWidth = marker.lineWidth();
        float lineX = switch (marker.alignment()) {
            case ETextAlignment.CENTER -> (layoutWidth - lineWidth) / 2.0f;
            case ETextAlignment.RIGHT -> layoutWidth - lineWidth - 1.0f;
            default -> 0.0f;
        };
        return Math.max(0.0f, lineX);
    }

    private void initRenderer() {
        this.effects.clear();
        this.renderCharacterIndex = -1;
        this.renderOffsetY = (float)((Integer)this.lineSpacing.get()).intValue() / 2.0f;
        List<LineMarker> orderedLines = this.getLinesOrdered();
        if (!orderedLines.isEmpty()) {
            this.currentMarker = orderedLines.get(0);
            this.renderOffsetX = this.calculateAlignedX(this.currentMarker, this.currentLayoutContentWidth);
        } else {
            Objects.requireNonNull(Minecraft.m_91087_().f_91062_);
            this.currentMarker = new LineMarker(0, 0, 0.0f, 1.0f, 9.0f, 0.0f, this.text.get() != null ? ((RichTextComponent)this.text.get()).getParagraphAlignment(0) : ETextAlignment.LEFT);
            this.renderOffsetX = 0.0f;
        }
    }

    private void addEffect(EffectBatch batch) {
        if (!batch.isEmpty()) {
            this.effects.add(batch);
        }
    }

    public boolean renderSegment(DLGuiGraphics graphics, TextSegment segment, int skip) {
        float segmentRenderStartXVirtual = this.renderOffsetX;
        float segmentRenderStartYVirtual = this.renderOffsetY;
        float screenPoseX = (float)((double)(this.currentLayoutContentX + segmentRenderStartXVirtual) - this.getScrollOffsetX());
        float screenPoseY = (float)((double)(this.currentLayoutContentY + segmentRenderStartYVirtual) - this.getScrollOffsetY());
        if (segment.style().dropShadow()) {
            this.setPose(graphics.poseStack(), screenPoseX, screenPoseY, segment.style().scale());
            this.renderSegmentInternal(graphics, segment, true, segmentRenderStartXVirtual, skip);
            this.clearPose(graphics.poseStack());
        }
        this.setPose(graphics.poseStack(), screenPoseX, screenPoseY, segment.style().scale());
        boolean b = this.renderSegmentInternal(graphics, segment, false, segmentRenderStartXVirtual, skip);
        this.clearPose(graphics.poseStack());
        return b;
    }

    private boolean renderSegmentInternal(DLGuiGraphics graphics, TextSegment segment, boolean renderShadow, float segmentStartXLineUnscaledVirtual, int skip) {
        float localX = segmentStartXLineUnscaledVirtual;
        float localY = this.renderOffsetY;
        int charIdxInRichText = this.renderCharacterIndex + skip;
        LineMarker currentLineMarker = this.currentMarker;
        float dX = 0.0f;
        Matrix4f pose = graphics.poseStack().m_85850_().m_252922_();
        MultiBufferSource.BufferSource bufferSource = graphics.graphics().m_280091_();
        Font.DisplayMode mode = Font.DisplayMode.NORMAL;
        int packedLightCoords = 0xF000F0;
        float dimFactor = renderShadow ? 0.25f : 1.0f;
        Font font = segment.style().font();
        FontAccessor accessor = (FontAccessor)font;
        FontSet fontSet = accessor.dragonlib$invokeGetFontSet(Style.f_131100_);
        boolean bold = segment.style().bold();
        int textColor = segment.style().color();
        float alpha = (float)(textColor >> 24 & 0xFF) / 255.0f;
        float red = (float)(textColor >> 16 & 0xFF) / 255.0f * dimFactor;
        float green = (float)(textColor >> 8 & 0xFF) / 255.0f * dimFactor;
        float blue = (float)(textColor & 0xFF) / 255.0f * dimFactor;
        EffectBatch effectHolder = new EffectBatch(localX, localY, segment.style().scale());
        float viewMinY_tb = (float)this.getScrollOffsetY();
        float viewMaxY_tb = (float)(this.getScrollOffsetY() + (double)this.currentLayoutContentHeight);
        float viewMinX_tb = (float)this.getScrollOffsetX();
        float viewMaxX_tb = (float)(this.getScrollOffsetX() + (double)this.currentLayoutContentWidth);
        for (int offset = skip; offset < segment.length(); ++offset) {
            float glyphAdvanceRenderShadowOffset;
            BufferBuilder bufferBuilder;
            Tesselator tesselator;
            float hY2;
            float hX2;
            float hY1;
            float hX1;
            float ha;
            float hb;
            float hg;
            float hr;
            InteractiveElement currentElementForChar;
            int c = segment.stringBuilder().codePointAt(segment.stringBuilder().offsetByCodePoints(0, offset));
            LineMarker oldMarker = currentLineMarker;
            currentLineMarker = this.getLineMarkers().floorEntry(++charIdxInRichText).getValue();
            localY = currentLineMarker.y();
            if (oldMarker != currentLineMarker) {
                this.addEffect(effectHolder);
                localX = this.calculateAlignedX(currentLineMarker, this.currentLayoutContentWidth);
                dX = 0.0f;
                if (!renderShadow) {
                    this.renderOffsetX = localX;
                    this.renderOffsetY = localY;
                    this.currentMarker = currentLineMarker;
                }
                this.clearPose(graphics.poseStack());
                float newScreenPoseX = (float)((double)(this.currentLayoutContentX + localX) - this.getScrollOffsetX());
                float newScreenPoseY = (float)((double)(this.currentLayoutContentY + localY) - this.getScrollOffsetY());
                this.setPose(graphics.poseStack(), newScreenPoseX, newScreenPoseY, segment.style().scale());
                pose = graphics.poseStack().m_85850_().m_252922_();
                effectHolder = new EffectBatch(localX, localY, segment.style().scale());
            }
            if (charIdxInRichText >= currentLineMarker.endIndex() || charIdxInRichText < currentLineMarker.startIndex()) continue;
            float lineTop_tb = localY;
            float lineBottom_tb = localY + currentLineMarker.lineHeight();
            if (((Boolean)this.multiline.get()).booleanValue() && lineTop_tb > viewMaxY_tb) {
                if (!renderShadow) {
                    this.renderCharacterIndex = charIdxInRichText - 1;
                }
                this.addEffect(effectHolder);
                return false;
            }
            float f = currentLineMarker.lineHeight();
            Objects.requireNonNull(segment.style().font());
            float dYInScaledSpace = Math.max(0.0f, (f - 9.0f * segment.style().scale()) / segment.style().scale() - segment.style().scale());
            float f2 = currentLineMarker.lineHeight();
            Objects.requireNonNull(segment.style().font());
            if (f2 == 9.0f * segment.style().scale()) {
                dYInScaledSpace = 0.0f;
            }
            GlyphInfo glyphInfo = fontSet.m_243128_(c, accessor.dragonlib$filterFishyGlyphs());
            BakedGlyph bakedGlyph = segment.style().obfuscated() && c != 32 ? fontSet.m_95067_(glyphInfo) : fontSet.m_95078_(c);
            float charWidthInScaledSpace = glyphInfo.m_83827_(bold);
            if (!((Boolean)this.multiline.get()).booleanValue() || !((Boolean)this.lineWrap.get()).booleanValue()) {
                float charLeft_tb = localX + dX * segment.style().scale();
                float charRight_tb = charLeft_tb + charWidthInScaledSpace * segment.style().scale();
                if (charRight_tb < viewMinX_tb) {
                    dX += charWidthInScaledSpace;
                    continue;
                }
                if (charLeft_tb > viewMaxX_tb) {
                    dX += charWidthInScaledSpace;
                    continue;
                }
            }
            InteractiveElement interactiveElement = currentElementForChar = this.hoveredElement != null && this.hoveredElement.contains(charIdxInRichText) ? this.hoveredElement : null;
            if (!renderShadow && currentElementForChar != null && currentElementForChar.shouldHighlightOnHover()) {
                int hoverColor = this.clickAreaColor.get().getAsARGB();
                hr = (float)(hoverColor >> 16 & 0xFF) / 255.0f;
                hg = (float)(hoverColor >> 8 & 0xFF) / 255.0f;
                hb = (float)(hoverColor & 0xFF) / 255.0f;
                ha = (float)(hoverColor >> 24 & 0xFF) / 255.0f;
                hX1 = dX;
                hY1 = -((float)((Integer)this.lineSpacing.get()).intValue()) / 2.0f;
                hX2 = dX + charWidthInScaledSpace;
                hY2 = currentLineMarker.lineHeight() / segment.style().scale() + (float)((Integer)this.lineSpacing.get()).intValue() / 2.0f;
                tesselator = Tesselator.m_85913_();
                bufferBuilder = tesselator.m_85915_();
                RenderSystem.setShader(GameRenderer::m_172811_);
                RenderSystem.enableBlend();
                RenderSystem.defaultBlendFunc();
                RenderSystem.disableCull();
                bufferBuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
                bufferBuilder.m_252986_(pose, hX1, hY2, 0.0f).m_85950_(hr, hg, hb, ha).m_5752_();
                bufferBuilder.m_252986_(pose, hX2, hY2, 0.0f).m_85950_(hr, hg, hb, ha).m_5752_();
                bufferBuilder.m_252986_(pose, hX2, hY1, 0.0f).m_85950_(hr, hg, hb, ha).m_5752_();
                bufferBuilder.m_252986_(pose, hX1, hY1, 0.0f).m_85950_(hr, hg, hb, ha).m_5752_();
                tesselator.m_85914_();
                RenderSystem.enableCull();
                RenderSystem.disableBlend();
                RenderSystem.setShader(GameRenderer::m_172817_);
            }
            if (!renderShadow && segment.style().highlightColor() != 0) {
                int highlightColorInt = segment.style().highlightColor();
                hr = (float)(highlightColorInt >> 16 & 0xFF) / 255.0f;
                hg = (float)(highlightColorInt >> 8 & 0xFF) / 255.0f;
                hb = (float)(highlightColorInt & 0xFF) / 255.0f;
                ha = (float)(highlightColorInt >> 24 & 0xFF) / 255.0f;
                hX1 = dX;
                hY1 = 0.0f;
                hX2 = dX + charWidthInScaledSpace;
                hY2 = currentLineMarker.lineHeight() / segment.style().scale();
                tesselator = Tesselator.m_85913_();
                bufferBuilder = tesselator.m_85915_();
                RenderSystem.setShader(GameRenderer::m_172811_);
                RenderSystem.enableBlend();
                RenderSystem.defaultBlendFunc();
                RenderSystem.disableCull();
                bufferBuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
                bufferBuilder.m_252986_(pose, hX1, hY2, 0.0f).m_85950_(hr, hg, hb, ha).m_5752_();
                bufferBuilder.m_252986_(pose, hX2, hY2, 0.0f).m_85950_(hr, hg, hb, ha).m_5752_();
                bufferBuilder.m_252986_(pose, hX2, hY1, 0.0f).m_85950_(hr, hg, hb, ha).m_5752_();
                bufferBuilder.m_252986_(pose, hX1, hY1, 0.0f).m_85950_(hr, hg, hb, ha).m_5752_();
                tesselator.m_85914_();
                RenderSystem.enableCull();
                RenderSystem.disableBlend();
                RenderSystem.setShader(GameRenderer::m_172817_);
            }
            if (!(bakedGlyph instanceof EmptyGlyph)) {
                float boldOffset = bold ? glyphInfo.m_5619_() : 0.0f;
                float shadowOffset = renderShadow ? glyphInfo.m_5645_() : 0.0f;
                VertexConsumer vertexConsumer = bufferSource.m_6299_(bakedGlyph.m_181387_(mode));
                accessor.dragonlib$renderChar(bakedGlyph, bold, segment.style().italic(), boldOffset, dX + shadowOffset, dYInScaledSpace + shadowOffset, pose, vertexConsumer, red, green, blue, alpha, packedLightCoords);
            }
            float f3 = glyphAdvanceRenderShadowOffset = renderShadow ? 1.0f : 0.0f;
            if (segment.style().strikethrough()) {
                effectHolder.addEffectToBatch(new BakedGlyph.Effect(dX + glyphAdvanceRenderShadowOffset - 1.0f, dYInScaledSpace + glyphAdvanceRenderShadowOffset + 4.5f, dX + glyphAdvanceRenderShadowOffset + charWidthInScaledSpace, dYInScaledSpace + glyphAdvanceRenderShadowOffset + 4.5f - 1.0f, 0.01f, red, green, blue, alpha));
            }
            if (segment.style().underlined()) {
                effectHolder.addEffectToBatch(new BakedGlyph.Effect(dX + glyphAdvanceRenderShadowOffset - 1.0f, dYInScaledSpace + glyphAdvanceRenderShadowOffset + 9.0f, dX + glyphAdvanceRenderShadowOffset + charWidthInScaledSpace, dYInScaledSpace + glyphAdvanceRenderShadowOffset + 9.0f - 1.0f, 0.01f, red, green, blue, alpha));
            }
            dX += charWidthInScaledSpace;
        }
        this.addEffect(effectHolder);
        if (!renderShadow) {
            this.renderOffsetX = localX + dX * segment.style().scale();
            this.renderCharacterIndex += segment.length();
        }
        return true;
    }

    public void postRender(DLGuiGraphics graphics, EffectBatch effectsBatch) {
        if (effectsBatch.isEmpty()) {
            return;
        }
        float effectVirtualX_tb = effectsBatch.x();
        float effectVirtualY_tb = effectsBatch.y();
        float effectScale = effectsBatch.scale();
        float approxEffectHeight = 10.0f * effectScale;
        double viewMinY_tb = this.getScrollOffsetY();
        double viewMaxY_tb = this.getScrollOffsetY() + (double)this.currentLayoutContentHeight;
        if (((Boolean)this.multiline.get()).booleanValue() && (double)(effectVirtualY_tb + approxEffectHeight) < viewMinY_tb) {
            return;
        }
        if (((Boolean)this.multiline.get()).booleanValue() && (double)effectVirtualY_tb > viewMaxY_tb) {
            return;
        }
        double screenPoseX = (double)(this.currentLayoutContentX + effectVirtualX_tb) - this.getScrollOffsetX();
        double screenPoseY = (double)(this.currentLayoutContentY + effectVirtualY_tb) - this.getScrollOffsetY();
        this.setPose(graphics.poseStack(), (float)screenPoseX, (float)screenPoseY, effectScale);
        Matrix4f pose = graphics.poseStack().m_85850_().m_252922_();
        MultiBufferSource.BufferSource bufferSource = graphics.graphics().m_280091_();
        Font.DisplayMode mode = Font.DisplayMode.NORMAL;
        int packedLightCoords = 0xF000F0;
        Font font = Minecraft.m_91087_().f_91062_;
        FontAccessor accessor = (FontAccessor)font;
        BakedGlyph whiteGlyph = accessor.dragonlib$invokeGetFontSet(Style.f_131100_).m_95064_();
        VertexConsumer vertexConsumer = bufferSource.m_6299_(whiteGlyph.m_181387_(mode));
        for (BakedGlyph.Effect effect : effectsBatch.getEffects()) {
            whiteGlyph.m_95220_(effect, pose, vertexConsumer, packedLightCoords);
        }
        this.clearPose(graphics.poseStack());
    }

    @Override
    public CursorType getCursor() {
        if (this.getResizeArea() == Align.CENTER && this.hoveredElement != null) {
            return CursorType.HAND;
        }
        return super.getCursor();
    }

    protected boolean onUnhover() {
        this.hoveredElement = null;
        return false;
    }

    protected boolean onHoverInteractiveElements(double mouseX, double mouseY) {
        this.lastMouseX = mouseX;
        this.lastMouseY = mouseY;
        this.hoveredElement = null;
        if (mouseX >= (double)this.currentLayoutContentX && mouseX <= (double)(this.currentLayoutContentX + this.currentLayoutContentWidth) && mouseY >= (double)this.currentLayoutContentY && mouseY <= (double)(this.currentLayoutContentY + this.currentLayoutContentHeight)) {
            int charIdx;
            float scrolledMouseY = (float)(mouseY + this.getScrollOffsetY() - (double)this.getLayoutContentY() - (double)((float)((Integer)this.lineSpacing.get()).intValue() / 2.0f));
            LineMarker selLine = this.getLineByYCoord((float)mouseY);
            if (selLine != null && scrolledMouseY >= selLine.y() - ((Integer)this.lineSpacing.get()).floatValue() / 2.0f && scrolledMouseY <= selLine.y() + selLine.lineHeight() + ((Integer)this.lineSpacing.get()).floatValue() / 2.0f && (charIdx = this.getIndexByPos((float)mouseX, (float)mouseY, false)) != -1) {
                this.hoveredElement = ((RichTextComponent)this.text.get()).getInteractiveElementAt(charIdx);
                return false;
            }
        }
        this.hoveredElement = null;
        return false;
    }

    @Override
    public void renderMainLayer(DLGuiGraphics graphics, double mouseX, double mouseY, Rectangle renderBounds) {
        if (this.text.get() == null) {
            return;
        }
        this.currentLayoutContentX = this.getLayoutContentX();
        this.currentLayoutContentY = this.getLayoutContentY();
        this.currentLayoutContentWidth = this.getLayoutContentWidth();
        this.currentLayoutContentHeight = this.getLayoutContentHeight();
        GuiUtils.enableScissor(graphics, (int)(renderBounds.x() + (double)this.getLayoutContentX()), (int)(renderBounds.y() + (double)this.getLayoutContentY()), (int)this.getLayoutContentWidth(), (int)this.getLayoutContentHeight());
        this.initRenderer();
        if (((RichTextComponent)this.text.get()).getSegmentsRaw() != null) {
            Objects.requireNonNull(Minecraft.m_91087_().f_91062_);
            float estimatedMaxLineHeight = 9 * 2;
            Map.Entry<Integer, LineMarker> firstMarkerEntry = this.getLineMarkersByY().floorEntry((int)this.getScrollOffsetY());
            if (firstMarkerEntry != null || (firstMarkerEntry = this.getLineMarkersByY().ceilingEntry((int)this.getScrollOffsetY())) != null) {
                graphics.poseStack().m_85836_();
                for (TextSegment segment : ((RichTextComponent)this.text.get()).getSegmentsRaw()) {
                    int segmentStartIndex = this.renderCharacterIndex;
                    int skip = 0;
                    if (((Boolean)this.multiline.get()).booleanValue()) {
                        if (this.renderCharacterIndex + segment.length() < firstMarkerEntry.getValue().startIndex()) {
                            this.renderCharacterIndex += segment.length();
                            continue;
                        }
                        if (this.renderCharacterIndex < firstMarkerEntry.getValue().startIndex()) {
                            skip = Math.max(0, firstMarkerEntry.getValue().startIndex() - segmentStartIndex - 1);
                        }
                        if ((double)(this.currentMarker.y() + this.currentMarker.lineHeight()) > this.getScrollOffsetY() + (double)this.currentLayoutContentHeight + (double)estimatedMaxLineHeight) break;
                    }
                    if (this.renderSegment(graphics, segment, skip)) continue;
                    break;
                }
                for (EffectBatch batch : this.effects) {
                    this.postRender(graphics, batch);
                }
                graphics.poseStack().m_85849_();
            }
        }
        graphics.graphics().m_280091_().m_109911_();
        GuiUtils.enableScissor(graphics, (int)renderBounds.x(), (int)renderBounds.y(), (int)renderBounds.width(), (int)renderBounds.height());
    }

    @Override
    public void renderFrontLayer(DLGuiGraphics graphics, double mouseX, double mouseY, Rectangle renderBounds) {
        if (this.hoveredElement != null) {
            this.renderInteractionElementOverlay(graphics, (int)(mouseX - this.getScrollOffsetX()), (int)(mouseY - this.getScrollOffsetY()), this.hoveredElement);
        }
    }

    protected void renderInteractionElementOverlay(DLGuiGraphics graphics, int mouseX, int mouseY, InteractiveElement element) {
        ArrayList<Object> lines = new ArrayList<Object>();
        if (element.hasActionFromType(InteractiveElement.HoverAction.class)) {
            lines.add(element.getActionFromType(InteractiveElement.HoverAction.class).text());
        }
        if (element.hasActionFromType(InteractiveElement.ClickAction.class)) {
            InteractiveElement.ClickAction action = element.getActionFromType(InteractiveElement.ClickAction.class);
            if (action.actionName().equals("open_url")) {
                lines.add(TextUtils.text(action.value()).m_130940_(ChatFormatting.GRAY));
                lines.add(TextUtils.text("Click to open URL").m_130940_(ChatFormatting.YELLOW));
            } else if (action.actionName().equals("copy_to_clipboard")) {
                lines.add(TextUtils.text("Click to copy to clipboard").m_130940_(ChatFormatting.YELLOW));
            } else {
                lines.add(TextUtils.text("Click to run action").m_130940_(ChatFormatting.YELLOW));
            }
        }
        GuiUtils.drawTooltip(graphics, Minecraft.m_91087_().f_91062_, mouseX, mouseY, lines, (int)(this.getWindowManager().getScreenWidth() * 0.75));
    }

    public record TextInteractiveElementClicked(InteractiveElement.ClickAction action) implements IEvent
    {
    }

    public record TextTextValidationEvent(String currentText, String futureText, Holder.MutableHolder<String> input) implements IEvent
    {
    }

    public record TextChangedEvent(RichTextComponent text) implements IEvent
    {
    }

    public record TextFilterRegexChangedEvent(Holder.MutableHolder<String> regex) implements IEvent
    {
    }

    public record TextLineSpacingChangedEvent(int lineSpacing) implements IEvent
    {
    }

    public record TextMaxCharactersChangedEvent(int maxCharacters) implements IEvent
    {
    }

    public record TextMultilinedChanged(boolean multiline) implements IEvent
    {
    }

    public record TextLineWrapChangedEvent(boolean lineWrap) implements IEvent
    {
    }
}

