/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.mcdragonlib.client.gui.widgets.components;

import de.mrjulsen.mcdragonlib.annotations.SupportsEvents;
import de.mrjulsen.mcdragonlib.client.gui.events.DLGuiStandardEvents;
import de.mrjulsen.mcdragonlib.client.gui.widgets.base.DLGuiComponent;
import de.mrjulsen.mcdragonlib.client.gui.widgets.components.DLButton;
import de.mrjulsen.mcdragonlib.client.gui.widgets.components.DLContextMenu;
import de.mrjulsen.mcdragonlib.client.gui.widgets.render.IStateRenderer;
import de.mrjulsen.mcdragonlib.client.gui.widgets.render.VanillaContainerScrollBarRenderer;
import de.mrjulsen.mcdragonlib.client.gui.widgets.render.VanillaSimpleButtonRenderer;
import de.mrjulsen.mcdragonlib.client.render.GuiIcons;
import de.mrjulsen.mcdragonlib.client.util.DLGuiGraphics;
import de.mrjulsen.mcdragonlib.client.util.DLSprite;
import de.mrjulsen.mcdragonlib.client.util.GuiUtils;
import de.mrjulsen.mcdragonlib.events.IEvent;
import de.mrjulsen.mcdragonlib.util.DLColor;
import de.mrjulsen.mcdragonlib.util.TextUtils;
import de.mrjulsen.mcdragonlib.util.math.Rectangle;
import de.mrjulsen.mcdragonlib.util.properties.BooleanProperty;
import de.mrjulsen.mcdragonlib.util.properties.ColorProperty;
import de.mrjulsen.mcdragonlib.util.properties.NumberProperty;
import de.mrjulsen.mcdragonlib.util.properties.Property;
import java.util.ArrayList;
import java.util.function.Supplier;
import net.minecraft.network.chat.Component;

@SupportsEvents(value={BackgroundColorChangedEvent.class, ValueChangedEvent.class, MaxValueChangedEvent.class, ScreenSizeChangedEvent.class, ScrollerSizeChangedEvent.class})
public class DLScrollBar
extends DLGuiComponent {
    public static final int DEFAULT_SCROLLBAR_SIZE = 16;
    public static final int SCROLL_AREA_BORDER = 0;
    public static final int BUTTON_SIZE = 14;
    protected final Orientation orientation;
    protected int dragOffset;
    protected DLButton scrollUpBtn;
    protected DLButton scrollDownBtn;
    public final NumberProperty<Integer> scrollerSize = (NumberProperty)new NumberProperty<Integer>(Integer.valueOf(0), 0, Integer.MAX_VALUE).withAfterPropertyChangedCallback((o, a) -> this.invokeEvent(this, new ScrollerSizeChangedEvent((int)a), true));
    public final NumberProperty<Integer> screenSize = (NumberProperty)new NumberProperty<Integer>(Integer.valueOf(50), 1, Integer.MAX_VALUE).withAfterPropertyChangedCallback((o, a) -> {
        this.clampValueToRange();
        this.invokeEvent(this, new ScreenSizeChangedEvent((int)a), true);
    });
    public final NumberProperty<Integer> scrollSteps = new NumberProperty<Integer>(Integer.valueOf(16), 1, Integer.MAX_VALUE);
    public final NumberProperty<Integer> gridSteps = new NumberProperty<Integer>(Integer.valueOf(0), 0, Integer.MAX_VALUE);
    public final NumberProperty<Integer> max = (NumberProperty)new NumberProperty<Integer>(Integer.valueOf(100), 0, Integer.MAX_VALUE).withAfterPropertyChangedCallback((o, a) -> {
        this.clampValueToRange();
        this.invokeEvent(this, new MaxValueChangedEvent((int)a), true);
    });
    public final NumberProperty<Double> value = (NumberProperty)new NumberProperty<Supplier<Double>>((Supplier<Double>)0.0, () -> 0.0, () -> Math.max(0, (Integer)this.max.get() - (Integer)this.screenSize.get())).withAfterPropertyChangedCallback((o, a) -> this.invokeEvent(this, new ValueChangedEvent((double)a), true));
    public final BooleanProperty showButtons = (BooleanProperty)new BooleanProperty(false).withAfterPropertyChangedCallback((o, a) -> {
        if (this.scrollUpBtn != null) {
            this.scrollUpBtn.visible.set(a);
        }
        if (this.scrollDownBtn != null) {
            this.scrollDownBtn.visible.set(a);
        }
    });
    public final ColorProperty backgroundTint = (ColorProperty)new ColorProperty(DLColor.UNDEFINED, DLColor.WHITE).withAfterPropertyChangedCallback((o, a) -> this.invokeEvent(this, new BackgroundColorChangedEvent((DLColor)a), true));
    public final Property<IStateRenderer<ScrollBarState>> componentRenderer = new Property<VanillaContainerScrollBarRenderer>(VanillaContainerScrollBarRenderer.VANILLA_SCROLLBAR);
    public final Property<IStateRenderer<DLButton.ButtonState>> buttonsComponentRenderer = new Property<VanillaSimpleButtonRenderer>(VanillaSimpleButtonRenderer.VANILLA_BUTTON_GRAY);

    public DLScrollBar(int x, int y, int s, Orientation orientation) {
        this(x, y, orientation == Orientation.HORIZONTAL ? s : 16, orientation == Orientation.VERTICAL ? s : 16, orientation);
    }

    public DLScrollBar(int x, int y, int w, int h, Orientation orientation) {
        super(x, y, w, h);
        this.orientation = orientation;
        DLContextMenu contextMenu = new DLContextMenu((pX, pY) -> {
            ArrayList<DLContextMenu.ItemEntry> entries = new ArrayList<DLContextMenu.ItemEntry>();
            entries.add(new DLContextMenu.ItemEntry((Component)TextUtils.translate("gui.dragonlib.scrollbar.here"), DLSprite.empty(), true, () -> this.scrollTo((double)pY - this.getYOnScreen()), null));
            entries.add(DLContextMenu.ItemEntry.SEPARATOR);
            entries.add(new DLContextMenu.ItemEntry((Component)TextUtils.translate("gui.dragonlib.scrollbar." + (orientation == Orientation.VERTICAL ? "top" : "left")), DLSprite.empty(), true, () -> this.value.set(0.0), null));
            entries.add(new DLContextMenu.ItemEntry((Component)TextUtils.translate("gui.dragonlib.scrollbar." + (orientation == Orientation.VERTICAL ? "bottom" : "right")), DLSprite.empty(), true, () -> this.value.set(Double.valueOf(Math.max(0, (Integer)this.max.get() - (Integer)this.screenSize.get()))), null));
            entries.add(DLContextMenu.ItemEntry.SEPARATOR);
            entries.add(new DLContextMenu.ItemEntry((Component)TextUtils.translate("gui.dragonlib.scrollbar." + (orientation == Orientation.VERTICAL ? "page_up" : "page_left")), DLSprite.empty(), true, () -> this.value.set((Double)this.value.get() - (double)((Integer)this.screenSize.get()).intValue()), null));
            entries.add(new DLContextMenu.ItemEntry((Component)TextUtils.translate("gui.dragonlib.scrollbar." + (orientation == Orientation.VERTICAL ? "page_down" : "page_right")), DLSprite.empty(), true, () -> this.value.set((Double)this.value.get() + (double)((Integer)this.screenSize.get()).intValue()), null));
            entries.add(DLContextMenu.ItemEntry.SEPARATOR);
            entries.add(new DLContextMenu.ItemEntry((Component)TextUtils.translate("gui.dragonlib.scrollbar." + (orientation == Orientation.VERTICAL ? "step_up" : "step_left")), DLSprite.empty(), true, () -> this.value.set((Double)this.value.get() - (double)((Integer)this.scrollSteps.get()).intValue()), null));
            entries.add(new DLContextMenu.ItemEntry((Component)TextUtils.translate("gui.dragonlib.scrollbar." + (orientation == Orientation.VERTICAL ? "step_down" : "step_right")), DLSprite.empty(), true, () -> this.value.set((Double)this.value.get() + (double)((Integer)this.scrollSteps.get()).intValue()), null));
            return entries;
        });
        this.addEventListener(DLGuiStandardEvents.RightClickEvent.class, (src, event) -> {
            contextMenu.open(this.getWindowManager(), (int)this.getWindowManager().mouseXOnScreen(), (int)this.getWindowManager().mouseYOnScreen());
            return false;
        });
        this.addEventListener(DLGuiStandardEvents.ScrollEvent.class, (src, event) -> {
            this.updateScrollValueOnScroll(event.deltaX(), event.deltaY());
            return false;
        });
        this.addEventListener(DLGuiStandardEvents.DragEvent.class, (src, event) -> {
            if (event.button() == 0) {
                this.updateScrollValueOnDrag(event.mouseX(), event.mouseY());
            }
            return false;
        });
        this.addEventListener(DLGuiStandardEvents.MouseDownEvent.class, (src, event) -> {
            if (event.button() == 0) {
                this.updateScrollValueOnClick(event.mouseX(), event.mouseY());
            }
            return false;
        });
        this.scrollUpBtn = new DLButton(0, 0, orientation == Orientation.HORIZONTAL ? 14 : w, orientation == Orientation.VERTICAL ? 14 : h);
        this.scrollUpBtn.text.set(TextUtils.EMPTY);
        this.scrollUpBtn.icon.set(orientation == Orientation.VERTICAL ? GuiIcons.ARROW_UP.getAsSprite(16, 16) : GuiIcons.ARROW_LEFT.getAsSprite(16, 16));
        this.scrollUpBtn.componentRenderer.set((IStateRenderer)this.buttonsComponentRenderer.get());
        this.scrollUpBtn.visible.set((Boolean)this.showButtons.get());
        this.scrollUpBtn.addEventListener(DLGuiStandardEvents.MouseHoldDownEvent.class, (src, event) -> {
            if (event.button() == 0) {
                this.value.set((Double)this.value.get() - (double)((Integer)this.scrollSteps.get()).intValue());
            }
            return false;
        });
        this.addComponent(this.scrollUpBtn);
        this.scrollDownBtn = new DLButton(orientation == Orientation.HORIZONTAL ? this.width() - 14 : 0, orientation == Orientation.VERTICAL ? this.height() - 14 : 0, orientation == Orientation.HORIZONTAL ? 14 : w, orientation == Orientation.VERTICAL ? 14 : h);
        this.scrollDownBtn.text.set(TextUtils.EMPTY);
        this.scrollDownBtn.icon.set(orientation == Orientation.VERTICAL ? GuiIcons.ARROW_DOWN.getAsSprite(16, 16) : GuiIcons.ARROW_RIGHT.getAsSprite(16, 16));
        this.scrollDownBtn.componentRenderer.set((IStateRenderer)this.buttonsComponentRenderer.get());
        this.scrollDownBtn.visible.set((Boolean)this.showButtons.get());
        this.scrollDownBtn.addEventListener(DLGuiStandardEvents.MouseHoldDownEvent.class, (src, event) -> {
            if (event.button() == 0) {
                this.value.set((Double)this.value.get() + (double)((Integer)this.scrollSteps.get()).intValue());
            }
            return false;
        });
        this.addComponent(this.scrollDownBtn);
        this.buttonsComponentRenderer.withAfterPropertyChangedCallback((o, val) -> {
            this.scrollUpBtn.componentRenderer.set((IStateRenderer<DLButton.ButtonState>)val);
            this.scrollDownBtn.componentRenderer.set((IStateRenderer<DLButton.ButtonState>)val);
        });
    }

    public boolean canScroll() {
        return (Integer)this.max.get() > (Integer)this.screenSize.get();
    }

    protected int getScrollAreaSize() {
        return switch (this.orientation.ordinal()) {
            default -> throw new IncompatibleClassChangeError();
            case 0 -> this.width() - 0 - ((Boolean)this.showButtons.get() != false ? 28 : 0);
            case 1 -> this.height() - 0 - ((Boolean)this.showButtons.get() != false ? 28 : 0);
        };
    }

    protected int getScrollAreaOffset() {
        return 0 + ((Boolean)this.showButtons.get() != false ? 14 : 0);
    }

    protected int calculateAutoScrollerSize() {
        if (!this.canScroll()) {
            return 0;
        }
        int forcedScroller = (Integer)this.scrollerSize.get();
        if (forcedScroller > 0) {
            return forcedScroller;
        }
        int area = this.getScrollAreaSize();
        double ratio = (double)((Integer)this.screenSize.get()).intValue() / (double)Math.max(1, (Integer)this.max.get());
        int computed = (int)((double)area * ratio);
        return Math.max(5, Math.min(area, computed));
    }

    protected double scrollRange() {
        return Math.max(0, (Integer)this.max.get() - (Integer)this.screenSize.get());
    }

    protected void clampValueToRange() {
        double min = 0.0;
        double maxRange = this.scrollRange();
        double cur = (Double)this.value.get();
        double clamped = Math.max(min, Math.min(cur, maxRange));
        if (clamped != cur) {
            this.value.set(clamped);
        }
    }

    protected void updateScrollValueOnScroll(double deltaX, double deltaY) {
        double next;
        if (!this.canScroll()) {
            this.value.set(0.0);
            return;
        }
        switch (this.orientation.ordinal()) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case 1: {
                double d = (Double)this.value.get() + deltaY * (double)((Integer)this.scrollSteps.get()).intValue();
                break;
            }
            case 0: {
                double d = next = (Double)this.value.get() + deltaX * (double)((Integer)this.scrollSteps.get()).intValue();
            }
        }
        if ((Integer)this.gridSteps.get() > 0) {
            next = (double)Math.round(next / ((Integer)this.gridSteps.get()).doubleValue()) * ((Integer)this.gridSteps.get()).doubleValue();
        }
        this.value.set(next);
    }

    protected void updateScrollValueOnDrag(double mouseX, double mouseY) {
        if (!this.canScroll()) {
            this.value.set(0.0);
            return;
        }
        int scroller = this.calculateAutoScrollerSize();
        int area = this.getScrollAreaSize();
        double range = this.scrollRange();
        if (range <= 0.0 || area - scroller <= 0) {
            this.value.set(0.0);
            return;
        }
        double posPixel = switch (this.orientation.ordinal()) {
            default -> throw new IncompatibleClassChangeError();
            case 1 -> mouseY - 0.0 - (double)this.dragOffset - (double)this.getScrollAreaOffset();
            case 0 -> mouseX - 0.0 - (double)this.dragOffset - (double)this.getScrollAreaOffset();
        };
        double value = range / (double)(area - scroller) * posPixel;
        if ((Integer)this.gridSteps.get() > 0) {
            value = (double)Math.round(value / ((Integer)this.gridSteps.get()).doubleValue()) * ((Integer)this.gridSteps.get()).doubleValue();
        }
        this.value.set(value);
    }

    protected void calculateDragOffset(double mouseX, double mouseY) {
        int scroller = this.calculateAutoScrollerSize();
        int area = this.getScrollAreaSize();
        double range = this.scrollRange();
        if (range <= 0.0 || area - scroller <= 0) {
            this.dragOffset = (int)((double)scroller / 2.0);
            return;
        }
        int d = (int)((double)(area - scroller) / range * (Double)this.value.get());
        this.dragOffset = (int)((this.orientation == Orientation.VERTICAL ? mouseY : mouseX) - (double)d - (double)this.getScrollAreaOffset());
    }

    protected void updateScrollValueOnClick(double mouseX, double mouseY) {
        this.calculateDragOffset(mouseX, mouseY);
        int scroller = this.calculateAutoScrollerSize();
        if (this.dragOffset < 0 || this.dragOffset > scroller) {
            this.dragOffset = (int)((double)scroller / 2.0);
            this.scrollTo(this.orientation == Orientation.VERTICAL ? mouseY : mouseX);
        }
    }

    public void scrollTo(double position) {
        if (!this.canScroll()) {
            this.value.set(0.0);
            return;
        }
        int scroller = this.calculateAutoScrollerSize();
        int area = this.getScrollAreaSize();
        double range = this.scrollRange();
        if (range <= 0.0 || area - scroller <= 0) {
            this.value.set(0.0);
            return;
        }
        double pixelCenter = position - (double)this.getScrollAreaOffset() - (double)scroller * 0.5;
        double value = range / (double)(area - scroller) * pixelCenter;
        if ((Integer)this.gridSteps.get() > 0) {
            value = (double)Math.round(value / ((Integer)this.gridSteps.get()).doubleValue()) * ((Integer)this.gridSteps.get()).doubleValue();
        }
        this.value.set(value);
    }

    @Override
    public void renderMainLayer(DLGuiGraphics graphics, double mouseX, double mouseY, Rectangle renderBounds) {
        GuiUtils.setTint(this.backgroundTint.get());
        ((IStateRenderer)this.componentRenderer.get()).renderSprite(graphics, this.orientation == Orientation.HORIZONTAL && (Boolean)this.showButtons.get() != false ? 14 : 0, this.orientation == Orientation.VERTICAL && (Boolean)this.showButtons.get() != false ? 14 : 0, this.width() - (this.orientation == Orientation.HORIZONTAL && (Boolean)this.showButtons.get() != false ? 28 : 0), this.height() - (this.orientation == Orientation.VERTICAL && (Boolean)this.showButtons.get() != false ? 28 : 0), this, ScrollBarState.BACKGROUND);
        if (this.canScroll()) {
            int scroller = this.calculateAutoScrollerSize();
            int area = this.getScrollAreaSize();
            switch (this.orientation.ordinal()) {
                case 1: {
                    ScrollBarState state = ScrollBarState.SCROLLER_VERTICAL_NORMAL;
                    if (!((Boolean)this.enabled.get()).booleanValue()) {
                        state = ScrollBarState.SCROLLER_VERTICAL_DISABLED;
                    } else if (this.isMouseDown() && this.getWindowManager().getMouseDownButton() == 0) {
                        state = ScrollBarState.SCROLLER_VERTICAL_DOWN_SELECTED;
                    } else if (this.isSelected()) {
                        state = ScrollBarState.SCROLLER_VERTICAL_SELECTED;
                    }
                    double range = this.scrollRange();
                    int d = 0;
                    if (range > 0.0) {
                        d = (int)((double)(area - scroller) / range * (Double)this.value.get());
                    }
                    ((IStateRenderer)this.componentRenderer.get()).renderSprite(graphics, 0, d + this.getScrollAreaOffset(), this.width() - 0, scroller, this, state);
                    break;
                }
                case 0: {
                    ScrollBarState state = ScrollBarState.SCROLLER_HORIZONTAL_NORMAL;
                    if (!((Boolean)this.enabled.get()).booleanValue()) {
                        state = ScrollBarState.SCROLLER_HORIZONTAL_DISABLED;
                    } else if (this.isMouseDown() && this.getWindowManager().getMouseDownButton() == 0) {
                        state = ScrollBarState.SCROLLER_HORIZONTAL_DOWN_SELECTED;
                    } else if (this.isSelected()) {
                        state = ScrollBarState.SCROLLER_HORIZONTAL_SELECTED;
                    }
                    double range = this.scrollRange();
                    int d = 0;
                    if (range > 0.0) {
                        d = (int)((double)(area - scroller) / range * (Double)this.value.get());
                    }
                    ((IStateRenderer)this.componentRenderer.get()).renderSprite(graphics, d + this.getScrollAreaOffset(), 0, scroller, this.height() - 0, this, state);
                }
            }
        }
        GuiUtils.resetTint();
    }

    public static enum Orientation {
        HORIZONTAL,
        VERTICAL;

    }

    public static enum ScrollBarState {
        BACKGROUND,
        SCROLLER_VERTICAL_NORMAL,
        SCROLLER_VERTICAL_SELECTED,
        SCROLLER_VERTICAL_DOWN_SELECTED,
        SCROLLER_VERTICAL_DISABLED,
        SCROLLER_HORIZONTAL_NORMAL,
        SCROLLER_HORIZONTAL_SELECTED,
        SCROLLER_HORIZONTAL_DOWN_SELECTED,
        SCROLLER_HORIZONTAL_DISABLED;

    }

    public record BackgroundColorChangedEvent(DLColor color) implements IEvent
    {
    }

    public record ValueChangedEvent(double value) implements IEvent
    {
    }

    public record MaxValueChangedEvent(int max) implements IEvent
    {
    }

    public record ScreenSizeChangedEvent(int size) implements IEvent
    {
    }

    public record ScrollerSizeChangedEvent(int size) implements IEvent
    {
    }
}

