/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.mcdragonlib.client.gui.widgets.components;

import de.mrjulsen.mcdragonlib.DragonLib;
import de.mrjulsen.mcdragonlib.annotations.SupportsEvents;
import de.mrjulsen.mcdragonlib.client.gui.events.DLGuiStandardEvents;
import de.mrjulsen.mcdragonlib.client.gui.widgets.base.DLGuiComponent;
import de.mrjulsen.mcdragonlib.client.gui.widgets.components.DLButton;
import de.mrjulsen.mcdragonlib.client.gui.widgets.render.IStateRenderer;
import de.mrjulsen.mcdragonlib.client.gui.widgets.render.VanillaButtonRenderer;
import de.mrjulsen.mcdragonlib.client.gui.widgets.util.ITextFormatter;
import de.mrjulsen.mcdragonlib.client.util.DLGuiGraphics;
import de.mrjulsen.mcdragonlib.client.util.DLSprite;
import de.mrjulsen.mcdragonlib.client.util.GuiUtils;
import de.mrjulsen.mcdragonlib.data.ETextAlignment;
import de.mrjulsen.mcdragonlib.events.IEvent;
import de.mrjulsen.mcdragonlib.util.DLColor;
import de.mrjulsen.mcdragonlib.util.TextUtils;
import de.mrjulsen.mcdragonlib.util.math.MathUtils;
import de.mrjulsen.mcdragonlib.util.math.Rectangle;
import de.mrjulsen.mcdragonlib.util.properties.BooleanProperty;
import de.mrjulsen.mcdragonlib.util.properties.ColorProperty;
import de.mrjulsen.mcdragonlib.util.properties.NumberProperty;
import de.mrjulsen.mcdragonlib.util.properties.Property;
import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;

@SupportsEvents(value={CaptionChangedEvent.class, TextColorChangedEvent.class, BackgroundColorChangedEvent.class, ValueChangedEvent.class, ValueRangeChangedEvent.class, TextFormatChanged.class})
public class DLSlider
extends DLGuiComponent {
    public static final ITextFormatter<DLSlider> DEFAULT_TEXT_DOUBLE_VALUE_FORMAT = src -> TextUtils.text(((Component)src.text.get()).getString()).m_130946_(": ").m_130946_(String.valueOf((Double)src.value.get())).m_130948_(((Component)src.text.get()).m_7383_());
    public static final ITextFormatter<DLSlider> DEFAULT_TEXT_INT_VALUE_FORMAT = src -> TextUtils.text(((Component)src.text.get()).getString()).m_130946_(": ").m_130946_(String.valueOf(((Double)src.value.get()).intValue())).m_130948_(((Component)src.text.get()).m_7383_());
    public static final ITextFormatter<DLSlider> DEFAULT_TEXT_DOUBLE_PERCENTAGE_FORMAT = src -> TextUtils.text(((Component)src.text.get()).getString()).m_130946_(": ").m_130946_(String.valueOf((int)((Double)src.value.get() * 100.0))).m_130946_("%").m_130948_(((Component)src.text.get()).m_7383_());
    public final NumberProperty<Integer> sliderWidth = new NumberProperty<Integer>(8);
    public final NumberProperty<Double> step = new NumberProperty<Double>(1.0);
    public final NumberProperty<Double> min = new NumberProperty<Double>(0.0);
    public final NumberProperty<Double> max = new NumberProperty<Double>(100.0);
    public final NumberProperty<Double> value = (NumberProperty)new NumberProperty<Supplier<Double>>((Supplier<Double>)0.0, () -> (Double)this.min.get(), () -> (Double)this.max.get()).withAfterPropertyChangedCallback((o, a) -> this.invokeEvent(this, new ValueChangedEvent((double)a), true));
    public final Property<ITextFormatter<DLSlider>> textFormat = (Property)new Property<ITextFormatter<DLSlider>>(DEFAULT_TEXT_INT_VALUE_FORMAT).withAfterPropertyChangedCallback((o, a) -> this.invokeEvent(this, new TextFormatChanged(a), true));
    public final Property<Component> text = (Property)new Property<MutableComponent>(TextUtils.text(this.getClass().getSimpleName())).withAfterPropertyChangedCallback((o, a) -> this.invokeEvent(this, new CaptionChangedEvent((Component)a), true));
    public final ColorProperty textColor = (ColorProperty)new ColorProperty(DLColor.UNDEFINED, DLColor.WHITE).withAfterPropertyChangedCallback((o, a) -> this.invokeEvent(this, new TextColorChangedEvent((DLColor)a), true));
    public final ColorProperty backgroundTint = (ColorProperty)new ColorProperty(DLColor.UNDEFINED, DLColor.WHITE).withAfterPropertyChangedCallback((o, a) -> this.invokeEvent(this, new BackgroundColorChangedEvent((DLColor)a), true));
    public final Property<IStateRenderer<DLButton.ButtonState>> componentRenderer = new Property<VanillaButtonRenderer>(VanillaButtonRenderer.VANILLA_BUTTONS);
    public final Property<DLSprite> icon = new Property<DLSprite>(DLSprite.empty());
    public final Property<ETextAlignment> textAlignment = new Property<ETextAlignment>(ETextAlignment.CENTER);
    public final Property<ETextAlignment> iconAlignment = new Property<ETextAlignment>(ETextAlignment.CENTER);
    public final BooleanProperty drawFontShadow = new BooleanProperty(true);
    protected Component displayText = TextUtils.empty();

    public DLSlider(int x, int y, int w, int h) {
        super(x, y, w, h);
        this.min.withAfterPropertyChangedCallback((o, a) -> this.invokeEvent(this, new ValueRangeChangedEvent((double)a, (Double)this.max.get()), true));
        this.max.withAfterPropertyChangedCallback((o, a) -> this.invokeEvent(this, new ValueRangeChangedEvent((Double)this.min.get(), (double)a), true));
        this.addEventListener(DLGuiStandardEvents.DragEvent.class, (src, event) -> {
            if (event.button() == 0) {
                this.updateSliderValue(event.mouseX(), event.mouseY());
            }
            return false;
        });
        this.addEventListener(DLGuiStandardEvents.MouseDownEvent.class, (src, event) -> {
            if (event.button() == 0) {
                this.updateSliderValue(event.mouseX(), event.mouseY());
            }
            return true;
        });
        this.addEventListener(ValueRangeChangedEvent.class, (src, event) -> {
            this.clampValue();
            return false;
        });
        this.addEventListener(ValueChangedEvent.class, (src, event) -> {
            this.displayText = ((ITextFormatter)this.textFormat.get()).combine(this);
            return false;
        });
        this.addEventListener(TextFormatChanged.class, (src, event) -> {
            this.displayText = ((ITextFormatter)this.textFormat.get()).combine(this);
            return false;
        });
        this.clampValue();
        this.displayText = ((ITextFormatter)this.textFormat.get()).combine(this);
    }

    protected void clampValue() {
        this.value.set(MathUtils.clamp((Double)this.value.get(), (Double)this.min.get(), (Double)this.max.get()));
    }

    protected void updateSliderValue(double mouseX, double mouseY) {
        double range = (Double)this.max.get() - (Double)this.min.get();
        double trackWidth = Math.max(0.0, (double)(this.width() - (Integer)this.sliderWidth.get()));
        if (range == 0.0 || trackWidth == 0.0) {
            this.value.set((Double)this.min.get());
            return;
        }
        double relativeX = (mouseX - (double)((Integer)this.sliderWidth.get()).intValue() / 2.0) / trackWidth;
        relativeX = MathUtils.clamp(relativeX, 0.0, 1.0);
        double rawValue = (Double)this.min.get() + relativeX * range;
        rawValue = (double)Math.round(rawValue / (Double)this.step.get()) * (Double)this.step.get();
        this.value.set(rawValue);
    }

    @Override
    public void renderMainLayer(DLGuiGraphics graphics, double mouseX, double mouseY, Rectangle renderBounds) {
        super.renderMainLayer(graphics, mouseX, mouseY, renderBounds);
        GuiUtils.setTint(this.backgroundTint.get());
        ((IStateRenderer)this.componentRenderer.get()).renderSprite(graphics, 0, 0, this.width(), this.height(), this, DLButton.ButtonState.DISABLED);
        double range = (Double)this.max.get() - (Double)this.min.get();
        double trackWidth = Math.max(0.0, (double)(this.width() - (Integer)this.sliderWidth.get()));
        int sliderX = range == 0.0 ? 0 : (int)(((Double)this.value.get() - (Double)this.min.get()) / range * trackWidth);
        if (!((Boolean)this.enabled.get()).booleanValue()) {
            ((IStateRenderer)this.componentRenderer.get()).renderSprite(graphics, sliderX, 0, (Integer)this.sliderWidth.get(), this.height(), this, DLButton.ButtonState.DISABLED);
        } else if (this.isMouseDown() && this.getWindowManager().getMouseDownButton() == 0) {
            ((IStateRenderer)this.componentRenderer.get()).renderSprite(graphics, sliderX, 0, (Integer)this.sliderWidth.get(), this.height(), this, DLButton.ButtonState.DOWN_SELECTED);
        } else if (this.isSelected()) {
            ((IStateRenderer)this.componentRenderer.get()).renderSprite(graphics, sliderX, 0, (Integer)this.sliderWidth.get(), this.height(), this, DLButton.ButtonState.SELECTED);
        } else {
            ((IStateRenderer)this.componentRenderer.get()).renderSprite(graphics, sliderX, 0, (Integer)this.sliderWidth.get(), this.height(), this, DLButton.ButtonState.NORMAL);
        }
        DLSprite iconSprite = (DLSprite)this.icon.get();
        boolean hasIcon = iconSprite != null && !iconSprite.isEmpty();
        Component buttonText = this.displayText;
        int textWidth = Minecraft.m_91087_().f_91062_.m_92852_((FormattedText)buttonText);
        Objects.requireNonNull(Minecraft.m_91087_().f_91062_);
        int textHeight = 9;
        int iconWidth = hasIcon ? iconSprite.getWidth() : 0;
        int iconHeight = hasIcon ? iconSprite.getHeight() : 0;
        int spacing = hasIcon && !buttonText.getString().isEmpty() ? 4 : 0;
        int centerY = this.height() / 2;
        int iconY = centerY - iconHeight / 2;
        int textY = centerY - textHeight / 2;
        int iconX = 0;
        int textX = 0;
        int buttonWidth = this.width();
        switch ((ETextAlignment)this.iconAlignment.get()) {
            case LEFT: {
                iconX = 4;
                int textStartX = iconX + iconWidth + spacing;
                switch ((ETextAlignment)this.textAlignment.get()) {
                    case LEFT: {
                        textX = Math.max(textStartX, 4);
                        break;
                    }
                    case CENTER: {
                        int centerTextX = buttonWidth / 2 - textWidth / 2;
                        textX = Math.max(centerTextX, textStartX);
                        break;
                    }
                    case RIGHT: {
                        textX = Math.max(buttonWidth - textWidth - 4, textStartX);
                    }
                }
                break;
            }
            case RIGHT: {
                iconX = buttonWidth - iconWidth - 4;
                int maxTextRight = iconX - spacing;
                switch ((ETextAlignment)this.textAlignment.get()) {
                    case LEFT: {
                        textX = 4;
                        break;
                    }
                    case CENTER: {
                        int centerTextX = buttonWidth / 2 - textWidth / 2;
                        textX = Math.min(centerTextX, maxTextRight - textWidth);
                        break;
                    }
                    case RIGHT: {
                        textX = Math.min(buttonWidth - textWidth - 4, maxTextRight - textWidth);
                    }
                }
                break;
            }
            case CENTER: {
                if (this.textAlignment.get() == ETextAlignment.CENTER) {
                    int startX;
                    int totalWidth = iconWidth + spacing + textWidth;
                    iconX = startX = (buttonWidth - totalWidth) / 2;
                    textX = iconX + iconWidth + spacing;
                    break;
                }
                switch ((ETextAlignment)this.textAlignment.get()) {
                    case LEFT: {
                        textX = 4;
                        break;
                    }
                    case CENTER: {
                        textX = buttonWidth / 2 - textWidth / 2;
                        break;
                    }
                    case RIGHT: {
                        textX = buttonWidth - textWidth - 4;
                    }
                }
                int centerIconX = buttonWidth / 2 - iconWidth / 2;
                if (textX < centerIconX + iconWidth && textX + textWidth > centerIconX) {
                    iconX = textX + textWidth + spacing;
                    if (iconX + iconWidth <= buttonWidth - 4 || (iconX = textX - iconWidth - spacing) >= 4) break;
                    iconX = centerIconX;
                    break;
                }
                iconX = centerIconX;
                break;
            }
            default: {
                iconX = 4;
                int textStartX = iconX + iconWidth + spacing;
                textX = Math.max(textStartX, 4);
            }
        }
        if (hasIcon) {
            iconSprite.render(graphics, iconX, iconY);
        }
        GuiUtils.setTint(this.textColor.get());
        GuiUtils.drawString(graphics, Minecraft.m_91087_().f_91062_, textX, textY, (FormattedText)buttonText, (Boolean)this.enabled.get() != false ? DragonLib.VANILLA_BUTTON_ACTIVE_FONT_COLOR : DragonLib.VANILLA_BUTTON_DISABLED_FONT_COLOR, ETextAlignment.LEFT, (boolean)((Boolean)this.drawFontShadow.get()));
        GuiUtils.resetTint();
    }

    public record ValueRangeChangedEvent(double min, double max) implements IEvent
    {
    }

    public record ValueChangedEvent(double value) implements IEvent
    {
    }

    public record TextFormatChanged<T extends DLGuiComponent>(ITextFormatter<T> format) implements IEvent
    {
    }

    public record BackgroundColorChangedEvent(DLColor color) implements IEvent
    {
    }

    public record TextColorChangedEvent(DLColor color) implements IEvent
    {
    }

    public record CaptionChangedEvent(Component text) implements IEvent
    {
    }
}

