/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.mcdragonlib.client.gui.widgets.components;

import de.mrjulsen.mcdragonlib.DragonLib;
import de.mrjulsen.mcdragonlib.annotations.SupportsEvents;
import de.mrjulsen.mcdragonlib.client.gui.events.DLGuiStandardEvents;
import de.mrjulsen.mcdragonlib.client.gui.widgets.base.DLGuiComponent;
import de.mrjulsen.mcdragonlib.client.gui.widgets.base.DLWindowManager;
import de.mrjulsen.mcdragonlib.client.gui.widgets.components.DLButton;
import de.mrjulsen.mcdragonlib.client.gui.widgets.render.IStateRenderer;
import de.mrjulsen.mcdragonlib.client.util.DLGuiGraphics;
import de.mrjulsen.mcdragonlib.client.util.DLSprite;
import de.mrjulsen.mcdragonlib.client.util.GuiUtils;
import de.mrjulsen.mcdragonlib.data.ETextAlignment;
import de.mrjulsen.mcdragonlib.events.IEvent;
import de.mrjulsen.mcdragonlib.util.math.Rectangle;
import de.mrjulsen.mcdragonlib.util.properties.BooleanProperty;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.sounds.SoundEvents;

@SupportsEvents(value={CheckedChangedEvent.class})
public class DLToggleButton
extends DLButton {
    public final BooleanProperty checked = (BooleanProperty)new BooleanProperty(false).withAfterPropertyChangedCallback((o, x) -> this.invokeEvent(this, new CheckedChangedEvent((boolean)x), true));
    public final BooleanProperty radioButtonMode = new BooleanProperty(false);

    public DLToggleButton(int x2, int y, int w, int h) {
        super(x2, y, w, h);
    }

    @Override
    public boolean defaultButtonClickAction(DLGuiComponent src, DLGuiStandardEvents.ClickEvent event) {
        if (((Boolean)this.radioButtonMode.get()).booleanValue()) {
            this.checked.set(true);
        } else {
            this.checked.toggle();
        }
        Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_263171_((Holder)SoundEvents.f_12490_, (float)((Boolean)this.checked.get() != false ? 0.75f : 1.0f)));
        if (((Boolean)this.radioButtonMode.get()).booleanValue() && ((Boolean)this.checked.get()).booleanValue()) {
            this.getParent().ifPresent(parent -> parent.forEachComponentMatching(this.getClass(), x -> x != this && (Boolean)x.radioButtonMode.get() != false, c -> c.checked.set(false)));
        }
        return false;
    }

    @Override
    public void renderMainLayer(DLGuiGraphics graphics, double mouseX, double mouseY, Rectangle renderBounds) {
        GuiUtils.setTint(this.backgroundTint.get());
        DLWindowManager manager = this.getWindowManager();
        if (((Boolean)this.checked.get()).booleanValue()) {
            if (!((Boolean)this.enabled.get()).booleanValue()) {
                ((IStateRenderer)this.componentRenderer.get()).renderSprite(graphics, 0, 0, this.width(), this.height(), this, DLButton.ButtonState.DISABLED);
            } else if (this.isMouseDown() && manager.getMouseDownButton() == 0) {
                ((IStateRenderer)this.componentRenderer.get()).renderSprite(graphics, 0, 0, this.width(), this.height(), this, DLButton.ButtonState.DOWN_SELECTED);
            } else if (this.isSelected()) {
                ((IStateRenderer)this.componentRenderer.get()).renderSprite(graphics, 0, 0, this.width(), this.height(), this, DLButton.ButtonState.DOWN_SELECTED);
            } else {
                ((IStateRenderer)this.componentRenderer.get()).renderSprite(graphics, 0, 0, this.width(), this.height(), this, DLButton.ButtonState.DOWN);
            }
        } else if (!((Boolean)this.enabled.get()).booleanValue()) {
            ((IStateRenderer)this.componentRenderer.get()).renderSprite(graphics, 0, 0, this.width(), this.height(), this, DLButton.ButtonState.DISABLED);
        } else if (this.isMouseDown() && manager.getMouseDownButton() == 0) {
            ((IStateRenderer)this.componentRenderer.get()).renderSprite(graphics, 0, 0, this.width(), this.height(), this, DLButton.ButtonState.DOWN_SELECTED);
        } else if (this.isSelected()) {
            ((IStateRenderer)this.componentRenderer.get()).renderSprite(graphics, 0, 0, this.width(), this.height(), this, DLButton.ButtonState.SELECTED);
        } else {
            ((IStateRenderer)this.componentRenderer.get()).renderSprite(graphics, 0, 0, this.width(), this.height(), this, DLButton.ButtonState.NORMAL);
        }
        DLSprite iconSprite = (DLSprite)this.icon.get();
        boolean hasIcon = iconSprite != null && !iconSprite.isEmpty();
        Component buttonText = (Component)this.text.get();
        int textWidth = Minecraft.m_91087_().f_91062_.m_92852_((FormattedText)buttonText);
        Objects.requireNonNull(Minecraft.m_91087_().f_91062_);
        int textHeight = 9;
        int iconWidth = hasIcon ? iconSprite.getWidth() : 0;
        int iconHeight = hasIcon ? iconSprite.getHeight() : 0;
        int spacing = hasIcon && !buttonText.getString().isEmpty() ? 4 : 0;
        int centerY = this.height() / 2;
        int offset = this.isMouseDown() ? 1 : 0;
        int iconY = centerY - iconHeight / 2;
        int textY = centerY - textHeight / 2;
        int iconX = 0;
        int textX = 0;
        int buttonWidth = this.width();
        switch ((ETextAlignment)this.iconAlignment.get()) {
            case LEFT: {
                iconX = 4;
                int textStartX = iconX + iconWidth + spacing;
                switch ((ETextAlignment)this.textAlignment.get()) {
                    case LEFT: {
                        textX = Math.max(textStartX, 4);
                        break;
                    }
                    case CENTER: {
                        int centerTextX = buttonWidth / 2 - textWidth / 2;
                        textX = Math.max(centerTextX, textStartX);
                        break;
                    }
                    case RIGHT: {
                        textX = Math.max(buttonWidth - textWidth - 4, textStartX);
                    }
                }
                break;
            }
            case RIGHT: {
                iconX = buttonWidth - iconWidth - 4;
                int maxTextRight = iconX - spacing;
                switch ((ETextAlignment)this.textAlignment.get()) {
                    case LEFT: {
                        textX = 4;
                        break;
                    }
                    case CENTER: {
                        int centerTextX = buttonWidth / 2 - textWidth / 2;
                        textX = Math.min(centerTextX, maxTextRight - textWidth);
                        break;
                    }
                    case RIGHT: {
                        textX = Math.min(buttonWidth - textWidth - 4, maxTextRight - textWidth);
                    }
                }
                break;
            }
            case CENTER: {
                if (this.textAlignment.get() == ETextAlignment.CENTER) {
                    int startX;
                    int totalWidth = iconWidth + spacing + textWidth;
                    iconX = startX = (buttonWidth - totalWidth) / 2;
                    textX = iconX + iconWidth + spacing;
                    break;
                }
                switch ((ETextAlignment)this.textAlignment.get()) {
                    case LEFT: {
                        textX = 4;
                        break;
                    }
                    case CENTER: {
                        textX = buttonWidth / 2 - textWidth / 2;
                        break;
                    }
                    case RIGHT: {
                        textX = buttonWidth - textWidth - 4;
                    }
                }
                int centerIconX = buttonWidth / 2 - iconWidth / 2;
                if (textX < centerIconX + iconWidth && textX + textWidth > centerIconX) {
                    iconX = textX + textWidth + spacing;
                    if (iconX + iconWidth <= buttonWidth - 4 || (iconX = textX - iconWidth - spacing) >= 4) break;
                    iconX = centerIconX;
                    break;
                }
                iconX = centerIconX;
                break;
            }
            default: {
                iconX = 4;
                int textStartX = iconX + iconWidth + spacing;
                textX = Math.max(textStartX, 4);
            }
        }
        if (hasIcon) {
            iconSprite.render(graphics, iconX + offset, iconY + offset);
        }
        GuiUtils.setTint(this.textColor.get());
        GuiUtils.drawString(graphics, Minecraft.m_91087_().f_91062_, textX + offset, textY + offset, (FormattedText)buttonText, (Boolean)this.enabled.get() != false ? DragonLib.VANILLA_BUTTON_ACTIVE_FONT_COLOR : DragonLib.VANILLA_BUTTON_DISABLED_FONT_COLOR, ETextAlignment.LEFT, (boolean)((Boolean)this.drawFontShadow.get()));
        GuiUtils.resetTint();
    }

    public record CheckedChangedEvent(boolean checked) implements IEvent
    {
    }
}

