/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.mcdragonlib.client.gui.widgets.layout;

import de.mrjulsen.mcdragonlib.client.gui.widgets.base.DLGuiComponent;
import de.mrjulsen.mcdragonlib.client.gui.widgets.layout.ILayoutManager;
import de.mrjulsen.mcdragonlib.client.gui.widgets.layout.LayoutResult;
import de.mrjulsen.mcdragonlib.client.gui.widgets.richtext.Padding;
import de.mrjulsen.mcdragonlib.util.properties.BooleanProperty;
import de.mrjulsen.mcdragonlib.util.properties.NumberProperty;
import de.mrjulsen.mcdragonlib.util.properties.Property;
import java.util.ArrayList;
import java.util.List;

public class FlowLayout
implements ILayoutManager {
    public final Property<Direction> flowDirection = new Property<Direction>(Direction.HORIZONTAL);
    public final BooleanProperty wrap = new BooleanProperty(true);
    public final NumberProperty<Integer> horizontalGap = new NumberProperty<Integer>(0);
    public final NumberProperty<Integer> verticalGap = new NumberProperty<Integer>(0);
    public final Property<Padding> padding = new Property<Padding>(Padding.ZERO);
    public final BooleanProperty fillCrossAxis = new BooleanProperty(false);

    @Override
    public LayoutResult arrangeComponents(DLGuiComponent host) {
        boolean isHorizontal;
        List<DLGuiComponent> children = host.getComponents();
        if (children.isEmpty()) {
            return LayoutResult.EMPTY;
        }
        boolean bl = isHorizontal = this.flowDirection.get() == Direction.HORIZONTAL;
        if (isHorizontal) {
            return this.arrangeHorizontal(host, children);
        }
        return this.arrangeVertical(host, children);
    }

    private LayoutResult arrangeHorizontal(DLGuiComponent host, List<DLGuiComponent> children) {
        Padding p = (Padding)this.padding.get();
        int gapX = (Integer)this.horizontalGap.get();
        int gapY = (Integer)this.verticalGap.get();
        int maxW = host.width() - p.left() - p.right();
        int currentY = p.top();
        int maxContentX = 0;
        int maxContentY = 0;
        int index = 0;
        while (index < children.size()) {
            FlowConstraint constraint;
            int currentLineWidth = 0;
            int fixedUsedWidth = 0;
            int fillCount = 0;
            ArrayList<DLGuiComponent> lineComponents = new ArrayList<DLGuiComponent>();
            while (index < children.size()) {
                int currentGap;
                DLGuiComponent child = children.get(index);
                FlowConstraint constraint2 = this.getConstraintOrDefault(child, FlowConstraint.START);
                if (((Boolean)this.fillCrossAxis.get()).booleanValue() && !((Boolean)this.wrap.get()).booleanValue()) {
                    child.setHeight(host.height() - p.top() - p.bottom());
                }
                int childW = child.width();
                int n = currentGap = lineComponents.isEmpty() ? 0 : gapX;
                if (((Boolean)this.wrap.get()).booleanValue() && !lineComponents.isEmpty() && currentLineWidth + currentGap + childW > maxW) break;
                currentLineWidth += currentGap + childW;
                lineComponents.add(child);
                if (constraint2 == FlowConstraint.FILL) {
                    ++fillCount;
                    fixedUsedWidth += currentGap;
                } else {
                    fixedUsedWidth += currentGap + childW;
                }
                if (!((Boolean)this.wrap.get()).booleanValue() && ++index >= children.size()) continue;
            }
            int lineAvailableSpace = maxW - fixedUsedWidth;
            int fillWidth = 0;
            if (fillCount > 0) {
                fillWidth = Math.max(0, lineAvailableSpace / fillCount);
            }
            int startX = p.left();
            int endX = host.width() - p.right();
            int rowHeight = 0;
            for (DLGuiComponent child : lineComponents) {
                constraint = this.getConstraintOrDefault(child, FlowConstraint.START);
                if (constraint == FlowConstraint.FILL) {
                    child.setWidth(fillWidth);
                }
                rowHeight = Math.max(rowHeight, child.height());
            }
            for (DLGuiComponent child : lineComponents) {
                constraint = this.getConstraintOrDefault(child, FlowConstraint.START);
                if (constraint == FlowConstraint.END) {
                    child.setPosition(endX -= child.width(), currentY);
                    endX -= gapX;
                } else {
                    child.setPosition(startX, currentY);
                    startX += child.width() + gapX;
                }
                maxContentX = Math.max(maxContentX, child.x() + child.width());
                maxContentY = Math.max(maxContentY, child.y() + child.height());
            }
            currentY += rowHeight + gapY;
        }
        return new LayoutResult(maxContentX + p.right(), maxContentY + p.bottom());
    }

    private LayoutResult arrangeVertical(DLGuiComponent host, List<DLGuiComponent> children) {
        Padding p = (Padding)this.padding.get();
        int gapX = (Integer)this.horizontalGap.get();
        int gapY = (Integer)this.verticalGap.get();
        int maxH = host.height() - p.top() - p.bottom();
        int currentX = p.left();
        int maxContentX = 0;
        int maxContentY = 0;
        int index = 0;
        while (index < children.size()) {
            FlowConstraint constraint;
            int currentColHeight = 0;
            int fixedUsedHeight = 0;
            int fillCount = 0;
            ArrayList<DLGuiComponent> colComponents = new ArrayList<DLGuiComponent>();
            while (index < children.size()) {
                int currentGap;
                DLGuiComponent child = children.get(index);
                FlowConstraint constraint2 = this.getConstraintOrDefault(child, FlowConstraint.START);
                if (((Boolean)this.fillCrossAxis.get()).booleanValue() && !((Boolean)this.wrap.get()).booleanValue()) {
                    child.setWidth(host.width() - p.left() - p.right());
                }
                int childH = child.height();
                int n = currentGap = colComponents.isEmpty() ? 0 : gapY;
                if (((Boolean)this.wrap.get()).booleanValue() && !colComponents.isEmpty() && currentColHeight + currentGap + childH > maxH) break;
                currentColHeight += currentGap + childH;
                colComponents.add(child);
                if (constraint2 == FlowConstraint.FILL) {
                    ++fillCount;
                    fixedUsedHeight += currentGap;
                } else {
                    fixedUsedHeight += currentGap + childH;
                }
                if (!((Boolean)this.wrap.get()).booleanValue() && ++index >= children.size()) continue;
            }
            int colAvailableSpace = maxH - fixedUsedHeight;
            int fillHeight = 0;
            if (fillCount > 0) {
                fillHeight = Math.max(0, colAvailableSpace / fillCount);
            }
            int startY = p.top();
            int endY = host.height() - p.bottom();
            int colWidth = 0;
            for (DLGuiComponent child : colComponents) {
                constraint = this.getConstraintOrDefault(child, FlowConstraint.START);
                if (constraint == FlowConstraint.FILL) {
                    child.setHeight(fillHeight);
                }
                colWidth = Math.max(colWidth, child.width());
            }
            for (DLGuiComponent child : colComponents) {
                constraint = this.getConstraintOrDefault(child, FlowConstraint.START);
                if (constraint == FlowConstraint.END) {
                    child.setPosition(currentX, endY -= child.height());
                    endY -= gapY;
                } else {
                    child.setPosition(currentX, startY);
                    startY += child.height() + gapY;
                }
                maxContentX = Math.max(maxContentX, child.x() + child.width());
                maxContentY = Math.max(maxContentY, child.y() + child.height());
            }
            currentX += colWidth + gapX;
        }
        return new LayoutResult(maxContentX + p.right(), maxContentY + p.bottom());
    }

    private FlowConstraint getConstraintOrDefault(DLGuiComponent child, FlowConstraint def) {
        if (child.layoutContraint != null && child.layoutContraint.get() instanceof FlowConstraint) {
            return (FlowConstraint)((Object)child.layoutContraint.get());
        }
        return def;
    }

    public static enum Direction {
        VERTICAL,
        HORIZONTAL;

    }

    public static enum FlowConstraint {
        START,
        END,
        FILL;

    }
}

