/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.mcdragonlib.client.gui.widgets.layout;

import de.mrjulsen.mcdragonlib.client.gui.widgets.base.DLGuiComponent;
import de.mrjulsen.mcdragonlib.client.gui.widgets.layout.ILayoutManager;
import de.mrjulsen.mcdragonlib.client.gui.widgets.layout.LayoutResult;
import de.mrjulsen.mcdragonlib.client.gui.widgets.richtext.Padding;
import de.mrjulsen.mcdragonlib.util.properties.NumberProperty;
import de.mrjulsen.mcdragonlib.util.properties.Property;
import java.util.HashSet;
import java.util.List;

public class GridLayout
implements ILayoutManager {
    public final NumberProperty<Integer> columns = new NumberProperty<Integer>(Integer.valueOf(9), 1, Integer.MAX_VALUE);
    public final NumberProperty<Integer> slotWidth = new NumberProperty<Integer>(Integer.valueOf(18), 0, Integer.MAX_VALUE);
    public final NumberProperty<Integer> slotHeight = new NumberProperty<Integer>(Integer.valueOf(18), 0, Integer.MAX_VALUE);
    public final NumberProperty<Integer> gap = new NumberProperty<Integer>(0);
    public final Property<Padding> padding = new Property<Padding>(Padding.ZERO);

    public GridLayout(int columns) {
        this.columns.set(columns);
    }

    @Override
    public LayoutResult arrangeComponents(DLGuiComponent host) {
        List<DLGuiComponent> children = host.getComponents();
        if (children.isEmpty()) {
            return LayoutResult.EMPTY;
        }
        Padding p = (Padding)this.padding.get();
        int cols = Math.max(1, (Integer)this.columns.get());
        int w = (Integer)this.slotWidth.get();
        int h = (Integer)this.slotHeight.get();
        int g = (Integer)this.gap.get();
        int xOffset = p.left();
        int yOffset = p.top();
        int maxGridX = 0;
        int maxGridY = 0;
        HashSet<Integer> occupied = new HashSet<Integer>();
        int nextFreeIndex = 0;
        for (int i = 0; i < children.size(); ++i) {
            int assignedIndex;
            DLGuiComponent child = children.get(i);
            GridConstraint gc = null;
            if (child.layoutContraint != null && child.layoutContraint.get() instanceof GridConstraint) {
                gc = (GridConstraint)child.layoutContraint.get();
            }
            if (gc != null) {
                int colIdx = Math.max(0, Math.min(gc.x, cols - 1));
                int rowIdx = Math.max(0, gc.y);
                int desiredIndex = rowIdx * cols + colIdx;
                while (occupied.contains(desiredIndex)) {
                    ++desiredIndex;
                }
                assignedIndex = desiredIndex;
                occupied.add(assignedIndex);
                if (assignedIndex >= nextFreeIndex) {
                    nextFreeIndex = assignedIndex + 1;
                }
            } else {
                while (occupied.contains(nextFreeIndex)) {
                    ++nextFreeIndex;
                }
                assignedIndex = nextFreeIndex++;
                occupied.add(assignedIndex);
            }
            int colIndex = assignedIndex % cols;
            int rowIndex = assignedIndex / cols;
            int xPos = xOffset + colIndex * (w + g);
            int yPos = yOffset + rowIndex * (h + g);
            child.setPosition(xPos, yPos);
            int currentRightEdge = xPos + w;
            int currentBottomEdge = yPos + h;
            if (currentRightEdge > maxGridX) {
                maxGridX = currentRightEdge;
            }
            if (currentBottomEdge <= maxGridY) continue;
            maxGridY = currentBottomEdge;
        }
        return new LayoutResult(maxGridX + p.right(), maxGridY + p.bottom());
    }

    public static class GridConstraint {
        public final int x;
        public final int y;

        public GridConstraint(int x, int y) {
            this.x = x;
            this.y = y;
        }
    }
}

