/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.mcdragonlib.client.gui.widgets.layout;

import de.mrjulsen.mcdragonlib.client.gui.widgets.base.DLGuiComponent;
import de.mrjulsen.mcdragonlib.client.gui.widgets.layout.ILayoutManager;
import de.mrjulsen.mcdragonlib.client.gui.widgets.layout.LayoutResult;
import de.mrjulsen.mcdragonlib.client.gui.widgets.richtext.Padding;
import de.mrjulsen.mcdragonlib.util.properties.NumberProperty;
import de.mrjulsen.mcdragonlib.util.properties.Property;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class TableLayout
implements ILayoutManager {
    private final List<TableColumn> columns = new ArrayList<TableColumn>();
    public final NumberProperty<Integer> columnGap = new NumberProperty<Integer>(0);
    public final Property<Padding> padding = new Property<Padding>(Padding.ZERO);

    public TableLayout addColumn(String name, double size, ColumnSizeMode mode) {
        this.columns.add(new TableColumn(name, size, mode));
        return this;
    }

    @Override
    public LayoutResult arrangeComponents(DLGuiComponent host) {
        List<DLGuiComponent> children = host.getComponents();
        if (this.columns.isEmpty()) {
            return LayoutResult.EMPTY;
        }
        Padding p = (Padding)this.padding.get();
        int totalAvailableWidth = Math.max(0, host.width() - p.left() - p.right());
        int gap = (Integer)this.columnGap.get();
        HashMap<String, DLGuiComponent> columnMap = new HashMap<String, DLGuiComponent>();
        for (DLGuiComponent child : children) {
            String slotName = this.getSlotName(child);
            if (slotName == null) continue;
            columnMap.put(slotName, child);
        }
        double usedWidth = 0.0;
        double totalPercentageWeight = 0.0;
        HashMap<String, Integer> calculatedWidths = new HashMap<String, Integer>();
        for (TableColumn col : this.columns) {
            if (col.mode == ColumnSizeMode.FIXED) {
                usedWidth += col.size;
                calculatedWidths.put(col.name, (int)col.size);
                continue;
            }
            if (col.mode == ColumnSizeMode.AUTO) {
                DLGuiComponent c = (DLGuiComponent)columnMap.get(col.name);
                int autoW = c != null ? c.width() : 0;
                usedWidth += (double)autoW;
                calculatedWidths.put(col.name, autoW);
                continue;
            }
            if (col.mode != ColumnSizeMode.PERCENTAGE) continue;
            totalPercentageWeight += col.size;
        }
        int totalGaps = Math.max(0, (this.columns.size() - 1) * gap);
        double availableForPercent = Math.max(0.0, (double)totalAvailableWidth - usedWidth - (double)totalGaps);
        for (TableColumn col : this.columns) {
            if (col.mode != ColumnSizeMode.PERCENTAGE) continue;
            double share = totalPercentageWeight > 0.0 ? col.size / totalPercentageWeight : 0.0;
            int w = (int)Math.round(availableForPercent * share);
            calculatedWidths.put(col.name, w);
        }
        int currentX = p.left();
        int maxContentY = 0;
        int childHeight = Math.max(0, host.height() - p.top() - p.bottom());
        for (TableColumn col : this.columns) {
            int colW = calculatedWidths.getOrDefault(col.name, 0);
            DLGuiComponent child = (DLGuiComponent)columnMap.get(col.name);
            if (child != null) {
                child.setX(currentX);
                child.setY(p.top());
                child.setWidth(colW);
                child.setHeight(childHeight);
                maxContentY = Math.max(maxContentY, child.y() + child.height());
            }
            currentX += colW + gap;
        }
        int finalRightEdge = this.columns.size() > 0 ? currentX - gap : p.left();
        return new LayoutResult(finalRightEdge + p.right(), maxContentY + p.bottom());
    }

    private String getSlotName(DLGuiComponent child) {
        Object t;
        if (child.layoutContraint != null && (t = child.layoutContraint.get()) instanceof String) {
            String s = (String)t;
            return s;
        }
        return null;
    }

    public static class TableColumn {
        String name;
        double size;
        ColumnSizeMode mode;

        public TableColumn(String name, double size, ColumnSizeMode mode) {
            this.name = name;
            this.size = size;
            this.mode = mode;
        }
    }

    public static enum ColumnSizeMode {
        FIXED,
        PERCENTAGE,
        AUTO;

    }
}

