/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.mcdragonlib.client.gui.widgets.render;

import de.mrjulsen.mcdragonlib.client.atlas.DLTextureSheetData;
import de.mrjulsen.mcdragonlib.client.gui.widgets.base.DLGuiComponent;
import de.mrjulsen.mcdragonlib.client.gui.widgets.components.DLButton;
import de.mrjulsen.mcdragonlib.client.gui.widgets.render.IStateRenderer;
import de.mrjulsen.mcdragonlib.client.render.DLTextureSheet;
import de.mrjulsen.mcdragonlib.client.util.DLGuiGraphics;

public class VanillaSimpleButtonRenderer
implements IStateRenderer<DLButton.ButtonState> {
    public static final VanillaSimpleButtonRenderer VANILLA_BUTTON_GRAY = new VanillaSimpleButtonRenderer(ColorVariant.GRAY);
    public static final VanillaSimpleButtonRenderer VANILLA_BUTTON_BROWN = new VanillaSimpleButtonRenderer(ColorVariant.BROWN);
    public static final VanillaSimpleButtonRenderer VANILLA_BUTTON_RED = new VanillaSimpleButtonRenderer(ColorVariant.RED);
    private final ColorVariant variant;

    public VanillaSimpleButtonRenderer(ColorVariant variant) {
        this.variant = variant;
    }

    @Override
    public void renderSprite(DLGuiGraphics graphics, int x, int y, int w, int h, DLGuiComponent component, DLButton.ButtonState state) {
        DLTextureSheetData.AbstractSprite sprite = switch (state) {
            case DLButton.ButtonState.SELECTED -> DLTextureSheet.DRAGONLIB_UI.getSprite("button_" + this.variant.getName() + "_selected");
            case DLButton.ButtonState.DOWN -> DLTextureSheet.DRAGONLIB_UI.getSprite("button_" + this.variant.getName() + "_down");
            case DLButton.ButtonState.DISABLED -> DLTextureSheet.DRAGONLIB_UI.getSprite("button_" + this.variant.getName() + "_disabled");
            case DLButton.ButtonState.DOWN_SELECTED -> DLTextureSheet.DRAGONLIB_UI.getSprite("button_" + this.variant.getName() + "_down_selected");
            case DLButton.ButtonState.DISABLED_SELECTED -> DLTextureSheet.DRAGONLIB_UI.getSprite("button_" + this.variant.getName() + "_disabled");
            default -> DLTextureSheet.DRAGONLIB_UI.getSprite("button_" + this.variant.getName() + "_normal");
        };
        sprite.render(graphics, x, y, w, h);
    }

    public static enum ColorVariant {
        GRAY("gray"),
        BROWN("brown"),
        RED("red");

        private final String name;

        private ColorVariant(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }
    }
}

