/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.mcdragonlib.client.gui.widgets.richtext;

import com.mojang.blaze3d.systems.RenderSystem;
import de.mrjulsen.mcdragonlib.annotations.SupportsEvents;
import de.mrjulsen.mcdragonlib.client.gui.events.DLGuiStandardEvents;
import de.mrjulsen.mcdragonlib.client.gui.widgets.base.DLGuiComponent;
import de.mrjulsen.mcdragonlib.client.gui.widgets.components.DLRichTextLabel;
import de.mrjulsen.mcdragonlib.client.gui.widgets.richtext.LineMarker;
import de.mrjulsen.mcdragonlib.client.gui.widgets.richtext.Padding;
import de.mrjulsen.mcdragonlib.client.gui.widgets.richtext.RichTextComponent;
import de.mrjulsen.mcdragonlib.client.gui.widgets.richtext.TextStyle;
import de.mrjulsen.mcdragonlib.client.gui.widgets.richtext.action.InteractiveElement;
import de.mrjulsen.mcdragonlib.client.gui.widgets.util.CursorType;
import de.mrjulsen.mcdragonlib.client.gui.widgets.util.TextCursorPosition;
import de.mrjulsen.mcdragonlib.client.util.DLGuiGraphics;
import de.mrjulsen.mcdragonlib.client.util.GuiUtils;
import de.mrjulsen.mcdragonlib.data.ETextAlignment;
import de.mrjulsen.mcdragonlib.events.IEvent;
import de.mrjulsen.mcdragonlib.util.DLColor;
import de.mrjulsen.mcdragonlib.util.DLUtils;
import de.mrjulsen.mcdragonlib.util.TextUtils;
import de.mrjulsen.mcdragonlib.util.math.MathUtils;
import de.mrjulsen.mcdragonlib.util.math.Rectangle;
import de.mrjulsen.mcdragonlib.util.properties.BooleanProperty;
import de.mrjulsen.mcdragonlib.util.properties.ColorProperty;
import de.mrjulsen.mcdragonlib.util.properties.NumberProperty;
import de.mrjulsen.mcdragonlib.util.properties.Property;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import net.minecraft.SharedConstants;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;

@SupportsEvents(value={TextReadOnlyChangedEvent.class, TextAcceptKeyPressedEvent.class, TextCancelKeyPressedEvent.class})
public abstract class DLAbstractRichTextInputField
extends DLRichTextLabel {
    private static final int CURSOR_BLINK_RATE = 20;
    private static final long DOUBLE_CLICK_TIME_MS = 300L;
    private static final float LINE_SCROLL_MULTIPLIER = 12.0f;
    private static final int CURSOR_SCROLL_Y_OFFSET_PIXELS = 5;
    private static final int SCROLL_X_ADVANCE_PIXELS = 10;
    private static final int SCROLL_Y_ADVANCE_PIXELS = 10;
    private static final int MOUSE_MULTICLICK_PRECISION_THRESHOLD = 2;
    public final ColorProperty selectionColor = new ColorProperty(DLColor.fromInt(-2147461633), DLColor.fromInt(-2147461633));
    public final ColorProperty lineHighlightColor = new ColorProperty(DLColor.fromInt(0x30FFFFFF), DLColor.TRANSPARENT);
    public final BooleanProperty showLineHighlight = new BooleanProperty(false);
    public final BooleanProperty readOnly = (BooleanProperty)new BooleanProperty(false).withAfterPropertyChangedCallback((o, x) -> this.invokeEvent(this, new TextReadOnlyChangedEvent((boolean)x)));
    public final Property<Component> placeholderText = new Property<MutableComponent>(TextUtils.empty());
    public final NumberProperty<Byte> cursorWidth = new NumberProperty<Byte>(Byte.valueOf((byte)1), (byte)1, (byte)127);
    public final Property<Padding> decoratedPadding = new Property<Padding>(Padding.ZERO);
    public final BooleanProperty acceptAndCancelKeysEnabled = new BooleanProperty(false);
    public final BooleanProperty hideSelection = new BooleanProperty(true);
    public final NumberProperty<Integer> cursorXOffset = new NumberProperty<Integer>(5);
    private int cursorBlink = 0;
    private int globalCursorIndex = 0;
    private int selectionAnchorIndex = 0;
    private boolean isDragging = false;
    private long lastClickTime = 0L;
    private int clickCount = 0;
    private double lastClickMouseX = 0.0;
    private double lastClickMouseY = 0.0;

    public DLAbstractRichTextInputField(int x2, int y, int w, int h) {
        super(x2, y, w, h);
        this.addEventListener(DLGuiStandardEvents.KeyPressEvent.class, (a, b) -> this.onKeyPressed(b.keyCode(), b.scanCode(), b.modifiers()));
        this.addEventListener(DLGuiStandardEvents.CharTypeEvent.class, (a, b) -> this.onCharTyped(b.codePoint(), b.modifiers()));
        this.addEventListener(DLGuiStandardEvents.MouseDownEvent.class, (a, b) -> this.onMouseDown2(b.mouseX(), b.mouseY(), b.button()));
        this.addEventListener(DLGuiStandardEvents.MultiClickEvent.class, (a, b) -> this.onMouseDown2(b.mouseX(), b.mouseY(), b.button()));
        this.addEventListener(DLGuiStandardEvents.ScrollEvent.class, (src, e) -> this.onScroll(e.mouseX(), e.mouseY(), e.deltaX(), e.deltaY()));
        this.addEventListener(DLGuiStandardEvents.DragEvent.class, this::onMouseDragged2);
        this.addEventListener(DLGuiStandardEvents.MouseReleaseEvent.class, this::onMouseUp2);
        this.setTextCursor(0, true);
        this.cursor.set(CursorType.IBEAM);
    }

    private int getCursorXOffsetWrapper() {
        return this.cursorXOffset == null ? 5 : (Integer)this.cursorXOffset.get();
    }

    @Override
    protected boolean onTextElementClicked(DLGuiComponent src, DLGuiStandardEvents.MouseDownEvent event) {
        if (Screen.m_96637_()) {
            return super.onTextElementClicked(src, event);
        }
        return false;
    }

    @Override
    protected boolean onHoverInteractiveElements(double mouseX, double mouseY) {
        LineMarker line = this.getLineAt(this.getGlobalCursorIndex());
        if (line == null) {
            return false;
        }
        double yOffset = (Boolean)this.multiline.get() != false ? 0.0 : (double)(this.getLayoutContentHeight() / 2.0f - line.lineHeight() / 2.0f - (float)((Integer)this.lineSpacing.get()).intValue() / 2.0f);
        return super.onHoverInteractiveElements(mouseX, mouseY - yOffset);
    }

    @Override
    protected float getLayoutContentX() {
        return super.getLayoutContentX() + (float)(this.decoratedPadding == null ? 0 : ((Padding)this.decoratedPadding.get()).left());
    }

    @Override
    protected float getLayoutContentY() {
        return super.getLayoutContentY() + (float)(this.decoratedPadding == null ? 0 : ((Padding)this.decoratedPadding.get()).top());
    }

    @Override
    protected float getLayoutContentWidth() {
        return super.getLayoutContentWidth() - (float)(this.decoratedPadding == null ? 0 : ((Padding)this.decoratedPadding.get()).right() + ((Padding)this.decoratedPadding.get()).left());
    }

    @Override
    protected float getLayoutContentHeight() {
        return super.getLayoutContentHeight() - (float)(this.decoratedPadding == null ? 0 : ((Padding)this.decoratedPadding.get()).bottom() + ((Padding)this.decoratedPadding.get()).top());
    }

    public int getGlobalCursorIndex() {
        return this.globalCursorIndex;
    }

    public int getSelectionAnchorIndex() {
        return this.selectionAnchorIndex;
    }

    public int getSelectionStart() {
        return Math.min(this.selectionAnchorIndex, this.globalCursorIndex);
    }

    public int getSelectionEnd() {
        return Math.max(this.selectionAnchorIndex, this.globalCursorIndex);
    }

    public String getSelectedText() {
        if (!this.hasSelection() || this.text.get() == null) {
            return "";
        }
        return ((RichTextComponent)this.text.get()).subComponent(this.getSelectionStart(), this.getSelectionEnd()).plainText();
    }

    public boolean hasSelection() {
        return this.selectionAnchorIndex != this.globalCursorIndex;
    }

    public int getLineCount() {
        List<LineMarker> lines = this.getLinesOrdered();
        return lines != null ? lines.size() : 0;
    }

    public String getTextInRange(int startIndex, int endIndex) {
        if (this.text.get() == null || startIndex < 0 || endIndex > ((RichTextComponent)this.text.get()).length() || startIndex >= endIndex) {
            return "";
        }
        return ((RichTextComponent)this.text.get()).subComponent(startIndex, endIndex).plainText();
    }

    public void scrollToLine(int lineIndex, boolean centerVertically) {
        List<LineMarker> lines = this.getLinesOrdered();
        if (lines == null || lines.isEmpty() || lineIndex < 0 || lineIndex >= lines.size()) {
            return;
        }
        LineMarker marker = lines.get(lineIndex);
        float y = marker.y() - (float)((Integer)this.lineSpacing.get()).intValue() / 2.0f;
        if (centerVertically) {
            y = y - this.getLayoutContentHeight() / 2.0f + (marker.lineHeight() + (float)((Integer)this.lineSpacing.get()).intValue()) / 2.0f;
        }
        this.setScrollOffsetY(MathUtils.clamp(y, 0.0f, this.getMaxScrollY()));
    }

    private boolean isNewLineCharBeforeLine(LineMarker line, String plainText) {
        if (line.startIndex() <= 0) {
            return false;
        }
        RichTextComponent rtc = (RichTextComponent)this.text.get();
        if (rtc == null || plainText == null) {
            return false;
        }
        return plainText.codePointBefore(line.startIndex()) == 10;
    }

    @Override
    public void refresh() {
        Font font = Minecraft.m_91087_().f_91062_;
        super.refresh();
        this.setTextCursor(this.globalCursorIndex, false);
    }

    private void deleteSelection() {
        if (((Boolean)this.readOnly.get()).booleanValue()) {
            return;
        }
        if (this.hasSelection() && this.text.get() != null) {
            int start = this.getSelectionStart();
            int end = this.getSelectionEnd();
            ((RichTextComponent)this.text.get()).remove(start, end);
            this.setTextCursor(start, true);
        }
    }

    public void replaceTextInternal(int startIndex, int endIndex, String text, TextStyle style) {
        if (((Boolean)this.readOnly.get()).booleanValue()) {
            return;
        }
        if (this.text.get() == null) {
            return;
        }
        int originalLengthOfReplacement = text.codePointCount(0, text.length());
        if (startIndex == this.getSelectionStart() && endIndex == this.getSelectionEnd() && this.hasSelection()) {
            this.deleteSelection();
            ((RichTextComponent)this.text.get()).insert(this.globalCursorIndex, text, style, null);
            this.setTextCursor(this.getGlobalCursorIndex() + originalLengthOfReplacement, true);
        } else {
            ((RichTextComponent)this.text.get()).remove(startIndex, endIndex);
            ((RichTextComponent)this.text.get()).insert(startIndex, text, style, null);
            this.setTextCursor(startIndex + originalLengthOfReplacement, true);
        }
    }

    public float getMaxScrollY() {
        if (!((Boolean)this.multiline.get()).booleanValue()) {
            return 0.0f;
        }
        List<LineMarker> lines = this.getLinesOrdered();
        if (lines.isEmpty()) {
            return 0.0f;
        }
        LineMarker lastLine = lines.get(lines.size() - 1);
        return lastLine.y() + lastLine.lineHeight() + (float)((Integer)this.lineSpacing.get()).intValue() - this.getLayoutContentHeight() + 10.0f;
    }

    public float getMaxScrollX() {
        if (((Boolean)this.lineWrap.get()).booleanValue()) {
            return 0.0f;
        }
        List<LineMarker> lines = this.getLinesOrdered();
        if (lines.isEmpty()) {
            return 0.0f;
        }
        float maxW = 0.0f;
        for (LineMarker marker : lines) {
            maxW = Math.max(marker.lineWidth(), maxW);
        }
        return maxW - this.getLayoutContentWidth() + 10.0f;
    }

    public boolean onScroll(double mouseX, double mouseY, double scrollX, double scrollY) {
        boolean shouldAllowHorizontalScroll;
        boolean changed = false;
        if (((Boolean)this.multiline.get()).booleanValue() && scrollY != 0.0) {
            float currentScrollY = (float)this.getScrollOffsetY();
            float newScrollY = currentScrollY + (float)(scrollY * 12.0);
            if (Float.compare(currentScrollY, newScrollY = MathUtils.clamp(newScrollY, 0.0f, this.getMaxScrollY())) != 0) {
                this.setScrollOffsetY(newScrollY);
                changed = true;
            }
        }
        boolean bl = shouldAllowHorizontalScroll = (Boolean)this.multiline.get() != false || (Boolean)this.lineWrap.get() == false;
        if (shouldAllowHorizontalScroll && scrollX != 0.0) {
            float currentScrollX = (float)this.getScrollOffsetX();
            float newScrollX = currentScrollX + (float)(scrollX * 12.0);
            if (Float.compare(currentScrollX, newScrollX = MathUtils.clamp(newScrollX, 0.0f, this.getMaxScrollX())) != 0) {
                this.setScrollOffsetX(newScrollX);
                changed = true;
            }
        }
        return true;
    }

    private String getClipboard() {
        return Minecraft.m_91087_().f_91068_.m_90876_();
    }

    private void setClipboard(String text) {
        Minecraft.m_91087_().f_91068_.m_90911_(text);
    }

    @Override
    public void tick() {
        super.tick();
        ++this.cursorBlink;
        this.cursorBlink %= 20;
    }

    @Override
    public void renderMainLayer(DLGuiGraphics graphics, double mouseX, double mouseY, Rectangle renderBounds) {
        TextCursorPosition textCursorPos;
        float lineMarkerHeight;
        float lineMarkerY;
        Font font = Minecraft.m_91087_().f_91062_;
        LineMarker currentLine = this.getLineAt(this.globalCursorIndex);
        if (currentLine == null) {
            return;
        }
        graphics.poseStack().m_85836_();
        graphics.poseStack().m_252880_(0.0f, (Boolean)this.multiline.get() != false ? 0.0f : this.getLayoutContentHeight() / 2.0f - currentLine.lineHeight() / 2.0f - (float)((Integer)this.lineSpacing.get()).intValue() / 2.0f, 0.0f);
        if (this.isFocused() && ((Boolean)this.showLineHighlight.get()).booleanValue() && this.globalCursorIndex >= 0 && this.text.get() != null && this.globalCursorIndex <= ((RichTextComponent)this.text.get()).length() && (lineMarkerY = (float)((double)(currentLine.y() - (float)((Integer)this.lineSpacing.get()).intValue() / 2.0f) - this.getScrollOffsetY())) + (lineMarkerHeight = currentLine.lineHeight() + (float)((Integer)this.lineSpacing.get()).intValue()) > 0.0f && lineMarkerY < (float)this.height()) {
            int targetY = (int)(lineMarkerY + this.getLayoutContentY());
            int targetH = (int)lineMarkerHeight;
            int realY = (int)MathUtils.clamp((float)targetY, this.getLayoutContentY(), (float)this.height() - this.getLayoutContentY());
            int diffY = Math.max(0, realY - targetY);
            int realH = MathUtils.clamp(targetH - diffY, 0, this.height() - realY - ((Padding)this.contentPadding.get()).bottom() - ((Padding)this.decoratedPadding.get()).bottom());
            GuiUtils.fill(graphics, ((Padding)this.decoratedPadding.get()).left(), realY, this.width() - ((Padding)this.decoratedPadding.get()).left() - ((Padding)this.decoratedPadding.get()).right(), realH, this.lineHighlightColor.get());
        }
        super.renderMainLayer(graphics, mouseX, mouseY, renderBounds);
        if (this.text.get() != null && ((RichTextComponent)this.text.get()).getPlainText().isEmpty() && this.placeholderText.get() != null && !this.isFocused()) {
            GuiUtils.drawString(graphics, font, (int)this.getLayoutContentX(), (int)(this.getLayoutContentY() + (float)((Integer)this.lineSpacing.get()).intValue() / 2.0f), (FormattedText)this.placeholderText.get(), DLColor.fromInt(-8355712), ETextAlignment.LEFT, false);
        }
        GuiUtils.enableScissor(graphics, (int)(renderBounds.x() + (double)this.getLayoutContentX()), (int)(renderBounds.y() + (double)this.getLayoutContentY()), (int)this.getLayoutContentWidth(), (int)this.getLayoutContentHeight());
        if (this.hasSelection()) {
            this.renderSelection(graphics);
        }
        if (this.isFocused() && !((Boolean)this.readOnly.get()).booleanValue() && this.cursorBlink < 10 && (textCursorPos = this.getPosByIndex(this.globalCursorIndex)) != null) {
            int curX = (int)((double)textCursorPos.x() - this.getScrollOffsetX() + (double)this.getLayoutContentX());
            int curY = (int)((double)(textCursorPos.y() - (float)((Integer)this.lineSpacing.get()).intValue() / 2.0f) - this.getScrollOffsetY() + (double)this.getLayoutContentY());
            int curH = (int)(textCursorPos.lineHeight() + (float)((Integer)this.lineSpacing.get()).intValue());
            graphics.graphics().m_285944_(RenderType.m_285783_(), curX, curY, curX + (Byte)this.cursorWidth.get(), curY + curH, -16776961);
        }
        GuiUtils.enableScissor(graphics, (int)renderBounds.x(), (int)renderBounds.y(), (int)renderBounds.width(), (int)renderBounds.height());
        graphics.poseStack().m_85849_();
    }

    public void renderTextRangeHighlights(DLGuiGraphics mcGraphics, List<TextRange> ranges, DLColor color) {
        if (this.getLinesOrdered().isEmpty() || ranges.isEmpty() || this.text.get() == null) {
            return;
        }
        mcGraphics.poseStack().m_85836_();
        mcGraphics.poseStack().m_252880_(0.0f, 0.0f, 0.5f);
        Map.Entry<Integer, LineMarker> lowerMarkerY = this.getLineMarkersByY().floorEntry((int)this.getScrollOffsetY());
        Map.Entry<Integer, LineMarker> upperMarkerY = this.getLineMarkersByY().ceilingEntry((int)(this.getScrollOffsetY() + (double)this.getLayoutContentHeight()));
        int minVisibleIdx = lowerMarkerY == null ? Integer.MIN_VALUE : lowerMarkerY.getValue().startIndex();
        int maxVisibleIdx = upperMarkerY == null ? Integer.MAX_VALUE : upperMarkerY.getValue().startIndex();
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        for (TextRange range : ranges) {
            int selStart = range.start();
            int selEnd = range.end();
            if (selEnd <= selStart || selEnd < minVisibleIdx || selStart > maxVisibleIdx) continue;
            Map.Entry<Integer, LineMarker> lowerMarker = this.getLineMarkers().floorEntry(selStart);
            Map.Entry<Integer, LineMarker> upperMarker = this.getLineMarkers().floorEntry(selEnd);
            if (lowerMarker == null || upperMarker == null) continue;
            int fromIdx = Math.max(lowerMarker.getValue().startIndex(), minVisibleIdx);
            int toIdx = Math.min(upperMarker.getValue().startIndex(), maxVisibleIdx);
            if (toIdx < fromIdx) continue;
            Collection markers = this.getLineMarkers().subMap(fromIdx, true, toIdx, true).values();
            for (LineMarker marker : markers) {
                TextCursorPosition posA = this.getPosByIndex(Math.max(selStart, marker.startIndex()));
                TextCursorPosition posB = this.getPosByIndex(Math.min(selEnd, marker.endIndex()));
                GuiUtils.fill(mcGraphics, (int)((double)(this.getLayoutContentX() + posA.x()) - this.getScrollOffsetX()), (int)((double)(this.getLayoutContentY() + posA.y() - (float)((Integer)this.lineSpacing.get()).intValue() / 2.0f) - this.getScrollOffsetY()), (int)(posB.x() - posA.x()), (int)posA.lineHeight() + (Integer)this.lineSpacing.get(), color);
            }
        }
        RenderSystem.disableBlend();
        mcGraphics.poseStack().m_85849_();
    }

    private void renderSelection(DLGuiGraphics mcGraphics) {
        this.renderTextRangeHighlights(mcGraphics, List.of(new TextRange(this.getSelectionStart(), this.getSelectionEnd())), this.selectionColor.get());
    }

    @Override
    public LineMarker getLineByYCoord(float y) {
        return super.getLineByYCoord((float)((double)y + this.getScrollOffsetY()));
    }

    public boolean onMouseDown2(double mouseX, double mouseY, int button) {
        if (this.isFocused() && button == 0) {
            int clickedIndex = this.getIndexByPos((float)mouseX, (float)mouseY, true);
            this.isDragging = true;
            long currentTime = Util.m_137550_();
            this.clickCount = currentTime - this.lastClickTime < 300L && Math.abs(mouseX - this.lastClickMouseX) < 2.0 && Math.abs(mouseY - this.lastClickMouseY) < 2.0 ? ++this.clickCount : 1;
            this.lastClickTime = currentTime;
            this.lastClickMouseX = mouseX;
            this.lastClickMouseY = mouseY;
            if (this.clickCount == 2) {
                this.selectWordAt(this.globalCursorIndex);
            } else if (this.clickCount >= 3) {
                this.selectLineAt(this.globalCursorIndex);
                this.clickCount = 0;
            } else {
                this.setTextCursor(clickedIndex, !Screen.m_96638_());
            }
        }
        return true;
    }

    public boolean onMultiClicked(double mouseX, double mouseY, int button, int clickCount) {
        if (this.isFocused() && button == 0) {
            int clickedIndex = this.getIndexByPos((float)mouseX, (float)mouseY, true);
            this.isDragging = true;
            long currentTime = Util.m_137550_();
            this.clickCount = currentTime - this.lastClickTime < 300L && Math.abs(mouseX - this.lastClickMouseX) < 2.0 && Math.abs(mouseY - this.lastClickMouseY) < 2.0 ? ++this.clickCount : 1;
            this.lastClickTime = currentTime;
            this.lastClickMouseX = mouseX;
            this.lastClickMouseY = mouseY;
            if (clickCount == 2) {
                this.selectWordAt(this.globalCursorIndex);
            } else if (clickCount >= 3) {
                this.selectLineAt(this.globalCursorIndex);
                clickCount = 0;
            } else {
                this.setTextCursor(clickedIndex, !Screen.m_96638_());
            }
        }
        return true;
    }

    public boolean onMouseDragged2(DLGuiComponent src, DLGuiStandardEvents.DragEvent event) {
        if (this.isFocused() && this.isDragging && event.button() == 0) {
            this.setTextCursor(this.getIndexByPos((float)event.mouseX(), (float)event.mouseY(), true), false);
        }
        return true;
    }

    public boolean onMouseUp2(DLGuiComponent src, DLGuiStandardEvents.MouseReleaseEvent event) {
        if (event.button() == 0) {
            this.isDragging = false;
        }
        return true;
    }

    public boolean onCharTyped(char codePointChar, int modifiers) {
        if (((Boolean)this.readOnly.get()).booleanValue()) {
            return false;
        }
        if (this.isFocused() && SharedConstants.m_136188_((char)codePointChar) && this.text.get() != null) {
            int cursorPosBeforeInsert = this.getGlobalCursorIndex();
            this.deleteSelection();
            cursorPosBeforeInsert = this.getGlobalCursorIndex();
            String charToInsert = SharedConstants.m_136190_((String)Character.toString(codePointChar));
            int codePointsInserted = ((RichTextComponent)this.text.get()).insert(cursorPosBeforeInsert, charToInsert, null, null);
            if (!Character.isLowSurrogate(codePointChar)) {
                this.setTextCursor(cursorPosBeforeInsert + codePointsInserted, true);
            }
            return true;
        }
        return false;
    }

    public boolean onKeyPressed(int keyCode, int scanCode, int modifiers) {
        block43: {
            boolean canModify;
            boolean shiftDown;
            block44: {
                if (!this.isFocused() || this.text.get() == null) break block43;
                boolean controlDown = Screen.m_96637_();
                shiftDown = Screen.m_96638_();
                boolean bl = canModify = (Boolean)this.readOnly.get() == false;
                if (!controlDown) break block44;
                switch (keyCode) {
                    case 257: 
                    case 335: {
                        if (canModify) {
                            if (((Boolean)this.acceptAndCancelKeysEnabled.get()).booleanValue() && !controlDown && !shiftDown) {
                                this.invokeEvent(this, new TextAcceptKeyPressedEvent());
                                break;
                            }
                            if (((Boolean)this.multiline.get()).booleanValue()) {
                                this.deleteSelection();
                                ((RichTextComponent)this.text.get()).insert(this.getGlobalCursorIndex(), "\n", null, null);
                                this.setTextCursor(this.getGlobalCursorIndex() + 1, true);
                                break;
                            }
                        }
                        break block43;
                    }
                    case 65: {
                        this.selectAll();
                        break;
                    }
                    case 67: {
                        this.copySelected();
                        break;
                    }
                    case 88: {
                        this.cutSelected();
                        break;
                    }
                    case 86: {
                        this.paste();
                        break;
                    }
                    case 259: {
                        if (canModify) {
                            if (this.hasSelection()) {
                                this.deleteSelection();
                                break;
                            }
                            if (this.getGlobalCursorIndex() > 0) {
                                String text = ((RichTextComponent)this.text.get()).getPlainText();
                                int wordStart = this.findPrevWordBoundary2(text, this.getGlobalCursorIndex(), true);
                                ((RichTextComponent)this.text.get()).remove(wordStart, this.getGlobalCursorIndex());
                                this.setTextCursor(wordStart, true);
                                break;
                            }
                        }
                        break block43;
                    }
                    case 261: {
                        if (canModify) {
                            if (this.hasSelection()) {
                                this.deleteSelection();
                                break;
                            }
                            if (this.getGlobalCursorIndex() < ((RichTextComponent)this.text.get()).length()) {
                                String text = ((RichTextComponent)this.text.get()).getPlainText();
                                int wordEnd = this.findNextWordBoundary2(text, this.getGlobalCursorIndex(), true);
                                ((RichTextComponent)this.text.get()).remove(this.getGlobalCursorIndex(), wordEnd);
                                this.setTextCursor(this.getGlobalCursorIndex(), true);
                                break;
                            }
                        }
                        break block43;
                    }
                    case 263: {
                        if (this.getGlobalCursorIndex() > 0) {
                            this.setTextCursor(this.findPrevWordBoundary2(((RichTextComponent)this.text.get()).getPlainText(), this.getGlobalCursorIndex(), true), !shiftDown);
                            break;
                        }
                        break block43;
                    }
                    case 262: {
                        if (this.getGlobalCursorIndex() < ((RichTextComponent)this.text.get()).length()) {
                            this.setTextCursor(this.findNextWordBoundary2(((RichTextComponent)this.text.get()).getPlainText(), this.getGlobalCursorIndex(), true), !shiftDown);
                            break;
                        }
                        break block43;
                    }
                    case 265: {
                        this.moveCursorToPreviousParagraphStart(shiftDown);
                        break;
                    }
                    case 264: {
                        this.moveCursorToNextParagraphStart(shiftDown);
                        break;
                    }
                    case 268: {
                        this.setTextCursor(0, !shiftDown);
                        break;
                    }
                    case 269: {
                        this.setTextCursor(((RichTextComponent)this.text.get()).length(), !shiftDown);
                        break;
                    }
                }
                break block43;
            }
            switch (keyCode) {
                case 256: {
                    if (!canModify || !((Boolean)this.acceptAndCancelKeysEnabled.get()).booleanValue()) break;
                    this.invokeEvent(this, new TextCancelKeyPressedEvent());
                    break;
                }
                case 257: 
                case 335: {
                    if (!canModify) break;
                    if (((Boolean)this.acceptAndCancelKeysEnabled.get()).booleanValue() && !shiftDown) {
                        this.invokeEvent(this, new TextAcceptKeyPressedEvent());
                        break;
                    }
                    if (!((Boolean)this.multiline.get()).booleanValue()) break;
                    this.deleteSelection();
                    ((RichTextComponent)this.text.get()).insert(this.getGlobalCursorIndex(), "\n", null, null);
                    this.setTextCursor(this.getGlobalCursorIndex() + 1, true);
                    break;
                }
                case 259: {
                    if (!canModify) break;
                    if (this.hasSelection()) {
                        this.deleteSelection();
                        break;
                    }
                    if (this.getGlobalCursorIndex() <= 0) break;
                    int newCursorPos = this.getGlobalCursorIndex() - 1;
                    ((RichTextComponent)this.text.get()).remove(this.getGlobalCursorIndex() - 1, this.getGlobalCursorIndex());
                    this.setTextCursor(newCursorPos, true);
                    break;
                }
                case 261: {
                    if (!canModify) break;
                    if (this.hasSelection()) {
                        this.deleteSelection();
                        break;
                    }
                    if (this.getGlobalCursorIndex() >= ((RichTextComponent)this.text.get()).length()) break;
                    ((RichTextComponent)this.text.get()).remove(this.getGlobalCursorIndex(), this.getGlobalCursorIndex() + 1);
                    this.setTextCursor(this.getGlobalCursorIndex(), true);
                    break;
                }
                case 263: {
                    if (this.getGlobalCursorIndex() <= 0) break;
                    this.setTextCursor(this.getGlobalCursorIndex() - 1, !shiftDown);
                    break;
                }
                case 262: {
                    if (this.getGlobalCursorIndex() >= ((RichTextComponent)this.text.get()).length()) break;
                    this.setTextCursor(this.getGlobalCursorIndex() + 1, !shiftDown);
                    break;
                }
                case 265: {
                    TextCursorPosition textCursorPosUp = this.getPosByIndex(this.getGlobalCursorIndex());
                    LineMarker currentLineUp = this.getLineAt(this.getGlobalCursorIndex());
                    int lineIndexUp = this.getLinesOrdered().indexOf(currentLineUp);
                    if (lineIndexUp > 0) {
                        LineMarker prevLine = this.getLineByLineIndex(lineIndexUp - 1);
                        float targetComponentLocalX = (float)((double)((float)this.x() + this.getLayoutContentX() + textCursorPosUp.x()) - this.getScrollOffsetX() - (double)this.x());
                        float targetComponentLocalY = (float)((double)((float)this.y() + this.getLayoutContentY() + prevLine.y() + prevLine.lineHeight() / 2.0f) - this.getScrollOffsetY() - (double)this.y());
                        this.setTextCursor(this.getIndexByPos(targetComponentLocalX, targetComponentLocalY, true), !shiftDown);
                        break;
                    }
                    this.setTextCursor(0, !shiftDown);
                    break;
                }
                case 264: {
                    TextCursorPosition textCursorPosDown = this.getPosByIndex(this.getGlobalCursorIndex());
                    LineMarker currentLineDown = this.getLineAt(this.getGlobalCursorIndex());
                    int lineIndexDown = this.getLinesOrdered().indexOf(currentLineDown);
                    if (lineIndexDown < this.getLinesOrdered().size() - 1) {
                        LineMarker nextLine = this.getLineByLineIndex(lineIndexDown + 1);
                        float targetComponentLocalX = (float)((double)((float)this.x() + this.getLayoutContentX() + textCursorPosDown.x()) - this.getScrollOffsetX() - (double)this.x());
                        float targetComponentLocalY = (float)((double)((float)this.y() + this.getLayoutContentY() + nextLine.y() + nextLine.lineHeight() / 2.0f) - this.getScrollOffsetY() - (double)this.y());
                        this.setTextCursor(this.getIndexByPos(targetComponentLocalX, targetComponentLocalY, true), !shiftDown);
                        break;
                    }
                    this.setTextCursor(((RichTextComponent)this.text.get()).length(), !shiftDown);
                    break;
                }
                case 268: {
                    LineMarker currentLineHome = this.getLineAt(this.getGlobalCursorIndex());
                    this.setTextCursor(currentLineHome.startIndex(), !shiftDown);
                    break;
                }
                case 269: {
                    LineMarker currentLineEnd = this.getLineAt(this.getGlobalCursorIndex());
                    this.setTextCursor(currentLineEnd.endIndex(), !shiftDown);
                    break;
                }
            }
        }
        return true;
    }

    public void setTextCursor(int index, boolean clearAnchor) {
        if (this.text.get() == null) {
            return;
        }
        this.globalCursorIndex = MathUtils.clamp(index, 0, ((RichTextComponent)this.text.get()).length());
        this.selectionAnchorIndex = clearAnchor ? this.globalCursorIndex : MathUtils.clamp(this.selectionAnchorIndex, 0, ((RichTextComponent)this.text.get()).length());
        TextCursorPosition textCursorPosition = this.getPosByIndex(this.globalCursorIndex);
        if (((Boolean)this.multiline.get()).booleanValue()) {
            float y = (float)this.getScrollOffsetY();
            if ((double)(textCursorPosition.y() - 5.0f) < this.getScrollOffsetY()) {
                y = textCursorPosition.y() - 5.0f;
            } else if ((double)(textCursorPosition.y() + 5.0f + textCursorPosition.lineHeight() + (float)((Integer)this.lineSpacing.get()).intValue()) > this.getScrollOffsetY() + (double)this.getLayoutContentHeight()) {
                y = textCursorPosition.y() - this.getLayoutContentHeight() + textCursorPosition.lineHeight() + (float)((Integer)this.lineSpacing.get()).intValue() + 5.0f;
            }
            if (this.getScrollOffsetY() != (double)y) {
                this.setScrollOffsetY(MathUtils.clamp(y, 0.0f, this.getMaxScrollY()));
            }
        }
        float x = (float)this.getScrollOffsetX();
        if ((double)(textCursorPosition.x() - (float)this.getCursorXOffsetWrapper()) < this.getScrollOffsetX()) {
            x = textCursorPosition.x() - (float)this.getCursorXOffsetWrapper();
        } else if ((double)(textCursorPosition.x() + (float)((Byte)this.cursorWidth.get()).byteValue() + (float)this.getCursorXOffsetWrapper()) > this.getScrollOffsetX() + (double)this.getLayoutContentWidth()) {
            x = textCursorPosition.x() - this.getLayoutContentWidth() + (float)((Byte)this.cursorWidth.get()).byteValue() + (float)this.getCursorXOffsetWrapper();
        }
        if (this.getScrollOffsetX() != (double)x) {
            this.setScrollOffsetX(MathUtils.clamp(x, 0.0f, this.getMaxScrollX()));
        }
        this.cursorBlink = 0;
    }

    private int findPrevWordBoundary2(String text, int startIndex, boolean includeWhitespaces) {
        if (startIndex <= 1) {
            return 0;
        }
        int idx = startIndex;
        int c = text.codePointAt(text.offsetByCodePoints(0, idx - 1));
        boolean whitespace = Character.isWhitespace(c);
        boolean initialIsWhitespace = whitespace;
        for (boolean stopAtWhitespace = false; !(Character.isWhitespace(c) && stopAtWhitespace || !includeWhitespaces && whitespace != initialIsWhitespace || --idx <= 0); stopAtWhitespace |= !Character.isWhitespace(c)) {
            c = text.codePointAt(text.offsetByCodePoints(0, idx - 1));
            whitespace = Character.isWhitespace(c);
        }
        return idx;
    }

    private int findNextWordBoundary2(String text, int startIndex, boolean includeWhitespaces) {
        int cpLength = text.codePointCount(0, text.length());
        if (startIndex >= cpLength - 1) {
            return cpLength;
        }
        int idx = startIndex;
        int c = text.codePointAt(text.offsetByCodePoints(0, idx));
        boolean whitespace = Character.isWhitespace(c);
        boolean initialIsWhitespace = whitespace;
        for (boolean stopAtNonWhitespace = false; !(!Character.isWhitespace(c) && stopAtNonWhitespace || !includeWhitespaces && whitespace != initialIsWhitespace || ++idx >= cpLength); stopAtNonWhitespace |= Character.isWhitespace(c)) {
            c = text.codePointAt(text.offsetByCodePoints(0, idx));
            whitespace = Character.isWhitespace(c);
        }
        return idx;
    }

    public void selectWordAt(int index) {
        int a = this.findPrevWordBoundary2(((RichTextComponent)this.text.get()).getPlainText(), index, false);
        int b = this.findNextWordBoundary2(((RichTextComponent)this.text.get()).getPlainText(), index, false);
        this.select(Math.min(a, b), Math.max(a, b));
    }

    public void selectLineAt(int index) {
        if (this.text.get() == null) {
            return;
        }
        LineMarker line = this.getLineAt(index);
        this.select(line.startIndex(), line.endIndex());
    }

    public void selectAll() {
        if (this.text.get() == null) {
            return;
        }
        this.select(0, ((RichTextComponent)this.text.get()).length());
    }

    public void cutSelected() {
        if (!((Boolean)this.readOnly.get()).booleanValue() && this.hasSelection()) {
            this.setClipboard(this.getSelectedText());
            this.deleteSelection();
        }
    }

    public void copySelected() {
        if (this.hasSelection()) {
            this.setClipboard(this.getSelectedText());
        }
    }

    public void paste() {
        if (!((Boolean)this.readOnly.get()).booleanValue()) {
            this.deleteSelection();
            String clipboardText = this.getClipboard();
            if (!clipboardText.isEmpty()) {
                String filteredText = SharedConstants.m_136190_((String)clipboardText);
                boolean validUrl = DLUtils.isValidURL(clipboardText);
                int insertIndex = this.getGlobalCursorIndex();
                int insertedCodePoints = ((RichTextComponent)this.text.get()).insert(insertIndex, filteredText, validUrl ? TextStyle.URL_STYLE : null, null);
                if (validUrl) {
                    ((RichTextComponent)this.text.get()).createInteractiveElement(insertIndex, insertIndex + insertedCodePoints).ifPresent(x -> x.withAction(new InteractiveElement.ClickAction("open_url", clipboardText)));
                }
                this.setTextCursor(this.getGlobalCursorIndex() + insertedCodePoints, true);
            }
        }
    }

    public void select(int start, int end) {
        if (this.text.get() == null) {
            return;
        }
        this.selectionAnchorIndex = MathUtils.clamp(start, 0, ((RichTextComponent)this.text.get()).length());
        this.setTextCursor(MathUtils.clamp(end, 0, ((RichTextComponent)this.text.get()).length()), false);
    }

    public void deselect() {
        this.setTextCursor(this.globalCursorIndex, true);
    }

    public void selectParagraphAt(int codePointIndex) {
        if (this.text.get() == null || ((RichTextComponent)this.text.get()).getPlainText().isEmpty()) {
            this.selectionAnchorIndex = 0;
            this.globalCursorIndex = 0;
            return;
        }
        String text = ((RichTextComponent)this.text.get()).getPlainText();
        int textCpLength = ((RichTextComponent)this.text.get()).length();
        int targetCpIndex = Math.max(0, Math.min(codePointIndex, textCpLength));
        int paraStartCp = 0;
        if (targetCpIndex > 0) {
            int charIdxBefore;
            boolean currentIsParaStart;
            boolean bl = currentIsParaStart = targetCpIndex == 0;
            if (!currentIsParaStart && targetCpIndex > 0 && targetCpIndex <= textCpLength && (charIdxBefore = ((RichTextComponent)this.text.get()).toCharIndex(text, targetCpIndex - 1)) < text.length() && text.codePointAt(charIdxBefore) == 10) {
                currentIsParaStart = true;
            }
            if (currentIsParaStart) {
                paraStartCp = targetCpIndex;
            } else {
                int searchEndCharIndexForStart = ((RichTextComponent)this.text.get()).toCharIndex(text, targetCpIndex);
                int prevNewlineCharIdx = -1;
                if (searchEndCharIndexForStart > 0) {
                    prevNewlineCharIdx = text.substring(0, searchEndCharIndexForStart).lastIndexOf(10);
                }
                paraStartCp = prevNewlineCharIdx != -1 ? text.codePointCount(0, prevNewlineCharIdx + 1) : 0;
            }
        }
        int paraEndCp = textCpLength;
        int searchStartCharIdxForEnd = ((RichTextComponent)this.text.get()).toCharIndex(text, paraStartCp);
        int nextNewlineCharIdx = text.indexOf(10, searchStartCharIdxForEnd);
        if (nextNewlineCharIdx != -1) {
            paraEndCp = text.codePointCount(0, nextNewlineCharIdx);
        }
        this.selectionAnchorIndex = paraStartCp;
        this.globalCursorIndex = paraEndCp;
    }

    private void moveCursorToPreviousParagraphStart(boolean select) {
        if (this.text.get() == null) {
            return;
        }
        String text = ((RichTextComponent)this.text.get()).getPlainText();
        if (text.isEmpty()) {
            this.globalCursorIndex = 0;
        } else {
            int currentCPI = this.globalCursorIndex;
            if (currentCPI != 0) {
                int charBeforeCursorIdx;
                int searchBeforeCPI = currentCPI;
                if (currentCPI > 0 && (charBeforeCursorIdx = ((RichTextComponent)this.text.get()).toCharIndex(text, currentCPI - 1)) < text.length() && text.codePointAt(charBeforeCursorIdx) == 10) {
                    searchBeforeCPI = currentCPI - 1;
                }
                if (searchBeforeCPI <= 0) {
                    this.globalCursorIndex = 0;
                } else {
                    int searchEndCharIndex = ((RichTextComponent)this.text.get()).toCharIndex(text, searchBeforeCPI);
                    int lastNewlineCharIndex = -1;
                    if (searchEndCharIndex > 0) {
                        lastNewlineCharIndex = text.substring(0, searchEndCharIndex).lastIndexOf(10);
                    }
                    this.globalCursorIndex = lastNewlineCharIndex != -1 ? text.codePointCount(0, lastNewlineCharIndex + 1) : 0;
                }
            }
        }
        if (!select) {
            this.selectionAnchorIndex = this.globalCursorIndex;
        }
    }

    private void moveCursorToNextParagraphStart(boolean select) {
        if (this.text.get() == null) {
            return;
        }
        String text = ((RichTextComponent)this.text.get()).getPlainText();
        int textCpLength = ((RichTextComponent)this.text.get()).length();
        if (text.isEmpty() || this.globalCursorIndex >= textCpLength) {
            this.globalCursorIndex = textCpLength;
        } else {
            int searchStartCharIndex = ((RichTextComponent)this.text.get()).toCharIndex(text, this.globalCursorIndex);
            int nextNewlineCharIndex = text.indexOf(10, searchStartCharIndex);
            if (nextNewlineCharIndex != -1) {
                this.globalCursorIndex = text.codePointCount(0, nextNewlineCharIndex + 1);
                this.globalCursorIndex = Math.min(this.globalCursorIndex, textCpLength);
            } else {
                this.globalCursorIndex = textCpLength;
            }
        }
        if (!select) {
            this.selectionAnchorIndex = this.globalCursorIndex;
        }
    }

    public record TextRange(int start, int end) {
    }

    public record TextAcceptKeyPressedEvent() implements IEvent
    {
    }

    public record TextCancelKeyPressedEvent() implements IEvent
    {
    }

    public record TextReadOnlyChangedEvent(boolean readOnly) implements IEvent
    {
    }

    public static enum LineNumberDisplayMode {
        NONE,
        LINE,
        PARAGRAPH;

    }
}

