/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.mcdragonlib.client.gui.widgets.richtext;

import com.google.common.collect.Maps;
import de.mrjulsen.mcdragonlib.client.gui.widgets.richtext.LineMarker;
import de.mrjulsen.mcdragonlib.client.gui.widgets.richtext.LineSplitter;
import de.mrjulsen.mcdragonlib.client.gui.widgets.richtext.TextSegment;
import de.mrjulsen.mcdragonlib.client.gui.widgets.richtext.TextStyle;
import de.mrjulsen.mcdragonlib.client.gui.widgets.richtext.WidthProvider;
import de.mrjulsen.mcdragonlib.client.gui.widgets.richtext.action.InteractiveElement;
import de.mrjulsen.mcdragonlib.data.ETextAlignment;
import de.mrjulsen.mcdragonlib.mixin.FontAccessor;
import de.mrjulsen.mcdragonlib.util.Cache;
import de.mrjulsen.mcdragonlib.util.DLUtils;
import de.mrjulsen.mcdragonlib.util.TextUtils;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.TreeMap;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import org.apache.commons.lang3.mutable.MutableFloat;
import org.apache.commons.lang3.mutable.MutableInt;

public class RichTextComponent {
    private static final WidthProvider widthProvider = (style, characterCodePoint) -> {
        FontAccessor accessor = (FontAccessor)style.font();
        return accessor.dragonlib$invokeGetFontSet(Style.f_131100_).m_243128_(characterCodePoint, accessor.dragonlib$filterFishyGlyphs()).m_83827_(style.bold()) * style.scale();
    };
    private final Cache<Float> textWidthCache = new Cache<Float>(() -> Float.valueOf(this.calcWidthOfSection(0, this.length())));
    private final Cache<Integer> textLengthCache = new Cache<Integer>(() -> {
        int i = 0;
        for (TextSegment segment : this.getSegmentsRaw()) {
            i += segment.codePointLength();
        }
        return i;
    });
    private final Cache<String> plainTextCache = new Cache<String>(() -> {
        StringBuilder sb = new StringBuilder();
        for (TextSegment seg : this.getSegmentsRaw()) {
            sb.append((CharSequence)seg.stringBuilder());
        }
        return sb.toString();
    });
    private static final String NBT_SEGMENTS = "segments";
    private static final String NBT_ALIGNMENTS = "alignments";
    private static final String NBT_INTERACTIVE_ELEMENTS = "actions";
    private static final ETextAlignment DEFAULT_ALIGNMENT = ETextAlignment.LEFT;
    public static final TextStyle DEFAULT_LINK_STYLE = new TextStyle.Builder().underlined(true).color(-11184641).build();
    public static final ITextValidator DEFAULT_TEXT_VALIDATOR = (current, newText, input) -> input;
    private final List<TextSegment> segments = new LinkedList<TextSegment>();
    private final TreeMap<Integer, ETextAlignment> paragraphAlignments = new TreeMap();
    private final List<InteractiveElement> interactiveElements = new LinkedList<InteractiveElement>();
    private boolean multiline = false;
    private int maxCharacters = 1000000;
    private Pattern filterRegex = Pattern.compile("(?s).*");
    private ITextValidator textValidator = DEFAULT_TEXT_VALIDATOR;
    private Runnable onTextChanged;

    public RichTextComponent() {
        this.paragraphAlignments.put(0, DEFAULT_ALIGNMENT);
    }

    public void setTextChangedCallback(Runnable callback) {
        this.onTextChanged = callback;
    }

    public boolean isMultiline() {
        return this.multiline;
    }

    public void setMultiline(boolean multiline) {
        this.multiline = multiline;
    }

    public int getMaxCharacters() {
        return this.maxCharacters;
    }

    public void setMaxCharacters(int maxCharacters) {
        this.maxCharacters = maxCharacters;
    }

    public Pattern getFilterRegex() {
        return this.filterRegex;
    }

    public void setFilterRegex(String regex) throws PatternSyntaxException {
        this.filterRegex = Pattern.compile(regex);
    }

    public ITextValidator getTextValidator() {
        return this.textValidator;
    }

    public void setTextValidator(ITextValidator textValidator) {
        this.textValidator = textValidator;
    }

    public Component toComponent() {
        MutableComponent component = TextUtils.empty();
        for (TextSegment segment : this.getSegmentsRaw()) {
            component.m_7220_(segment.toComponent());
        }
        return component;
    }

    int toCharIndex(CharSequence cs, int codePointIndex) {
        String str;
        if (cs == null) {
            throw new NullPointerException("CharSequence cannot be null");
        }
        String string = str = cs instanceof String ? (String)cs : cs.toString();
        if (codePointIndex < 0) {
            throw new StringIndexOutOfBoundsException("Code point index cannot be negative: " + codePointIndex);
        }
        int cpCount = str.codePointCount(0, str.length());
        if (codePointIndex > cpCount) {
            throw new StringIndexOutOfBoundsException("Code point index: " + codePointIndex + ", Total code points: " + cpCount);
        }
        if (codePointIndex == cpCount) {
            return str.length();
        }
        return str.offsetByCodePoints(0, codePointIndex);
    }

    private int toCharIndex(StringBuilder sb, int codePointIndex) {
        if (sb == null) {
            throw new NullPointerException("StringBuilder cannot be null");
        }
        return this.toCharIndex(sb.toString(), codePointIndex);
    }

    private void checkIndex(int index) {
        int len = this.length();
        if (index < 0 || index > len) {
            throw new IndexOutOfBoundsException("Index: " + index + ", CodePointLength: " + len);
        }
    }

    private void checkRange(int start, int end) {
        this.checkIndex(start);
        this.checkIndex(end);
        if (start > end) {
            throw new IndexOutOfBoundsException("Start code point index (" + start + ") > end code point index (" + end + ")");
        }
    }

    public TextStyle getStyleAt(int index) {
        this.checkIndex(index);
        if (this.segments.isEmpty()) {
            return TextStyle.EMPTY;
        }
        if (index == this.length()) {
            TextSegment lastSegment = this.segments.get(this.segments.size() - 1);
            if (lastSegment.isEmpty() && this.segments.size() > 1) {
                return this.segments.get(this.segments.size() - 2).style();
            }
            return lastSegment.style();
        }
        int currentCodePointPos = 0;
        for (TextSegment segment : this.segments) {
            int segCodePointLen = segment.length();
            if (index >= currentCodePointPos && index < currentCodePointPos + segCodePointLen) {
                return segment.style();
            }
            currentCodePointPos += segCodePointLen;
        }
        return TextStyle.EMPTY;
    }

    public TextSegmentResult getSegmentAt(int index) {
        this.checkIndex(index);
        List<TextSegment> segments = this.getSegmentsRaw();
        if (segments == null || segments.isEmpty()) {
            return new TextSegmentResult(-1, -1, null);
        }
        if (index >= this.length() - 1) {
            TextSegment segment = segments.get(segments.size() - 1);
            return new TextSegmentResult(segments.size() - 1, this.length() - segment.length(), segment);
        }
        int segIdx = 0;
        int txtIdx = 0;
        for (TextSegment segment : segments) {
            if (txtIdx + segment.length() > index) {
                return new TextSegmentResult(segIdx, txtIdx, segment);
            }
            txtIdx += segment.length();
            ++segIdx;
        }
        return new TextSegmentResult(-1, -1, null);
    }

    public String filterText(String rawText) {
        int avLength;
        String filteredText = rawText;
        if (!this.multiline) {
            filteredText = filteredText.replace("\n", "").replace("\r", "");
        }
        if ((avLength = this.maxCharacters - this.length()) <= 0) {
            return "";
        }
        filteredText = filteredText.substring(0, Math.min(avLength, filteredText.length()));
        return filteredText;
    }

    private String validateText(String current, String future, String input) {
        if (!this.filterRegex.matcher(future).matches()) {
            return null;
        }
        return this.textValidator.validate(current, future, input);
    }

    public int set(String text) {
        return this.set(text, null, null);
    }

    public int set(String text, TextStyle style) {
        return this.set(text, style, null);
    }

    public int set(String text, TextStyle style, ETextAlignment alignment) {
        this.clear();
        return this.insert(this.length(), text, style, alignment);
    }

    public int append(String text) {
        return this.append(text, null, null);
    }

    public int append(String text, TextStyle style) {
        return this.append(text, style, null);
    }

    public int append(String text, TextStyle style, ETextAlignment alignment) {
        return this.insert(this.length(), text, style, alignment);
    }

    public int insert(int index, String text) {
        return this.insert(index, text, null, null);
    }

    public int insert(int index, String text, TextStyle style) {
        return this.insert(index, text, style, null);
    }

    public int insert(int index, String text, TextStyle style, ETextAlignment alignment) {
        int prevCharIdx;
        ETextAlignment currentAlignment;
        this.checkIndex(index);
        if (text == null || text.isEmpty()) {
            return 0;
        }
        Object filteredText = this.filterText(text);
        if (((String)filteredText).isEmpty()) {
            return 0;
        }
        TextStyle actualStyle = style;
        actualStyle = actualStyle == null ? this.getStyleAt(index) : style.copy();
        String plainTextBeforeInsert = this.getPlainText();
        if (alignment != null && alignment != (currentAlignment = this.getParagraphAlignment(index)) && index > 0 && (prevCharIdx = this.toCharIndex(plainTextBeforeInsert, index - 1)) < plainTextBeforeInsert.length() && plainTextBeforeInsert.codePointAt(prevCharIdx) != 10) {
            filteredText = "\n" + (String)filteredText;
        }
        return this.insertInternal(index, (String)filteredText, actualStyle, alignment, true);
    }

    private int insertInternal(int codePointInsertIndex, String textToInsert, TextStyle style, ETextAlignment alignment, boolean performUpdate) {
        int insertedCpLength;
        StringBuilder futureText = new StringBuilder(this.getPlainText());
        futureText.insert(codePointInsertIndex, textToInsert);
        textToInsert = this.validateText(this.getPlainText(), futureText.toString(), textToInsert);
        if (textToInsert == null) {
            return 0;
        }
        if (this.segments.isEmpty()) {
            this.segments.add(new TextSegment(new StringBuilder(textToInsert), style));
            this.updateAlignmentsOnInsert(codePointInsertIndex, textToInsert);
            if (alignment != null) {
                this.setParagraphAlignment(codePointInsertIndex, alignment, false);
            }
        } else {
            int currentCodePointPos = 0;
            ListIterator<TextSegment> iterator = this.segments.listIterator();
            boolean inserted = false;
            while (iterator.hasNext()) {
                TextSegment currentSegment = iterator.next();
                int segCodePointLen = currentSegment.length();
                if (codePointInsertIndex >= currentCodePointPos && codePointInsertIndex <= currentCodePointPos + segCodePointLen) {
                    int codePointOffsetInSegment = codePointInsertIndex - currentCodePointPos;
                    int charOffsetInSegment = this.toCharIndex(currentSegment.stringBuilder(), codePointOffsetInSegment);
                    if (codePointOffsetInSegment == 0) {
                        TextSegment prevOfCurrent;
                        if (iterator.previousIndex() > 0 && (prevOfCurrent = this.segments.get(iterator.previousIndex() - 1)).style().equals(style)) {
                            prevOfCurrent.stringBuilder().append(textToInsert);
                            inserted = true;
                            break;
                        }
                        iterator.previous();
                        iterator.add(new TextSegment(new StringBuilder(textToInsert), style));
                    } else if (codePointOffsetInSegment == segCodePointLen) {
                        if (currentSegment.style().equals(style)) {
                            currentSegment.stringBuilder().append(textToInsert);
                        } else {
                            iterator.add(new TextSegment(new StringBuilder(textToInsert), style));
                        }
                    } else {
                        String beforeText = currentSegment.stringBuilder().substring(0, charOffsetInSegment);
                        String afterText = currentSegment.stringBuilder().substring(charOffsetInSegment);
                        currentSegment.stringBuilder().setLength(0);
                        currentSegment.stringBuilder().append(beforeText);
                        iterator.add(new TextSegment(new StringBuilder(textToInsert), style));
                        iterator.add(new TextSegment(new StringBuilder(afterText), currentSegment.style().copy()));
                    }
                    inserted = true;
                    break;
                }
                currentCodePointPos += segCodePointLen;
            }
            if (!inserted) {
                if (codePointInsertIndex == this.length() && !this.segments.isEmpty()) {
                    TextSegment lastSegment = this.segments.get(this.segments.size() - 1);
                    if (lastSegment.style().equals(style) && !lastSegment.isEmpty()) {
                        lastSegment.stringBuilder().append(textToInsert);
                    } else {
                        this.segments.add(new TextSegment(new StringBuilder(textToInsert), style));
                    }
                } else {
                    this.segments.add(new TextSegment(new StringBuilder(textToInsert), style));
                }
            }
            this.updateAlignmentsOnInsert(codePointInsertIndex, textToInsert);
            if (alignment != null) {
                this.setParagraphAlignment(codePointInsertIndex, alignment, false);
            }
        }
        if ((insertedCpLength = this.getFullCodepointCount(textToInsert)) > 0) {
            for (InteractiveElement el : this.interactiveElements) {
                if (el.start >= codePointInsertIndex) {
                    el.start += insertedCpLength;
                }
                if (el.end >= codePointInsertIndex && el.start < codePointInsertIndex) {
                    el.end += insertedCpLength;
                    continue;
                }
                if (el.end < codePointInsertIndex) continue;
                el.end += insertedCpLength;
            }
        }
        if (performUpdate) {
            this.mergeAndUpdate();
        }
        return textToInsert.codePointCount(0, textToInsert.length());
    }

    private int getFullCodepointCount(String text) {
        int cpc = 0;
        for (char c : text.toCharArray()) {
            if (Character.isLowSurrogate(c)) continue;
            ++cpc;
        }
        return cpc;
    }

    public void clear() {
        this.remove(0, this.length());
    }

    public RichTextComponent remove(int startCp, int endCp) {
        this.checkRange(startCp, endCp);
        if (startCp == endCp) {
            return this;
        }
        String plainTextBeforeRemove = this.getPlainText();
        String removedTextContent = "";
        if (startCp < endCp && endCp <= plainTextBeforeRemove.codePointCount(0, plainTextBeforeRemove.length())) {
            int charStartForRemoval = this.toCharIndex(plainTextBeforeRemove, startCp);
            int charEndForRemoval = this.toCharIndex(plainTextBeforeRemove, endCp);
            removedTextContent = plainTextBeforeRemove.substring(charStartForRemoval, charEndForRemoval);
        }
        LinkedList<TextSegment> newSegments = new LinkedList<TextSegment>();
        int currentCodePointIndex = 0;
        for (TextSegment segment : this.segments) {
            int segmentStartCodePoint = currentCodePointIndex;
            int segmentEndCodePoint = currentCodePointIndex + segment.length();
            if (segmentEndCodePoint <= startCp || segmentStartCodePoint >= endCp) {
                newSegments.add(segment);
            } else {
                if (segmentStartCodePoint < startCp) {
                    int charCountBefore = this.toCharIndex(segment.stringBuilder(), startCp - segmentStartCodePoint);
                    newSegments.add(new TextSegment(new StringBuilder(segment.stringBuilder().substring(0, charCountBefore)), segment.style().copy()));
                }
                if (segmentEndCodePoint > endCp) {
                    int codePointsInSegmentToRemoveUpToEndCp = endCp - segmentStartCodePoint;
                    int charCountAfter = this.toCharIndex(segment.stringBuilder(), codePointsInSegmentToRemoveUpToEndCp);
                    newSegments.add(new TextSegment(new StringBuilder(segment.stringBuilder().substring(charCountAfter)), segment.style().copy()));
                }
            }
            currentCodePointIndex = segmentEndCodePoint;
        }
        this.segments.clear();
        this.segments.addAll(newSegments);
        this.updateAlignmentsOnRemove(startCp, endCp, removedTextContent);
        int lengthRemoved = endCp - startCp;
        if (lengthRemoved > 0) {
            ListIterator<InteractiveElement> iter = this.interactiveElements.listIterator();
            while (iter.hasNext()) {
                InteractiveElement el = iter.next();
                if (el.end <= startCp) continue;
                if (el.start >= endCp) {
                    el.start -= lengthRemoved;
                    el.end -= lengthRemoved;
                    continue;
                }
                int oldStart = el.start;
                int oldEnd = el.end;
                if (el.start >= startCp && el.start < endCp) {
                    el.start = startCp;
                }
                if (el.end > startCp && el.end <= endCp) {
                    el.end = startCp;
                }
                if (oldStart < startCp && oldEnd > startCp) {
                    el.end = oldEnd > endCp ? (el.end -= lengthRemoved) : startCp;
                } else if (oldStart >= startCp && oldStart < endCp && oldEnd > endCp) {
                    el.start = startCp;
                    el.end -= lengthRemoved;
                }
                if (el.start < el.end) continue;
                iter.remove();
            }
        }
        this.mergeAndUpdate();
        return this;
    }

    public RichTextComponent replace(int start, int end, String text) {
        return this.replace(start, end, text, null, null);
    }

    public RichTextComponent replace(int start, int end, String text, TextStyle style) {
        return this.replace(start, end, text, style, null);
    }

    public RichTextComponent replace(int start, int end, String text, TextStyle style, ETextAlignment alignment) {
        TextStyle actualStyle;
        String replacementText;
        this.checkRange(start, end);
        String string = replacementText = text == null ? "" : text;
        if (!this.multiline) {
            replacementText = replacementText.replace("\n", "").replace("\r", "");
        }
        actualStyle = (actualStyle = style) == null ? this.getStyleAt(start) : style.copy();
        this.remove(start, end);
        this.insertInternal(start, replacementText, actualStyle, alignment, false);
        if (alignment != null && !replacementText.isEmpty()) {
            this.setParagraphAlignment(start, alignment, false);
        }
        this.mergeAndUpdate();
        return this;
    }

    public RichTextComponent replace(String searchText, String replacementText) {
        return this.replace(searchText, replacementText, null, null);
    }

    public RichTextComponent replace(String searchText, String replacementText, TextStyle style) {
        return this.replace(searchText, replacementText, style, null);
    }

    public RichTextComponent replace(String searchText, String replacementText, TextStyle style, ETextAlignment alignment) {
        int foundCharIndex;
        int replacementTextCodePointLength;
        if (searchText == null || searchText.isEmpty()) {
            return this;
        }
        String currentPlainText = this.getPlainText();
        int currentSearchCharIndex = 0;
        int searchTextCharLength = searchText.length();
        int n = replacementTextCodePointLength = replacementText != null ? replacementText.codePointCount(0, replacementText.length()) : 0;
        while ((foundCharIndex = currentPlainText.indexOf(searchText, currentSearchCharIndex)) != -1) {
            int foundCodePointIndex = currentPlainText.codePointCount(0, foundCharIndex);
            int searchTextCodePointLength = searchText.codePointCount(0, searchTextCharLength);
            this.replace(foundCodePointIndex, foundCodePointIndex + searchTextCodePointLength, replacementText, style, alignment);
            currentPlainText = this.getPlainText();
            if (replacementTextCodePointLength == 0 && searchTextCodePointLength == 0) {
                currentSearchCharIndex = foundCharIndex + 1;
                if (currentSearchCharIndex > currentPlainText.length()) {
                    break;
                }
            } else {
                currentSearchCharIndex = this.toCharIndex(currentPlainText, foundCodePointIndex + replacementTextCodePointLength);
            }
            if (currentSearchCharIndex <= currentPlainText.length()) continue;
            break;
        }
        return this;
    }

    private void updateAlignmentsOnInsert(int index, String insertedText) {
        if (insertedText == null || insertedText.isEmpty()) {
            return;
        }
        int cpl = this.getFullCodepointCount(insertedText);
        TreeMap<Integer, ETextAlignment> newAlignments = new TreeMap<Integer, ETextAlignment>();
        for (Map.Entry<Integer, ETextAlignment> entry : this.paragraphAlignments.entrySet()) {
            int oldKey = entry.getKey();
            ETextAlignment value = entry.getValue();
            if (oldKey < index) {
                newAlignments.put(oldKey, value);
                continue;
            }
            newAlignments.put(oldKey + cpl, value);
        }
        this.paragraphAlignments.clear();
        this.paragraphAlignments.putAll(newAlignments);
        ETextAlignment alignmentForNewParagraphs = this.getParagraphAlignment(index > 0 ? index - 1 : 0);
        int charIdx = 0;
        for (int cpIdx = 0; cpIdx < cpl; ++cpIdx) {
            int codePoint = insertedText.codePointAt(charIdx);
            if (codePoint == 10) {
                int newParagraphStartIndex = index + cpIdx + 1;
                this.paragraphAlignments.put(newParagraphStartIndex, alignmentForNewParagraphs);
            }
            charIdx += Character.charCount(codePoint);
        }
        if (!this.paragraphAlignments.containsKey(0)) {
            this.paragraphAlignments.put(0, DEFAULT_ALIGNMENT);
        }
    }

    private void updateAlignmentsOnRemove(int start, int end, String removedText) {
        if (start == end) {
            return;
        }
        int removedCodePointLength = end - start;
        TreeMap<Integer, ETextAlignment> newAlignments = new TreeMap<Integer, ETextAlignment>();
        ETextAlignment alignmentBeforeRemovalStart = this.getParagraphAlignment(start > 0 ? start - 1 : 0);
        for (Map.Entry<Integer, ETextAlignment> entry : this.paragraphAlignments.entrySet()) {
            int oldKey = entry.getKey();
            ETextAlignment value = entry.getValue();
            if (oldKey < start) {
                newAlignments.put(oldKey, value);
                continue;
            }
            if (oldKey < end) continue;
            newAlignments.put(oldKey - removedCodePointLength, value);
        }
        this.paragraphAlignments.clear();
        this.paragraphAlignments.putAll(newAlignments);
        boolean newlineRemovedDuringOperation = false;
        if (removedText != null && !removedText.isEmpty()) {
            int charIter = 0;
            int removedTextCpLength = removedText.codePointCount(0, removedText.length());
            for (int cpIter = 0; cpIter < removedTextCpLength; ++cpIter) {
                if (removedText.codePointAt(charIter) == 10) {
                    newlineRemovedDuringOperation = true;
                    break;
                }
                charIter += Character.charCount(removedText.codePointAt(charIter));
            }
        }
        if (newlineRemovedDuringOperation) {
            String textBeforeStartCp;
            int lastNewlineCharIndex;
            String currentPlainText = this.getPlainText();
            int currentPlainTextCpLength = currentPlainText.codePointCount(0, currentPlainText.length());
            int paragraphStartIndexForCursor = 0;
            if (start > 0 && start <= currentPlainTextCpLength && (lastNewlineCharIndex = (textBeforeStartCp = currentPlainText.substring(0, this.toCharIndex(currentPlainText, start))).lastIndexOf(10)) != -1) {
                paragraphStartIndexForCursor = currentPlainText.codePointCount(0, lastNewlineCharIndex + 1);
            }
            if (!(this.paragraphAlignments.containsKey(paragraphStartIndexForCursor) && this.paragraphAlignments.get(paragraphStartIndexForCursor) == alignmentBeforeRemovalStart || paragraphStartIndexForCursor > this.length())) {
                this.paragraphAlignments.put(paragraphStartIndexForCursor, alignmentBeforeRemovalStart);
            }
        }
        if (!this.paragraphAlignments.containsKey(0) && this.length() > 0) {
            this.paragraphAlignments.put(0, DEFAULT_ALIGNMENT);
        } else if (this.length() == 0) {
            this.paragraphAlignments.clear();
            this.paragraphAlignments.put(0, DEFAULT_ALIGNMENT);
        }
    }

    public RichTextComponent setFormat(int start, int end, TextStyle style) {
        this.checkRange(start, end);
        if (start == end || style == null) {
            return this;
        }
        LinkedList<TextSegment> newSegments = new LinkedList<TextSegment>();
        int currentCodePointIndex = 0;
        TextStyle newStyle = style.copy();
        for (TextSegment segment : this.segments) {
            int segmentStartCp = currentCodePointIndex;
            int segmentEndCp = currentCodePointIndex + segment.length();
            if (segmentEndCp <= start || segmentStartCp >= end) {
                newSegments.add(segment);
            } else {
                int formatEndInSegCp;
                int formatStartInSegCp;
                if (segmentStartCp < start) {
                    int charEndOffset = this.toCharIndex(segment.stringBuilder(), start - segmentStartCp);
                    newSegments.add(new TextSegment(new StringBuilder(segment.stringBuilder().substring(0, charEndOffset)), segment.style().copy()));
                }
                if ((formatStartInSegCp = Math.max(0, start - segmentStartCp)) < (formatEndInSegCp = Math.min(segment.length(), end - segmentStartCp))) {
                    int charFormatStart = this.toCharIndex(segment.stringBuilder(), formatStartInSegCp);
                    int charFormatEnd = this.toCharIndex(segment.stringBuilder(), formatEndInSegCp);
                    newSegments.add(new TextSegment(new StringBuilder(segment.stringBuilder().substring(charFormatStart, charFormatEnd)), newStyle));
                }
                if (segmentEndCp > end) {
                    int charStartOffset = this.toCharIndex(segment.stringBuilder(), end - segmentStartCp);
                    newSegments.add(new TextSegment(new StringBuilder(segment.stringBuilder().substring(charStartOffset)), segment.style().copy()));
                }
            }
            currentCodePointIndex = segmentEndCp;
        }
        this.segments.clear();
        this.segments.addAll(newSegments);
        this.mergeAndUpdate();
        return this;
    }

    public RichTextComponent clearFormat(int start, int end) {
        return this.setFormat(start, end, TextStyle.EMPTY);
    }

    public RichTextComponent clearFormatAt(int codePointIndex) {
        this.checkIndex(codePointIndex);
        if (codePointIndex == this.length() && this.length() > 0) {
            if (codePointIndex > 0) {
                return this.setFormat(codePointIndex - 1, codePointIndex, TextStyle.EMPTY);
            }
            return this;
        }
        return this.setFormat(codePointIndex, codePointIndex + 1, TextStyle.EMPTY);
    }

    public String getPlainText() {
        return this.plainTextCache.get();
    }

    private boolean mergeNeighbors(int fromSegmentIndex, int toSegmentIndex) {
        this.segments.removeIf(TextSegment::isEmpty);
        if (this.segments.size() < 2) {
            return false;
        }
        boolean changed = false;
        int from = Math.max(0, fromSegmentIndex);
        int to = Math.min(this.segments.size() - 1, toSegmentIndex);
        LinkedList<TextSegment> merged = new LinkedList<TextSegment>();
        if (from <= 0) {
            merged.add(this.segments.get(0).copy());
        }
        for (int i = from + 1; i <= to; ++i) {
            TextSegment previous = (TextSegment)merged.get(merged.size() - 1);
            TextSegment current = this.segments.get(i);
            if (previous.style().equals(current.style())) {
                previous.stringBuilder().append((CharSequence)current.stringBuilder());
                changed = true;
                continue;
            }
            merged.add(current.copy());
        }
        this.segments.clear();
        this.segments.addAll(merged);
        return changed;
    }

    private void update() {
        this.textWidthCache.clear();
        this.textLengthCache.clear();
        this.plainTextCache.clear();
    }

    private void mergeAndUpdate() {
        this.mergeAndUpdate(Integer.MIN_VALUE, Integer.MAX_VALUE);
    }

    private void mergeAndUpdate(int firstSegmentIndex, int secondSegmentIndex) {
        this.mergeNeighbors(firstSegmentIndex, secondSegmentIndex);
        this.update();
        this.onTextChanged();
    }

    public ImmutableRichTextComponent subComponent(LineMarker line) {
        if (line == null || line.isEmpty()) {
            return ImmutableRichTextComponent.EMPTY;
        }
        return this.subComponent(line.startIndex(), line.endIndex());
    }

    public ImmutableRichTextComponent subComponent(int start, int end) {
        this.checkRange(start, end);
        if (start == end) {
            return ImmutableRichTextComponent.EMPTY;
        }
        LinkedList<TextSegment.ImmutableTextSegment> resultSegments = new LinkedList<TextSegment.ImmutableTextSegment>();
        int currentCodePointIndex = 0;
        for (TextSegment segment : this.getSegmentsRaw()) {
            int subEndInSegmentCp;
            int subStartInSegmentCp;
            int segmentStartCp = currentCodePointIndex;
            int segmentEndCp = currentCodePointIndex + segment.length();
            if (segmentEndCp > start && segmentStartCp < end && (subStartInSegmentCp = Math.max(0, start - segmentStartCp)) < (subEndInSegmentCp = Math.min(segment.length(), end - segmentStartCp))) {
                resultSegments.add(segment.copyImmutable(subStartInSegmentCp, subEndInSegmentCp));
            }
            if ((currentCodePointIndex = segmentEndCp) < end) continue;
            break;
        }
        return new ImmutableRichTextComponent(List.copyOf(resultSegments));
    }

    public List<TextSegment> getSegmentsRaw() {
        return this.segments;
    }

    public int length() {
        return this.textLengthCache.get();
    }

    public int charLength() {
        int i = 0;
        for (TextSegment segment : this.getSegmentsRaw()) {
            i += segment.charLength();
        }
        return i;
    }

    public float width() {
        return this.width(0, this.length());
    }

    public float width(int endIndex) {
        return this.width(0, endIndex);
    }

    public float width(int startIndex, int endIndex) {
        this.checkRange(startIndex, endIndex);
        if (endIndex <= startIndex) {
            return 0.0f;
        }
        if (startIndex == 0 && endIndex == this.length()) {
            return this.textWidthCache.get().floatValue();
        }
        return this.calcWidthOfSection(startIndex, endIndex);
    }

    private float calcWidthOfSection(int startIndex, int endIndex) {
        MutableFloat currentWidth = new MutableFloat();
        MutableInt currentIdx = new MutableInt(0);
        for (TextSegment segment : this.getSegmentsRaw()) {
            int baseCpIndexForThisSegment;
            if (currentIdx.intValue() + segment.length() <= startIndex) {
                currentIdx.add(segment.length());
                continue;
            }
            if (currentIdx.intValue() >= endIndex) break;
            int segmentLength = segment.length();
            int effectiveStartInSegmentCp = Math.max(0, startIndex - currentIdx.intValue());
            int effectiveEndInSegmentCp = Math.min(segmentLength, endIndex - currentIdx.intValue());
            int numCodePointsToIterate = effectiveEndInSegmentCp - effectiveStartInSegmentCp;
            if (numCodePointsToIterate > 0 && !TextSegment.iterate(segment, effectiveStartInSegmentCp, (arg_0, arg_1, arg_2) -> RichTextComponent.lambda$calcWidthOfSection$5(baseCpIndexForThisSegment = currentIdx.intValue(), effectiveStartInSegmentCp, endIndex, currentWidth, arg_0, arg_1, arg_2), numCodePointsToIterate)) break;
            currentIdx.add(segmentLength);
        }
        return currentWidth.floatValue();
    }

    public int indexByWidth(float maxWidth) {
        return this.calcIndexByWidth(maxWidth, 0, this.length(), false);
    }

    public int indexByWidth(float maxWidth, int skip) {
        return this.calcIndexByWidth(maxWidth, skip, this.length(), false);
    }

    public int indexByWidth(float maxWidth, LineMarker line, boolean pickClosest) {
        if (line == null) {
            return this.calcIndexByWidth(maxWidth, 0, this.length(), pickClosest);
        }
        return this.calcIndexByWidth(maxWidth, line.startIndex(), line.endIndex(), pickClosest);
    }

    public int indexByWidth(float maxWidth, int skip, int max, boolean pickClosest) {
        return this.calcIndexByWidth(maxWidth, skip, max, pickClosest);
    }

    private int calcIndexByWidth(float targetWidth, int skip, int max, boolean pickClosest) {
        MutableFloat currentWidth = new MutableFloat(0.0f);
        MutableInt targetIndex = new MutableInt(0);
        int globalIndex = 0;
        for (TextSegment segment : this.getSegmentsRaw()) {
            if (globalIndex + segment.length() < skip) {
                globalIndex += segment.length();
                continue;
            }
            if (globalIndex > max) break;
            int segmentLen = segment.length();
            int globalIdx = globalIndex;
            int localSkipInSegmentCp = Math.max(0, skip - globalIdx);
            int localEndInSegmentCp = Math.min(segmentLen, max - globalIdx);
            int numCodePointsToIterateInSegment = Math.max(0, localEndInSegmentCp - localSkipInSegmentCp);
            if (numCodePointsToIterateInSegment > 0) {
                boolean cancel;
                boolean bl = cancel = !TextSegment.iterate(segment, localSkipInSegmentCp, (iterCpIdx, style, codePoint) -> {
                    int currentIteratedGlobalCpIndex = globalIdx + localSkipInSegmentCp + iterCpIdx;
                    if (currentIteratedGlobalCpIndex >= max) {
                        return false;
                    }
                    if (currentIteratedGlobalCpIndex < skip) {
                        return true;
                    }
                    float charWidth = widthProvider.getWidth(style, codePoint);
                    if (!(currentWidth.floatValue() + charWidth <= targetWidth)) {
                        if (pickClosest && Math.abs(targetWidth - (currentWidth.floatValue() + charWidth)) < Math.abs(targetWidth - currentWidth.floatValue())) {
                            currentWidth.add(charWidth);
                            targetIndex.increment();
                        }
                        return false;
                    }
                    currentWidth.add(charWidth);
                    targetIndex.increment();
                    return true;
                }, numCodePointsToIterateInSegment);
                if (cancel) break;
            }
            globalIndex += segmentLen;
        }
        return skip + targetIndex.intValue();
    }

    public TreeMap<Integer, LineMarker> splitLines(int maxWidth) {
        int textCodePointLength;
        int[] fullPlainTextCodePoints;
        TreeMap calculatedMarkers = Maps.newTreeMap();
        if (this.segments.isEmpty()) {
            Integer n = 0;
            Objects.requireNonNull(Minecraft.m_91087_().f_91062_);
            calculatedMarkers.put(n, new LineMarker(0, 0, 0.0f, 1.0f, 9.0f, 0.0f, this.getParagraphAlignment(0)));
            return calculatedMarkers;
        }
        String fullPlainText = this.getPlainText();
        if (!fullPlainText.isEmpty()) {
            fullPlainTextCodePoints = fullPlainText.codePoints().toArray();
            textCodePointLength = fullPlainTextCodePoints.length;
        } else {
            fullPlainTextCodePoints = new int[]{};
            textCodePointLength = 0;
        }
        MutableInt lastCodePointIndex = new MutableInt(0);
        MutableFloat currentY = new MutableFloat(0.0f);
        LineSplitter splitter = new LineSplitter(maxWidth, 0, widthProvider, lineBreak -> {
            int breakCpIndex;
            int effectiveLineEndCodePointIndex = breakCpIndex = lineBreak.breakIndex();
            int nextLineStartCodePointIndex = breakCpIndex;
            if (breakCpIndex < textCodePointLength) {
                int codePointAtBreak = fullPlainTextCodePoints[breakCpIndex];
                if (codePointAtBreak == 10) {
                    nextLineStartCodePointIndex = breakCpIndex + 1;
                } else if (codePointAtBreak == 32 && maxWidth != Integer.MAX_VALUE) {
                    nextLineStartCodePointIndex = breakCpIndex + 1;
                }
            }
            float actualRenderedWidth = lineBreak.lineWidth();
            ETextAlignment lineAlignment = this.getParagraphAlignment(lastCodePointIndex.intValue());
            calculatedMarkers.put(lastCodePointIndex.intValue(), new LineMarker(lastCodePointIndex.intValue(), effectiveLineEndCodePointIndex, actualRenderedWidth, lineBreak.scale(), lineBreak.lineHeight(), currentY.floatValue(), lineAlignment));
            currentY.add(lineBreak.lineHeight());
            lastCodePointIndex.setValue(nextLineStartCodePointIndex);
        });
        MutableInt segmentBaseCodePointIndex = new MutableInt(0);
        for (TextSegment segment : this.getSegmentsRaw()) {
            splitter.offset = segmentBaseCodePointIndex.intValue();
            TextSegment.iterate(segment, 0, splitter::accept, segment.length());
            segmentBaseCodePointIndex.add(segment.length());
        }
        int currentTotalCpLength = this.length();
        if (lastCodePointIndex.intValue() < currentTotalCpLength || calculatedMarkers.isEmpty()) {
            float finalLineWidth = splitter.widthSinceLastBreak();
            ETextAlignment lineAlignment = this.getParagraphAlignment(lastCodePointIndex.intValue());
            calculatedMarkers.put(lastCodePointIndex.intValue(), new LineMarker(lastCodePointIndex.intValue(), currentTotalCpLength, finalLineWidth, splitter.highestScale(), splitter.lineHeight(), currentY.floatValue(), lineAlignment));
        } else if (currentTotalCpLength > 0 && lastCodePointIndex.intValue() == currentTotalCpLength && textCodePointLength > 0 && fullPlainTextCodePoints[textCodePointLength - 1] == 10 && !calculatedMarkers.containsKey(lastCodePointIndex.intValue())) {
            ETextAlignment lineAlignment = this.getParagraphAlignment(lastCodePointIndex.intValue());
            Objects.requireNonNull(Minecraft.m_91087_().f_91062_);
            float defaultLineHeight = 9.0f;
            calculatedMarkers.put(lastCodePointIndex.intValue(), new LineMarker(lastCodePointIndex.intValue(), currentTotalCpLength, 0.0f, 1.0f, defaultLineHeight, currentY.floatValue(), lineAlignment));
        }
        return calculatedMarkers;
    }

    public void setParagraphAlignment(int charIndex, ETextAlignment alignment) {
        this.setParagraphAlignment(charIndex, alignment, true);
    }

    private void setParagraphAlignment(int charIndex, ETextAlignment alignment, boolean performUpdate) {
        int charIdxAtEffective;
        int charIndexForSearch;
        String subToEffectiveChar;
        int lastNewlineCharIndex;
        int lastCharIdx;
        this.checkIndex(charIndex);
        String text = this.getPlainText();
        int textCodePointLength = text.codePointCount(0, text.length());
        int effectiveCodePointIndex = charIndex;
        if (charIndex == textCodePointLength && textCodePointLength > 0 && (lastCharIdx = this.toCharIndex(text, textCodePointLength - 1)) < text.length() && text.codePointAt(lastCharIdx) != 10) {
            effectiveCodePointIndex = textCodePointLength - 1;
        }
        int paraStartIndexCodePoints = 0;
        if (effectiveCodePointIndex > 0 && (lastNewlineCharIndex = (subToEffectiveChar = text.substring(0, charIndexForSearch = this.toCharIndex(text, Math.min(effectiveCodePointIndex + 1, textCodePointLength)))).lastIndexOf(10, Math.max(0, this.toCharIndex(text, effectiveCodePointIndex) - 1))) != -1) {
            paraStartIndexCodePoints = text.codePointCount(0, lastNewlineCharIndex + 1);
        }
        if (effectiveCodePointIndex < textCodePointLength && (charIdxAtEffective = this.toCharIndex(text, effectiveCodePointIndex)) < text.length() && text.codePointAt(charIdxAtEffective) == 10 && effectiveCodePointIndex + 1 <= textCodePointLength) {
            paraStartIndexCodePoints = effectiveCodePointIndex + 1;
        }
        if (paraStartIndexCodePoints <= textCodePointLength) {
            this.paragraphAlignments.put(paraStartIndexCodePoints, alignment);
        }
        if (performUpdate) {
            this.update();
        }
    }

    public ETextAlignment getParagraphAlignment(int charIndex) {
        int currentTotalCodePoints;
        if (charIndex < 0) {
            charIndex = 0;
        }
        if (charIndex > (currentTotalCodePoints = this.length())) {
            charIndex = currentTotalCodePoints;
        }
        if (this.paragraphAlignments.isEmpty()) {
            return DEFAULT_ALIGNMENT;
        }
        Map.Entry<Integer, ETextAlignment> entry = this.paragraphAlignments.floorEntry(charIndex);
        if (entry == null) {
            return this.paragraphAlignments.getOrDefault(0, DEFAULT_ALIGNMENT);
        }
        return entry.getValue();
    }

    private void addInteractiveElementInternal(InteractiveElement newElement) {
        if (newElement.start >= newElement.end) {
            return;
        }
        LinkedList<InteractiveElement> resultElements = new LinkedList<InteractiveElement>();
        for (InteractiveElement existingElement : this.interactiveElements) {
            InteractiveElement element;
            if (existingElement.end <= newElement.start || existingElement.start >= newElement.end) {
                resultElements.add(existingElement);
                continue;
            }
            if (existingElement.start < newElement.start) {
                element = new InteractiveElement(existingElement.start, newElement.start);
                element.copyFrom(existingElement);
                resultElements.add(element);
            }
            if (existingElement.end <= newElement.end) continue;
            element = new InteractiveElement(newElement.end, existingElement.end);
            element.copyFrom(existingElement);
            resultElements.add(element);
        }
        resultElements.add(newElement);
        resultElements.sort(Comparator.comparingInt(e -> e.start));
        this.interactiveElements.clear();
        this.interactiveElements.addAll(resultElements);
        this.update();
    }

    public Optional<InteractiveElement> createInteractiveElement(int start, int end) {
        this.checkRange(start, end);
        if (end <= start) {
            return Optional.empty();
        }
        InteractiveElement newElement = new InteractiveElement(start, end);
        this.addInteractiveElementInternal(newElement);
        return Optional.of(newElement);
    }

    public List<InteractiveElement> getInteractiveElements() {
        return this.interactiveElements;
    }

    public InteractiveElement getInteractiveElementAt(int codePointIndex) {
        this.checkIndex(codePointIndex);
        if (codePointIndex == this.length() && this.length() > 0) {
            return null;
        }
        for (InteractiveElement element : this.interactiveElements) {
            if (!element.contains(codePointIndex)) continue;
            return element;
        }
        return null;
    }

    public RichTextComponent removeActionAt(int codePointIndex) {
        this.checkIndex(codePointIndex);
        if (codePointIndex == this.length() && this.length() > 0) {
            return this;
        }
        InteractiveElement elementToRemove = null;
        for (InteractiveElement element : this.interactiveElements) {
            if (!element.contains(codePointIndex)) continue;
            elementToRemove = element;
            break;
        }
        if (elementToRemove != null) {
            this.interactiveElements.remove(elementToRemove);
            this.update();
        }
        return this;
    }

    public void onTextChanged() {
        DLUtils.doIfNotNull(this.onTextChanged, Runnable::run);
    }

    private static /* synthetic */ boolean lambda$calcWidthOfSection$5(int baseCpIndexForThisSegment, int effectiveStartInSegmentCp, int endIndex, MutableFloat currentWidth, int idxInIterationCp, TextStyle style, int codePoint) {
        if (baseCpIndexForThisSegment + effectiveStartInSegmentCp + idxInIterationCp < endIndex) {
            currentWidth.add(widthProvider.getWidth(style, codePoint));
            return true;
        }
        return false;
    }

    @FunctionalInterface
    public static interface ITextValidator {
        public String validate(String var1, String var2, String var3);
    }

    public record TextSegmentResult(int segmentIndex, int textStartIndex, TextSegment segment) {
        public boolean available() {
            return this.segment() != null;
        }
    }

    public record ImmutableRichTextComponent(List<TextSegment.ImmutableTextSegment> segments) {
        public static final ImmutableRichTextComponent EMPTY = new ImmutableRichTextComponent(List.of());

        public String plainText() {
            return this.segments().stream().map(TextSegment.ImmutableTextSegment::text).collect(Collectors.joining());
        }
    }
}

