/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.mcdragonlib.client.gui.widgets.richtext;

import de.mrjulsen.mcdragonlib.client.gui.widgets.richtext.TextStyle;
import de.mrjulsen.mcdragonlib.mixin.FontAccessor;
import de.mrjulsen.mcdragonlib.util.TextUtils;
import net.minecraft.client.gui.font.FontSet;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import org.apache.commons.lang3.mutable.MutableFloat;

public class TextSegment {
    private static final String NBT_TEXT = "Text";
    private static final String NBT_STYLE = "Style";
    private StringBuilder text;
    private TextStyle style;
    private static final int REPLACEMENT_CHAR_CODEPOINT = 65533;

    public TextSegment(StringBuilder text, TextStyle style) {
        this.text = text;
        this.style = style;
    }

    public StringBuilder stringBuilder() {
        return this.text;
    }

    public String text() {
        return this.text.toString();
    }

    public TextStyle style() {
        return this.style;
    }

    public int charLength() {
        return this.stringBuilder().length();
    }

    public int length() {
        return this.stringBuilder().codePointCount(0, this.text.length());
    }

    public int codePointLength() {
        return this.stringBuilder().codePointCount(0, this.text.length());
    }

    public boolean isEmpty() {
        return this.stringBuilder().isEmpty();
    }

    public TextSegment copy() {
        return new TextSegment(new StringBuilder(this.text), this.style.copy());
    }

    public CompoundTag toNbt() {
        CompoundTag nbt = new CompoundTag();
        nbt.m_128359_(NBT_TEXT, this.text.toString());
        nbt.m_128365_(NBT_STYLE, (Tag)this.style.toNbt());
        return nbt;
    }

    public static TextSegment fromNbt(CompoundTag nbt) {
        return new TextSegment(new StringBuilder(nbt.m_128461_(NBT_TEXT)), TextStyle.fromNbt(nbt.m_128469_(NBT_STYLE)));
    }

    public Component toComponent() {
        return TextUtils.text(this.text()).m_130948_(this.style().toStyle());
    }

    public static TextSegment fromComponent(Component component) {
        return new TextSegment(new StringBuilder(component.getString()), TextStyle.fromStyle(component.m_7383_()));
    }

    public float width() {
        if (this.text == null || this.text.length() == 0) {
            return 0.0f;
        }
        MutableFloat mutableFloat = new MutableFloat();
        FontAccessor accessor = (FontAccessor)this.style().font();
        FontSet fontSet = accessor.dragonlib$invokeGetFontSet(Style.f_131100_);
        TextSegment.iterate(this, 0, (idx, style, c) -> {
            mutableFloat.add(fontSet.m_243128_(c, accessor.dragonlib$filterFishyGlyphs()).m_83827_(this.style().bold()));
            return true;
        }, this.length());
        return mutableFloat.floatValue() * this.style().scale();
    }

    public ImmutableTextSegment copyImmutable() {
        return this.copyImmutable(0, this.length());
    }

    public ImmutableTextSegment copyImmutable(int codePointStartIndex, int codePointEndIndex) {
        if (codePointStartIndex < 0 || codePointEndIndex > this.length() || codePointStartIndex > codePointEndIndex) {
            throw new IndexOutOfBoundsException("Cannot copy immutable part from code point index " + codePointStartIndex + " to " + codePointEndIndex + " for segment with code point length " + this.length());
        }
        String originalString = this.stringBuilder().toString();
        int charStartIndex = originalString.offsetByCodePoints(0, codePointStartIndex);
        int charEndIndex = originalString.offsetByCodePoints(0, codePointEndIndex);
        return new ImmutableTextSegment(originalString.substring(charStartIndex, charEndIndex), this.style().copy());
    }

    public static boolean iterate2(TextSegment segment, int skip, CharCallback sink, int count) {
        int charsForThisCodePoint;
        StringBuilder sb = segment.stringBuilder();
        int charLength = sb.length();
        if (skip < 0 || count <= 0) {
            return true;
        }
        int currentCodePointIndex = 0;
        int iteratedCodePoints = 0;
        for (int charIdx = 0; charIdx < charLength && iteratedCodePoints < count; charIdx += charsForThisCodePoint) {
            int codePoint = sb.codePointAt(charIdx);
            charsForThisCodePoint = Character.charCount(codePoint);
            if (currentCodePointIndex >= skip) {
                if (!sink.accept(iteratedCodePoints, segment.style(), codePoint)) {
                    return false;
                }
                ++iteratedCodePoints;
            }
            ++currentCodePointIndex;
        }
        return true;
    }

    public static boolean iterate(TextSegment segment, int skipCodePoints, CharCallback sink, int countCodePoints) {
        int charsForThisCodePoint;
        StringBuilder sb = segment.stringBuilder();
        int charLength = sb.length();
        if (skipCodePoints < 0 || countCodePoints <= 0) {
            return true;
        }
        int currentOverallCodePointIndex = 0;
        int iteratedCodePointsInThisCall = 0;
        for (int charIdx = 0; charIdx < charLength && iteratedCodePointsInThisCall < countCodePoints; charIdx += charsForThisCodePoint) {
            int codePoint = sb.codePointAt(charIdx);
            charsForThisCodePoint = Character.charCount(codePoint);
            if (currentOverallCodePointIndex >= skipCodePoints) {
                if (!sink.accept(iteratedCodePointsInThisCall, segment.style(), codePoint)) {
                    return false;
                }
                ++iteratedCodePointsInThisCall;
            }
            ++currentOverallCodePointIndex;
        }
        return true;
    }

    @FunctionalInterface
    public static interface CharCallback {
        public boolean accept(int var1, TextStyle var2, int var3);
    }

    public record ImmutableTextSegment(String text, TextStyle style) {
    }
}

