/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.mcdragonlib.client.gui.widgets.richtext;

import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Style;

public record TextStyle(Font font, boolean bold, boolean italic, boolean underlined, boolean strikethrough, boolean obfuscated, int color, boolean dropShadow, float scale, int highlightColor) {
    public static final TextStyle EMPTY = new Builder().build();
    public static final TextStyle URL_STYLE = new Builder().color(-11184641).underlined(true).build();
    private static final String NBT_BOLD = "bold";
    private static final String NBT_ITALIC = "italic";
    private static final String NBT_UNDERLINED = "underlined";
    private static final String NBT_STRIKETHROUGH = "strikethrough";
    private static final String NBT_OBFUSCATED = "obfuscated";
    private static final String NBT_COLOR = "color";
    private static final String NBT_SHADOW = "shadow";
    private static final String NBT_SCALE = "scale";
    private static final String NBT_HIGHLIGHT_COLOR = "highlight_color";

    public TextStyle copy() {
        return new TextStyle(this.font, this.bold, this.italic, this.underlined, this.strikethrough, this.obfuscated, this.color, this.dropShadow, this.scale, this.highlightColor);
    }

    public CompoundTag toNbt() {
        CompoundTag nbt = new CompoundTag();
        nbt.m_128379_(NBT_BOLD, this.bold);
        nbt.m_128379_(NBT_ITALIC, this.italic);
        nbt.m_128379_(NBT_UNDERLINED, this.underlined);
        nbt.m_128379_(NBT_STRIKETHROUGH, this.strikethrough);
        nbt.m_128379_(NBT_OBFUSCATED, this.obfuscated);
        nbt.m_128405_(NBT_COLOR, this.color);
        nbt.m_128379_(NBT_SHADOW, this.dropShadow);
        nbt.m_128350_(NBT_SCALE, this.scale);
        nbt.m_128405_(NBT_HIGHLIGHT_COLOR, this.highlightColor);
        return nbt;
    }

    public static TextStyle fromNbt(CompoundTag nbt) {
        Builder builder = new Builder().bold(nbt.m_128471_(NBT_BOLD)).italic(nbt.m_128471_(NBT_ITALIC)).underlined(nbt.m_128471_(NBT_UNDERLINED)).strikethrough(nbt.m_128471_(NBT_STRIKETHROUGH)).obfuscated(nbt.m_128471_(NBT_OBFUSCATED)).shadow(nbt.m_128471_(NBT_SHADOW)).color(nbt.m_128451_(NBT_COLOR));
        Objects.requireNonNull(Minecraft.m_91087_().f_91062_);
        return builder.size((int)(9.0f * nbt.m_128457_(NBT_SCALE))).highlightColor(nbt.m_128451_(NBT_HIGHLIGHT_COLOR)).build();
    }

    public Style toStyle() {
        return Style.f_131099_.m_131136_(Boolean.valueOf(this.bold)).m_131155_(Boolean.valueOf(this.italic)).m_131162_(Boolean.valueOf(this.underlined)).m_178522_(Boolean.valueOf(this.strikethrough)).m_178524_(Boolean.valueOf(this.obfuscated)).m_178520_(this.color);
    }

    public static TextStyle fromStyle(Style style) {
        return new Builder().bold(style.m_131154_()).italic(style.m_131161_()).underlined(style.m_131171_()).obfuscated(style.m_131176_()).strikethrough(style.m_131168_()).color(style.m_131135_().m_131265_()).build();
    }

    public static class Builder {
        private Font font;
        private boolean bold;
        private boolean italic;
        private boolean underlined;
        private boolean strikethrough;
        private boolean obfuscated;
        private int color;
        private boolean dropShadow;
        private int size;
        private int highlightColor;

        public Builder() {
            this.font = Minecraft.m_91087_().f_91062_;
            this.color = -1;
            Objects.requireNonNull(Minecraft.m_91087_().f_91062_);
            this.size = 9;
            this.highlightColor = 0;
        }

        public Builder font(Font font) {
            this.font = font;
            return this;
        }

        public Builder bold(boolean b) {
            this.bold = b;
            return this;
        }

        public Builder italic(boolean b) {
            this.italic = b;
            return this;
        }

        public Builder strikethrough(boolean b) {
            this.strikethrough = b;
            return this;
        }

        public Builder underlined(boolean b) {
            this.underlined = b;
            return this;
        }

        public Builder obfuscated(boolean b) {
            this.obfuscated = b;
            return this;
        }

        public Builder color(int color) {
            this.color = color;
            return this;
        }

        public Builder shadow(boolean b) {
            this.dropShadow = b;
            return this;
        }

        public Builder size(int size) {
            this.size = size;
            return this;
        }

        public Builder highlightColor(int highlightColor) {
            this.highlightColor = highlightColor;
            return this;
        }

        public TextStyle build() {
            float f = this.size;
            Objects.requireNonNull(this.font);
            return new TextStyle(this.font, this.bold, this.italic, this.underlined, this.strikethrough, this.obfuscated, this.color, this.dropShadow, f / 9.0f, this.highlightColor);
        }
    }
}

