/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.mcdragonlib.client.gui.widgets.richtext.action;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.network.chat.Component;

public class InteractiveElement {
    public int start;
    public int end;
    public Map<Class<? extends IInteraction>, IInteraction> interactions = new HashMap<Class<? extends IInteraction>, IInteraction>();

    public InteractiveElement(int start, int end) {
        this.start = start;
        this.end = end;
    }

    public <T extends IInteraction> InteractiveElement withAction(T action) {
        this.interactions.put(action.getClass(), action);
        return this;
    }

    public <T extends IInteraction> boolean hasActionFromType(Class<T> type) {
        return this.interactions.containsKey(type);
    }

    public <T extends IInteraction> T getActionFromType(Class<T> type) {
        return (T)this.interactions.get(type);
    }

    public boolean shouldHighlightOnHover() {
        for (IInteraction el : this.interactions.values()) {
            if (!el.highlightOnHover()) continue;
            return true;
        }
        return false;
    }

    public void copyFrom(InteractiveElement other) {
        this.interactions.putAll(other.interactions);
    }

    public boolean contains(int codePointIndex) {
        return codePointIndex >= this.start && codePointIndex < this.end;
    }

    public boolean intersects(int otherStart, int otherEnd) {
        return Math.max(this.start, otherStart) < Math.min(this.end, otherEnd);
    }

    public int length() {
        return this.end - this.start;
    }

    public static interface IInteraction {
        public boolean highlightOnHover();
    }

    public record HoverAction(Component text) implements IInteraction
    {
        @Override
        public boolean highlightOnHover() {
            return false;
        }
    }

    public record ClickAction(String actionName, String value) implements IInteraction
    {
        public static final String OPEN_URL = "open_url";
        public static final String COPY_TO_CLIPBAORD = "copy_to_clipboard";

        @Override
        public boolean highlightOnHover() {
            return true;
        }
    }
}

