/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.mcdragonlib.client.gui.widgets.richtext.autocomplete;

import de.mrjulsen.mcdragonlib.DragonLib;
import de.mrjulsen.mcdragonlib.client.gui.events.DLGuiStandardEvents;
import de.mrjulsen.mcdragonlib.client.gui.widgets.components.DLAbstractCollectionComponent;
import de.mrjulsen.mcdragonlib.client.gui.widgets.components.DLItemSelectionBox;
import de.mrjulsen.mcdragonlib.client.gui.widgets.components.DLRichTextEditBox;
import de.mrjulsen.mcdragonlib.client.gui.widgets.richtext.RichTextComponent;
import de.mrjulsen.mcdragonlib.client.gui.widgets.richtext.autocomplete.DLAutocompleteWindow;
import de.mrjulsen.mcdragonlib.client.util.DLGuiGraphics;
import de.mrjulsen.mcdragonlib.client.util.GuiUtils;
import de.mrjulsen.mcdragonlib.data.ETextAlignment;
import de.mrjulsen.mcdragonlib.util.DLColor;
import de.mrjulsen.mcdragonlib.util.TextUtils;
import de.mrjulsen.mcdragonlib.util.math.Rectangle;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;

public class DLAutocompleteListBox<T>
extends DLItemSelectionBox<T> {
    private final Component txtNoResults = TextUtils.translate("gui.dragonlib.autocomplete.no_results").m_130944_(new ChatFormatting[]{ChatFormatting.GRAY, ChatFormatting.ITALIC});
    private final DLAutocompleteWindow<T> windowRef;
    private final DLRichTextEditBox textbox;
    final List<T> visibleItems = new ArrayList<T>();

    public DLAutocompleteListBox(DLAutocompleteWindow<T> windowRef, DLRichTextEditBox textbox, int x, int y, int w, int h) {
        super(x, y, w, h);
        this.windowRef = windowRef;
        this.textbox = textbox;
        this.contentPanel.setPosition(0.0, 0.0);
        this.contentPanel.setSize(this.width(), this.height());
        this.scrollBar.setPosition(this.width() - 7, 0.0);
        this.scrollBar.setSize(7.0, this.height());
        this.addEventListener(DLItemSelectionBox.ItemSelectionChangeEvent.class, (s, e) -> {
            if (e.selected().getValue().booleanValue()) {
                e.item().getParent().ifPresent(p -> p.scrollIntoView(e.item()));
            }
            return false;
        });
        this.addEventListener(DLAbstractCollectionComponent.ListLayoutChangedEvent.class, (s, e) -> {
            int n = Math.min(e.layoutResult().contentHeight() + 2, 101);
            Objects.requireNonNull(Minecraft.m_91087_().f_91062_);
            windowRef.setHeight(Math.max(n, 9 + 4));
            return false;
        });
    }

    @Override
    protected void createComponents() {
        this.contentPanel.clearComponents();
        this.visibleItems.clear();
        Iterator iterator = this.items.get().iterator();
        while (iterator.hasNext()) {
            Object item = iterator.next();
            if (!((Predicate)this.filter.get()).test(item)) continue;
            this.visibleItems.add(item);
            DLItemSelectionBox.DLListBoxItem listItem = (DLItemSelectionBox.DLListBoxItem)((Function)this.itemBuilder.get()).apply(item);
            this.contentPanel.addComponent(listItem);
        }
    }

    @Override
    protected DLItemSelectionBox.DLListBoxItem<T> defaultItemBuilder(T item) {
        return new AutocompleteItem<T>(this, item);
    }

    public void selectFirst() {
        if (!this.visibleItems.isEmpty()) {
            this.selectedItems.set(List.of(this.visibleItems.get(0)));
        }
    }

    public int visibleCurrentIndex() {
        if (((List)this.selectedItems.get()).isEmpty()) {
            return 0;
        }
        return this.visibleIndexOf(((List)this.selectedItems.get()).get(0));
    }

    public int visibleIndexOf(T item) {
        return this.visibleItems.indexOf(item);
    }

    public void selectByVisibleIndex(int index) {
        this.selectedItems.set(List.of(this.visibleItems.get(index)));
    }

    @Override
    public void renderMainLayer(DLGuiGraphics graphics, double mouseX, double mouseY, Rectangle renderBounds) {
        if (this.visibleItems.isEmpty()) {
            Font font = graphics.defaultFont();
            int n = this.width() / 2;
            int n2 = this.height() / 2;
            Objects.requireNonNull(graphics.defaultFont());
            GuiUtils.drawString(graphics, font, n, n2 - 9 / 2, (FormattedText)this.txtNoResults, DLColor.WHITE, ETextAlignment.CENTER, false);
        }
    }

    public static class AutocompleteItem<T>
    extends DLItemSelectionBox.DLListBoxItem<T> {
        protected AutocompleteItem(DLAutocompleteListBox<T> collectionComponentRef, T item) {
            Objects.requireNonNull(Minecraft.m_91087_().f_91062_);
            super(collectionComponentRef, item, 100, 9 + 2);
            this.addEventListener(DLGuiStandardEvents.ClickEvent.class, (s, e) -> {
                collectionComponentRef.windowRef.supressTextUpdate = true;
                ((RichTextComponent)collectionComponentRef.textbox.text.get()).set(((FormattedText)((Function)collectionComponentRef.textFormat.get()).apply(item)).getString());
                this.getWindowManager().closeWindow(collectionComponentRef.windowRef);
                collectionComponentRef.windowRef.supressTextUpdate = false;
                return false;
            });
        }

        @Override
        public void renderMainLayer(DLGuiGraphics graphics, double mouseX, double mouseY, Rectangle renderBounds) {
            if (((Boolean)this.selected.get()).booleanValue()) {
                GuiUtils.fill(graphics, 0, 0, this.width(), this.height(), DLColor.fromInt(0x60FFFFFF));
            }
            if (this.isSelected()) {
                GuiUtils.fill(graphics, 0, 0, this.width(), this.height(), DLColor.fromInt(0x30FFFFFF));
            }
            DLAutocompleteListBox list = (DLAutocompleteListBox)this.collectionComponentRef;
            String searchText = ((RichTextComponent)list.textbox.text.get()).getPlainText();
            String itemName = ((FormattedText)((Function)list.textFormat.get()).apply(this.item)).getString();
            int index = itemName.toLowerCase().indexOf(searchText.toLowerCase());
            MutableComponent txt = TextUtils.empty();
            if (index != -1) {
                String before = itemName.substring(0, index);
                String match = itemName.substring(index, index + searchText.length());
                String after = itemName.substring(index + searchText.length());
                txt = txt.m_7220_((Component)TextUtils.text(before)).m_7220_((Component)TextUtils.text(match).m_130940_(ChatFormatting.YELLOW)).m_7220_((Component)TextUtils.text(after));
            }
            Font font = Minecraft.m_91087_().f_91062_;
            int n = this.height() / 2;
            Objects.requireNonNull(Minecraft.m_91087_().f_91062_);
            GuiUtils.drawString(graphics, font, 2, n - 9 / 2, (FormattedText)txt, DragonLib.VANILLA_BUTTON_ACTIVE_FONT_COLOR, ETextAlignment.LEFT, false);
        }

        @Override
        public T getItem() {
            return (T)this.item;
        }
    }
}

