/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.mcdragonlib.client.gui.widgets.util;

import de.mrjulsen.mcdragonlib.client.gui.widgets.util.CursorType;
import java.util.Arrays;

public enum Align {
    TOP_LEFT("top_left", 0, CursorType.TLBRRESIZE, AffectedTransformtion.POSITION),
    TOP("top", 1, CursorType.VRESIZE, AffectedTransformtion.POSITION),
    TOP_RIGHT("top_right", 2, CursorType.TRBLRESIZE, AffectedTransformtion.POSITION),
    LEFT("left", 3, CursorType.HRESIZE, AffectedTransformtion.POSITION),
    CENTER("center", 4, null, AffectedTransformtion.NONE),
    RIGHT("right", 5, CursorType.HRESIZE, AffectedTransformtion.SIZE),
    BOTTOM_LEFT("bottom_left", 6, CursorType.TRBLRESIZE, AffectedTransformtion.SIZE),
    BOTTOM("bottom", 7, CursorType.VRESIZE, AffectedTransformtion.SIZE),
    BOTTOM_RIGHT("bottom_right", 8, CursorType.TLBRRESIZE, AffectedTransformtion.SIZE);

    private final String name;
    private final byte id;
    private final CursorType cursor;
    private final AffectedTransformtion transform;

    private Align(String name, byte id, CursorType cursor, AffectedTransformtion transform) {
        this.name = name;
        this.id = id;
        this.cursor = cursor;
        this.transform = transform;
    }

    public String getName() {
        return this.name;
    }

    public byte getId() {
        return this.id;
    }

    public CursorType getCursor() {
        return this.cursor;
    }

    public AffectedTransformtion getAffectedTransformation() {
        return this.transform;
    }

    public String toString() {
        return this.name;
    }

    public static Align getById(int id) {
        return Arrays.stream(Align.values()).filter(x -> x.getId() == id).findFirst().orElse(CENTER);
    }

    public boolean isRightAlign() {
        return this == BOTTOM_RIGHT || this == RIGHT || this == TOP_RIGHT;
    }

    public boolean isLeftAlign() {
        return this == BOTTOM_LEFT || this == LEFT || this == TOP_LEFT;
    }

    public boolean isTopAlign() {
        return this == TOP_LEFT || this == TOP || this == TOP_RIGHT;
    }

    public boolean isBottomAlign() {
        return this == BOTTOM_LEFT || this == BOTTOM || this == BOTTOM_RIGHT;
    }

    public boolean isVerticalCentered() {
        return this == TOP || this == CENTER || this == BOTTOM;
    }

    public boolean isHorizontalCentered() {
        return this == LEFT || this == CENTER || this == RIGHT;
    }

    public static enum AffectedTransformtion {
        NONE,
        POSITION,
        SIZE;

    }
}

