/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.mcdragonlib.client.gui.widgets.util;

import com.google.common.collect.ImmutableMap;
import de.mrjulsen.mcdragonlib.client.gui.widgets.util.BitflagEnum;
import de.mrjulsen.mcdragonlib.data.IIterableEnum;
import de.mrjulsen.mcdragonlib.data.ITranslatableEnum;
import java.util.HashMap;
import java.util.Optional;

public enum EAlign implements BitflagEnum,
ITranslatableEnum,
IIterableEnum<EAlign>
{
    TOP(0, "top", 1, AffectedTransformtion.POSITION, true),
    LEFT(1, "left", 2, AffectedTransformtion.POSITION, false),
    RIGHT(3, "right", 4, AffectedTransformtion.SIZE, false),
    BOTTOM(2, "bottom", 8, AffectedTransformtion.SIZE, true);

    private final byte order;
    private final String name;
    private final int bit;
    private final AffectedTransformtion transform;
    private final boolean isVertical;
    private static final ImmutableMap<Long, EAlign> valueMap;

    private EAlign(byte order, String name, int bit, AffectedTransformtion transform, boolean isVertical) {
        this.order = order;
        this.name = name;
        this.bit = bit;
        this.transform = transform;
        this.isVertical = isVertical;
    }

    public byte getOrder() {
        return this.order;
    }

    public String getName() {
        return this.name;
    }

    @Override
    public long getBit() {
        return this.bit;
    }

    public AffectedTransformtion getAffectedTransformation() {
        return this.transform;
    }

    public String toString() {
        return this.name;
    }

    public static Optional<EAlign> getByBit(long bit) {
        return Optional.ofNullable(valueMap.containsKey((Object)bit) ? (EAlign)valueMap.get((Object)bit) : null);
    }

    public boolean isVertical() {
        return this.isVertical;
    }

    public boolean isHorizontal() {
        return !this.isVertical();
    }

    @Override
    public ITranslatableEnum.Data getTranslationData() {
        return new ITranslatableEnum.Data("dragonlib", "align", this.getName());
    }

    public EAlign[] getValues() {
        return EAlign.values();
    }

    static {
        HashMap<Long, EAlign> map = new HashMap<Long, EAlign>();
        for (EAlign value : EAlign.values()) {
            map.put(value.getBit(), value);
        }
        valueMap = ImmutableMap.copyOf(map);
    }

    public static enum AffectedTransformtion {
        NONE,
        POSITION,
        SIZE;

    }
}

