/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.mcdragonlib.client.gui.widgets.util;

import de.mrjulsen.mcdragonlib.client.gui.widgets.base.DLGuiComponent;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Optional;
import java.util.TreeMap;

public class HitResult {
    private TreeMap<ComponentSelectionState, LinkedList<ComponentHitContext>> allHitComponents = new TreeMap();
    private boolean consumed;

    public void add(ComponentSelectionState pain, ComponentHitContext context) {
        this.allHitComponents.computeIfAbsent(pain, x -> new LinkedList()).add(context);
    }

    public void addAll(ComponentSelectionState pain, Collection<ComponentHitContext> context) {
        this.allHitComponents.computeIfAbsent(pain, x -> new LinkedList()).addAll(context);
    }

    public void addAll(TreeMap<ComponentSelectionState, LinkedList<ComponentHitContext>> entries) {
        entries.entrySet().forEach(a -> this.addAll((ComponentSelectionState)((Object)((Object)a.getKey())), (Collection)a.getValue()));
    }

    public boolean isPresent() {
        return !this.allHitComponents.isEmpty() && (this.allHitComponents.containsKey((Object)ComponentSelectionState.FOCUSED) || this.allHitComponents.containsKey((Object)ComponentSelectionState.HIT));
    }

    public Optional<ComponentHitContext> focusedComponent() {
        return Optional.ofNullable(this.isPresent() && this.components().containsKey((Object)ComponentSelectionState.FOCUSED) ? this.components().get((Object)ComponentSelectionState.FOCUSED).get(0) : null);
    }

    public boolean consumed() {
        return this.consumed;
    }

    public TreeMap<ComponentSelectionState, LinkedList<ComponentHitContext>> components() {
        return this.allHitComponents;
    }

    public void consume(boolean b) {
        this.consumed = b;
    }

    public static enum ComponentSelectionState {
        UNSELECTED,
        HIT,
        FOCUSED;


        public boolean isHit() {
            return this == HIT || this == FOCUSED;
        }

        public boolean isNotFocused() {
            return this == HIT || this == UNSELECTED;
        }
    }

    public record ComponentHitContext(DLGuiComponent component, double mouseX, double mouseY, int xOffset, int yOffset, boolean enabled) {
    }
}

