/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.mcdragonlib.client.model;

import com.google.common.collect.ImmutableMap;
import de.mrjulsen.mcdragonlib.client.model.mesh.DLModel;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.BlockModelShaper;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.ResourceManagerReloadListener;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.ApiStatus;

public class DLBlockModelRegistry
implements ResourceManagerReloadListener {
    private static final Map<BlockState, BakedModel> originalModels = new ConcurrentHashMap<BlockState, BakedModel>();
    private static final Queue<ICustomModelFactory> customModels = new LinkedBlockingQueue<ICustomModelFactory>();

    public static void registerForBlock(Supplier<Block> block, Supplier<DLModel> blockModelFactory, Supplier<DLModel> itemModelFactory) {
        if (blockModelFactory != null) {
            customModels.add(new BlockModelFactory(block, blockModelFactory));
        }
        if (itemModelFactory != null) {
            customModels.add(new BlockItemModelFactory(() -> ((Block)block.get()).m_49966_(), itemModelFactory));
        }
    }

    public static void registerForStates(Supplier<Collection<BlockState>> blockStates, Supplier<DLModel> modelFactory) {
        customModels.add(new BlockStateModelFactory(blockStates, modelFactory));
    }

    public static void registerForBlockItem(Supplier<BlockState> itemBlockState, Supplier<DLModel> modelFactory) {
        customModels.add(new BlockItemModelFactory(itemBlockState, modelFactory));
    }

    public static Queue<ICustomModelFactory> getCustomRegisteredModels(Map<ResourceLocation, BakedModel> registry) {
        return new LinkedBlockingQueue<ICustomModelFactory>(customModels);
    }

    public static ImmutableMap<ResourceLocation, ModelRegistryData> getCustomRegisteredModelsMapped() {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        while (!customModels.isEmpty()) {
            ICustomModelFactory factory = customModels.poll();
            if (factory.getModelFactory() == null) continue;
            for (BlockState state : factory.getStates()) {
                ModelResourceLocation location = BlockModelShaper.m_110895_((BlockState)state);
                if (factory.getType() == DLModel.ModelType.ITEM) {
                    location = new ModelResourceLocation((ResourceLocation)location, "inventory");
                }
                builder.put((Object)location, (Object)new ModelRegistryData(factory, state));
            }
        }
        return builder.build();
    }

    @ApiStatus.Internal
    public static void setOriginalModel(BlockState state, BakedModel model) {
        originalModels.computeIfAbsent(state, s -> model);
    }

    public static BakedModel getOriginalModel(BlockState state) {
        if (originalModels.containsKey(state)) {
            return originalModels.get(state);
        }
        return Minecraft.m_91087_().m_91304_().m_119430_().m_110893_(state);
    }

    public void m_6213_(ResourceManager resourceManager) {
    }

    private static class BlockModelFactory
    extends AbstractModelFactory {
        private final Supplier<Block> block;

        public BlockModelFactory(Supplier<Block> block, Supplier<DLModel> modelFactory) {
            super(modelFactory);
            this.block = block;
        }

        @Override
        public Collection<BlockState> getStates() {
            return this.block.get().m_49965_().m_61056_();
        }

        @Override
        public DLModel.ModelType getType() {
            return DLModel.ModelType.BLOCK;
        }
    }

    private static class BlockItemModelFactory
    extends AbstractModelFactory {
        private final Supplier<BlockState> itemBlockState;

        public BlockItemModelFactory(Supplier<BlockState> itemBlockState, Supplier<DLModel> modelFactory) {
            super(modelFactory);
            this.itemBlockState = itemBlockState;
        }

        @Override
        public Collection<BlockState> getStates() {
            return List.of(this.itemBlockState.get());
        }

        @Override
        public DLModel.ModelType getType() {
            return DLModel.ModelType.ITEM;
        }
    }

    private static class BlockStateModelFactory
    extends AbstractModelFactory {
        private final Supplier<Collection<BlockState>> blockStates;

        public BlockStateModelFactory(Supplier<Collection<BlockState>> blockStates, Supplier<DLModel> modelFactory) {
            super(modelFactory);
            this.blockStates = blockStates;
        }

        @Override
        public Collection<BlockState> getStates() {
            return this.blockStates.get();
        }

        @Override
        public DLModel.ModelType getType() {
            return DLModel.ModelType.BLOCK;
        }
    }

    public static interface ICustomModelFactory {
        public Collection<BlockState> getStates();

        public Supplier<DLModel> getModelFactory();

        public DLModel.ModelType getType();
    }

    public record ModelRegistryData(ICustomModelFactory factory, BlockState state) {
        @Override
        public final int hashCode() {
            return this.factory.hashCode();
        }

        @Override
        public final boolean equals(Object obj) {
            if (obj instanceof ModelRegistryData) {
                ModelRegistryData o = (ModelRegistryData)obj;
                return this.factory == o.factory;
            }
            return false;
        }
    }

    private static abstract class AbstractModelFactory
    implements ICustomModelFactory {
        private final Supplier<DLModel> modelFactory;

        public AbstractModelFactory(Supplier<DLModel> modelFactory) {
            this.modelFactory = modelFactory;
        }

        @Override
        public Supplier<DLModel> getModelFactory() {
            return this.modelFactory;
        }
    }
}

