/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.mcdragonlib.client.model.mesh;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import de.mrjulsen.mcdragonlib.client.ber.BERGraphics;
import de.mrjulsen.mcdragonlib.client.model.ModelUtils;
import de.mrjulsen.mcdragonlib.client.model.extension.DLBakedQuad;
import de.mrjulsen.mcdragonlib.client.model.mesh.CornerType;
import de.mrjulsen.mcdragonlib.client.model.mesh.Edge;
import de.mrjulsen.mcdragonlib.client.model.mesh.EdgeType;
import de.mrjulsen.mcdragonlib.client.model.mesh.FaceVertex;
import de.mrjulsen.mcdragonlib.client.model.mesh.ITransformable;
import de.mrjulsen.mcdragonlib.client.model.mesh.Rotation;
import de.mrjulsen.mcdragonlib.client.model.mesh.Vertex;
import de.mrjulsen.mcdragonlib.client.util.DLGraphics;
import de.mrjulsen.mcdragonlib.util.DLColor;
import de.mrjulsen.mcdragonlib.util.Pair;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.UnaryOperator;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.ModelBlockRenderer;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix3f;
import org.joml.Matrix4f;
import org.joml.Vector2f;
import org.joml.Vector2i;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class Face
implements ITransformable<Face> {
    private final List<FaceVertex> corners = Arrays.asList(new FaceVertex[CornerType.values().length]);
    private final List<Edge> edges = Arrays.asList(new Edge[EdgeType.values().length]);
    private TextureAtlasSprite sprite;
    private ResourceLocation texture;
    private DLColor color = DLColor.WHITE;
    private int tintIndex = -1;
    private Direction normalDirection;
    private Direction cullface = null;
    private boolean isShade = true;
    private RenderType renderType = RenderType.m_110451_();
    private boolean useAlternateSplitLine = false;
    private boolean ambientOcclusion = true;
    private boolean emissive = false;
    private List<String> tags = List.of();
    private Direction overrideNormalDirection;

    public Face(Vector3f[] positions) {
        if (positions.length != CornerType.values().length) {
            throw new IllegalArgumentException("A Face must have exactly " + CornerType.values().length + " vertices!");
        }
        for (int i = 0; i < positions.length; ++i) {
            this.corners.set(i, new FaceVertex(new Vertex(positions[i], new Vector3f(), DLColor.WHITE), CornerType.getByIndex(i).uv(), new int[]{0, 0}));
        }
        this.setTexture((TextureAtlasSprite)Minecraft.m_91087_().m_91258_(InventoryMenu.f_39692_).apply(new ResourceLocation("dragonlib", "block/white")));
        this.createEdges();
        Vector3f normal = this.recalculateNormals();
        this.normalDirection = Direction.m_122372_((float)normal.x(), (float)normal.y(), (float)normal.z());
    }

    public Face(BakedQuad quad, Direction cullface) {
        int[] vertexData = quad.m_111303_();
        float[] pos = new float[3];
        float[] normal = new float[3];
        int[] vertexColor = new int[4];
        int[] light = new int[2];
        float[] uv = new float[2];
        float u0 = quad.m_173410_().m_118409_();
        float v0 = quad.m_173410_().m_118411_();
        float u1 = quad.m_173410_().m_118410_();
        float v1 = quad.m_173410_().m_118412_();
        float spriteW = u1 - u0;
        float spriteH = v1 - v0;
        if (quad instanceof DLBakedQuad) {
            DLBakedQuad ext = (DLBakedQuad)quad;
            this.ambientOcclusion = ext.isAmbientOcclusion();
            this.emissive = ext.isEmissive();
            this.tags = new ArrayList<String>(ext.getTags());
        }
        for (int i = 0; i < this.corners.size(); ++i) {
            ModelUtils.unpackPosition(vertexData, pos, i);
            ModelUtils.unpackNormals(vertexData, normal, i);
            ModelUtils.unpackColor(vertexData, vertexColor, i);
            ModelUtils.unpackLight(vertexData, light, i);
            ModelUtils.unpackUV(vertexData, uv, i);
            float lU = uv[0] - u0;
            float lV = uv[1] - v0;
            FaceVertex corner = new FaceVertex(new Vertex(pos, normal, vertexColor), new float[]{1.0f / spriteW * lU, 1.0f / spriteH * lV}, light);
            this.corners.set(i, corner);
        }
        this.createEdges();
        this.recalculateNormals();
        this.normalDirection = quad.m_111306_();
        this.cullface = cullface;
        this.isShade = quad.m_111307_();
        this.sprite = quad.m_173410_();
        this.tintIndex = quad.m_111305_();
    }

    private void createEdges() {
        for (int i = 0; i < this.corners.size(); ++i) {
            CornerType currentCorner = CornerType.getByIndex(i);
            CornerType nextCorner = CornerType.getByIndex((i + 1) % this.corners.size());
            this.edges.set(i, new Edge(this.getCorner(currentCorner).getVertex(), this.getCorner(nextCorner).getVertex()));
        }
    }

    public static Face createFace(Direction dir, Vector3f position, float width, float height) {
        return Face.createFace(dir, position.x(), position.y(), position.z(), width, height);
    }

    public static Face createFace(Direction dir, float x, float y, float z, float width, float height) {
        Vector3f[] positions = new Vector3f[4];
        switch (dir) {
            case SOUTH: {
                positions[0] = new Vector3f(x, y + height, z);
                positions[1] = new Vector3f(x, y, z);
                positions[2] = new Vector3f(x + width, y, z);
                positions[3] = new Vector3f(x + width, y + height, z);
                break;
            }
            case NORTH: {
                positions[0] = new Vector3f(x + width, y + height, z);
                positions[1] = new Vector3f(x + width, y, z);
                positions[2] = new Vector3f(x, y, z);
                positions[3] = new Vector3f(x, y + height, z);
                break;
            }
            case EAST: {
                positions[0] = new Vector3f(x, y + height, z + width);
                positions[1] = new Vector3f(x, y, z + width);
                positions[2] = new Vector3f(x, y, z);
                positions[3] = new Vector3f(x, y + height, z);
                break;
            }
            case WEST: {
                positions[0] = new Vector3f(x, y + height, z);
                positions[1] = new Vector3f(x, y, z);
                positions[2] = new Vector3f(x, y, z + width);
                positions[3] = new Vector3f(x, y + height, z + width);
                break;
            }
            case UP: {
                positions[0] = new Vector3f(x, y, z);
                positions[1] = new Vector3f(x, y, z + height);
                positions[2] = new Vector3f(x + width, y, z + height);
                positions[3] = new Vector3f(x + width, y, z);
                break;
            }
            case DOWN: {
                positions[0] = new Vector3f(x, y, z + height);
                positions[1] = new Vector3f(x, y, z);
                positions[2] = new Vector3f(x + width, y, z);
                positions[3] = new Vector3f(x + width, y, z + height);
            }
        }
        Face face = new Face(positions);
        return face;
    }

    public void autoSetCullface(float threshold) {
        boolean withinBlock;
        Vector3f n = this.recalculateNormals();
        Direction direction = Direction.m_122372_((float)n.x, (float)n.y, (float)n.z);
        if (direction == null) {
            return;
        }
        Vector3f p0 = this.getVertexPos(CornerType.TOP_LEFT);
        Vector3f p1 = this.getVertexPos(CornerType.BOTTOM_LEFT);
        Vector3f p2 = this.getVertexPos(CornerType.BOTTOM_RIGHT);
        Vector3f p3 = this.getVertexPos(CornerType.TOP_RIGHT);
        float minX = Math.min(Math.min(p0.x, p1.x), Math.min(p2.x, p3.x));
        float maxX = Math.max(Math.max(p0.x, p1.x), Math.max(p2.x, p3.x));
        float minY = Math.min(Math.min(p0.y, p1.y), Math.min(p2.y, p3.y));
        float maxY = Math.max(Math.max(p0.y, p1.y), Math.max(p2.y, p3.y));
        float minZ = Math.min(Math.min(p0.z, p1.z), Math.min(p2.z, p3.z));
        float maxZ = Math.max(Math.max(p0.z, p1.z), Math.max(p2.z, p3.z));
        float width = 0.0f;
        float height = 0.0f;
        float expectedPlane = 0.0f;
        float planeValue = 0.0f;
        switch (direction) {
            case UP: {
                width = maxX - minX;
                height = maxZ - minZ;
                planeValue = maxY;
                expectedPlane = 1.0f;
                break;
            }
            case DOWN: {
                width = maxX - minX;
                height = maxZ - minZ;
                planeValue = minY;
                expectedPlane = 0.0f;
                break;
            }
            case NORTH: {
                width = maxX - minX;
                height = maxY - minY;
                planeValue = minZ;
                expectedPlane = 0.0f;
                break;
            }
            case SOUTH: {
                width = maxX - minX;
                height = maxY - minY;
                planeValue = maxZ;
                expectedPlane = 1.0f;
                break;
            }
            case EAST: {
                width = maxZ - minZ;
                height = maxY - minY;
                planeValue = maxX;
                expectedPlane = 1.0f;
                break;
            }
            case WEST: {
                width = maxZ - minZ;
                height = maxY - minY;
                planeValue = minX;
                expectedPlane = 0.0f;
            }
        }
        boolean isFullSize = Math.abs(width - 1.0f) <= threshold && Math.abs(height - 1.0f) <= threshold;
        boolean isOnBlockBorder = Math.abs(planeValue - expectedPlane) <= threshold;
        boolean bl = withinBlock = minX >= -threshold && maxX <= 1.0f + threshold && minY >= -threshold && maxY <= 1.0f + threshold && minZ >= -threshold && maxZ <= 1.0f + threshold;
        if (isFullSize && isOnBlockBorder && withinBlock) {
            this.setCullface(direction);
        }
    }

    public List<BakedQuad> build() {
        FaceVertex[] corners2;
        FaceVertex[] corners1;
        boolean isPlanar = this.checkIsPlanar();
        if (isPlanar) {
            BakedQuad singleQuad = this.buildSingleQuad((FaceVertex[])this.corners.toArray(FaceVertex[]::new));
            return List.of(singleQuad);
        }
        ArrayList<BakedQuad> resultQuads = new ArrayList<BakedQuad>(2);
        FaceVertex v0 = this.corners.get(0);
        FaceVertex v1 = this.corners.get(1);
        FaceVertex v2 = this.corners.get(2);
        FaceVertex v3 = this.corners.get(3);
        if (!this.useAlternateSplitLine) {
            corners1 = new FaceVertex[]{v0, v1, v2, v2};
            corners2 = new FaceVertex[]{v0, v0, v2, v3};
        } else {
            corners1 = new FaceVertex[]{v0, v0, v1, v3};
            corners2 = new FaceVertex[]{v1, v1, v2, v3};
        }
        resultQuads.add(this.buildSingleQuad(corners1));
        resultQuads.add(this.buildSingleQuad(corners2));
        return resultQuads;
    }

    private boolean checkIsPlanar() {
        Vector3f vecToP3;
        Vector3f vecB;
        if (this.corners.size() < 4) {
            return true;
        }
        float EPSILON = 1.0E-5f;
        Vector3f p0 = new Vector3f(this.corners.get(0).getVertex().getPosAsArray());
        Vector3f p1 = new Vector3f(this.corners.get(1).getVertex().getPosAsArray());
        Vector3f p2 = new Vector3f(this.corners.get(2).getVertex().getPosAsArray());
        Vector3f p3 = new Vector3f(this.corners.get(3).getVertex().getPosAsArray());
        Vector3f vecA = new Vector3f((Vector3fc)p1).sub((Vector3fc)p0);
        Vector3f planeNormal = new Vector3f((Vector3fc)vecA).cross((Vector3fc)(vecB = new Vector3f((Vector3fc)p2).sub((Vector3fc)p0)));
        return Math.abs(planeNormal.dot((Vector3fc)(vecToP3 = new Vector3f((Vector3fc)p3).sub((Vector3fc)p0)))) < 1.0E-5f;
    }

    private BakedQuad buildSingleQuad(FaceVertex[] specificCorners) {
        if (this.getSprite().isEmpty()) {
            throw new IllegalStateException("Cannot create BakedQuad without a texture sprite.");
        }
        Vector3f normal = ModelUtils.fillNormal(specificCorners);
        Direction normalDir = Direction.m_122372_((float)normal.x, (float)normal.y, (float)normal.z);
        int[] vertexData = new int[specificCorners.length * 8];
        float spriteW = this.sprite.m_118410_() - this.sprite.m_118409_();
        float spriteH = this.sprite.m_118412_() - this.sprite.m_118411_();
        for (int i = 0; i < specificCorners.length; ++i) {
            FaceVertex corner = specificCorners[i];
            DLColor col = DLColor.mixTint(this.getColor(), corner.getVertex().getColor());
            int[] colorArray = new int[]{col.getRed(), col.getGreen(), col.getBlue(), col.getAlpha()};
            float[] uv = new float[]{this.sprite.m_118409_() + spriteW * corner.getU(), this.sprite.m_118411_() + spriteH * corner.getV()};
            ModelUtils.packPosition(corner.getVertex().getPosAsArray(), vertexData, i);
            ModelUtils.packUV(uv, vertexData, i);
            ModelUtils.packNormals(corner.getVertex().getNormalAsArray(), vertexData, i);
            ModelUtils.packColor(colorArray, vertexData, i);
            ModelUtils.packLight(corner.getLightAsArray(), vertexData, i);
        }
        return DLBakedQuad.create(vertexData, this.getTintIndex(), this.hasOverrideNormalDirection() ? this.overrideNormalDirection : normalDir, this.getSprite().orElse((TextureAtlasSprite)Minecraft.m_91087_().m_91258_(InventoryMenu.f_39692_).apply(this.getTextureLocation())), this.isShade(), this.ambientOcclusion, this.emissive, List.copyOf(this.tags));
    }

    @Override
    public List<? extends FaceVertex> getTransformableElements() {
        return this.corners;
    }

    public FaceVertex getCorner(CornerType corner) {
        return this.corners.get(corner.index());
    }

    public ImmutableList<FaceVertex> getCorners() {
        return ImmutableList.copyOf(this.corners);
    }

    public Edge getEdge(EdgeType edge) {
        return this.edges.get(edge.index());
    }

    public ImmutableList<Edge> getEdges() {
        return ImmutableList.copyOf(this.edges);
    }

    public Pair<Edge, Edge> getEdgesAtCorner(CornerType corner) {
        return new Pair<Edge, Edge>(this.edges.get((corner.index() + 1) % EdgeType.values().length), this.edges.get(corner.index()));
    }

    void updateVertices(UnaryOperator<Vertex> replaceFunc) {
        for (FaceVertex wrapper : this.corners) {
            wrapper.updateVertex((Vertex)replaceFunc.apply(wrapper.getVertex()));
        }
    }

    void updateEdges(UnaryOperator<Edge> replaceFunc) {
        for (int i = 0; i < this.edges.size(); ++i) {
            this.edges.set(i, (Edge)replaceFunc.apply(this.edges.get(i)));
        }
    }

    public Optional<TextureAtlasSprite> getSprite() {
        return Optional.ofNullable(this.sprite);
    }

    public ResourceLocation getTextureLocation() {
        return this.getSprite().map(x -> x.m_245424_().m_246162_()).orElse(this.texture);
    }

    public Direction getCullface() {
        return this.cullface;
    }

    public RenderType getRenderType() {
        return this.renderType;
    }

    public int getTintIndex() {
        return this.tintIndex;
    }

    public Direction getNormalDirection() {
        return this.hasOverrideNormalDirection() ? this.overrideNormalDirection : this.normalDirection;
    }

    public boolean hasOverrideNormalDirection() {
        return this.overrideNormalDirection != null;
    }

    public boolean isShade() {
        return this.isShade;
    }

    public boolean useAlternateSplitLine() {
        return this.useAlternateSplitLine;
    }

    public boolean isEmissive() {
        return this.emissive;
    }

    public boolean useAmbientOcclusion() {
        return this.ambientOcclusion;
    }

    public void setTexture(TextureAtlasSprite sprite) {
        Objects.requireNonNull(sprite);
        this.sprite = sprite;
        this.texture = null;
    }

    public void setTexture(ResourceLocation texture) {
        Objects.requireNonNull(texture);
        this.texture = texture;
        this.sprite = null;
    }

    public void setRenderType(RenderType type) {
        this.renderType = type;
    }

    public void setCullface(Direction direction) {
        this.cullface = direction;
    }

    public void setTintIndex(int index) {
        this.tintIndex = index;
    }

    public void setOverwriteNormalDirection(Direction direction) {
        this.overrideNormalDirection = direction;
    }

    public void setShade(boolean b) {
        this.isShade = b;
    }

    public void setUseAlternateSplitLine(boolean b) {
        this.useAlternateSplitLine = b;
    }

    public void setEmissive(boolean b) {
        this.emissive = b;
    }

    public void setAmbientOcclusion(boolean b) {
        this.ambientOcclusion = b;
    }

    public List<String> getTags() {
        return this.tags;
    }

    public DLColor getColor() {
        return this.color;
    }

    public Vector3f getVertexPos(CornerType corner) {
        return this.getCorner(corner).getVertex().getPos();
    }

    public Vector3f[] getVertexPositionArray() {
        Vector3f[] array = new Vector3f[CornerType.values().length];
        for (CornerType type : CornerType.values()) {
            array[type.index()] = this.getVertexPos(type);
        }
        return array;
    }

    public Vector2f getTextureUV(CornerType corner) {
        return this.getCorner(corner).getUV();
    }

    public Vector2i getLight(CornerType corner) {
        return this.getCorner(corner).getLight();
    }

    public void setLight(int packedLight) {
        for (FaceVertex vertex : this.corners) {
            vertex.setLight(packedLight);
        }
    }

    public void setColor(DLColor color) {
        this.color = color;
    }

    @Override
    public Vector3f center() {
        Vector3f center = new Vector3f();
        for (FaceVertex v : this.corners) {
            center.add((Vector3fc)v.getVertex().getPos());
        }
        center.div(4.0f);
        return center;
    }

    public Vector3f getNormal() {
        Vector3f edge1 = new Vector3f((Vector3fc)this.corners.get(1).getVertex().getPos()).sub((Vector3fc)this.corners.get(0).getVertex().getPos());
        Vector3f edge2 = new Vector3f((Vector3fc)this.corners.get(2).getVertex().getPos()).sub((Vector3fc)this.corners.get(0).getVertex().getPos());
        Vector3f normal = edge1.cross((Vector3fc)edge2).normalize();
        return normal;
    }

    public Vector3f recalculateNormals() {
        Vector3f normal = this.getNormal();
        for (FaceVertex v : this.corners) {
            v.getVertex().getNormal().set((Vector3fc)normal);
        }
        return normal;
    }

    public Direction getFacingDirection() {
        Vector3f normal = this.recalculateNormals();
        return Direction.m_122372_((float)normal.x(), (float)normal.y(), (float)normal.z());
    }

    public void autoUV() {
        this.autoUV(CornerType.TOP_LEFT, 1.0f);
    }

    public void autoUV(CornerType align, float scale) {
        float v1;
        float u1;
        float v0;
        float u0;
        float leftLen = this.getEdge(EdgeType.LEFT).length();
        float rightLen = this.getEdge(EdgeType.RIGHT).length();
        float topLen = this.getEdge(EdgeType.TOP).length();
        float bottomLen = this.getEdge(EdgeType.BOTTOM).length();
        float width = Math.min(Math.max(Math.min(topLen, bottomLen) / scale, 0.0f), 1.0f);
        float height = Math.min(Math.max(Math.min(leftLen, rightLen) / scale, 0.0f), 1.0f);
        switch (align) {
            case TOP_LEFT: {
                u0 = 0.0f;
                v0 = 0.0f;
                u1 = width;
                v1 = height;
                break;
            }
            case TOP_RIGHT: {
                u1 = 1.0f;
                v0 = 0.0f;
                u0 = 1.0f - width;
                v1 = height;
                break;
            }
            case BOTTOM_LEFT: {
                u0 = 0.0f;
                v1 = 1.0f;
                u1 = width;
                v0 = 1.0f - height;
                break;
            }
            case BOTTOM_RIGHT: {
                u1 = 1.0f;
                v1 = 1.0f;
                u0 = 1.0f - width;
                v0 = 1.0f - height;
                break;
            }
            default: {
                u0 = 0.0f;
                v0 = 0.0f;
                u1 = width;
                v1 = height;
            }
        }
        for (CornerType corner : CornerType.values()) {
            float u = switch (corner) {
                default -> throw new IncompatibleClassChangeError();
                case CornerType.TOP_LEFT, CornerType.BOTTOM_LEFT -> u0;
                case CornerType.TOP_RIGHT, CornerType.BOTTOM_RIGHT -> u1;
            };
            float v = switch (corner) {
                default -> throw new IncompatibleClassChangeError();
                case CornerType.TOP_LEFT, CornerType.TOP_RIGHT -> v0;
                case CornerType.BOTTOM_LEFT, CornerType.BOTTOM_RIGHT -> v1;
            };
            this.getCorner(corner).setUV(new Vector2f(u, v));
        }
    }

    public void rotateTexture(Rotation rotation) {
        int i;
        int VERTEX_COUNT = this.corners.size();
        int shift = (rotation.getIterations() % VERTEX_COUNT + VERTEX_COUNT) % VERTEX_COUNT;
        FaceVertex[] original = new FaceVertex[VERTEX_COUNT];
        for (i = 0; i < VERTEX_COUNT; ++i) {
            original[i] = this.corners.get(i);
        }
        for (i = 0; i < VERTEX_COUNT; ++i) {
            int newIndex = (i + shift) % VERTEX_COUNT;
            this.corners.set(newIndex, original[i]);
        }
    }

    private static int getBlockLight(int packedLight) {
        return packedLight & 0xFFFF;
    }

    private static int getSkyLight(int packedLight) {
        return packedLight >> 16 & 0xFFFF;
    }

    public void render(DLGraphics graphics) {
        this.render(graphics, graphics.packedLight(), OverlayTexture.f_118083_, this.isShade(), graphics instanceof BERGraphics);
    }

    public void render(DLGraphics graphics, int light, boolean ambientOcclusion) {
        this.render(graphics, light, OverlayTexture.f_118083_, ambientOcclusion, graphics instanceof BERGraphics);
    }

    public void render(DLGraphics graphics, int packedLight, int packedOverlay, boolean ambientOcclusion, boolean transformForBER) {
        if (this.getSprite().isEmpty() && this.texture == null) {
            return;
        }
        TextureAtlasSprite sprite = this.getSprite().orElse(null);
        VertexConsumer consumer = sprite != null ? graphics.multiBufferSource().m_6299_(this.renderType) : graphics.vertexConsumer(this.getTextureLocation());
        if (this.checkIsPlanar()) {
            FaceVertex[] quadVertices = (FaceVertex[])this.corners.toArray(FaceVertex[]::new);
            this.renderQuad(consumer, graphics, packedLight, packedOverlay, ambientOcclusion, sprite, quadVertices, transformForBER);
        } else {
            FaceVertex v0 = this.corners.get(0);
            FaceVertex v1 = this.corners.get(1);
            FaceVertex v2 = this.corners.get(2);
            FaceVertex v3 = this.corners.get(3);
            if (!this.useAlternateSplitLine) {
                this.renderQuad(consumer, graphics, packedLight, packedOverlay, ambientOcclusion, sprite, new FaceVertex[]{v0, v1, v2, v2}, transformForBER);
                this.renderQuad(consumer, graphics, packedLight, packedOverlay, ambientOcclusion, sprite, new FaceVertex[]{v0, v2, v3, v3}, transformForBER);
            } else {
                this.renderQuad(consumer, graphics, packedLight, packedOverlay, ambientOcclusion, sprite, new FaceVertex[]{v0, v1, v3, v3}, transformForBER);
                this.renderQuad(consumer, graphics, packedLight, packedOverlay, ambientOcclusion, sprite, new FaceVertex[]{v1, v2, v3, v3}, transformForBER);
            }
        }
    }

    private void renderQuad(VertexConsumer consumer, DLGraphics graphics, int packedLight, int packedOverlay, boolean ambientOcclusion, @Nullable TextureAtlasSprite sprite, FaceVertex[] quadVertices, boolean transformForBER) {
        BERGraphics berGraphics;
        if (quadVertices.length != 4) {
            return;
        }
        PoseStack.Pose lastPose = graphics.poseStack().m_85850_();
        Matrix4f poseMatrix = lastPose.m_252922_();
        Matrix3f normalMatrix = lastPose.m_252943_();
        float atlasU0 = sprite != null ? sprite.m_118409_() : 0.0f;
        float atlasV0 = sprite != null ? sprite.m_118411_() : 0.0f;
        float atlasUWidth = sprite != null ? sprite.m_118410_() - sprite.m_118409_() : 1.0f;
        float atlasVHeight = sprite != null ? sprite.m_118412_() - sprite.m_118411_() : 1.0f;
        float r = this.color.getRedF();
        float g = this.color.getGreenF();
        float b = this.color.getBlueF();
        float a = this.color.getAlphaF();
        float[] brightness = new float[]{1.0f, 1.0f, 1.0f, 1.0f};
        int[] lightmap = new int[]{packedLight, packedLight, packedLight, packedLight};
        if (ambientOcclusion && ((Boolean)Minecraft.m_91087_().f_91066_.m_232070_().m_231551_()).booleanValue() && graphics instanceof BERGraphics && (berGraphics = (BERGraphics)graphics).blockEntity() != null && berGraphics.blockEntity().m_58904_() != null && berGraphics.blockEntity().m_58899_() != null) {
            try {
                ModelBlockRenderer.AmbientOcclusionFace ao = new ModelBlockRenderer.AmbientOcclusionFace();
                Level batg = berGraphics.blockEntity().m_58904_();
                BlockPos pos = berGraphics.blockEntity().m_58899_();
                float[] tempAfloat = new float[Direction.values().length * 2];
                BitSet tempBitSet = new BitSet(3);
                ao.m_111167_((BlockAndTintGetter)batg, berGraphics.blockEntity().m_58900_(), pos, this.getFacingDirection(), tempAfloat, tempBitSet, true);
                for (int i = 0; i < 4; ++i) {
                    brightness[i] = ao.f_111149_[i];
                    lightmap[i] = ao.f_111150_[i];
                }
            }
            catch (Exception ao) {
                // empty catch block
            }
        }
        float scaleXZ = transformForBER ? 16.0f : 1.0f;
        float scaleY = transformForBER ? -16.0f : 1.0f;
        for (int i = 0; i < 4; ++i) {
            FaceVertex fv = quadVertices[i];
            Vertex v = fv.getVertex();
            DLColor vColor = v.getColor();
            float finalR = r * brightness[i] * vColor.getRedF();
            float finalG = g * brightness[i] * vColor.getGreenF();
            float finalB = b * brightness[i] * vColor.getBlueF();
            float finalA = a * vColor.getAlphaF();
            float finalU = atlasU0 + fv.getU() * atlasUWidth;
            float finalV = atlasV0 + fv.getV() * atlasVHeight;
            Vector3f pos = v.getPos();
            float correctedX = pos.x() * scaleXZ;
            float correctedZ = pos.z() * scaleXZ;
            float correctedY = pos.y() * scaleY;
            consumer.m_252986_(poseMatrix, correctedX, correctedY, correctedZ);
            consumer.m_85950_(finalR, finalG, finalB, finalA);
            consumer.m_7421_(finalU, finalV);
            consumer.m_7120_(Face.getBlockLight(lightmap[i]), Face.getSkyLight(lightmap[i]));
            consumer.m_86008_(packedOverlay);
            Vector3f normal = v.getNormal();
            consumer.m_252939_(normalMatrix, normal.x(), normal.y(), normal.z());
            consumer.m_5752_();
        }
    }
}

