/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.mcdragonlib.client.model.mesh;

import de.mrjulsen.mcdragonlib.client.model.ModelUtils;
import de.mrjulsen.mcdragonlib.client.model.mesh.IVertexElement;
import java.util.List;
import net.minecraft.core.Direction;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix4f;
import org.joml.Quaternionf;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.joml.Vector4f;

public interface ITransformable<T extends ITransformable<T>> {
    public List<? extends IVertexElement> getTransformableElements();

    default public void translate(float x, float y, float z) {
        this.translate(new Vector3f(x, y, z));
    }

    default public void translate(Vector3f delta) {
        for (IVertexElement vertex : this.getTransformableElements()) {
            vertex.getPos().add((Vector3fc)delta);
        }
    }

    default public void scale(float x, float y, float z, Vector3f pivot) {
        this.scale(new Vector3f(x, y, z), pivot);
    }

    default public void scale(Vector3f factor, Vector3f pivot) {
        for (IVertexElement v : this.getTransformableElements()) {
            v.getPos().sub((Vector3fc)pivot).mul((Vector3fc)factor).add((Vector3fc)pivot);
        }
    }

    default public void rotate(Quaternionf rotation, Vector3f pivot) {
        for (IVertexElement v : this.getTransformableElements()) {
            Vector3f relative = new Vector3f((Vector3fc)v.getPos()).sub((Vector3fc)pivot);
            rotation.transform(relative);
            v.getPos().set((Vector3fc)relative.add((Vector3fc)pivot));
        }
    }

    default public void rotateTo(Vector3f direction, Vector3f pivot) {
        Vector3f dir = new Vector3f((Vector3fc)direction).normalize();
        float yaw = (float)Math.atan2(-dir.x, -dir.z);
        float pitch = (float)Math.asin(dir.y);
        this.rotate(new Quaternionf().rotateY(yaw).rotateX(pitch), pivot);
    }

    default public void transform(Matrix4f matrix) {
        for (IVertexElement v : this.getTransformableElements()) {
            Vector4f temp = new Vector4f((Vector3fc)v.getPos(), 1.0f);
            matrix.transform(temp);
            v.getPos().set(temp.x(), temp.y(), temp.z());
        }
    }

    default public boolean overlaps(T other, float threshold) {
        if (other == this) {
            return false;
        }
        for (int i = 0; i < this.getTransformableElements().size(); ++i) {
            IVertexElement s = this.getTransformableElements().get(i);
            IVertexElement o = other.getTransformableElements().get(i);
            if (ModelUtils.positionsIntersect(s.getPos(), o.getPos(), threshold)) continue;
            return false;
        }
        return true;
    }

    default public Vector3f center() {
        Vector3f center = new Vector3f();
        List<IVertexElement> elements = this.getTransformableElements();
        if (elements.isEmpty()) {
            return center;
        }
        for (IVertexElement v : elements) {
            center.add((Vector3fc)v.getPos());
        }
        center.div((float)elements.size());
        return center;
    }

    default public void centerTo(Vector3f target) {
        Vector3f currentCenter = this.center();
        Vector3f delta = new Vector3f((Vector3fc)target).sub((Vector3fc)currentCenter);
        this.translate(delta);
    }

    default public void projectOntoPlane(Vector3f planeNormal, Vector3f planePoint) {
        Vector3f n = new Vector3f((Vector3fc)planeNormal).normalize();
        for (IVertexElement v : this.getTransformableElements()) {
            Vector3f p = v.getPos();
            Vector3f toPoint = new Vector3f((Vector3fc)p).sub((Vector3fc)planePoint);
            float distance = toPoint.dot((Vector3fc)n);
            Vector3f projection = new Vector3f((Vector3fc)n).mul(distance);
            p.sub((Vector3fc)projection);
        }
    }

    default public void mirror(Direction.Axis axis, float pivot) {
        for (IVertexElement v : this.getTransformableElements()) {
            Vector3f pos = v.getPos();
            switch (axis) {
                case X: {
                    pos.x = pivot - (pos.x - pivot);
                    break;
                }
                case Y: {
                    pos.y = pivot - (pos.y - pivot);
                    break;
                }
                case Z: {
                    pos.z = pivot - (pos.z - pivot);
                }
            }
        }
    }

    default public void alignToAxis(Vector3f targetAxis, Vector3f up) {
        Quaternionf rotation = new Quaternionf().rotateTo((Vector3fc)new Vector3f(0.0f, 0.0f, 1.0f), (Vector3fc)targetAxis);
        Vector3f pivot = this.center();
        this.rotate(rotation, pivot);
    }

    default public AABB getBoundingBox() {
        List<IVertexElement> elements = this.getTransformableElements();
        if (elements.isEmpty()) {
            return new AABB(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
        }
        Vector3f min = new Vector3f(Float.POSITIVE_INFINITY);
        Vector3f max = new Vector3f(Float.NEGATIVE_INFINITY);
        for (IVertexElement v : elements) {
            Vector3f pos = v.getPos();
            min.min((Vector3fc)pos);
            max.max((Vector3fc)pos);
        }
        return new AABB(new Vec3(min), new Vec3(max));
    }

    default public void normalize() {
        AABB box = this.getBoundingBox();
        Vector3f min = new Vector3f((float)box.f_82288_, (float)box.f_82289_, (float)box.f_82290_);
        Vector3f max = new Vector3f((float)box.f_82291_, (float)box.f_82292_, (float)box.f_82293_);
        Vector3f size = new Vector3f((Vector3fc)max).sub((Vector3fc)min);
        for (IVertexElement v : this.getTransformableElements()) {
            Vector3f pos = v.getPos();
            pos.sub((Vector3fc)min).div((Vector3fc)size);
        }
    }

    default public void invert() {
        for (IVertexElement v : this.getTransformableElements()) {
            v.getPos().negate();
        }
    }

    default public boolean contains(Vector3f point, float threshold) {
        for (IVertexElement v : this.getTransformableElements()) {
            if (!(v.getPos().distance((Vector3fc)point) < threshold)) continue;
            return true;
        }
        return false;
    }
}

