/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.mcdragonlib.client.model.mesh;

import com.google.common.collect.ImmutableList;
import de.mrjulsen.mcdragonlib.client.model.ModelUtils;
import de.mrjulsen.mcdragonlib.client.model.mesh.Edge;
import de.mrjulsen.mcdragonlib.client.model.mesh.Face;
import de.mrjulsen.mcdragonlib.client.model.mesh.ITransformable;
import de.mrjulsen.mcdragonlib.client.model.mesh.IVertexElement;
import de.mrjulsen.mcdragonlib.client.model.mesh.Vertex;
import de.mrjulsen.mcdragonlib.client.util.DLGraphics;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.Direction;

public abstract class Mesh
implements ITransformable<Mesh> {
    protected final List<Vertex> vertices;
    protected final List<Edge> edges;
    protected final List<Face> faces;

    protected Mesh(List<Vertex> vertices, List<Edge> edges, List<Face> faces) {
        this.vertices = vertices;
        this.edges = edges;
        this.faces = faces;
    }

    @Override
    public List<? extends IVertexElement> getTransformableElements() {
        return this.vertices;
    }

    public void cleanUp() {
        this.cleanUp(1.0E-4f, true, true, true);
    }

    public void cleanUp(float threshold, boolean mergeVertices, boolean mergeEdges, boolean mergeFaces) {
        if (mergeVertices) {
            this.mergeVertices(threshold);
        }
        if (mergeEdges) {
            this.mergeEdges(threshold);
        }
        if (mergeFaces) {
            this.mergeFaces(threshold);
        }
    }

    public Map<Vertex, Vertex> mergeVertices(float threshold) {
        HashMap<Vertex, Vertex> replaced = new HashMap<Vertex, Vertex>(this.vertices.size());
        ArrayList<Vertex> merged = new ArrayList<Vertex>(this.vertices.size());
        for (Vertex v : this.vertices) {
            boolean found = false;
            for (Vertex existing : merged) {
                if (!ModelUtils.positionsIntersect(v.getPos(), existing.getPos(), threshold)) continue;
                replaced.put(v, existing);
                found = true;
                break;
            }
            if (found) continue;
            merged.add(v);
        }
        this.replaceVertices(merged);
        for (Edge edge : this.edges) {
            edge.updateVertices(x -> Mesh.replaceFunc(replaced, x));
        }
        for (Face face : this.faces) {
            face.updateVertices(x -> Mesh.replaceFunc(replaced, x));
        }
        return replaced;
    }

    protected void replaceVertices(List<Vertex> other) {
        this.vertices.clear();
        this.vertices.addAll(other);
    }

    public Map<Edge, Edge> mergeEdges(float threshold) {
        HashMap<Edge, Edge> replaced = new HashMap<Edge, Edge>(this.edges.size());
        ArrayList<Edge> merged = new ArrayList<Edge>(this.edges.size());
        for (Edge v : this.edges) {
            boolean found = false;
            for (Edge existing : merged) {
                if (!v.overlaps(existing, threshold)) continue;
                replaced.put(v, existing);
                found = true;
                break;
            }
            if (found) continue;
            merged.add(v);
        }
        this.replaceEdges(merged);
        for (Face face : this.faces) {
            face.updateEdges(x -> Mesh.replaceFunc(replaced, x));
        }
        return replaced;
    }

    protected void replaceEdges(List<Edge> other) {
        this.edges.clear();
        this.edges.addAll(other);
    }

    public int mergeFaces(float threshold) {
        int currentFaces = this.faces.size();
        ArrayList<Face> uniqueFaces = new ArrayList<Face>(this.faces.size());
        for (Face face : this.faces) {
            boolean found = false;
            for (Face u : uniqueFaces) {
                if (!face.overlaps(u, threshold)) continue;
                found = true;
                break;
            }
            if (found) continue;
            uniqueFaces.add(face);
        }
        this.replaceFaces(uniqueFaces);
        return currentFaces - this.faces.size();
    }

    protected void replaceFaces(List<Face> other) {
        this.faces.clear();
        this.faces.addAll(other);
    }

    protected static <T> T replaceFunc(Map<T, T> replacements, T in) {
        if (replacements.containsKey(in)) {
            return replacements.get(in);
        }
        return in;
    }

    public List<Vertex> getVertices() {
        return Collections.unmodifiableList(this.vertices);
    }

    public List<Edge> getEdges() {
        return Collections.unmodifiableList(this.edges);
    }

    public List<Face> getFaces() {
        return Collections.unmodifiableList(this.faces);
    }

    public List<Face> getFacesOfDirection(Direction direction) {
        if (direction == null) {
            return this.getFaces();
        }
        ImmutableList.Builder builder = ImmutableList.builder();
        for (Face face : this.faces) {
            if (face.getNormalDirection() != direction) continue;
            builder.add((Object)face);
        }
        return builder.build();
    }

    public void render(DLGraphics graphics) {
        this.getFaces().forEach(face -> face.render(graphics));
    }

    public void render(DLGraphics graphics, int light, boolean ambientOcclusion) {
        this.getFaces().forEach(face -> face.render(graphics, light, ambientOcclusion));
    }

    public void render(DLGraphics graphics, int light, int overlay, boolean ambientOcclusion, boolean transformForBER) {
        this.getFaces().forEach(face -> face.render(graphics, light, overlay, ambientOcclusion, transformForBER));
    }
}

