/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.mcdragonlib.client.model.mesh;

import de.mrjulsen.mcdragonlib.client.model.mesh.IVertexElement;
import de.mrjulsen.mcdragonlib.util.DLColor;
import java.util.Objects;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class Vertex
implements IVertexElement {
    private Vector3f pos = new Vector3f();
    private Vector3f normal = new Vector3f();
    private DLColor vertexColor = DLColor.WHITE;

    private Vertex() {
    }

    public Vertex(float[] pos, float[] normal, int[] color) {
        this.pos = new Vector3f(pos);
        this.normal = new Vector3f(normal);
        this.setColor(DLColor.of(color[3], color[0], color[1], color[2]));
    }

    public Vertex(Vector3f pos, Vector3f normal, DLColor color) {
        this.pos = pos;
        this.normal = normal;
        this.vertexColor = color;
    }

    public Vertex copy() {
        Vertex v = new Vertex();
        v.pos = new Vector3f((Vector3fc)this.pos);
        v.normal = new Vector3f((Vector3fc)this.normal);
        v.vertexColor = this.vertexColor;
        return v;
    }

    @Override
    public Vector3f getPos() {
        return this.pos;
    }

    public float[] getPosAsArray() {
        return new float[]{this.getX(), this.getY(), this.getZ()};
    }

    public float getX() {
        return this.getPos().x;
    }

    public float getY() {
        return this.getPos().y;
    }

    public float getZ() {
        return this.getPos().z;
    }

    public Vector3f getNormal() {
        return this.normal;
    }

    public float[] getNormalAsArray() {
        return new float[]{this.getNormal().x, this.getNormal().y, this.getNormal().z};
    }

    public DLColor getColor() {
        return this.vertexColor;
    }

    public int[] getColorRGBAAsArray() {
        return new int[]{this.getColor().getRed(), this.getColor().getGreen(), this.getColor().getBlue(), this.getColor().getAlpha()};
    }

    public void setPos(Vector3f pos) {
        Objects.requireNonNull(pos);
        this.pos = pos;
    }

    public void setPos(float x, float y, float z) {
        this.setPos(new Vector3f(x, y, z));
    }

    public void setX(float x) {
        this.getPos().set(x, this.getPos().y, this.getPos().z);
    }

    public void setY(float y) {
        this.getPos().set(this.getPos().x, y, this.getPos().z);
    }

    public void setZ(float z) {
        this.getPos().set(this.getPos().x, this.getPos().y, z);
    }

    public void setNormal(Vector3f normal) {
        Objects.requireNonNull(normal);
        this.normal = normal;
    }

    public void setColor(DLColor color) {
        Objects.requireNonNull(color);
        this.vertexColor = color;
    }
}

