/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.mcdragonlib.client.render;

import de.mrjulsen.mcdragonlib.client.util.DLGuiGraphics;
import de.mrjulsen.mcdragonlib.client.util.DLSprite;
import de.mrjulsen.mcdragonlib.client.util.DLTexture;
import de.mrjulsen.mcdragonlib.client.util.GuiUtils;
import java.util.Arrays;
import net.minecraft.resources.ResourceLocation;

public enum GuiIcons {
    EMPTY("empty", 0, 0),
    CHECK("check", 1, 0),
    CROSS("cross", 2, 0),
    WARN("warn", 3, 0),
    CHECKMARK("checkmark", 4, 0),
    BULLET("bullet", 5, 0),
    ARROW_DOWN("arrow_down", 6, 0),
    ARROW_UP("arrow_up", 7, 0),
    ARROW_LEFT("arrow_left", 8, 0),
    ARROW_RIGHT("arrow_right", 9, 0),
    X("x", 10, 0);

    private String id;
    private int u;
    private int v;
    public static final int ICON_SIZE = 16;
    public static final DLTexture ICON_TEXTURE;

    private GuiIcons(String id, int u, int v) {
        this.id = id;
        this.u = u;
        this.v = v;
    }

    public String getId() {
        return this.id;
    }

    public int getUMultiplier() {
        return this.u;
    }

    public int getVMultiplier() {
        return this.v;
    }

    public int getU() {
        return this.u * 16;
    }

    public int getV() {
        return this.v * 16;
    }

    public static GuiIcons getByStringId(String id) {
        return Arrays.stream(GuiIcons.values()).filter(x -> x.getId().equals(id)).findFirst().orElse(EMPTY);
    }

    public void render(DLGuiGraphics graphics, int x, int y) {
        GuiUtils.drawTexture(ICON_TEXTURE, graphics, x, y, 16, 16, this.getU(), this.getV());
    }

    public DLSprite getAsSprite(int renderWidth, int renderHeight) {
        return new DLSprite(ICON_TEXTURE, 16, 16, this.getU(), this.getV(), renderWidth, renderHeight);
    }

    static {
        ICON_TEXTURE = new DLTexture(new ResourceLocation("dragonlib", "textures/gui/icons.png"), 256, 256);
    }
}

