/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.mcdragonlib.client.render;

import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.blaze3d.systems.RenderSystem;
import de.mrjulsen.mcdragonlib.client.util.DLGuiGraphics;
import de.mrjulsen.mcdragonlib.client.util.GuiUtils;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.Vec2;

public class MapImage {
    private final Level world;
    private final BlockPos pos;
    private final int yLevel;
    private final int areaWidth;
    private final int areaHeight;
    private final Vec2 centerPosOnMap;
    private final boolean sameLayer;
    private int scale;
    private DynamicTexture texture;

    public MapImage(Level world, BlockPos pos, int yLevel, int width, int height, boolean sameLayer, int scale) {
        this.world = world;
        this.pos = pos;
        this.yLevel = yLevel;
        this.areaWidth = width;
        this.areaHeight = height;
        this.sameLayer = sameLayer;
        this.scale = scale;
        this.centerPosOnMap = new Vec2((float)(this.areaWidth / 2), (float)(this.areaHeight / 2));
    }

    public void bindTexture() {
        if (this.texture == null) {
            this.texture = new DynamicTexture(this.createImage());
        }
        RenderSystem.setShaderTexture((int)0, (int)this.texture.m_117963_());
    }

    public void render(DLGuiGraphics graphics, int x, int y) {
        this.bindTexture();
        GuiUtils.drawTexture(this.texture.m_117963_(), graphics, x, y, this.areaWidth * this.scale, this.areaHeight * this.scale, 0, 0, this.areaWidth, this.areaHeight, GuiUtils.TextureFillMode.STRETCH, this.areaWidth, this.areaHeight);
    }

    public int getWidth() {
        return this.areaWidth;
    }

    public int getHeight() {
        return this.areaHeight;
    }

    public void setScale(int scale) {
        this.scale = scale;
    }

    public int getScale() {
        return this.scale;
    }

    public int getScaledWidth() {
        return this.getWidth() * this.getScale();
    }

    public int getScaledHeight() {
        return this.getHeight() * this.getScale();
    }

    public Vec2 getCenterPosOnMap() {
        return this.centerPosOnMap;
    }

    public void dispose() {
        if (this.texture != null) {
            this.texture.close();
            this.texture = null;
        }
    }

    private NativeImage createImage() {
        NativeImage image = new NativeImage(NativeImage.Format.RGBA, this.areaWidth, this.areaHeight, false);
        int rWidth = this.areaWidth / 2;
        int rHeight = this.areaHeight / 2;
        int minX = this.pos.m_123341_() - rWidth;
        int minZ = this.pos.m_123343_() - rHeight;
        for (int x = 0; x < this.areaWidth; ++x) {
            for (int z = 0; z < this.areaHeight; ++z) {
                int westY;
                int northY;
                BlockPos pos;
                if (this.shouldDrawAtSameLayer()) {
                    pos = this.getFirstBlockGoingDown(minX + x, this.yLevel + 1, minZ + z, 5);
                    northY = this.getFirstBlockGoingDown(minX + x, this.yLevel + 1, minZ + z - 1, 6).m_123342_();
                    westY = this.getFirstBlockGoingDown(minX + x - 1, this.yLevel + 1, minZ + z, 6).m_123342_();
                } else {
                    pos = this.world.m_5452_(Heightmap.Types.WORLD_SURFACE, new BlockPos(minX + x, 0, minZ + z)).m_7495_();
                    northY = this.world.m_6924_(Heightmap.Types.WORLD_SURFACE, pos.m_123341_(), pos.m_123343_() - 1) - 1;
                    westY = this.world.m_6924_(Heightmap.Types.WORLD_SURFACE, pos.m_123341_() - 1, pos.m_123343_()) - 1;
                }
                BlockState state = this.world.m_8055_(pos);
                MapColor color = state.m_284242_((BlockGetter)this.world, pos);
                int rgb = color == null ? MapColor.f_283808_.f_283871_ : color.f_283871_;
                int red = rgb >> 16 & 0xFF;
                int green = rgb >> 8 & 0xFF;
                int blue = rgb & 0xFF;
                if (pos.m_123342_() > northY && northY >= 0 || pos.m_123342_() > westY && westY >= 0) {
                    if (red == 0 && green == 0 && blue == 0) {
                        red = 3;
                        green = 3;
                        blue = 3;
                    } else {
                        if (red > 0 && red < 3) {
                            red = 3;
                        }
                        if (green > 0 && green < 3) {
                            green = 3;
                        }
                        if (blue > 0 && blue < 3) {
                            blue = 3;
                        }
                        red = Math.min((int)((double)red / 0.7), 255);
                        green = Math.min((int)((double)green / 0.7), 255);
                        blue = Math.min((int)((double)blue / 0.7), 255);
                    }
                }
                if (pos.m_123342_() < northY && northY >= 0 || pos.m_123342_() < westY && westY >= 0) {
                    red = Math.max((int)((double)red * 0.7), 0);
                    green = Math.max((int)((double)green * 0.7), 0);
                    blue = Math.max((int)((double)blue * 0.7), 0);
                }
                image.m_84988_(x, z, 0xFF000000 | blue << 16 | green << 8 | red);
            }
        }
        return image;
    }

    private BlockPos getFirstBlockGoingDown(int x, int y, int z, int maxTries) {
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos(x, y, z);
        int tries = 0;
        while (this.world.m_46859_((BlockPos)pos) && ++tries < maxTries) {
            pos.m_142448_(pos.m_123342_() - 1);
        }
        return pos;
    }

    private boolean shouldDrawAtSameLayer() {
        return this.sameLayer || this.world.m_6042_().f_63856_();
    }
}

