/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.mcdragonlib.client.util;

import com.mojang.blaze3d.font.GlyphInfo;
import de.mrjulsen.mcdragonlib.mixin.BakedGlyphAccessor;
import de.mrjulsen.mcdragonlib.mixin.FontAccessor;
import de.mrjulsen.mcdragonlib.mixin.StringSplitterAccessor;
import de.mrjulsen.mcdragonlib.util.TextUtils;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.font.FontSet;
import net.minecraft.client.gui.font.glyphs.BakedGlyph;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.FormattedCharSink;
import net.minecraft.util.StringDecomposer;
import org.apache.commons.lang3.mutable.MutableFloat;

public class FontUtils {
    public Font font;
    public FontSet fontSet;
    protected static final Map<Integer, Deque<UVData>> uvStack = new HashMap<Integer, Deque<UVData>>();

    public FontUtils(ResourceLocation fontStyle) {
        this.font = Minecraft.m_91087_().f_91062_;
        this.fontSet = ((FontAccessor)this.font).dragonlib$invokeGetFontSet(fontStyle);
    }

    private void checkAndUpdateFont() {
        if (this.font != Minecraft.m_91087_().f_91062_) {
            // empty if block
        }
    }

    public BakedGlyphAccessor getGlyphAccessor(int charCode) {
        return (BakedGlyphAccessor)this.getGlyph(charCode);
    }

    public void pushUV(int charCode) {
        BakedGlyphAccessor glyph = this.getGlyphAccessor(charCode);
        this.pushUV(charCode, glyph.dragonlib$getU0(), glyph.dragonlib$getV0(), glyph.dragonlib$getU1(), glyph.dragonlib$getV1());
    }

    protected void pushUV(int charCode, float u0, float v0, float u1, float v1) {
        if (!uvStack.containsKey(charCode)) {
            uvStack.put(charCode, new ArrayDeque());
        }
        uvStack.get(charCode).addLast(new UVData(u0, v0, u1, v1));
    }

    public boolean popUV(int charCode) {
        if (!uvStack.containsKey(charCode)) {
            return false;
        }
        UVData data = uvStack.get(charCode).pollLast();
        if (uvStack.get(charCode).isEmpty()) {
            uvStack.remove(charCode);
        }
        BakedGlyphAccessor glyph = this.getGlyphAccessor(charCode);
        glyph.dragonlib$setU0(data.u0());
        glyph.dragonlib$setV0(data.v0());
        glyph.dragonlib$setU1(data.u1());
        glyph.dragonlib$setV1(data.v1());
        return true;
    }

    public GlyphInfo getGlyphInfo(int charCode) {
        return this.fontSet.m_243128_(charCode, false);
    }

    public BakedGlyph getGlyph(int charCode) {
        return this.fontSet.m_95078_(charCode);
    }

    public void reset() {
        uvStack.clear();
    }

    public static float formattedWidthByIndex(String content, final int index, Style style) {
        final MutableFloat sum = new MutableFloat(0.0f);
        Font font = Minecraft.m_91087_().f_91062_;
        final StringSplitterAccessor accessor = (StringSplitterAccessor)font.m_92865_();
        FormattedCharSink sink = new FormattedCharSink(){

            public boolean m_6411_(int pos, Style s, int codePoint) {
                if (pos >= index) {
                    return false;
                }
                sum.add(accessor.dragonlib$getWidthProvider().m_92515_(codePoint, s));
                return true;
            }
        };
        StringDecomposer.m_14346_((String)content, (Style)style, (FormattedCharSink)sink);
        return sum.floatValue();
    }

    public static FormattedText substring(FormattedText text, int start, int end) {
        AtomicInteger currentIndex = new AtomicInteger(0);
        MutableComponent result = TextUtils.empty();
        text.m_7451_((currentStyle, part) -> {
            int currentIdx = currentIndex.get();
            currentIndex.set(currentIdx + part.length());
            if (currentIndex.get() < start || currentIdx > end) {
                return Optional.empty();
            }
            result.m_7220_((Component)TextUtils.text(part.substring(Math.max(start, currentIdx), Math.min(end, currentIdx + part.length()))).m_130948_(currentStyle));
            return Optional.ofNullable(null);
        }, Style.f_131099_);
        return result;
    }

    public static float formattedWidthByIndex(FormattedText content, int index, Style style) {
        MutableFloat sum = new MutableFloat(0.0f);
        Font font = Minecraft.m_91087_().f_91062_;
        StringSplitterAccessor accessor = (StringSplitterAccessor)font.m_92865_();
        AtomicBoolean finished = new AtomicBoolean(false);
        AtomicInteger currentIndex = new AtomicInteger(0);
        FormattedCharSink sink = (pos, s, codePoint) -> {
            if (currentIndex.getAndIncrement() >= index) {
                finished.set(true);
                return false;
            }
            sum.add(accessor.dragonlib$getWidthProvider().m_92515_(codePoint, s));
            return true;
        };
        content.m_7451_((currentStyle, part) -> {
            if (finished.get()) {
                return Optional.ofNullable("");
            }
            return StringDecomposer.m_14346_((String)part, (Style)currentStyle, (FormattedCharSink)sink) ? Optional.empty() : Optional.ofNullable("");
        }, style);
        return sum.floatValue();
    }

    public static float formattedWidthByIndex(FormattedCharSequence content, int index) {
        MutableFloat sum = new MutableFloat(0.0f);
        Font font = Minecraft.m_91087_().f_91062_;
        StringSplitterAccessor accessor = (StringSplitterAccessor)font.m_92865_();
        FormattedCharSink sink = (pos, s, codePoint) -> {
            if (pos >= index) {
                return false;
            }
            sum.add(accessor.dragonlib$getWidthProvider().m_92515_(codePoint, s));
            return true;
        };
        content.m_13731_(sink);
        return sum.floatValue();
    }

    protected record UVData(float u0, float v0, float u1, float v1) {
    }
}

