/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.mcdragonlib.client.util;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import de.mrjulsen.mcdragonlib.DragonLib;
import de.mrjulsen.mcdragonlib.client.ber.BERGraphics;
import de.mrjulsen.mcdragonlib.client.util.DLGraphics;
import de.mrjulsen.mcdragonlib.client.util.DLTexture;
import de.mrjulsen.mcdragonlib.client.util.GuiUtils;
import de.mrjulsen.mcdragonlib.data.ETextAlignment;
import de.mrjulsen.mcdragonlib.util.DLColor;
import de.mrjulsen.mcdragonlib.util.TextUtils;
import de.mrjulsen.mcdragonlib.util.math.MathUtils;
import java.util.BitSet;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.ModelBlockRenderer;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.BlockAndTintGetter;
import org.joml.Matrix3f;
import org.joml.Matrix4f;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public final class RenderUtils {
    private static boolean aoRenderingErrorKnown = false;
    public static final ResourceLocation BLANK_TEXTURE_LOCATION;

    public static void initRenderEngine() {
        RenderSystem.enableBlend();
        RenderSystem.enableDepthTest();
        RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
    }

    public static void setTint(DLColor color) {
        GuiUtils.setTint(color);
    }

    public static void resetTint() {
        GuiUtils.resetTint();
    }

    public static void addVert(VertexConsumer builder, DLGraphics graphics, float x, float y, float z, float u, float v, float r, float g, float b, float a, int lu, int lv) {
        builder.m_252986_(graphics.poseStack().m_85850_().m_252922_(), x, y, z).m_85950_(r, g, b, a).m_7421_(u, v).m_7120_(lu, lv).m_86008_(OverlayTexture.f_118083_).m_252939_(graphics.poseStack().m_85850_().m_252943_(), 0.0f, 0.0f, 1.0f).m_5752_();
    }

    private static void renderWithoutAO(VertexConsumer builder, DLGraphics graphics, float x0, float y0, float z0, float x1, float y1, float z1, float u0, float v0, float u1, float v1, float r, float g, float b, float a, int packedLight) {
        RenderUtils.addVert(builder, graphics, x0, y0, z0, u0, v0, r, g, b, a, packedLight & 0xFFFF, packedLight >> 16 & 0xFFFF);
        RenderUtils.addVert(builder, graphics, x0, y1, z0, u0, v1, r, g, b, a, packedLight & 0xFFFF, packedLight >> 16 & 0xFFFF);
        RenderUtils.addVert(builder, graphics, x1, y1, z1, u1, v1, r, g, b, a, packedLight & 0xFFFF, packedLight >> 16 & 0xFFFF);
        RenderUtils.addVert(builder, graphics, x1, y0, z1, u1, v0, r, g, b, a, packedLight & 0xFFFF, packedLight >> 16 & 0xFFFF);
    }

    private static void renderWithAO(Direction direction, VertexConsumer builder, BERGraphics<?> graphics, float x0, float y0, float z0, float x1, float y1, float z1, float u0, float v0, float u1, float v1, float r, float g, float b, float a, int packedLight) {
        float[] afloat = new float[Direction.values().length * 2];
        BitSet bitset = new BitSet(3);
        ModelBlockRenderer.AmbientOcclusionFace ao = new ModelBlockRenderer.AmbientOcclusionFace();
        ClientLevel batg = Minecraft.m_91087_().f_91073_;
        ao.m_111167_((BlockAndTintGetter)batg, graphics.blockEntity().m_58900_(), graphics.blockEntity().m_58899_(), direction, afloat, bitset, true);
        RenderUtils.addVert(builder, graphics, x0, y0, z0, u0, v0, r * ao.f_111149_[0], g * ao.f_111149_[0], b * ao.f_111149_[0], a, ao.f_111150_[0] & 0xFFFF, ao.f_111150_[0] >> 16 & 0xFFFF);
        RenderUtils.addVert(builder, graphics, x0, y1, z0, u0, v1, r * ao.f_111149_[1], g * ao.f_111149_[1], b * ao.f_111149_[1], a, ao.f_111150_[1] & 0xFFFF, ao.f_111150_[1] >> 16 & 0xFFFF);
        RenderUtils.addVert(builder, graphics, x1, y1, z1, u1, v1, r * ao.f_111149_[2], g * ao.f_111149_[2], b * ao.f_111149_[2], a, ao.f_111150_[2] & 0xFFFF, ao.f_111150_[2] >> 16 & 0xFFFF);
        RenderUtils.addVert(builder, graphics, x1, y0, z1, u1, v0, r * ao.f_111149_[3], g * ao.f_111149_[3], b * ao.f_111149_[3], a, ao.f_111150_[3] & 0xFFFF, ao.f_111150_[3] >> 16 & 0xFFFF);
    }

    public static void addQuadSide(Direction direction, VertexConsumer builder, DLGraphics graphics, float x0, float y0, float z0, float x1, float y1, float z1, float u0, float v0, float u1, float v1, float r, float g, float b, float a, int packedLight, boolean ambientOcclusion) {
        BERGraphics berGraphics;
        if (!(ambientOcclusion && Minecraft.m_91086_() && graphics instanceof BERGraphics && (berGraphics = (BERGraphics)graphics).blockEntity().m_58904_() != null && berGraphics.blockEntity().m_58899_() != null)) {
            try {
                RenderUtils.renderWithoutAO(builder, graphics, x0, y0, z0, x1, y1, z1, u0, v0, u1, v1, r, g, b, a, packedLight);
            }
            catch (Exception e2) {
                DragonLib.LOGGER.error("Error while rendering without AO.", (Throwable)e2);
            }
        } else {
            try {
                RenderUtils.renderWithAO(direction, builder, berGraphics, x0, y0, z0, x1, y1, z1, u0, v0, u1, v1, r, g, b, a, packedLight);
                aoRenderingErrorKnown = false;
            }
            catch (Exception e) {
                if (!aoRenderingErrorKnown) {
                    DragonLib.LOGGER.error("Error while rendering with AO.", (Throwable)e);
                }
                aoRenderingErrorKnown = true;
                try {
                    RenderUtils.renderWithoutAO(builder, graphics, x0, y0, z0, x1, y1, z1, u0, v0, u1, v1, r, g, b, a, packedLight);
                }
                catch (Exception e2) {
                    DragonLib.LOGGER.error("Error while rendering without AO.", (Throwable)e2);
                }
            }
        }
    }

    public static void renderTexture(ResourceLocation texture, DLGraphics graphics, Vector3f pos, float w, float h, float u, float v, float uW, float vH, Direction facing, DLColor tint, int light, boolean ambiebtOcclusion) {
        graphics.multiBufferSource().m_6299_(RenderType.m_110497_((ResourceLocation)texture));
        VertexConsumer vertexconsumer = graphics.vertexConsumer(texture);
        RenderUtils.addQuadSide(facing, vertexconsumer, graphics, pos.x(), pos.y(), pos.z(), pos.x() + w, pos.y() + h, pos.z(), u, v, u + uW, v + vH, tint.getRedF(), tint.getGreenF(), tint.getBlueF(), tint.getAlphaF(), light, ambiebtOcclusion);
    }

    public static void renderTexture(ResourceLocation texture, DLGraphics graphics, Vector3f pos, float w, float h, float u, float v, float uW, float vH, Direction facing, DLColor tint, boolean ambientOcclusion) {
        RenderUtils.renderTexture(texture, graphics, pos, w, h, u, v, uW, vH, facing, tint, graphics.packedLight(), ambientOcclusion);
    }

    public static void renderTexture(ResourceLocation texture, DLGraphics graphics, Vector3f pos, float w, float h, Direction facing, boolean ambientOcclusion) {
        RenderUtils.renderTexture(texture, graphics, pos, w, h, 0.0f, 0.0f, 1.0f, 1.0f, facing, DLColor.WHITE, graphics.packedLight(), ambientOcclusion);
    }

    public static void renderTexture(DLTexture texture, DLGraphics graphics, Vector3f pos, float w, float h, float u, float v, float uW, float vH, Direction facing, DLColor tint, int light, boolean ambientOcclusion) {
        if (texture.usesTextureId() || texture.getTexture().isEmpty()) {
            throw new IllegalArgumentException("TextureIds are not supported in BlockEntityRenderers.");
        }
        RenderUtils.renderTexture(texture.getTexture().get(), graphics, pos, w, h, (float)MathUtils.proportion(u, texture.width()), (float)MathUtils.proportion(v, texture.height()), (float)MathUtils.proportion(uW, texture.width()), (float)MathUtils.proportion(vH, texture.height()), facing, tint, light, ambientOcclusion);
    }

    public static void renderTexture(DLTexture texture, DLGraphics graphics, Vector3f pos, float w, float h, float u, float v, float uW, float vH, Direction facing, DLColor tint, boolean ambientOcclusion) {
        RenderUtils.renderTexture(texture, graphics, pos, w, h, u, v, uW, vH, facing, tint, graphics.packedLight(), ambientOcclusion);
    }

    public static void renderTexture(DLTexture texture, DLGraphics graphics, Vector3f pos, float w, float h, Direction facing, boolean ambientOcclusion) {
        RenderUtils.renderTexture(texture, graphics, pos, w, h, 0.0f, 0.0f, (float)texture.width(), (float)texture.height(), facing, DLColor.WHITE, ambientOcclusion);
    }

    public static void fillColor(DLGraphics graphics, Vector3f pos, float w, float h, DLColor color, Direction facing, int light, boolean ambientOcclusion) {
        RenderUtils.renderTexture(BLANK_TEXTURE_LOCATION, graphics, pos, w, h, 0.0f, 0.0f, 1.0f, 1.0f, facing, color, light, ambientOcclusion);
    }

    public static void fillColor(DLGraphics graphics, Vector3f pos, float w, float h, DLColor color, Direction facing) {
        RenderUtils.fillColor(graphics, pos, w, h, color, facing, graphics.packedLight(), false);
    }

    public static void drawString(DLGraphics graphics, Font font, float x, float y, Component text, DLColor color, ETextAlignment alignment, boolean dropShadow, boolean transparent, DLColor backgroundColor, int packedLight) {
        float dx = x;
        switch (alignment) {
            case RIGHT: {
                dx = x - (float)font.m_92852_((FormattedText)text);
                break;
            }
            case CENTER: {
                dx = x - (float)(font.m_92852_((FormattedText)text) / 2);
                break;
            }
        }
        font.m_272077_(text, dx, y, color.getAsARGB(), dropShadow, graphics.poseStack().m_85850_().m_252922_(), graphics.multiBufferSource(), transparent ? Font.DisplayMode.SEE_THROUGH : Font.DisplayMode.NORMAL, backgroundColor.getAsARGB(), packedLight);
    }

    public static void drawString(DLGraphics graphics, Font font, float x, float y, Component text, DLColor color, ETextAlignment alignment, boolean dropShadow, int packedLight) {
        RenderUtils.drawString(graphics, font, x, y, text, color, alignment, dropShadow, false, DLColor.TRANSPARENT, packedLight);
    }

    public static void drawString(DLGraphics graphics, Font font, float x, float y, Component text, DLColor color, ETextAlignment alignment, boolean dropShadow) {
        RenderUtils.drawString(graphics, font, x, y, text, color, alignment, dropShadow, graphics.packedLight());
    }

    public static void drawString(DLGraphics graphics, Font font, float x, float y, String text, DLColor color, ETextAlignment alignment, boolean dropShadow, boolean transparent, DLColor backgroundColor, int packedLight) {
        RenderUtils.drawString(graphics, font, x, y, (Component)TextUtils.text(text), color, alignment, dropShadow, transparent, backgroundColor, packedLight);
    }

    public static void drawString(DLGraphics graphics, Font font, float x, float y, String text, DLColor color, ETextAlignment alignment, boolean dropShadow, int packedLight) {
        RenderUtils.drawString(graphics, font, x, y, text, color, alignment, dropShadow, false, DLColor.TRANSPARENT, packedLight);
    }

    public static void drawString(DLGraphics graphics, Font font, float x, float y, String text, DLColor color, ETextAlignment alignment, boolean dropShadow) {
        RenderUtils.drawString(graphics, font, x, y, text, color, alignment, dropShadow, graphics.packedLight());
    }

    public static void drawDebugLineGradient(PoseStack poseStack, VertexConsumer consumer, Vector3f from, Vector3f to, DLColor colorA, DLColor colorB) {
        float dz;
        float dy;
        Matrix4f matrix4f = poseStack.m_85850_().m_252922_();
        Matrix3f matrix3f = poseStack.m_85850_().m_252943_();
        float dx = to.x() - from.x();
        float length = (float)Math.sqrt(dx * dx + (dy = to.y() - from.y()) * dy + (dz = to.z() - from.z()) * dz);
        if (length > 0.0f) {
            dx /= length;
            dy /= length;
            dz /= length;
        }
        consumer.m_252986_(matrix4f, from.x(), from.y(), from.z()).m_85950_(colorA.getRedF(), colorA.getGreenF(), colorA.getBlueF(), colorA.getAlphaF()).m_252939_(matrix3f, dx, dy, dz).m_5752_();
        consumer.m_252986_(matrix4f, to.x(), to.y(), to.z()).m_85950_(colorB.getRedF(), colorB.getGreenF(), colorB.getBlueF(), colorB.getAlphaF()).m_252939_(matrix3f, dx, dy, dz).m_5752_();
    }

    public static void drawDebugLine(PoseStack poseStack, VertexConsumer consumer, Vector3f from, Vector3f to, DLColor color) {
        RenderUtils.drawDebugLineGradient(poseStack, consumer, from, to, color, color);
    }

    public static void drawDebugLineGradient(DLGraphics graphics, Vector3f from, Vector3f to, DLColor colorA, DLColor colorB) {
        RenderUtils.drawDebugLine(graphics.poseStack(), graphics.multiBufferSource().m_6299_(RenderType.m_110504_()), from, to, colorB);
    }

    public static void drawDebugLine(DLGraphics graphics, Vector3f from, Vector3f to, DLColor color) {
        RenderUtils.drawDebugLineGradient(graphics, from, to, color, color);
    }

    protected static void renderNameTag(PoseStack poseStack, MultiBufferSource buffer, Vector3f pos, float yOffset, List<Component> text, int packedLight) {
        if (Minecraft.m_91087_().m_91288_().m_20182_().m_252839_().distance((Vector3fc)pos) > 64.0f) {
            return;
        }
        Objects.requireNonNull(Minecraft.m_91087_().f_91062_);
        float lineHeight = 9.0f * 1.5f;
        poseStack.m_85836_();
        poseStack.m_252880_(pos.x(), pos.y() + yOffset, pos.z());
        poseStack.m_252781_(Minecraft.m_91087_().f_91063_.m_109153_().m_253121_());
        poseStack.m_85841_(-0.0125f, -0.0125f, 0.0125f);
        Matrix4f matrix4f = poseStack.m_85850_().m_252922_();
        for (int k = 0; k < text.size(); ++k) {
            float y = lineHeight * (float)k;
            Component txt = text.get(k);
            float opacity = Minecraft.m_91087_().f_91066_.m_92141_(0.25f);
            int backgroundColor = (int)(opacity * 255.0f) << 24;
            Font font = Minecraft.m_91087_().f_91062_;
            float x = -font.m_92852_((FormattedText)txt) / 2;
            font.m_272077_(txt, x, -(lineHeight * (float)text.size()) + y, 0x20FFFFFF, false, matrix4f, buffer, Font.DisplayMode.SEE_THROUGH, backgroundColor, packedLight);
            font.m_272077_(txt, x, -(lineHeight * (float)text.size()) + y, -1, false, matrix4f, buffer, Font.DisplayMode.NORMAL, 0, packedLight);
        }
        poseStack.m_85849_();
    }

    protected static void renderNameTag(DLGraphics graphics, Vector3f pos, float yOffset, List<Component> text, int packedLight) {
        RenderUtils.renderNameTag(graphics.poseStack(), graphics.multiBufferSource(), pos, yOffset, text, packedLight);
    }

    static {
        NativeImage img = new NativeImage(1, 1, false);
        img.m_84988_(0, 0, -1);
        BLANK_TEXTURE_LOCATION = Minecraft.m_91087_().m_91097_().m_118490_("dragonlib_blank_texture", new DynamicTexture(img));
    }
}

