/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.mcdragonlib.events;

import de.mrjulsen.mcdragonlib.events.EventListenerId;
import de.mrjulsen.mcdragonlib.events.IEventListener;
import java.util.UUID;
import org.jetbrains.annotations.NotNull;

public class EventListenerWrapper<E extends IEventListener<?, ?>>
implements Comparable<EventListenerWrapper<E>> {
    @NotNull
    private final E event;
    private final int priority;
    private final EventListenerId id;

    public EventListenerWrapper(@NotNull E event, int priority, EventListenerId id) {
        this.event = event;
        this.priority = priority;
        this.id = id;
    }

    public E event() {
        return this.event;
    }

    public int priority() {
        return this.priority;
    }

    @Override
    public int compareTo(EventListenerWrapper<E> o) {
        return Integer.compare(this.priority(), o.priority());
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof EventListenerWrapper) {
            EventListenerWrapper o = (EventListenerWrapper)obj;
            return this.id.equals(o.id);
        }
        if (obj instanceof EventListenerId) {
            EventListenerId o = (EventListenerId)obj;
            return this.id.equals(o);
        }
        if (obj instanceof UUID) {
            UUID o = (UUID)obj;
            return this.id.equals(o);
        }
        return false;
    }

    public String toString() {
        return String.format("%s[priority=%s,id=%s]", this.event().toString(), this.priority(), this.id);
    }
}

