/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.mcdragonlib.forge.client;

import de.mrjulsen.mcdragonlib.client.model.DLBlockModelRegistry;
import de.mrjulsen.mcdragonlib.client.model.mesh.DLModel;
import de.mrjulsen.mcdragonlib.forge.client.model.DynamicBakedModel;
import de.mrjulsen.mcdragonlib.forge.client.model.loaders.DLModelExtensionLoader;
import de.mrjulsen.mcdragonlib.forge.client.model.loaders.MultipartObjLoader;
import java.util.Map;
import java.util.Queue;
import net.minecraft.client.renderer.block.BlockModelShaper;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.ModelEvent;
import net.minecraftforge.client.model.geometry.IGeometryLoader;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="dragonlib", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
public final class ClientEvents {
    private ClientEvents() {
    }

    @SubscribeEvent
    public static void registerGeometryLoaders(ModelEvent.RegisterGeometryLoaders event) {
        event.register("multipart_obj", (IGeometryLoader)MultipartObjLoader.INSTANCE);
        event.register("advanced_json", (IGeometryLoader)DLModelExtensionLoader.INSTANCE);
    }

    @SubscribeEvent
    public static void onModifyBakingResult(ModelEvent.ModifyBakingResult event) {
        Map registry = event.getModels();
        Queue<DLBlockModelRegistry.ICustomModelFactory> replacements = DLBlockModelRegistry.getCustomRegisteredModels(registry);
        while (!replacements.isEmpty()) {
            DLBlockModelRegistry.ICustomModelFactory r = replacements.poll();
            if (r.getModelFactory() == null || r.getStates().isEmpty()) continue;
            for (BlockState state : r.getStates()) {
                ModelResourceLocation location = BlockModelShaper.m_110895_((BlockState)state);
                if (r.getType() == DLModel.ModelType.ITEM) {
                    location = new ModelResourceLocation((ResourceLocation)location, "inventory");
                }
                BakedModel originalModel = (BakedModel)registry.get(location);
                DLBlockModelRegistry.setOriginalModel(state, originalModel);
                DynamicBakedModel newModel = new DynamicBakedModel(originalModel, state, r.getModelFactory().get());
                registry.put(location, newModel);
            }
        }
    }
}

