/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.mcdragonlib.forge.client.model.loaders;

import de.mrjulsen.mcdragonlib.client.model.extension.DLBakedQuad;
import de.mrjulsen.mcdragonlib.client.model.extension.DLFaceData;
import de.mrjulsen.mcdragonlib.client.model.extension.DLFaceKey;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.model.BakedModelWrapper;
import net.minecraftforge.client.model.data.ModelData;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DLBakedModelExtension
extends BakedModelWrapper<BakedModel> {
    private final Map<DLFaceKey, DLFaceData> faceData;
    private final Map<CacheKey, List<BakedQuad>> cachedQuads = new ConcurrentHashMap<CacheKey, List<BakedQuad>>();

    public DLBakedModelExtension(BakedModel parent, Map<DLFaceKey, DLFaceData> faceData) {
        super(parent);
        this.faceData = faceData;
    }

    @NotNull
    public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, @NotNull RandomSource rand, @NotNull ModelData extraData, @Nullable RenderType renderType) {
        return this.m_213637_(state, side, rand);
    }

    @NotNull
    public List<BakedQuad> m_213637_(BlockState state, Direction side, RandomSource rand) {
        return this.cachedQuads.computeIfAbsent(new CacheKey(state, side), k -> {
            List src = super.m_213637_(state, side, rand);
            ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>(src.size());
            int i = 0;
            for (BakedQuad q : src) {
                DLFaceKey key = new DLFaceKey(i, side);
                DLFaceData data = this.faceData.get(key);
                if (data != null) {
                    quads.add(DLBakedQuad.create(q, data));
                } else {
                    quads.add(q);
                }
                ++i;
            }
            return quads;
        });
    }

    private record CacheKey(BlockState state, Direction side) {
    }
}

