/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.mcdragonlib.forge.client.model.loaders;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import de.mrjulsen.mcdragonlib.client.model.extension.DLFaceData;
import de.mrjulsen.mcdragonlib.client.model.extension.DLFaceKey;
import de.mrjulsen.mcdragonlib.forge.client.model.loaders.DLUnbakedModelExtension;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.block.model.BlockModel;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraftforge.client.model.geometry.IGeometryLoader;
import org.apache.commons.lang3.mutable.MutableInt;

public class DLModelExtensionLoader
implements IGeometryLoader<DLUnbakedModelExtension> {
    public static final ResourceLocation ID = new ResourceLocation("dragonlib", "advanced_json");
    public static final DLModelExtensionLoader INSTANCE = new DLModelExtensionLoader();

    public DLUnbakedModelExtension read(JsonObject json, JsonDeserializationContext ctx) {
        BlockModel vanilla = new BlockModel.Deserializer().deserialize((JsonElement)json, BlockModel.class, ctx);
        HashMap<DLFaceKey, DLFaceData> faceData = new HashMap<DLFaceKey, DLFaceData>();
        HashMap<DirectionKey, MutableInt> faceIndex = new HashMap<DirectionKey, MutableInt>();
        JsonArray elements = json.getAsJsonArray("elements");
        for (int e = 0; e < elements.size(); ++e) {
            JsonObject element = elements.get(e).getAsJsonObject();
            JsonObject faces = element.getAsJsonObject("faces");
            for (Map.Entry entry : faces.entrySet()) {
                JsonObject face = ((JsonElement)entry.getValue()).getAsJsonObject();
                Direction cullFace = this.getCullFacing(face);
                MutableInt idx = faceIndex.computeIfAbsent(new DirectionKey(cullFace), c -> new MutableInt(0));
                DLFaceData data = DLFaceData.read((JsonElement)face.getAsJsonObject("dragonlib_data"), DLFaceData.DEFAULT);
                if (data == null) continue;
                faceData.put(new DLFaceKey(idx.getAndIncrement(), cullFace), data);
            }
        }
        return new DLUnbakedModelExtension(vanilla, faceData);
    }

    @Nullable
    private Direction getCullFacing(JsonObject json) {
        String s = GsonHelper.m_13851_((JsonObject)json, (String)"cullface", (String)"");
        return Direction.m_122402_((String)s);
    }

    private record DirectionKey(Direction dir) {
    }
}

