/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.mcdragonlib.internal;

import de.mrjulsen.mcdragonlib.DragonLib;
import de.mrjulsen.mcdragonlib.client.gui.widgets.base.DLWindow;
import de.mrjulsen.mcdragonlib.client.gui.widgets.base.DLWindowManager;
import de.mrjulsen.mcdragonlib.client.render.DLTextureSheet;
import de.mrjulsen.mcdragonlib.client.util.DLGuiGraphics;
import de.mrjulsen.mcdragonlib.client.util.GuiUtils;
import de.mrjulsen.mcdragonlib.data.ETextAlignment;
import de.mrjulsen.mcdragonlib.util.math.Rectangle;
import de.mrjulsen.mcdragonlib.util.time.DLTime;
import de.mrjulsen.mcdragonlib.util.time.DLTimeUnit;
import de.mrjulsen.mcdragonlib.util.time.ITimeSystem;
import de.mrjulsen.mcdragonlib.util.time.TimeContext;
import de.mrjulsen.mcdragonlib.util.time.TimeZone;
import de.mrjulsen.mcdragonlib.util.time.VanillaTimeSystem;
import de.mrjulsen.mcdragonlib.util.time.format.TimeFormat12Hours;
import de.mrjulsen.mcdragonlib.util.time.format.TimeFormat24Hours;
import de.mrjulsen.mcdragonlib.util.time.format.TimeFormatDigitalDuration;
import de.mrjulsen.mcdragonlib.util.time.format.TimeFormatTicks;
import de.mrjulsen.mcdragonlib.util.time.format.TimeFormatVerboseDuration;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;

public class TimeWindow
extends DLWindow {
    public TimeWindow(DLWindowManager manager) {
        super(manager);
        this.movable.set(true);
    }

    @Override
    public void renderMainLayer(DLGuiGraphics graphics, double mouseX, double mouseY, Rectangle renderBounds) {
        DLTextureSheet.DRAGONLIB_UI.getSprite("window_rounded").render(graphics, 0, 0, this.width(), this.height());
        GuiUtils.renderItem(graphics, new ItemStack((ItemLike)Blocks.f_50624_.m_5456_()), this.width() - 20, 5);
        ITimeSystem system = DLTime.defaultTimeSystem();
        DLTime time = new DLTime((Level)Minecraft.m_91087_().f_91073_, system);
        Font font = graphics.defaultFont();
        Objects.requireNonNull(graphics.defaultFont());
        GuiUtils.drawString(graphics, font, 5, 5 + 9 * 0, time.format(TimeFormat24Hours.INSTANCE, TimeContext.INGAME, system), DragonLib.VANILLA_UI_FONT_COLOR, ETextAlignment.LEFT, false);
        Font font2 = graphics.defaultFont();
        Objects.requireNonNull(graphics.defaultFont());
        GuiUtils.drawString(graphics, font2, 5, 5 + 9 * 1, time.format(TimeFormat12Hours.INSTANCE, TimeContext.INGAME, system), DragonLib.VANILLA_UI_FONT_COLOR, ETextAlignment.LEFT, false);
        Font font3 = graphics.defaultFont();
        Objects.requireNonNull(graphics.defaultFont());
        GuiUtils.drawString(graphics, font3, 5, 5 + 9 * 2, time.format(TimeFormatTicks.INSTANCE, TimeContext.INGAME, system), DragonLib.VANILLA_UI_FONT_COLOR, ETextAlignment.LEFT, false);
        Font font4 = graphics.defaultFont();
        Objects.requireNonNull(graphics.defaultFont());
        GuiUtils.drawString(graphics, font4, 5, 5 + 9 * 5, "Game: " + time.format(new TimeFormatDigitalDuration(DLTimeUnit.MILLIS, true), TimeContext.INGAME, system), DragonLib.VANILLA_UI_FONT_COLOR, ETextAlignment.LEFT, false);
        Font font5 = graphics.defaultFont();
        Objects.requireNonNull(graphics.defaultFont());
        GuiUtils.drawString(graphics, font5, 5, 5 + 9 * 6, "Real:  " + time.format(new TimeFormatDigitalDuration(DLTimeUnit.MILLIS, true), TimeContext.REAL, system), DragonLib.VANILLA_UI_FONT_COLOR, ETextAlignment.LEFT, false);
        Font font6 = graphics.defaultFont();
        Objects.requireNonNull(graphics.defaultFont());
        GuiUtils.drawString(graphics, font6, 5, 5 + 9 * 7, "Game: " + time.format(TimeFormatVerboseDuration.DEFAULT_INSTANCE, TimeContext.INGAME, system), DragonLib.VANILLA_UI_FONT_COLOR, ETextAlignment.LEFT, false);
        Font font7 = graphics.defaultFont();
        Objects.requireNonNull(graphics.defaultFont());
        GuiUtils.drawString(graphics, font7, 5, 5 + 9 * 8, "Real:  " + time.format(TimeFormatVerboseDuration.DEFAULT_INSTANCE, TimeContext.REAL, system), DragonLib.VANILLA_UI_FONT_COLOR, ETextAlignment.LEFT, false);
        Font font8 = graphics.defaultFont();
        Objects.requireNonNull(graphics.defaultFont());
        GuiUtils.drawString(graphics, font8, 5, 5 + 9 * 10, "(+1h) Game:  " + time.add(DLTime.fromGameHours(1.0, VanillaTimeSystem.INSTANCE)).format(TimeFormatVerboseDuration.DEFAULT_INSTANCE, TimeContext.INGAME, system), DragonLib.VANILLA_UI_FONT_COLOR, ETextAlignment.LEFT, false);
        Font font9 = graphics.defaultFont();
        Objects.requireNonNull(graphics.defaultFont());
        GuiUtils.drawString(graphics, font9, 5, 5 + 9 * 11, "(+1h) Real:  " + time.add(DLTime.fromGameHours(1.0, VanillaTimeSystem.INSTANCE)).format(TimeFormatVerboseDuration.DEFAULT_INSTANCE, TimeContext.REAL, system), DragonLib.VANILLA_UI_FONT_COLOR, ETextAlignment.LEFT, false);
        Font font10 = graphics.defaultFont();
        Objects.requireNonNull(graphics.defaultFont());
        GuiUtils.drawString(graphics, font10, 5, 5 + 9 * 13, "(-1h) Game:  " + time.sub(DLTime.fromGameHours(1.0, VanillaTimeSystem.INSTANCE)).format(TimeFormatVerboseDuration.DEFAULT_INSTANCE, TimeContext.INGAME, system), DragonLib.VANILLA_UI_FONT_COLOR, ETextAlignment.LEFT, false);
        Font font11 = graphics.defaultFont();
        Objects.requireNonNull(graphics.defaultFont());
        GuiUtils.drawString(graphics, font11, 5, 5 + 9 * 14, "(-1h) Real:  " + time.sub(DLTime.fromGameHours(1.0, VanillaTimeSystem.INSTANCE)).format(TimeFormatVerboseDuration.DEFAULT_INSTANCE, TimeContext.REAL, system), DragonLib.VANILLA_UI_FONT_COLOR, ETextAlignment.LEFT, false);
    }

    public static class TestTimeSystem
    implements ITimeSystem {
        private static final List<TimeZone> VANILLA_ZONES = List.of(new TimeZone(0L, 12000L, 20.0), new TimeZone(12000L, 24000L, 80.0));

        private TestTimeSystem() {
        }

        @Override
        public long getTicksPerDay() {
            return 24000L;
        }

        @Override
        public List<TimeZone> getTimeZones() {
            return VANILLA_ZONES;
        }
    }
}

