/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.mcdragonlib.network;

import de.mrjulsen.mcdragonlib.data.DLStatus;
import de.mrjulsen.mcdragonlib.network.CommunicationType;
import de.mrjulsen.mcdragonlib.network.NetworkDirection;
import de.mrjulsen.mcdragonlib.network.NetworkPacketContext;
import de.mrjulsen.mcdragonlib.network.NetworkPacketData;
import de.mrjulsen.mcdragonlib.network.NetworkPacketType;
import de.mrjulsen.mcdragonlib.network.NetworkProcessor;
import de.mrjulsen.mcdragonlib.network.NetworkSide;
import de.mrjulsen.mcdragonlib.network.forge.DLNetworkManagerImpl;
import de.mrjulsen.mcdragonlib.network.packet.NetworkPacker;
import de.mrjulsen.mcdragonlib.network.packet.SegmentedPacketHeaderInfo;
import dev.architectury.injectables.annotations.ExpectPlatform;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.Packet;
import net.minecraft.resources.ResourceLocation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DLNetworkManager {
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"DragonLib Networking System");
    private static final ConcurrentHashMap<ResourceLocation, DLNetworkManager> managers = new ConcurrentHashMap();
    private final ResourceLocation channelId;
    private final String protocolVersion;
    private final ConcurrentHashMap<String, NetworkPacketType<?, ?, ?>> packets = new ConcurrentHashMap();

    public DLNetworkManager(ResourceLocation channelId, String protocolVersion) {
        this.channelId = channelId;
        this.protocolVersion = protocolVersion;
    }

    public <N extends NetworkDirection, I extends NetworkPacketData, S extends NetworkProcessor.Send<I>> NetworkPacketType.Send<N, I> registerSendOnlyPacket(String name, N direction, S processor, Function<DLStatus, I> factory) {
        return this.register(new NetworkPacketType.Send(this.channelId, name, direction, processor, factory));
    }

    public <N extends NetworkDirection, O extends NetworkPacketData, S extends NetworkProcessor.Receive<O>> NetworkPacketType.Receive<N, O> registerReceiveOnlyPacket(String name, N direction, S processor, Function<DLStatus, O> factory) {
        return this.register(new NetworkPacketType.Receive(this.channelId, name, direction, processor, factory));
    }

    public <N extends NetworkDirection, I extends NetworkPacketData, O extends NetworkPacketData, S extends NetworkProcessor.SendAndReceive<I, O>> NetworkPacketType.SendAndReceive<N, I, O> registerSendAndReceivePacket(String name, N direction, S processor, Function<DLStatus, I> inputFactory, Function<DLStatus, O> outputFactory) {
        return this.register(new NetworkPacketType.SendAndReceive(this.channelId, name, direction, processor, inputFactory, outputFactory));
    }

    public <N extends NetworkDirection, I extends NetworkPacketData, O extends NetworkPacketData> NetworkPacketType.Stream<N, I, O> registerStreamPacket(String name, N direction, Supplier<NetworkProcessor.StreamReceiver<I, O>> factory, Function<DLStatus, I> inputFactory, Function<DLStatus, O> outputFactory) {
        return this.register(new NetworkPacketType.Stream(this.channelId, name, direction, factory, inputFactory, outputFactory));
    }

    private <T extends NetworkPacketType<?, ?, ?>> T register(T packet) {
        if (this.isPacketRegistered(packet.getName())) {
            throw new IllegalArgumentException("A packet with id '" + packet.getName() + "' has already been registered for '" + String.valueOf(this.channelId) + "'.");
        }
        managers.computeIfAbsent(this.channelId, x -> {
            DLNetworkManager.registerChannel(this.channelId, this.protocolVersion);
            return this;
        });
        this.packets.put(packet.getName(), packet);
        LOGGER.info("Registering {} network packet of type {} with id '{}' in '{}'.", new Object[]{packet.getDirection(), packet.getType(), packet.getName(), this.channelId});
        return packet;
    }

    public boolean isPacketRegistered(String name) {
        return this.packets.containsKey(name);
    }

    public Optional<NetworkPacketType<?, ?, ?>> getRegisteredPacket(String name, NetworkSide side) {
        if (!this.isPacketRegistered(name)) {
            return Optional.empty();
        }
        NetworkPacketType<?, ?, ?> type = this.packets.get(name);
        if (type == null || type.getDirection() != side) {
            return Optional.empty();
        }
        return Optional.of(type);
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static void registerChannel(ResourceLocation channelId, String protocolVersion) {
        void var1_1;
        DLNetworkManagerImpl.registerChannel(channelId, (String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static Packet<?> toPacket(ResourceLocation channelId, NetworkSide side, FriendlyByteBuf buffer) {
        void var2_2;
        void var1_1;
        return DLNetworkManagerImpl.toPacket(channelId, (NetworkSide)var1_1, (FriendlyByteBuf)var2_2);
    }

    public static void receiveData(ResourceLocation channelId, FriendlyByteBuf buf, NetworkSide side, NetworkPacketContext context) {
        if (!managers.containsKey(channelId)) {
            return;
        }
        SegmentedPacketHeaderInfo header = SegmentedPacketHeaderInfo.readBufferHeader(buf);
        CommunicationType communication = header.type().communication();
        NetworkSide fSide = communication == CommunicationType.RESPONSE ? side : (side == NetworkSide.S2C ? NetworkSide.C2S : NetworkSide.S2C);
        managers.get(channelId).getRegisteredPacket(header.type().name(), fSide).ifPresentOrElse(x -> NetworkPacker.unpack(header, fSide, buf, context, rawData -> {
            CompoundTag nbt = rawData.m_130261_();
            x.receive(header.type(), context, nbt, communication);
            NetworkPacker.cleanUp(header, fSide);
        }), () -> {
            LOGGER.warn("There is no {} packet registered with ID '{}' in '{}'.", new Object[]{fSide, header.type().name(), channelId});
            NetworkPacker.cleanUp(header, fSide);
        });
    }
}

