/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.mcdragonlib.network;

import de.mrjulsen.mcdragonlib.internal.ClientWrapper;
import de.mrjulsen.mcdragonlib.network.NetworkPacketContext;
import de.mrjulsen.mcdragonlib.network.NetworkSide;
import java.util.Objects;
import net.minecraft.network.protocol.Packet;
import net.minecraft.server.level.ServerPlayer;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public interface NetworkDirection {
    public static final C2S C2S = packet -> {};
    public static final S2C S2C = packet -> {};

    public void send(Packet<?> var1);

    public NetworkSide getDirection();

    public static S2C toPlayer(ServerPlayer player) {
        return packet -> Objects.requireNonNull(player, (String)"Unable to send packet to a 'null' player!").f_8906_.m_9829_(packet);
    }

    public static C2S toServer() {
        return ClientWrapper.toServer();
    }

    public static <N extends NetworkDirection> N forContext(N current, NetworkPacketContext context) {
        if (current instanceof S2C) {
            return (N)NetworkDirection.toPlayer((ServerPlayer)context.getPlayer());
        }
        if (current instanceof C2S) {
            return (N)NetworkDirection.toServer();
        }
        return null;
    }

    @FunctionalInterface
    public static interface S2C
    extends NetworkDirection {
        @Override
        default public NetworkSide getDirection() {
            return NetworkSide.S2C;
        }
    }

    @FunctionalInterface
    public static interface C2S
    extends NetworkDirection {
        @Override
        default public NetworkSide getDirection() {
            return NetworkSide.C2S;
        }
    }
}

