/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.mcdragonlib.network.packet;

import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;

public enum PacketType {
    EMPTY(0),
    SEND(1),
    RECEIVE(2),
    SEND_AND_RECEIVE(3),
    STREAM(4);

    private final byte id;
    private static final Map<Byte, PacketType> TYPES_BY_ID;

    private PacketType(byte id) {
        this.id = id;
    }

    public byte getId() {
        return this.id;
    }

    public static PacketType getById(byte id) {
        if (TYPES_BY_ID.containsKey(id)) {
            return TYPES_BY_ID.get(id);
        }
        return EMPTY;
    }

    static {
        TYPES_BY_ID = Arrays.stream(PacketType.values()).collect(Collectors.toMap(x -> x.getId(), x -> x));
    }
}

